/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.preferences.relocated.freemarker.core;

import org.uberfire.ext.preferences.relocated.freemarker.core.Environment;
import org.uberfire.ext.preferences.relocated.freemarker.core.Expression;
import org.uberfire.ext.preferences.relocated.freemarker.template.SimpleNumber;
import org.uberfire.ext.preferences.relocated.freemarker.template.TemplateModel;
import org.uberfire.ext.preferences.relocated.freemarker.template.TemplateNumberModel;

final class NumberLiteral
extends Expression
implements TemplateNumberModel {
    private final Number value;

    public NumberLiteral(Number value) {
        this.value = value;
    }

    TemplateModel _getAsTemplateModel(Environment env) {
        return new SimpleNumber(this.value);
    }

    public String getStringValue(Environment env) {
        return env.formatNumber(this.value);
    }

    public Number getAsNumber() {
        return this.value;
    }

    String getName() {
        return "the number: '" + this.value + "'";
    }

    public String getCanonicalForm() {
        return this.value.toString();
    }

    boolean isLiteral() {
        return true;
    }

    Expression _deepClone(String name, Expression subst) {
        return new NumberLiteral(this.value);
    }
}

