/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.preferences.relocated.freemarker.core;

import org.uberfire.ext.preferences.relocated.freemarker.core.Environment;
import org.uberfire.ext.preferences.relocated.freemarker.core.EvaluationUtil;
import org.uberfire.ext.preferences.relocated.freemarker.core.Expression;
import org.uberfire.ext.preferences.relocated.freemarker.core.NonBooleanException;
import org.uberfire.ext.preferences.relocated.freemarker.core.NumericalRange;
import org.uberfire.ext.preferences.relocated.freemarker.template.TemplateException;
import org.uberfire.ext.preferences.relocated.freemarker.template.TemplateModel;

final class Range
extends Expression {
    final Expression left;
    final Expression right;

    Range(Expression left, Expression right) {
        this.left = left;
        this.right = right;
    }

    boolean hasRhs() {
        return this.right != null;
    }

    TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
        int min = EvaluationUtil.getNumber(this.left, env).intValue();
        int max = 0;
        if (this.right != null) {
            max = EvaluationUtil.getNumber(this.right, env).intValue();
            return new NumericalRange(min, max);
        }
        return new NumericalRange(min);
    }

    boolean isTrue(Environment env) throws TemplateException {
        String msg = "Error " + this.getStartLocation() + ". " + "\nExpecting a boolean here." + " Expression " + this + " is a range.";
        throw new NonBooleanException(msg, env);
    }

    public String getCanonicalForm() {
        String rhs = this.right != null ? this.right.getCanonicalForm() : "";
        return this.left.getCanonicalForm() + ".." + rhs;
    }

    boolean isLiteral() {
        boolean rightIsLiteral = this.right == null || this.right.isLiteral();
        return this.constantValue != null || this.left.isLiteral() && rightIsLiteral;
    }

    Expression _deepClone(String name, Expression subst) {
        return new Range(this.left.deepClone(name, subst), this.right.deepClone(name, subst));
    }
}

