/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.preferences.relocated.freemarker.core;

import java.io.Serializable;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.uberfire.ext.preferences.relocated.freemarker.core.ArithmeticEngine;
import org.uberfire.ext.preferences.relocated.freemarker.core.BuiltIn;
import org.uberfire.ext.preferences.relocated.freemarker.core.Environment;
import org.uberfire.ext.preferences.relocated.freemarker.core.TemplateObject;
import org.uberfire.ext.preferences.relocated.freemarker.ext.beans.CollectionModel;
import org.uberfire.ext.preferences.relocated.freemarker.template.SimpleNumber;
import org.uberfire.ext.preferences.relocated.freemarker.template.TemplateBooleanModel;
import org.uberfire.ext.preferences.relocated.freemarker.template.TemplateCollectionModel;
import org.uberfire.ext.preferences.relocated.freemarker.template.TemplateDateModel;
import org.uberfire.ext.preferences.relocated.freemarker.template.TemplateException;
import org.uberfire.ext.preferences.relocated.freemarker.template.TemplateHashModel;
import org.uberfire.ext.preferences.relocated.freemarker.template.TemplateMethodModelEx;
import org.uberfire.ext.preferences.relocated.freemarker.template.TemplateModel;
import org.uberfire.ext.preferences.relocated.freemarker.template.TemplateModelException;
import org.uberfire.ext.preferences.relocated.freemarker.template.TemplateModelIterator;
import org.uberfire.ext.preferences.relocated.freemarker.template.TemplateModelListSequence;
import org.uberfire.ext.preferences.relocated.freemarker.template.TemplateNumberModel;
import org.uberfire.ext.preferences.relocated.freemarker.template.TemplateScalarModel;
import org.uberfire.ext.preferences.relocated.freemarker.template.TemplateSequenceModel;
import org.uberfire.ext.preferences.relocated.freemarker.template.utility.Constants;
import org.uberfire.ext.preferences.relocated.freemarker.template.utility.StringUtil;

abstract class SequenceBuiltins {
    SequenceBuiltins() {
    }

    private static boolean isBuggySeqButGoodCollection(TemplateModel model) {
        return model instanceof CollectionModel ? !((CollectionModel)model).getSupportsIndexedAccess() : false;
    }

    public static boolean modelsEqual(TemplateModel model1, TemplateModel model2, Environment env) throws TemplateModelException {
        if (env.isClassicCompatible()) {
            if (model1 == null) {
                model1 = TemplateScalarModel.EMPTY_STRING;
            }
            if (model2 == null) {
                model2 = TemplateScalarModel.EMPTY_STRING;
            }
        }
        int comp = -1;
        if (model1 instanceof TemplateNumberModel && model2 instanceof TemplateNumberModel) {
            Number first = ((TemplateNumberModel)model1).getAsNumber();
            Number second = ((TemplateNumberModel)model2).getAsNumber();
            ArithmeticEngine ae = env.getArithmeticEngine();
            try {
                comp = ae.compareNumbers(first, second);
            }
            catch (TemplateException ex) {
                throw new TemplateModelException(ex);
            }
        } else if (model1 instanceof TemplateDateModel && model2 instanceof TemplateDateModel) {
            int rtype;
            TemplateDateModel ltdm = (TemplateDateModel)model1;
            TemplateDateModel rtdm = (TemplateDateModel)model2;
            int ltype = ltdm.getDateType();
            if (ltype != (rtype = rtdm.getDateType())) {
                throw new TemplateModelException("Can not compare dates of different type. Left date is of " + TemplateDateModel.TYPE_NAMES.get(ltype) + " type, right date is of " + TemplateDateModel.TYPE_NAMES.get(rtype) + " type.");
            }
            if (ltype == 0) {
                throw new TemplateModelException("Left date is of UNKNOWN type, and can not be compared.");
            }
            if (rtype == 0) {
                throw new TemplateModelException("Right date is of UNKNOWN type, and can not be compared.");
            }
            Date first = ltdm.getAsDate();
            Date second = rtdm.getAsDate();
            comp = first.compareTo(second);
        } else if (model1 instanceof TemplateScalarModel && model2 instanceof TemplateScalarModel) {
            String first = ((TemplateScalarModel)model1).getAsString();
            String second = ((TemplateScalarModel)model2).getAsString();
            comp = env.getCollator().compare(first, second);
        } else if (model1 instanceof TemplateBooleanModel && model2 instanceof TemplateBooleanModel) {
            boolean first = ((TemplateBooleanModel)model1).getAsBoolean();
            boolean second = ((TemplateBooleanModel)model2).getAsBoolean();
            comp = (first ? 1 : 0) - (second ? 1 : 0);
        }
        return comp == 0;
    }

    static class chunkBI
    extends SequenceBuiltIn {
        chunkBI() {
        }

        TemplateModel calculateResult(TemplateSequenceModel tsm) throws TemplateModelException {
            return new BIMethod(tsm);
        }

        private static class ChunkedSequence
        implements TemplateSequenceModel {
            private final TemplateSequenceModel wrappedTsm;
            private final int chunkSize;
            private final TemplateModel fillerItem;
            private final int numberOfChunks;

            private ChunkedSequence(TemplateSequenceModel wrappedTsm, int chunkSize, TemplateModel fillerItem) throws TemplateModelException {
                if (chunkSize < 1) {
                    throw new TemplateModelException("The 1st argument to ?chunk(...) must be at least 1.");
                }
                this.wrappedTsm = wrappedTsm;
                this.chunkSize = chunkSize;
                this.fillerItem = fillerItem;
                this.numberOfChunks = (wrappedTsm.size() + chunkSize - 1) / chunkSize;
            }

            public TemplateModel get(final int chunkIndex) throws TemplateModelException {
                if (chunkIndex >= this.numberOfChunks) {
                    return null;
                }
                return new TemplateSequenceModel(){
                    private final int baseIndex;
                    {
                        this.baseIndex = chunkIndex * ChunkedSequence.this.chunkSize;
                    }

                    public TemplateModel get(int relIndex) throws TemplateModelException {
                        int absIndex = this.baseIndex + relIndex;
                        if (absIndex < ChunkedSequence.this.wrappedTsm.size()) {
                            return ChunkedSequence.this.wrappedTsm.get(absIndex);
                        }
                        return absIndex < ChunkedSequence.this.numberOfChunks * ChunkedSequence.this.chunkSize ? ChunkedSequence.this.fillerItem : null;
                    }

                    public int size() throws TemplateModelException {
                        return ChunkedSequence.this.fillerItem != null || chunkIndex + 1 < ChunkedSequence.this.numberOfChunks ? ChunkedSequence.this.chunkSize : ChunkedSequence.this.wrappedTsm.size() - this.baseIndex;
                    }
                };
            }

            public int size() throws TemplateModelException {
                return this.numberOfChunks;
            }
        }

        private static class BIMethod
        implements TemplateMethodModelEx {
            private final TemplateSequenceModel tsm;

            private BIMethod(TemplateSequenceModel tsm) {
                this.tsm = tsm;
            }

            public Object exec(List args) throws TemplateModelException {
                int numArgs = args.size();
                if (numArgs != 1 && numArgs != 2) {
                    throw new TemplateModelException("?chunk(...) expects 1 or 2 arguments.");
                }
                Object chunkSize = args.get(0);
                if (!(chunkSize instanceof TemplateNumberModel)) {
                    throw new TemplateModelException("?chunk(...) expects a number as its 1st argument.");
                }
                return new ChunkedSequence(this.tsm, ((TemplateNumberModel)chunkSize).getAsNumber().intValue(), numArgs > 1 ? (TemplateModel)args.get(1) : null);
            }
        }
    }

    static class seq_index_ofBI
    extends BuiltIn {
        private int m_dir;

        public seq_index_ofBI(int dir) {
            this.m_dir = dir;
        }

        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            return new BIMethod(env);
        }

        private class BIMethod
        implements TemplateMethodModelEx {
            protected final TemplateSequenceModel m_seq;
            protected final TemplateCollectionModel m_col;
            protected final Environment m_env;

            private BIMethod(Environment env) throws TemplateException {
                TemplateModel model = seq_index_ofBI.this.target.getAsTemplateModel(env);
                this.m_seq = model instanceof TemplateSequenceModel && !SequenceBuiltins.isBuggySeqButGoodCollection(model) ? (TemplateSequenceModel)model : null;
                TemplateCollectionModel templateCollectionModel = this.m_col = this.m_seq == null && model instanceof TemplateCollectionModel ? (TemplateCollectionModel)model : null;
                if (this.m_seq == null && this.m_col == null) {
                    throw TemplateObject.invalidTypeException(model, seq_index_ofBI.this.target, env, "sequence or collection");
                }
                this.m_env = env;
            }

            public final Object exec(List args) throws TemplateModelException {
                int foundAtIdx;
                int argcnt = args.size();
                if (argcnt != 1 && argcnt != 2) {
                    throw new TemplateModelException(this.getBuiltinTemplate() + " expects 1 or 2 arguments.");
                }
                TemplateModel target = (TemplateModel)args.get(0);
                if (argcnt > 1) {
                    Object obj = args.get(1);
                    if (!(obj instanceof TemplateNumberModel)) {
                        throw new TemplateModelException(this.getBuiltinTemplate() + "expects a number as its second argument.");
                    }
                    int startIndex = ((TemplateNumberModel)obj).getAsNumber().intValue();
                    foundAtIdx = this.m_seq != null ? this.findInSeq(target, startIndex) : this.findInCol(target, startIndex);
                } else {
                    foundAtIdx = this.m_seq != null ? this.findInSeq(target) : this.findInCol(target);
                }
                return foundAtIdx == -1 ? Constants.MINUS_ONE : new SimpleNumber(foundAtIdx);
            }

            private final String getBuiltinTemplate() {
                return seq_index_ofBI.this.m_dir == 1 ? "?seq_index_of(...)" : "?seq_last_index_of(...)";
            }

            public int findInSeq(TemplateModel target) throws TemplateModelException {
                int seqSize = this.m_seq.size();
                int actualStartIndex = seq_index_ofBI.this.m_dir == 1 ? 0 : seqSize - 1;
                return this.findInSeq(target, actualStartIndex, seqSize);
            }

            private int findInSeq(TemplateModel target, int startIndex) throws TemplateModelException {
                int seqSize = this.m_seq.size();
                if (seq_index_ofBI.this.m_dir == 1) {
                    if (startIndex >= seqSize) {
                        return -1;
                    }
                    if (startIndex < 0) {
                        startIndex = 0;
                    }
                } else {
                    if (startIndex >= seqSize) {
                        startIndex = seqSize - 1;
                    }
                    if (startIndex < 0) {
                        return -1;
                    }
                }
                return this.findInSeq(target, startIndex, seqSize);
            }

            private int findInSeq(TemplateModel target, int scanStartIndex, int seqSize) throws TemplateModelException {
                if (seq_index_ofBI.this.m_dir == 1) {
                    for (int i = scanStartIndex; i < seqSize; ++i) {
                        if (!SequenceBuiltins.modelsEqual(this.m_seq.get(i), target, this.m_env)) continue;
                        return i;
                    }
                } else {
                    for (int i = scanStartIndex; i >= 0; --i) {
                        if (!SequenceBuiltins.modelsEqual(this.m_seq.get(i), target, this.m_env)) continue;
                        return i;
                    }
                }
                return -1;
            }

            public int findInCol(TemplateModel target) throws TemplateModelException {
                return this.findInCol(target, 0, Integer.MAX_VALUE);
            }

            protected int findInCol(TemplateModel target, int startIndex) throws TemplateModelException {
                if (seq_index_ofBI.this.m_dir == 1) {
                    return this.findInCol(target, startIndex, Integer.MAX_VALUE);
                }
                return this.findInCol(target, 0, startIndex);
            }

            protected int findInCol(TemplateModel target, int allowedRangeStart, int allowedRangeEnd) throws TemplateModelException {
                if (allowedRangeEnd < 0) {
                    return -1;
                }
                TemplateModelIterator it = this.m_col.iterator();
                int foundAtIdx = -1;
                for (int idx = 0; it.hasNext() && idx <= allowedRangeEnd; ++idx) {
                    TemplateModel current = it.next();
                    if (idx < allowedRangeStart || !SequenceBuiltins.modelsEqual(current, target, this.m_env)) continue;
                    foundAtIdx = idx;
                    if (seq_index_ofBI.this.m_dir == 1) break;
                }
                return foundAtIdx;
            }
        }
    }

    static class seq_containsBI
    extends BuiltIn {
        seq_containsBI() {
        }

        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            TemplateModel model = this.target.getAsTemplateModel(env);
            if (model instanceof TemplateSequenceModel && !SequenceBuiltins.isBuggySeqButGoodCollection(model)) {
                return new BIMethodForSequence((TemplateSequenceModel)model, env);
            }
            if (model instanceof TemplateCollectionModel) {
                return new BIMethodForCollection((TemplateCollectionModel)model, env);
            }
            throw seq_containsBI.invalidTypeException(model, this.target, env, "sequence or collection");
        }

        private static class BIMethodForCollection
        implements TemplateMethodModelEx {
            private TemplateCollectionModel m_coll;
            private Environment m_env;

            private BIMethodForCollection(TemplateCollectionModel coll, Environment env) {
                this.m_coll = coll;
                this.m_env = env;
            }

            public Object exec(List args) throws TemplateModelException {
                if (args.size() != 1) {
                    throw new TemplateModelException("?seq_contains(...) expects one argument.");
                }
                TemplateModel arg = (TemplateModel)args.get(0);
                TemplateModelIterator it = this.m_coll.iterator();
                while (it.hasNext()) {
                    if (!SequenceBuiltins.modelsEqual(it.next(), arg, this.m_env)) continue;
                    return TemplateBooleanModel.TRUE;
                }
                return TemplateBooleanModel.FALSE;
            }
        }

        private static class BIMethodForSequence
        implements TemplateMethodModelEx {
            private TemplateSequenceModel m_seq;
            private Environment m_env;

            private BIMethodForSequence(TemplateSequenceModel seq, Environment env) {
                this.m_seq = seq;
                this.m_env = env;
            }

            public Object exec(List args) throws TemplateModelException {
                if (args.size() != 1) {
                    throw new TemplateModelException("?seq_contains(...) expects one argument.");
                }
                TemplateModel arg = (TemplateModel)args.get(0);
                int size = this.m_seq.size();
                for (int i = 0; i < size; ++i) {
                    if (!SequenceBuiltins.modelsEqual(this.m_seq.get(i), arg, this.m_env)) continue;
                    return TemplateBooleanModel.TRUE;
                }
                return TemplateBooleanModel.FALSE;
            }
        }
    }

    static class sort_byBI
    extends sortBI {
        sort_byBI() {
        }

        TemplateModel calculateResult(TemplateSequenceModel seq) {
            return new BIMethod(seq);
        }

        static class BIMethod
        implements TemplateMethodModelEx {
            TemplateSequenceModel seq;

            BIMethod(TemplateSequenceModel seq) {
                this.seq = seq;
            }

            public Object exec(List params) throws TemplateModelException {
                String[] subvars;
                if (params.size() == 0) {
                    throw new TemplateModelException("?sort_by(key) needs exactly 1 argument.");
                }
                Object obj = params.get(0);
                if (obj instanceof TemplateScalarModel) {
                    subvars = new String[]{((TemplateScalarModel)obj).getAsString()};
                } else if (obj instanceof TemplateSequenceModel) {
                    TemplateSequenceModel seq = (TemplateSequenceModel)obj;
                    int ln = seq.size();
                    subvars = new String[ln];
                    for (int i = 0; i < ln; ++i) {
                        TemplateModel item = seq.get(i);
                        try {
                            subvars[i] = ((TemplateScalarModel)item).getAsString();
                            continue;
                        }
                        catch (ClassCastException e) {
                            if (item instanceof TemplateScalarModel) continue;
                            throw new TemplateModelException("The argument to ?sort_by(key), when it is a sequence, must be a sequence of strings, but the item at index " + i + " is not a string.");
                        }
                    }
                } else {
                    throw new TemplateModelException("The argument to ?sort_by(key) must be a string (the name of the subvariable), or a sequence of strings (the \"path\" to the subvariable).");
                }
                return sortBI.sort(this.seq, subvars);
            }
        }
    }

    static class sortBI
    extends SequenceBuiltIn {
        static final int KEY_TYPE_NOT_YET_DETECTED = 0;
        static final int KEY_TYPE_STRING = 1;
        static final int KEY_TYPE_NUMBER = 2;
        static final int KEY_TYPE_DATE = 3;
        static final int KEY_TYPE_BOOLEAN = 4;

        sortBI() {
        }

        TemplateModel calculateResult(TemplateSequenceModel seq) throws TemplateModelException {
            return sortBI.sort(seq, null);
        }

        static String startErrorMessage(int keyNamesLn) {
            return (keyNamesLn == 0 ? "?sort" : "?sort_by(...)") + " failed: ";
        }

        static String startErrorMessage(int keyNamesLn, int index) {
            return (keyNamesLn == 0 ? "?sort" : "?sort_by(...)") + " failed at sequence index " + index + (index == 0 ? ": " : " (0-based): ");
        }

        static TemplateModelException newInconsistentSortKeyTypeException(int keyNamesLn, String firstType, String firstTypePlural, int index) {
            String valuesInMsg;
            String valueInMsg;
            if (keyNamesLn == 0) {
                valueInMsg = "value";
                valuesInMsg = "values";
            } else {
                valueInMsg = "key value";
                valuesInMsg = "key values";
            }
            return new TemplateModelException(sortBI.startErrorMessage(keyNamesLn, index) + "All " + valuesInMsg + " in the sequence must be " + firstTypePlural + ", because the first " + valueInMsg + " was that. However, the " + valueInMsg + " of the current item isn't a " + firstType + ".");
        }

        static TemplateSequenceModel sort(TemplateSequenceModel seq, String[] keyNames) throws TemplateModelException {
            int i;
            int ln = seq.size();
            if (ln == 0) {
                return seq;
            }
            ArrayList<Object> res = new ArrayList<Object>(ln);
            int keyNamesLn = keyNames == null ? 0 : keyNames.length;
            int keyType = 0;
            Comparator keyComparator = null;
            block18: for (i = 0; i < ln; ++i) {
                TemplateModel item;
                TemplateModel key = item = seq.get(i);
                for (int keyNameI = 0; keyNameI < keyNamesLn; ++keyNameI) {
                    try {
                        key = ((TemplateHashModel)key).get(keyNames[keyNameI]);
                    }
                    catch (ClassCastException e) {
                        if (!(key instanceof TemplateHashModel)) {
                            throw new TemplateModelException(sortBI.startErrorMessage(keyNamesLn, i) + (keyNameI == 0 ? "Sequence items must be hashes when using ?sort_by. " : "The " + StringUtil.jQuote(keyNames[keyNameI - 1]) + " subvariable is not a hash, so ?sort_by " + "can't proceed with getting the " + StringUtil.jQuote(keyNames[keyNameI]) + " subvariable."));
                        }
                        throw e;
                    }
                    if (key != null) continue;
                    throw new TemplateModelException(sortBI.startErrorMessage(keyNamesLn, i) + "The " + StringUtil.jQuote(keyNames[keyNameI]) + " subvariable was not found.");
                }
                if (keyType == 0) {
                    if (key instanceof TemplateScalarModel) {
                        keyType = 1;
                        keyComparator = new LexicalKVPComparator(Environment.getCurrentEnvironment().getCollator());
                    } else if (key instanceof TemplateNumberModel) {
                        keyType = 2;
                        keyComparator = new NumericalKVPComparator(Environment.getCurrentEnvironment().getArithmeticEngine());
                    } else if (key instanceof TemplateDateModel) {
                        keyType = 3;
                        keyComparator = new DateKVPComparator();
                    } else if (key instanceof TemplateBooleanModel) {
                        keyType = 4;
                        keyComparator = new BooleanKVPComparator();
                    } else {
                        throw new TemplateModelException(sortBI.startErrorMessage(keyNamesLn, i) + "Values used for sorting must be numbers, strings, " + "date/times or booleans.");
                    }
                }
                switch (keyType) {
                    case 1: {
                        try {
                            res.add(new KVP(((TemplateScalarModel)key).getAsString(), item));
                            continue block18;
                        }
                        catch (ClassCastException e) {
                            if (!(key instanceof TemplateScalarModel)) {
                                throw sortBI.newInconsistentSortKeyTypeException(keyNamesLn, "string", "strings", i);
                            }
                            throw e;
                        }
                    }
                    case 2: {
                        try {
                            res.add(new KVP(((TemplateNumberModel)key).getAsNumber(), item));
                            continue block18;
                        }
                        catch (ClassCastException e) {
                            if (key instanceof TemplateNumberModel) continue block18;
                            throw sortBI.newInconsistentSortKeyTypeException(keyNamesLn, "number", "numbers", i);
                        }
                    }
                    case 3: {
                        try {
                            res.add(new KVP(((TemplateDateModel)key).getAsDate(), item));
                            continue block18;
                        }
                        catch (ClassCastException e) {
                            if (key instanceof TemplateDateModel) continue block18;
                            throw sortBI.newInconsistentSortKeyTypeException(keyNamesLn, "date/time", "date/times", i);
                        }
                    }
                    case 4: {
                        try {
                            res.add(new KVP(((TemplateBooleanModel)key).getAsBoolean() ? Boolean.TRUE : Boolean.FALSE, item));
                            continue block18;
                        }
                        catch (ClassCastException e) {
                            if (key instanceof TemplateBooleanModel) continue block18;
                            throw sortBI.newInconsistentSortKeyTypeException(keyNamesLn, "boolean", "booleans", i);
                        }
                    }
                    default: {
                        throw new RuntimeException("FreeMarker bug: Unexpected key type");
                    }
                }
            }
            try {
                Collections.sort(res, keyComparator);
            }
            catch (Exception exc) {
                throw new TemplateModelException(sortBI.startErrorMessage(keyNamesLn) + "Unexpected error while sorting:" + exc, exc);
            }
            for (i = 0; i < ln; ++i) {
                res.set(i, ((KVP)res.get(i)).value);
            }
            return new TemplateModelListSequence(res);
        }

        private static class BooleanKVPComparator
        implements Comparator,
        Serializable {
            private BooleanKVPComparator() {
            }

            public int compare(Object arg0, Object arg1) {
                boolean b0 = (Boolean)((KVP)arg0).key;
                boolean b1 = (Boolean)((KVP)arg1).key;
                if (b0) {
                    return b1 ? 0 : 1;
                }
                return b1 ? -1 : 0;
            }
        }

        private static class DateKVPComparator
        implements Comparator,
        Serializable {
            private DateKVPComparator() {
            }

            public int compare(Object arg0, Object arg1) {
                return ((Date)((KVP)arg0).key).compareTo((Date)((KVP)arg1).key);
            }
        }

        private static class LexicalKVPComparator
        implements Comparator {
            private Collator collator;

            LexicalKVPComparator(Collator collator) {
                this.collator = collator;
            }

            public int compare(Object arg0, Object arg1) {
                return this.collator.compare(((KVP)arg0).key, ((KVP)arg1).key);
            }
        }

        private static class NumericalKVPComparator
        implements Comparator {
            private ArithmeticEngine ae;

            private NumericalKVPComparator(ArithmeticEngine ae) {
                this.ae = ae;
            }

            public int compare(Object arg0, Object arg1) {
                try {
                    return this.ae.compareNumbers((Number)((KVP)arg0).key, (Number)((KVP)arg1).key);
                }
                catch (TemplateException e) {
                    throw new ClassCastException("Failed to compare numbers: " + e);
                }
            }
        }

        private static class KVP {
            private Object key;
            private Object value;

            private KVP(Object key, Object value) {
                this.key = key;
                this.value = value;
            }
        }
    }

    static class reverseBI
    extends SequenceBuiltIn {
        reverseBI() {
        }

        TemplateModel calculateResult(TemplateSequenceModel tsm) {
            if (tsm instanceof ReverseSequence) {
                return ((ReverseSequence)tsm).seq;
            }
            return new ReverseSequence(tsm);
        }

        private static class ReverseSequence
        implements TemplateSequenceModel {
            private final TemplateSequenceModel seq;

            ReverseSequence(TemplateSequenceModel seq) {
                this.seq = seq;
            }

            public int size() throws TemplateModelException {
                return this.seq.size();
            }

            public TemplateModel get(int index) throws TemplateModelException {
                return this.seq.get(this.seq.size() - 1 - index);
            }
        }
    }

    static class lastBI
    extends SequenceBuiltIn {
        lastBI() {
        }

        TemplateModel calculateResult(TemplateSequenceModel tsm) throws TemplateModelException {
            if (tsm.size() == 0) {
                return null;
            }
            return tsm.get(tsm.size() - 1);
        }
    }

    static class firstBI
    extends SequenceBuiltIn {
        firstBI() {
        }

        TemplateModel calculateResult(TemplateSequenceModel tsm) throws TemplateModelException {
            if (tsm.size() == 0) {
                return null;
            }
            return tsm.get(0);
        }
    }

    static abstract class SequenceBuiltIn
    extends BuiltIn {
        SequenceBuiltIn() {
        }

        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            TemplateModel model = this.target.getAsTemplateModel(env);
            if (!(model instanceof TemplateSequenceModel)) {
                throw SequenceBuiltIn.invalidTypeException(model, this.target, env, "sequence");
            }
            return this.calculateResult((TemplateSequenceModel)model);
        }

        abstract TemplateModel calculateResult(TemplateSequenceModel var1) throws TemplateModelException;
    }
}

