/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.preferences.relocated.freemarker.ext.beans;

import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.uberfire.ext.preferences.relocated.freemarker.template.utility.UndeclaredThrowableException;

class MethodUtilities {
    static final Class OBJECT_CLASS = class$java$lang$Object == null ? (class$java$lang$Object = MethodUtilities.class$("java.lang.Object")) : class$java$lang$Object;
    private static final Method METHOD_IS_VARARGS = MethodUtilities.getIsVarArgsMethod(class$java$lang$reflect$Method == null ? (class$java$lang$reflect$Method = MethodUtilities.class$("java.lang.reflect.Method")) : class$java$lang$reflect$Method);
    private static final Method CONSTRUCTOR_IS_VARARGS = MethodUtilities.getIsVarArgsMethod(class$java$lang$reflect$Constructor == null ? (class$java$lang$reflect$Constructor = MethodUtilities.class$("java.lang.reflect.Constructor")) : class$java$lang$reflect$Constructor);
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$reflect$Method;
    static /* synthetic */ Class class$java$lang$reflect$Constructor;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Double;

    MethodUtilities() {
    }

    static Class getMostSpecificCommonType(Class c1, Class c2) {
        if (c1 == c2) {
            return c1;
        }
        if (c2.isPrimitive()) {
            if (c2 == Byte.TYPE) {
                c2 = class$java$lang$Byte == null ? (class$java$lang$Byte = MethodUtilities.class$("java.lang.Byte")) : class$java$lang$Byte;
            } else if (c2 == Short.TYPE) {
                c2 = class$java$lang$Short == null ? (class$java$lang$Short = MethodUtilities.class$("java.lang.Short")) : class$java$lang$Short;
            } else if (c2 == Character.TYPE) {
                c2 = class$java$lang$Character == null ? (class$java$lang$Character = MethodUtilities.class$("java.lang.Character")) : class$java$lang$Character;
            } else if (c2 == Integer.TYPE) {
                c2 = class$java$lang$Integer == null ? (class$java$lang$Integer = MethodUtilities.class$("java.lang.Integer")) : class$java$lang$Integer;
            } else if (c2 == Float.TYPE) {
                c2 = class$java$lang$Float == null ? (class$java$lang$Float = MethodUtilities.class$("java.lang.Float")) : class$java$lang$Float;
            } else if (c2 == Long.TYPE) {
                c2 = class$java$lang$Long == null ? (class$java$lang$Long = MethodUtilities.class$("java.lang.Long")) : class$java$lang$Long;
            } else if (c2 == Double.TYPE) {
                c2 = class$java$lang$Double == null ? (class$java$lang$Double = MethodUtilities.class$("java.lang.Double")) : class$java$lang$Double;
            }
        }
        Set a1 = MethodUtilities.getAssignables(c1, c2);
        Set a2 = MethodUtilities.getAssignables(c2, c1);
        a1.retainAll(a2);
        if (a1.isEmpty()) {
            return class$java$lang$Object == null ? (class$java$lang$Object = MethodUtilities.class$("java.lang.Object")) : class$java$lang$Object;
        }
        ArrayList<Class> max = new ArrayList<Class>();
        Iterator it = a1.iterator();
        block0: while (it.hasNext()) {
            Class clazz = (Class)it.next();
            Iterator maxiter = max.iterator();
            while (maxiter.hasNext()) {
                Class maxClazz = (Class)maxiter.next();
                if (MethodUtilities.isMoreSpecific(maxClazz, clazz)) continue block0;
                if (!MethodUtilities.isMoreSpecific(clazz, maxClazz)) continue;
                maxiter.remove();
            }
            max.add(clazz);
        }
        if (max.size() > 1) {
            return OBJECT_CLASS;
        }
        return (Class)max.get(0);
    }

    static boolean isMoreSpecific(Class specific, Class generic) {
        if (generic.isAssignableFrom(specific)) {
            return true;
        }
        if (generic.isPrimitive()) {
            if (generic == Short.TYPE && specific == Byte.TYPE) {
                return true;
            }
            if (generic == Integer.TYPE && (specific == Short.TYPE || specific == Byte.TYPE)) {
                return true;
            }
            if (generic == Long.TYPE && (specific == Integer.TYPE || specific == Short.TYPE || specific == Byte.TYPE)) {
                return true;
            }
            if (generic == Float.TYPE && (specific == Long.TYPE || specific == Integer.TYPE || specific == Short.TYPE || specific == Byte.TYPE)) {
                return true;
            }
            if (generic == Double.TYPE && (specific == Float.TYPE || specific == Long.TYPE || specific == Integer.TYPE || specific == Short.TYPE || specific == Byte.TYPE)) {
                return true;
            }
        }
        return false;
    }

    private static Set getAssignables(Class c1, Class c2) {
        HashSet s = new HashSet();
        MethodUtilities.collectAssignables(c1, c2, s);
        return s;
    }

    private static void collectAssignables(Class c1, Class c2, Set s) {
        Class sc;
        if (c1.isAssignableFrom(c2)) {
            s.add(c1);
        }
        if ((sc = c1.getSuperclass()) != null) {
            MethodUtilities.collectAssignables(sc, c2, s);
        }
        Class<?>[] itf = c1.getInterfaces();
        for (int i = 0; i < itf.length; ++i) {
            MethodUtilities.collectAssignables(itf[i], c2, s);
        }
    }

    static Class[] getParameterTypes(Member member) {
        if (member instanceof Method) {
            return ((Method)member).getParameterTypes();
        }
        if (member instanceof Constructor) {
            return ((Constructor)member).getParameterTypes();
        }
        throw new RuntimeException();
    }

    static boolean isVarArgs(Member member) {
        if (member instanceof Method) {
            return MethodUtilities.isVarArgs(member, METHOD_IS_VARARGS);
        }
        if (member instanceof Constructor) {
            return MethodUtilities.isVarArgs(member, CONSTRUCTOR_IS_VARARGS);
        }
        throw new RuntimeException();
    }

    private static boolean isVarArgs(Member member, Method isVarArgsMethod) {
        if (isVarArgsMethod == null) {
            return false;
        }
        try {
            return (Boolean)isVarArgsMethod.invoke((Object)member, (Object[])null);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    private static Method getIsVarArgsMethod(Class memberClass) {
        try {
            return memberClass.getMethod("isVarArgs", null);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

