/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.preferences.scope;

import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.guvnor.common.services.project.context.ProjectContext;
import org.guvnor.common.services.project.model.Project;
import org.uberfire.preferences.shared.PreferenceScope;
import org.uberfire.preferences.shared.PreferenceScopeFactory;
import org.uberfire.preferences.shared.bean.PreferenceScopeBean;

@Dependent
public class UserProjectPreferenceScope
implements PreferenceScopeBean {
    private PreferenceScopeFactory scopeFactory;
    private ProjectContext projectContext;
    private Project project;

    @Inject
    public UserProjectPreferenceScope(PreferenceScopeFactory scopeFactory, ProjectContext projectContext) {
        this.scopeFactory = scopeFactory;
        this.projectContext = projectContext;
    }

    public UserProjectPreferenceScope forProject(Project project) {
        this.project = project;
        return this;
    }

    public PreferenceScope resolve() {
        if (this.project != null) {
            return this.createProjectScope(this.project);
        }
        if (this.projectContext.getActiveProject() != null) {
            return this.createProjectScope(this.projectContext.getActiveProject());
        }
        throw new RuntimeException("A project must be selected or be active to use this scope.");
    }

    private PreferenceScope createProjectScope(Project project) {
        PreferenceScope projectScope = this.scopeFactory.createScope("project", project.getEncodedIdentifier());
        PreferenceScope userProjectScope = this.scopeFactory.createScope("user", projectScope);
        return userProjectScope;
    }
}

