/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.model;

import java.util.ArrayList;
import java.util.Collection;
import org.guvnor.common.services.project.model.POM;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.uberfire.backend.vfs.Path;
import org.uberfire.util.URIUtil;

@Portable
public class Module {
    protected Path rootPath;
    protected Path pomXMLPath;
    protected Collection<String> modules = new ArrayList<String>();
    protected POM pom;
    private int numberOfAssets;

    public Module() {
    }

    public Module(Path rootPath, Path pomXMLPath, POM pom) {
        this(rootPath, pomXMLPath);
        this.pom = (POM)PortablePreconditions.checkNotNull((String)"pom", (Object)pom);
    }

    public Module(Path rootPath, Path pomXMLPath, POM pom, Collection<String> modules) {
        this(rootPath, pomXMLPath, pom);
        this.modules = modules;
    }

    public Module(Path rootPath, Path pomXMLPath) {
        this.rootPath = (Path)PortablePreconditions.checkNotNull((String)"rootPath", (Object)rootPath);
        this.pomXMLPath = (Path)PortablePreconditions.checkNotNull((String)"pomXMLPath", (Object)pomXMLPath);
    }

    public int getNumberOfAssets() {
        return this.numberOfAssets;
    }

    public void setNumberOfAssets(int numberOfAssets) {
        this.numberOfAssets = numberOfAssets;
    }

    public Path getRootPath() {
        return this.rootPath;
    }

    public Path getPomXMLPath() {
        return this.pomXMLPath;
    }

    public String getModuleName() {
        if (this.pom != null && this.pom.getName() != null) {
            return this.pom.getName();
        }
        if (this.pom != null && this.pom.getGav() != null && this.pom.getGav().getArtifactId() != null && !this.pom.getGav().getArtifactId().trim().isEmpty()) {
            return this.pom.getGav().getArtifactId();
        }
        return this.getRootPath().getFileName();
    }

    public String getIdentifier() {
        return this.getRootPath().toURI();
    }

    public String getEncodedIdentifier() {
        return URIUtil.encodeQueryString((String)this.getIdentifier());
    }

    public Collection<String> getModules() {
        return this.modules;
    }

    public POM getPom() {
        return this.pom;
    }

    public void setPom(POM pom) {
        this.pom = pom;
    }

    public int hashCode() {
        int hash = 5;
        hash = 17 * hash + (this.rootPath != null ? this.rootPath.hashCode() : 0);
        hash = ~(~hash);
        hash = 17 * hash + (this.pomXMLPath != null ? this.pomXMLPath.hashCode() : 0);
        hash = ~(~hash);
        hash = 17 * hash + (this.pom != null ? this.pom.hashCode() : 0);
        hash = ~(~hash);
        hash = 17 * hash + (this.modules != null ? this.modules.hashCode() : 0);
        hash = ~(~hash);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Module other = (Module)obj;
        if (!(this.rootPath == other.rootPath || this.rootPath != null && this.rootPath.equals(other.rootPath))) {
            return false;
        }
        if (!(this.pomXMLPath == other.pomXMLPath || this.pomXMLPath != null && this.pomXMLPath.equals(other.pomXMLPath))) {
            return false;
        }
        if (this.pom == null ? other.pom != null : !this.pom.equals(other.pom)) {
            return false;
        }
        return this.modules == other.modules || this.modules != null && this.modules.equals(other.modules);
    }
}

