/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.model;

import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.guvnor.common.services.project.model.GAV;
import org.junit.Test;

public class GAVTest {
    @Test
    public void testGAVFromString() {
        GAV gav = new GAV("myGroupID:myArtifactID:version");
        Assertions.assertThat((String)gav.getGroupId()).isEqualTo("myGroupID");
        Assertions.assertThat((String)gav.getArtifactId()).isEqualTo("myArtifactID");
        Assertions.assertThat((String)gav.getVersion()).isEqualTo("version");
    }

    @Test
    public void whenGivenNullString_throwsIllegalArgumentException() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new GAV(null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'gavString' should be not null!");
    }

    @Test
    public void createGavFromString() {
        GAV gav1 = new GAV("gr1:ar1:ver1");
        Assertions.assertThat((String)gav1.getGroupId()).isEqualTo("gr1");
        Assertions.assertThat((String)gav1.getArtifactId()).isEqualTo("ar1");
        Assertions.assertThat((String)gav1.getVersion()).isEqualTo("ver1");
        GAV gav2 = new GAV("gr2:ar2:ver2:compile");
        Assertions.assertThat((String)gav2.getGroupId()).isEqualTo("gr2");
        Assertions.assertThat((String)gav2.getArtifactId()).isEqualTo("ar2");
        Assertions.assertThat((String)gav2.getVersion()).isEqualTo("ver2");
    }

    @Test
    public void whenGivenInvalidGav_throwsIllegalArgumentExceptions() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new GAV("nonsense")).isInstanceOf(IllegalArgumentException.class)).hasMessage("The GAV String must have the form group:artifact:version[:scope] but was 'nonsense'");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new GAV("mygroup:myartifact")).isInstanceOf(IllegalArgumentException.class)).hasMessage("The GAV String must have the form group:artifact:version[:scope] but was 'mygroup:myartifact'");
    }

    @Test
    public void isSnapshotTest() {
        GAV noSnapshot1 = new GAV();
        GAV noSnapshot2 = new GAV("group:artifact:1.0");
        GAV noSnapshot3 = new GAV("group", "artifact", "version");
        GAV noSnapshot4 = new GAV("group", "artifact", null);
        GAV snapshot = new GAV("group", "artifact", "1.0-SNAPSHOT");
        Assertions.assertThat((boolean)noSnapshot1.isSnapshot()).isFalse();
        Assertions.assertThat((boolean)noSnapshot2.isSnapshot()).isFalse();
        Assertions.assertThat((boolean)noSnapshot3.isSnapshot()).isFalse();
        Assertions.assertThat((boolean)noSnapshot4.isSnapshot()).isFalse();
        Assertions.assertThat((boolean)snapshot.isSnapshot()).isTrue();
    }
}

