/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.model;

import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.repositories.Branch;
import org.guvnor.structure.repositories.Repository;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.uberfire.backend.vfs.Path;

public class WorkspaceProjectTest {
    @Test
    public void OUCanNotBeNull() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new WorkspaceProject(null, (Repository)Mockito.mock(Repository.class), (Branch)Mockito.mock(Branch.class), (Module)Mockito.mock(Module.class))).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'organizationalUnit' should be not null!");
    }

    @Test
    public void ProjectCanNotBeNull() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new WorkspaceProject((OrganizationalUnit)Mockito.mock(OrganizationalUnit.class), null, (Branch)Mockito.mock(Branch.class), (Module)Mockito.mock(Module.class))).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'repository' should be not null!");
    }

    @Test
    public void BranchCanNotBeNull() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new WorkspaceProject((OrganizationalUnit)Mockito.mock(OrganizationalUnit.class), (Repository)Mockito.mock(Repository.class), null, (Module)Mockito.mock(Module.class))).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'branch' should be not null!");
    }

    @Test
    public void ModuleCanBeNull() {
        new WorkspaceProject((OrganizationalUnit)Mockito.mock(OrganizationalUnit.class), (Repository)Mockito.mock(Repository.class), (Branch)Mockito.mock(Branch.class), null);
    }

    @Test
    public void getNameNoModule() {
        Repository repository = (Repository)Mockito.mock(Repository.class);
        ((Repository)Mockito.doReturn((Object)"my-repo").when((Object)repository)).getAlias();
        WorkspaceProject workspaceProject = new WorkspaceProject((OrganizationalUnit)Mockito.mock(OrganizationalUnit.class), repository, (Branch)Mockito.mock(Branch.class), null);
        Assert.assertEquals((Object)"my-repo", (Object)workspaceProject.getName());
    }

    @Test
    public void getName() {
        Repository repository = (Repository)Mockito.mock(Repository.class);
        ((Repository)Mockito.doReturn((Object)"my-repo").when((Object)repository)).getAlias();
        Module mainModule = (Module)Mockito.mock(Module.class);
        ((Module)Mockito.doReturn((Object)"my-module").when((Object)mainModule)).getModuleName();
        WorkspaceProject workspaceProject = new WorkspaceProject((OrganizationalUnit)Mockito.mock(OrganizationalUnit.class), repository, (Branch)Mockito.mock(Branch.class), mainModule);
        Assert.assertEquals((Object)"my-module", (Object)workspaceProject.getName());
    }

    @Test
    public void getNameNoModuleName() {
        Repository repository = (Repository)Mockito.mock(Repository.class);
        ((Repository)Mockito.doReturn((Object)"my-repo").when((Object)repository)).getAlias();
        Module mainModule = (Module)Mockito.mock(Module.class);
        ((Module)Mockito.doReturn((Object)"").when((Object)mainModule)).getModuleName();
        WorkspaceProject workspaceProject = new WorkspaceProject((OrganizationalUnit)Mockito.mock(OrganizationalUnit.class), repository, (Branch)Mockito.mock(Branch.class), mainModule);
        Assert.assertEquals((Object)"my-repo", (Object)workspaceProject.getName());
    }

    @Test
    public void getRootPath() {
        Branch branch = (Branch)Mockito.mock(Branch.class);
        Path branchPath = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)branch.getPath()).thenReturn((Object)branchPath);
        WorkspaceProject workspaceProject = new WorkspaceProject((OrganizationalUnit)Mockito.mock(OrganizationalUnit.class), (Repository)Mockito.mock(Repository.class), branch, (Module)Mockito.mock(Module.class));
        Assert.assertEquals((Object)branchPath, (Object)workspaceProject.getRootPath());
    }

    @Test
    public void requiresRefresh() {
        WorkspaceProject workspaceProject = new WorkspaceProject((OrganizationalUnit)Mockito.mock(OrganizationalUnit.class), (Repository)Mockito.mock(Repository.class), (Branch)Mockito.mock(Branch.class), (Module)Mockito.mock(Module.class));
        Assert.assertTrue((boolean)workspaceProject.requiresRefresh());
        workspaceProject.markAsCached();
        Assert.assertFalse((boolean)workspaceProject.requiresRefresh());
    }
}

