/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.backend.server;

import java.util.ArrayList;
import javax.enterprise.event.Event;
import org.guvnor.common.services.backend.util.CommentedOptionFactory;
import org.guvnor.common.services.project.backend.server.POMServiceImpl;
import org.guvnor.common.services.project.backend.server.PomEnhancer;
import org.guvnor.common.services.project.backend.server.utils.POMContentHandler;
import org.guvnor.common.services.project.events.ModuleUpdatedEvent;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.service.ModuleService;
import org.guvnor.common.services.shared.metadata.MetadataService;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.guvnor.m2repo.service.M2RepoService;
import org.guvnor.test.TestFileSystem;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.Path;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=MockitoJUnitRunner.class)
public class POMServiceImplSaveWithSubModulesTest {
    @Mock
    private IOService ioService;
    @Mock
    private ModuleService moduleService;
    @Mock
    private EventSourceMock<ModuleUpdatedEvent> moduleUpdatedEvent;
    @Captor
    private ArgumentCaptor<Path> pathArgumentCaptor;
    private TestFileSystem testFileSystem;
    private POMServiceImpl service;

    @Before
    public void setUp() throws Exception {
        this.testFileSystem = new TestFileSystem();
        ((ModuleService)Mockito.doReturn((Object)Mockito.mock(Module.class)).when((Object)this.moduleService)).resolveModule((org.uberfire.backend.vfs.Path)Matchers.any());
        this.service = new POMServiceImpl(this.ioService, (POMContentHandler)Mockito.mock(POMContentHandler.class), (M2RepoService)Mockito.mock(M2RepoService.class), (MetadataService)Mockito.mock(MetadataService.class), (Event)this.moduleUpdatedEvent, this.moduleService, (CommentedOptionFactory)Mockito.mock(CommentedOptionFactory.class), (PomEnhancer)Mockito.mock(PomEnhancer.class)){
            int index;
            {
                this.index = 0;
            }

            public POM load(org.uberfire.backend.vfs.Path pomPath) {
                return new POM("mymodule " + this.index++, "desctiption", "url", new GAV());
            }
        };
    }

    @After
    public void tearDown() throws Exception {
        this.testFileSystem.tearDown();
    }

    @Test
    public void whenProjectSubModulesEdited_UpdateModuleEventIsFired() throws Exception {
        org.uberfire.backend.vfs.Path path = this.testFileSystem.createTempFile("testproject/pom.xml");
        ((IOService)Mockito.doReturn((Object)true).when((Object)this.ioService)).exists((Path)Matchers.any());
        POM pom = new POM("newName", "desctiption", "url", new GAV());
        pom.setPackaging("pom");
        ArrayList<String> modules = new ArrayList<String>();
        modules.add("module1");
        modules.add("module2");
        pom.setModules(modules);
        this.service.save(path, pom, (Metadata)Mockito.mock(Metadata.class), "", true);
        ((EventSourceMock)Mockito.verify(this.moduleUpdatedEvent, (VerificationMode)Mockito.times((int)3))).fire(Matchers.any());
    }
}

