/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.backend.server;

import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.backend.util.CommentedOptionFactory;
import org.guvnor.common.services.project.backend.server.DefaultPomEnhancer;
import org.guvnor.common.services.project.backend.server.POMServiceImpl;
import org.guvnor.common.services.project.backend.server.PomEnhancer;
import org.guvnor.common.services.project.backend.server.utils.POMContentHandler;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.service.ModuleService;
import org.guvnor.common.services.shared.metadata.MetadataService;
import org.guvnor.m2repo.service.M2RepoService;
import org.guvnor.test.TestTempFileSystem;
import org.guvnor.test.WeldJUnitRunner;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=WeldJUnitRunner.class)
public class POMServiceImplCreateTest {
    @Inject
    @Named(value="ioStrategy")
    IOService ioService;
    @Inject
    POMContentHandler pomContentHandler;
    @Mock
    M2RepoService m2RepoService;
    @Mock
    MetadataService metadataService;
    PomEnhancer pomEnhancer;
    private POMServiceImpl service;
    @Inject
    private Paths paths;
    private IOService ioServiceSpy;
    @Inject
    private TestTempFileSystem testFileSystem;

    @Before
    public void setUp() throws Exception {
        this.pomEnhancer = new DefaultPomEnhancer();
        MockitoAnnotations.initMocks((Object)this);
        this.ioServiceSpy = (IOService)Mockito.spy((Object)this.ioService);
        this.service = new POMServiceImpl(this.ioServiceSpy, this.pomContentHandler, this.m2RepoService, this.metadataService, (Event)new EventSourceMock(), (ModuleService)Mockito.mock(ModuleService.class), (CommentedOptionFactory)Mockito.mock(CommentedOptionFactory.class), this.pomEnhancer);
    }

    @After
    public void tearDown() throws Exception {
        this.testFileSystem.tearDown();
    }

    @Test
    public void testCreate() throws Exception {
        org.uberfire.backend.vfs.Path path = this.testFileSystem.createTempDirectory("/MyTestProject");
        this.service.create(path, new POM());
        ArgumentCaptor pathArgumentCaptor = ArgumentCaptor.forClass(Path.class);
        ArgumentCaptor stringArgumentCaptor = ArgumentCaptor.forClass(String.class);
        ((IOService)Mockito.verify((Object)this.ioServiceSpy)).write((Path)pathArgumentCaptor.capture(), (String)stringArgumentCaptor.capture(), new OpenOption[0]);
        Assert.assertEquals((Object)((Path)pathArgumentCaptor.getValue()).toUri().toString(), (Object)(path.toURI() + "/pom.xml"));
        String pomXML = (String)stringArgumentCaptor.getValue();
        Assert.assertTrue((boolean)pomXML.contains("<id>guvnor-m2-repo</id>"));
    }
}

