/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.backend.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.service.ProjectSearchService;
import org.guvnor.common.services.project.service.ProjectService;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryService;
import org.jboss.errai.bus.server.annotations.Service;

@Service
@ApplicationScoped
public class ProjectSearchServiceImpl
implements ProjectSearchService {
    private RepositoryService repositoryService;
    private Instance<ProjectService<? extends Project>> projectServices;

    @Inject
    public ProjectSearchServiceImpl(RepositoryService repositoryService, Instance<ProjectService<? extends Project>> projectServices) {
        this.repositoryService = repositoryService;
        this.projectServices = projectServices;
    }

    public ProjectService getProjectService() {
        return (ProjectService)this.projectServices.get();
    }

    public Collection<Project> searchByName(String pattern, int maxItems, boolean caseSensitive) {
        ArrayList<Project> results = new ArrayList<Project>();
        for (Repository repository : this.repositoryService.getAllRepositories()) {
            ProjectService projectService = this.getProjectService();
            if (projectService == null) continue;
            Set repositoryProjects = projectService.getAllProjects(repository, "master");
            for (Project project : repositoryProjects) {
                String name = project.getProjectName();
                if (!(caseSensitive ? name.contains(pattern) : name.toLowerCase().contains(pattern.toLowerCase()))) continue;
                results.add(project);
                if (maxItems <= 0 || results.size() < maxItems) continue;
                return results;
            }
        }
        return results;
    }

    public Collection<Project> searchById(Collection<String> ids) {
        ArrayList<Project> results = new ArrayList<Project>();
        for (Repository repository : this.repositoryService.getAllRepositories()) {
            ProjectService projectService = this.getProjectService();
            if (projectService == null) continue;
            Set repositoryProjects = projectService.getAllProjects(repository, "master");
            for (Project project : repositoryProjects) {
                if (!ids.contains(project.getIdentifier())) continue;
                results.add(project);
            }
        }
        return results;
    }
}

