/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.backend.server;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Instance;
import org.guvnor.common.services.project.backend.server.WorkspaceProjectServiceImpl;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.common.services.project.model.MavenRepositoryMetadata;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.common.services.project.service.DeploymentMode;
import org.guvnor.common.services.project.service.ModuleRepositoryResolver;
import org.guvnor.common.services.project.service.ModuleService;
import org.guvnor.common.services.project.service.WorkspaceProjectService;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.guvnor.structure.organizationalunit.impl.OrganizationalUnitImpl;
import org.guvnor.structure.repositories.Branch;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryEnvironmentConfigurations;
import org.guvnor.structure.repositories.RepositoryService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.backend.server.spaces.SpacesAPIImpl;
import org.uberfire.backend.vfs.Path;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.spaces.Space;
import org.uberfire.spaces.SpacesAPI;

@RunWith(value=MockitoJUnitRunner.class)
public class WorkspaceProjectServiceImplTest {
    WorkspaceProjectService workspaceProjectService;
    @Mock
    OrganizationalUnitService organizationalUnitService;
    @Mock
    RepositoryService repositoryService;
    @Mock
    Instance<ModuleService<? extends Module>> moduleServices;
    @Mock
    Repository repository1;
    @Mock
    Repository repository2;
    @Mock
    Repository repository3;
    @Mock
    ModuleService moduleService;
    @Mock
    ModuleRepositoryResolver repositoryResolver;
    SpacesAPI spaces = new SpacesAPIImpl();
    Space space1;
    Space space2;
    private OrganizationalUnit ou1;
    private OrganizationalUnit ou2;
    private List<Repository> allRepositories;

    @Before
    public void setUp() throws Exception {
        this.setUpOUs();
        this.setUpRepositories();
        ((Instance)Mockito.doReturn((Object)this.moduleService).when(this.moduleServices)).get();
        ((RepositoryService)Mockito.doReturn(this.allRepositories).when((Object)this.repositoryService)).getAllRepositoriesFromAllUserSpaces();
        this.workspaceProjectService = new WorkspaceProjectServiceImpl(this.organizationalUnitService, this.repositoryService, this.spaces, (Event)new EventSourceMock(), this.moduleServices, this.repositoryResolver);
    }

    private void setUpOUs() {
        this.ou1 = new OrganizationalUnitImpl("ou1", "defaultGroupID");
        this.ou2 = new OrganizationalUnitImpl("ou2", "defaultGroupID");
        this.space1 = this.spaces.getSpace("ou1");
        this.space2 = this.spaces.getSpace("ou2");
        ((OrganizationalUnitService)Mockito.doReturn((Object)this.ou1).when((Object)this.organizationalUnitService)).getOrganizationalUnit("ou1");
        ((OrganizationalUnitService)Mockito.doReturn((Object)this.ou2).when((Object)this.organizationalUnitService)).getOrganizationalUnit("ou2");
        ArrayList<OrganizationalUnit> allOUs = new ArrayList<OrganizationalUnit>();
        allOUs.add(this.ou1);
        allOUs.add(this.ou2);
        ((OrganizationalUnitService)Mockito.doReturn(allOUs).when((Object)this.organizationalUnitService)).getOrganizationalUnits();
        ((OrganizationalUnitService)Mockito.doReturn(allOUs).when((Object)this.organizationalUnitService)).getAllOrganizationalUnits();
        this.ou1.getRepositories().add(this.repository1);
        this.ou1.getRepositories().add(this.repository2);
        this.ou2.getRepositories().add(this.repository3);
    }

    private void setUpRepositories() {
        ((Repository)Mockito.doReturn(Optional.of(Mockito.mock(Branch.class))).when((Object)this.repository1)).getDefaultBranch();
        ((Repository)Mockito.doReturn((Object)"repository1").when((Object)this.repository1)).getAlias();
        ((Repository)Mockito.doReturn((Object)"space1/repository1").when((Object)this.repository1)).getIdentifier();
        ((Repository)Mockito.doReturn(Optional.of(Mockito.mock(Branch.class))).when((Object)this.repository2)).getDefaultBranch();
        ((Repository)Mockito.doReturn((Object)"repository-with-same-alias").when((Object)this.repository2)).getAlias();
        ((Repository)Mockito.doReturn((Object)"space1/repository-with-same-alias").when((Object)this.repository2)).getIdentifier();
        ((Repository)Mockito.doReturn(Optional.of(Mockito.mock(Branch.class))).when((Object)this.repository3)).getDefaultBranch();
        ((Repository)Mockito.doReturn((Object)"repository-with-same-alias").when((Object)this.repository3)).getAlias();
        ((Repository)Mockito.doReturn((Object)"space2/repository-with-same-alias").when((Object)this.repository3)).getIdentifier();
        this.allRepositories = new ArrayList<Repository>();
        this.allRepositories.add(this.repository1);
        this.allRepositories.add(this.repository2);
        this.allRepositories.add(this.repository3);
        ((RepositoryService)Mockito.doReturn(this.allRepositories).when((Object)this.repositoryService)).getAllRepositoriesFromAllUserSpaces();
        ((RepositoryService)Mockito.doReturn(this.allRepositories).when((Object)this.repositoryService)).getAllRepositoriesFromAllUserSpaces();
        ((RepositoryService)Mockito.doReturn(Arrays.asList(this.repository1, this.repository2)).when((Object)this.repositoryService)).getRepositories((Space)Mockito.eq((Object)this.space1));
        ((RepositoryService)Mockito.doReturn(Arrays.asList(this.repository1, this.repository2)).when((Object)this.repositoryService)).getAllRepositories((Space)Mockito.eq((Object)this.space1), Mockito.anyBoolean());
        ((RepositoryService)Mockito.doReturn(Arrays.asList(this.repository3)).when((Object)this.repositoryService)).getAllRepositories((Space)Mockito.eq((Object)this.space2), Mockito.anyBoolean());
        ((RepositoryService)Mockito.doReturn(Collections.singletonList(this.repository3)).when((Object)this.repositoryService)).getRepositories((Space)Mockito.eq((Object)this.space2));
    }

    @Test
    public void getAllProjects() {
        Collection allWorkspaceProjects = this.workspaceProjectService.getAllWorkspaceProjects();
        Assert.assertEquals((long)3L, (long)allWorkspaceProjects.size());
    }

    @Test
    public void getAllProjectsForOU1() {
        Collection allWorkspaceProjects = this.workspaceProjectService.getAllWorkspaceProjects(this.ou1);
        this.assertContains(this.repository1, allWorkspaceProjects);
        this.assertContains(this.repository2, allWorkspaceProjects);
        Assert.assertEquals((long)2L, (long)allWorkspaceProjects.size());
    }

    @Test
    public void getAllProjectsForOU2() {
        Collection allWorkspaceProjects = this.workspaceProjectService.getAllWorkspaceProjects(this.ou2);
        this.assertContains(this.repository3, allWorkspaceProjects);
        Assert.assertEquals((long)1L, (long)allWorkspaceProjects.size());
    }

    @Test
    public void getAllProjectsWithName() {
        Collection allWorkspaceProjects = this.workspaceProjectService.getAllWorkspaceProjectsByName(this.ou1, "repository-with-same-alias");
        this.assertContains(this.repository2, allWorkspaceProjects);
        Assert.assertEquals((long)1L, (long)allWorkspaceProjects.size());
    }

    @Test
    public void spaceHasProjectsWithName() {
        boolean hasNoProjects = this.workspaceProjectService.spaceHasNoProjectsWithName(this.ou1, "repository1", new WorkspaceProject(this.ou1, this.repository2, (Branch)this.repository2.getDefaultBranch().get(), null));
        Assert.assertFalse((boolean)hasNoProjects);
    }

    @Test
    public void spaceHasNoProjectsWithName() throws Exception {
        boolean hasNoProjects = this.workspaceProjectService.spaceHasNoProjectsWithName(this.ou1, "other-project", new WorkspaceProject(this.ou1, this.repository1, (Branch)this.repository1.getDefaultBranch().get(), null));
        Assert.assertTrue((boolean)hasNoProjects);
    }

    @Test
    public void spaceHasProjectsWithNameSameProject() throws Exception {
        boolean hasNoProjects = this.workspaceProjectService.spaceHasNoProjectsWithName(this.ou1, "repository1", new WorkspaceProject(this.ou1, this.repository1, (Branch)this.repository1.getDefaultBranch().get(), null));
        Assert.assertTrue((boolean)hasNoProjects);
    }

    @Test
    public void noProjects() {
        OrganizationalUnit organizationalUnit = (OrganizationalUnit)Mockito.mock(OrganizationalUnit.class);
        ((OrganizationalUnit)Mockito.doReturn((Object)"myOU").when((Object)organizationalUnit)).getName();
        ((OrganizationalUnitService)Mockito.doReturn((Object)organizationalUnit).when((Object)this.organizationalUnitService)).getOrganizationalUnit("myOU");
        Assert.assertTrue((boolean)this.workspaceProjectService.getAllWorkspaceProjects(organizationalUnit).isEmpty());
    }

    @Test
    public void testReturnSameNameIfProjectDoesNotExist() {
        String projectName = "projectA";
        POM pom = new POM(projectName, "description", "url", null);
        WorkspaceProjectServiceImpl impl = (WorkspaceProjectServiceImpl)this.workspaceProjectService;
        String newName = impl.createFreshProjectName(this.ou1, pom.getName());
        Assert.assertEquals((Object)projectName, (Object)newName);
    }

    @Test
    public void testCreateNewNameIfProjectExists() {
        POM pom = new POM("repository1", "description", "url", null);
        WorkspaceProjectServiceImpl impl = (WorkspaceProjectServiceImpl)this.workspaceProjectService;
        String newName = impl.createFreshProjectName(this.ou1, pom.getName());
        Assert.assertEquals((Object)"repository1-1", (Object)newName);
        ((Repository)Mockito.doReturn(Optional.of(Mockito.mock(Branch.class))).when((Object)this.repository2)).getDefaultBranch();
        ((Repository)Mockito.doReturn((Object)"repository1-1").when((Object)this.repository2)).getAlias();
        pom = new POM("repository1", "description", "url", null);
        impl = (WorkspaceProjectServiceImpl)this.workspaceProjectService;
        newName = impl.createFreshProjectName(this.ou1, pom.getName());
        Assert.assertEquals((Object)"repository1-2", (Object)newName);
    }

    @Test
    public void testReturnSameNameIfRepositoryDoesNotExist() {
        String repositoryName = "repositoryA";
        WorkspaceProjectServiceImpl impl = (WorkspaceProjectServiceImpl)this.workspaceProjectService;
        String newName = impl.createFreshRepositoryAlias(this.ou1, repositoryName);
        Assert.assertEquals((Object)repositoryName, (Object)newName);
    }

    @Test
    public void testCreateNewNameIfRepositoryExists() {
        String repositoryName = "repository1";
        WorkspaceProjectServiceImpl impl = (WorkspaceProjectServiceImpl)this.workspaceProjectService;
        String newName = impl.createFreshProjectName(this.ou1, repositoryName);
        Assert.assertEquals((Object)"repository1-1", (Object)newName);
        ((Repository)Mockito.doReturn(Optional.of(Mockito.mock(Branch.class))).when((Object)this.repository2)).getDefaultBranch();
        ((Repository)Mockito.doReturn((Object)"repository1-1").when((Object)this.repository2)).getAlias();
        WorkspaceProjectServiceImpl impl2 = (WorkspaceProjectServiceImpl)this.workspaceProjectService;
        String newName2 = impl2.createFreshProjectName(this.ou1, "repository1");
        Assert.assertEquals((Object)"repository1-2", (Object)newName2);
    }

    @Test
    public void testErrorWhenNewProject() {
        String repository1 = "repository1";
        POM pom = new POM(repository1, "description", "url", null);
        Mockito.when((Object)this.repositoryResolver.getRepositoriesResolvingArtifact((GAV)Mockito.any(GAV.class), new MavenRepositoryMetadata[0])).thenReturn(Collections.emptySet());
        Mockito.when((Object)this.repositoryService.createRepository((OrganizationalUnit)Mockito.eq((Object)this.ou1), (String)Mockito.eq((Object)"git"), (String)Mockito.any(), (RepositoryEnvironmentConfigurations)Mockito.any())).thenReturn((Object)this.repository1);
        Mockito.when((Object)this.moduleService.newModule((Path)Mockito.any(), (POM)Mockito.any(), (DeploymentMode)Mockito.any())).thenThrow(new Throwable[]{new RuntimeException("Expected error")});
        try {
            this.workspaceProjectService.newProject(this.ou1, pom);
        }
        catch (Exception e) {
            ((RepositoryService)Mockito.verify((Object)this.repositoryService)).removeRepository(new Space(this.ou1.getName()), repository1);
        }
    }

    private void assertContains(Repository repository, Collection<WorkspaceProject> allWorkspaceProjects) {
        for (WorkspaceProject workspaceProject : allWorkspaceProjects) {
            if (!workspaceProject.getRepository().equals(repository)) continue;
            return;
        }
        Assert.fail((String)("Could not find " + repository));
    }
}

