/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.backend.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.project.events.NewProjectEvent;
import org.guvnor.common.services.project.model.MavenRepositoryMetadata;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.common.services.project.service.DeploymentMode;
import org.guvnor.common.services.project.service.GAVAlreadyExistsException;
import org.guvnor.common.services.project.service.ModuleRepositoryResolver;
import org.guvnor.common.services.project.service.ModuleService;
import org.guvnor.common.services.project.service.WorkspaceProjectService;
import org.guvnor.common.services.project.utils.NewWorkspaceProjectUtils;
import org.guvnor.structure.contributors.Contributor;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.guvnor.structure.organizationalunit.config.SpaceConfigStorageRegistry;
import org.guvnor.structure.repositories.Branch;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryEnvironmentConfigurations;
import org.guvnor.structure.repositories.RepositoryService;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.java.nio.file.Path;
import org.uberfire.spaces.Space;
import org.uberfire.spaces.SpacesAPI;

public class WorkspaceProjectServiceImpl
implements WorkspaceProjectService {
    private OrganizationalUnitService organizationalUnitService;
    private RepositoryService repositoryService;
    private Event<NewProjectEvent> newProjectEvent;
    private ModuleService<? extends Module> moduleService;
    private SpacesAPI spaces;
    private ModuleRepositoryResolver repositoryResolver;
    private SpaceConfigStorageRegistry spaceConfigStorageRegistry;

    public WorkspaceProjectServiceImpl() {
    }

    @Inject
    public WorkspaceProjectServiceImpl(OrganizationalUnitService organizationalUnitService, RepositoryService repositoryService, SpacesAPI spaces, Event<NewProjectEvent> newProjectEvent, Instance<ModuleService<? extends Module>> moduleServices, ModuleRepositoryResolver repositoryResolver, SpaceConfigStorageRegistry spaceConfigStorageRegistry) {
        this.organizationalUnitService = organizationalUnitService;
        this.repositoryService = repositoryService;
        this.spaces = spaces;
        this.newProjectEvent = newProjectEvent;
        this.moduleService = (ModuleService)moduleServices.get();
        this.repositoryResolver = repositoryResolver;
        this.spaceConfigStorageRegistry = spaceConfigStorageRegistry;
    }

    public Collection<WorkspaceProject> getAllWorkspaceProjects() {
        ArrayList<WorkspaceProject> result = new ArrayList<WorkspaceProject>();
        for (OrganizationalUnit ou : this.organizationalUnitService.getOrganizationalUnits()) {
            result.addAll(this.getAllWorkspaceProjects(ou));
        }
        return result;
    }

    public Collection<WorkspaceProject> getAllWorkspaceProjects(OrganizationalUnit organizationalUnit) {
        return this.getAllWorkspaceProjectsByName(organizationalUnit, null);
    }

    public Collection<WorkspaceProject> getAllWorkspaceProjectsByName(OrganizationalUnit organizationalUnit, String name) {
        return this.getAllWorkspaceProjectsByName(organizationalUnit, name, false);
    }

    public Collection<WorkspaceProject> getAllWorkspaceProjectsByName(OrganizationalUnit organizationalUnit, String name, boolean includeDeleted) {
        ArrayList<WorkspaceProject> result = new ArrayList<WorkspaceProject>();
        Space space = this.spaces.getSpace(organizationalUnit.getName());
        for (Repository repository : this.repositoryService.getAllRepositories(space, includeDeleted)) {
            if (!repository.getDefaultBranch().isPresent()) continue;
            WorkspaceProject project = new WorkspaceProject(organizationalUnit, repository, (Branch)repository.getDefaultBranch().get(), this.moduleService.resolveModule(((Branch)repository.getDefaultBranch().get()).getPath()));
            if (name != null && !name.equals(project.getName())) continue;
            result.add(project);
        }
        return result;
    }

    public boolean spaceHasNoProjectsWithName(OrganizationalUnit organizationalUnit, String name, WorkspaceProject projectToIgnore) {
        return this.getAllWorkspaceProjectsByName(organizationalUnit, name).stream().noneMatch(p -> !p.getEncodedIdentifier().equals(projectToIgnore.getEncodedIdentifier()));
    }

    public WorkspaceProject newProject(OrganizationalUnit organizationalUnit, POM pom) {
        return this.newProject(organizationalUnit, pom, DeploymentMode.VALIDATED);
    }

    public WorkspaceProject newProject(OrganizationalUnit organizationalUnit, POM pom, DeploymentMode mode) {
        return this.newProject(organizationalUnit, pom, mode, null);
    }

    public WorkspaceProject newProject(OrganizationalUnit organizationalUnit, POM pom, DeploymentMode mode, List<Contributor> contributors) {
        return (WorkspaceProject)this.spaceConfigStorageRegistry.getBatch(organizationalUnit.getSpace().getName()).run(context -> {
            String newName = this.createFreshProjectName(organizationalUnit, pom.getName());
            pom.setName(newName);
            if (DeploymentMode.VALIDATED.equals((Object)mode)) {
                this.checkRepositories(pom);
            }
            String repositoryAlias = this.createFreshRepositoryAlias(organizationalUnit, pom.getName());
            Repository repository = this.repositoryService.createRepository(organizationalUnit, "git", repositoryAlias, new RepositoryEnvironmentConfigurations(), contributors != null ? contributors : Collections.emptyList());
            try {
                if (!repository.getDefaultBranch().isPresent()) {
                    throw new IllegalStateException("New repository should always have a branch.");
                }
                Module module = (Module)this.moduleService.newModule(((Branch)repository.getDefaultBranch().get()).getPath(), pom, mode);
                WorkspaceProject workspaceProject = new WorkspaceProject(organizationalUnit, repository, (Branch)repository.getDefaultBranch().get(), module);
                this.newProjectEvent.fire((Object)new NewProjectEvent(workspaceProject));
                return workspaceProject;
            }
            catch (Exception e) {
                this.repositoryService.removeRepository(this.spaces.getSpace(organizationalUnit.getName()), repository.getAlias());
                throw ExceptionUtilities.handleException((Exception)e);
            }
        });
    }

    String createFreshRepositoryAlias(OrganizationalUnit organizationalUnit, String projectName) {
        int index = 0;
        String suffix = "";
        String repositoryAlias = (String)PortablePreconditions.checkNotNull((String)"project name in pom model", (Object)NewWorkspaceProjectUtils.sanitizeProjectName((String)projectName));
        while (this.repositoryService.getRepositoryFromSpace(organizationalUnit.getSpace(), repositoryAlias + suffix) != null) {
            suffix = "-" + ++index;
        }
        return repositoryAlias + suffix;
    }

    public String createFreshProjectName(OrganizationalUnit organizationalUnit, String name) {
        int index = 0;
        String suffix = "";
        while (!this.getAllWorkspaceProjectsByName(organizationalUnit, name + suffix, true).isEmpty()) {
            suffix = "-" + ++index;
        }
        return name + suffix;
    }

    public WorkspaceProject resolveProject(Repository repository) {
        if (!repository.getDefaultBranch().isPresent()) {
            throw new IllegalStateException("New repository should always have a branch.");
        }
        return this.resolveProject(repository.getSpace(), (Branch)repository.getDefaultBranch().get());
    }

    public WorkspaceProject resolveProject(Space space, Branch branch) {
        return this.resolveProject(space, branch.getPath());
    }

    public WorkspaceProject resolveProject(Space space, Module module) {
        return this.resolveProject(space, module.getRootPath());
    }

    public WorkspaceProject resolveProject(Space space, String name) {
        OrganizationalUnit ou = this.organizationalUnitService.getOrganizationalUnit(space.getName());
        return this.resolveProject(ou, name);
    }

    private WorkspaceProject resolveProject(OrganizationalUnit ou, String name) {
        for (WorkspaceProject workspaceProject : this.getAllWorkspaceProjects(ou)) {
            if (!workspaceProject.getName().equals(name)) continue;
            return workspaceProject;
        }
        return null;
    }

    public WorkspaceProject resolveProjectByRepositoryAlias(Space space, String repositoryAlias) {
        return this.resolveProject(this.repositoryService.getRepositoryFromSpace(space, repositoryAlias));
    }

    public WorkspaceProject resolveProject(Space space, org.uberfire.backend.vfs.Path path) {
        Path repositoryRoot = Paths.convert((org.uberfire.backend.vfs.Path)path).getRoot();
        Repository repository = this.repositoryService.getRepository(space, Paths.convert((Path)repositoryRoot));
        if (repository == null) {
            throw new RuntimeException("Repository not found inside space " + space.getName() + " with path " + path.toURI() + " (root path " + repositoryRoot.toUri() + ")");
        }
        Branch branch = this.resolveBranch(repositoryRoot, repository);
        return new WorkspaceProject(this.organizationalUnitService.getOrganizationalUnit(repository.getSpace().getName()), repository, branch, this.moduleService.resolveModule(Paths.convert((Path)Paths.convert((org.uberfire.backend.vfs.Path)branch.getPath()).getRoot())));
    }

    public WorkspaceProject resolveProject(org.uberfire.backend.vfs.Path path) {
        return this.spaces.resolveSpace(path.toURI()).map(space -> this.resolveProject((Space)space, path)).orElseThrow(() -> new IllegalArgumentException("Could not determine space containing path: " + path));
    }

    private Branch resolveBranch(Path repositoryRoot, Repository repository) {
        if (!repository.getDefaultBranch().isPresent()) {
            throw new RuntimeException("Default branch not found in repository " + repository.getAlias() + " with path " + repositoryRoot.toUri());
        }
        Branch defaultBranch = (Branch)repository.getDefaultBranch().get();
        if (!Paths.convert((org.uberfire.backend.vfs.Path)defaultBranch.getPath()).equals(repositoryRoot)) {
            for (Branch branch : repository.getBranches()) {
                if (!Paths.convert((org.uberfire.backend.vfs.Path)branch.getPath()).equals(repositoryRoot)) continue;
                return branch;
            }
        }
        return defaultBranch;
    }

    private void checkRepositories(POM pom) {
        Set repositories = this.repositoryResolver.getRepositoriesResolvingArtifact(pom.getGav(), new MavenRepositoryMetadata[0]);
        if (repositories.size() > 0) {
            throw new GAVAlreadyExistsException(pom.getGav(), repositories);
        }
    }
}

