/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.backend.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.enterprise.inject.Instance;
import org.apache.commons.lang3.StringUtils;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.backend.file.LinkedDirectoryFilter;
import org.guvnor.common.services.backend.file.LinkedDotFileFilter;
import org.guvnor.common.services.backend.file.LinkedFilter;
import org.guvnor.common.services.backend.file.LinkedMetaInfFolderFilter;
import org.guvnor.common.services.backend.util.CommentedOptionFactory;
import org.guvnor.common.services.project.backend.server.ModuleResourcePathResolver;
import org.guvnor.common.services.project.backend.server.utils.IdentifierUtils;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.service.ModuleResourceResolver;
import org.guvnor.common.services.project.service.POMService;
import org.guvnor.common.services.project.service.PackageAlreadyExistsException;
import org.guvnor.common.services.project.utils.ModuleResourcePaths;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.Option;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.attribute.FileAttribute;

public abstract class ResourceResolver<T extends Module>
implements ModuleResourceResolver<T> {
    protected IOService ioService;
    protected POMService pomService;
    protected CommentedOptionFactory commentedOptionFactory;
    protected List<ModuleResourcePathResolver> resourcePathResolvers = new ArrayList<ModuleResourcePathResolver>();

    public ResourceResolver() {
    }

    public ResourceResolver(IOService ioService, POMService pomService, CommentedOptionFactory commentedOptionFactory, Instance<ModuleResourcePathResolver> resourcePathResolversInstance) {
        this.ioService = ioService;
        this.pomService = pomService;
        this.commentedOptionFactory = commentedOptionFactory;
        this.initResourcePathResolvers(resourcePathResolversInstance);
    }

    private void initResourcePathResolvers(Instance<ModuleResourcePathResolver> resourcePathResolversInstance) {
        Optional.ofNullable(resourcePathResolversInstance.iterator()).ifPresent(iterator -> iterator.forEachRemaining(resolver -> this.resourcePathResolvers.add((ModuleResourcePathResolver)resolver)));
    }

    public Package newPackage(Package parentPackage, String packageName, boolean startBatch) {
        String newPackageName = packageName.toLowerCase();
        if (newPackageName.contains(".")) {
            newPackageName = newPackageName.replace(".", "/");
        }
        org.uberfire.backend.vfs.Path mainSrcPath = parentPackage.getPackageMainSrcPath();
        org.uberfire.backend.vfs.Path testSrcPath = parentPackage.getPackageTestSrcPath();
        org.uberfire.backend.vfs.Path mainResourcesPath = parentPackage.getPackageMainResourcesPath();
        org.uberfire.backend.vfs.Path testResourcesPath = parentPackage.getPackageTestResourcesPath();
        org.uberfire.backend.vfs.Path pkgPath = null;
        FileSystem fs = Paths.convert((org.uberfire.backend.vfs.Path)parentPackage.getPackageMainSrcPath()).getFileSystem();
        try {
            Package newPackage;
            Path nioTestResourcesPackagePath;
            Path nioMainResourcesPackagePath;
            Path nioTestSrcPackagePath;
            Path nioMainSrcPackagePath;
            if (startBatch) {
                this.ioService.startBatch(fs, new Option[]{this.commentedOptionFactory.makeCommentedOption("New package [" + packageName + "]")});
            }
            if (!Files.exists((Path)(nioMainSrcPackagePath = Paths.convert((org.uberfire.backend.vfs.Path)mainSrcPath).resolve(newPackageName)), (LinkOption[])new LinkOption[0])) {
                pkgPath = Paths.convert((Path)this.ioService.createDirectory(nioMainSrcPackagePath, new FileAttribute[0]));
            }
            if (!Files.exists((Path)(nioTestSrcPackagePath = Paths.convert((org.uberfire.backend.vfs.Path)testSrcPath).resolve(newPackageName)), (LinkOption[])new LinkOption[0])) {
                pkgPath = Paths.convert((Path)this.ioService.createDirectory(nioTestSrcPackagePath, new FileAttribute[0]));
            }
            if (!Files.exists((Path)(nioMainResourcesPackagePath = Paths.convert((org.uberfire.backend.vfs.Path)mainResourcesPath).resolve(newPackageName)), (LinkOption[])new LinkOption[0])) {
                pkgPath = Paths.convert((Path)this.ioService.createDirectory(nioMainResourcesPackagePath, new FileAttribute[0]));
            }
            if (!Files.exists((Path)(nioTestResourcesPackagePath = Paths.convert((org.uberfire.backend.vfs.Path)testResourcesPath).resolve(newPackageName)), (LinkOption[])new LinkOption[0])) {
                pkgPath = Paths.convert((Path)this.ioService.createDirectory(nioTestResourcesPackagePath, new FileAttribute[0]));
            }
            if (pkgPath == null) {
                throw new PackageAlreadyExistsException(packageName);
            }
            Package package_ = newPackage = this.resolvePackage(pkgPath);
            return package_;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
        finally {
            if (startBatch) {
                this.ioService.endBatch();
            }
        }
    }

    private String getPackagePathSuffix(Path nioModuleRootPath, Path nioPackagePath) {
        Path nioMainSrcPath = nioModuleRootPath.resolve("src/main/java");
        Path nioTestSrcPath = nioModuleRootPath.resolve("src/test/java");
        Path nioMainResourcesPath = nioModuleRootPath.resolve("src/main/resources");
        Path nioTestResourcesPath = nioModuleRootPath.resolve("src/test/resources");
        String packageName = null;
        Path packagePath = null;
        if (nioPackagePath.startsWith(nioMainSrcPath)) {
            packagePath = nioMainSrcPath.relativize(nioPackagePath);
            packageName = packagePath.toString();
        } else if (nioPackagePath.startsWith(nioTestSrcPath)) {
            packagePath = nioTestSrcPath.relativize(nioPackagePath);
            packageName = packagePath.toString();
        } else if (nioPackagePath.startsWith(nioMainResourcesPath)) {
            packagePath = nioMainResourcesPath.relativize(nioPackagePath);
            packageName = packagePath.toString();
        } else if (nioPackagePath.startsWith(nioTestResourcesPath)) {
            packagePath = nioTestResourcesPath.relativize(nioPackagePath);
            packageName = packagePath.toString();
        }
        return packageName;
    }

    public T resolveModule(org.uberfire.backend.vfs.Path resource) {
        return (T)this.resolveModule(resource, true);
    }

    public Module resolveParentModule(org.uberfire.backend.vfs.Path resource) {
        try {
            if (resource == null) {
                return null;
            }
            Path path = Paths.convert((org.uberfire.backend.vfs.Path)resource).normalize();
            if (this.hasPom(path)) {
                org.uberfire.backend.vfs.Path moduleRootPath = Paths.convert((Path)path);
                org.uberfire.backend.vfs.Path pomXMLPath = Paths.convert((Path)path.resolve("pom.xml"));
                POM pom = (POM)this.pomService.load(pomXMLPath);
                return new Module(moduleRootPath, pomXMLPath, pom);
            }
            return null;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public Module resolveToParentModule(org.uberfire.backend.vfs.Path resource) {
        try {
            if (resource == null) {
                return null;
            }
            Path path = Paths.convert((org.uberfire.backend.vfs.Path)resource).normalize();
            Path parentPomPath = path.resolve("pom.xml");
            if (this.hasPom(path)) {
                POM parent = (POM)this.pomService.load(Paths.convert((Path)parentPomPath));
                org.uberfire.backend.vfs.Path moduleRootPath = Paths.convert((Path)path);
                Module module = new Module(moduleRootPath, Paths.convert((Path)parentPomPath), parent, (Collection)parent.getModules());
                return module;
            }
            return null;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public Set<Package> resolvePackages(Module module) {
        HashSet<Package> packages = new HashSet<Package>();
        HashSet<String> packageNames = new HashSet<String>();
        if (module == null) {
            return packages;
        }
        org.uberfire.backend.vfs.Path moduleRoot = module.getRootPath();
        Path nioModuleRootPath = Paths.convert((org.uberfire.backend.vfs.Path)moduleRoot);
        for (String src : ModuleResourcePaths.SOURCE_PATHS) {
            Path nioPackageRootSrcPath = nioModuleRootPath.resolve(src);
            packageNames.addAll(this.getPackageNames(nioModuleRootPath, nioPackageRootSrcPath, true, true, true));
        }
        HashSet<String> resolvedPackages = new HashSet<String>();
        for (String packagePathSuffix : packageNames) {
            for (String src : ModuleResourcePaths.SOURCE_PATHS) {
                Path nioPackagePath = nioModuleRootPath.resolve(src).resolve(packagePathSuffix);
                if (!Files.exists((Path)nioPackagePath, (LinkOption[])new LinkOption[0]) || resolvedPackages.contains(packagePathSuffix)) continue;
                packages.add(this.resolvePackage(Paths.convert((Path)nioPackagePath)));
                resolvedPackages.add(packagePathSuffix);
            }
        }
        return packages;
    }

    public Set<Package> resolvePackages(Package pkg) {
        HashSet<Package> packages = new HashSet<Package>();
        HashSet<String> packageNames = new HashSet<String>();
        if (pkg == null) {
            return packages;
        }
        org.uberfire.backend.vfs.Path moduleRoot = pkg.getModuleRootPath();
        Path nioModuleRootPath = Paths.convert((org.uberfire.backend.vfs.Path)moduleRoot);
        for (String src : ModuleResourcePaths.SOURCE_PATHS) {
            Path nioPackageRootSrcPath = nioModuleRootPath.resolve(src).resolve(this.resolvePkgName(pkg.getCaption()));
            packageNames.addAll(this.getPackageNames(nioModuleRootPath, nioPackageRootSrcPath, false, true, false));
        }
        HashSet<String> resolvedPackages = new HashSet<String>();
        for (String packagePathSuffix : packageNames) {
            for (String src : ModuleResourcePaths.SOURCE_PATHS) {
                Path nioPackagePath = nioModuleRootPath.resolve(src).resolve(packagePathSuffix);
                if (!Files.exists((Path)nioPackagePath, (LinkOption[])new LinkOption[0]) || resolvedPackages.contains(packagePathSuffix)) continue;
                packages.add(this.resolvePackage(Paths.convert((Path)nioPackagePath)));
                resolvedPackages.add(packagePathSuffix);
            }
        }
        return packages;
    }

    public Package resolveDefaultPackage(Module module) {
        HashSet<String> packageNames = new HashSet<String>();
        if (module == null) {
            return null;
        }
        org.uberfire.backend.vfs.Path moduleRoot = module.getRootPath();
        Path nioModuleRootPath = Paths.convert((org.uberfire.backend.vfs.Path)moduleRoot);
        for (String src : ModuleResourcePaths.SOURCE_PATHS) {
            Path nioPackageRootSrcPath = nioModuleRootPath.resolve(src);
            packageNames.addAll(this.getPackageNames(nioModuleRootPath, nioPackageRootSrcPath, true, true, false));
        }
        HashSet resolvedPackages = new HashSet();
        for (String packagePathSuffix : packageNames) {
            for (String src : ModuleResourcePaths.SOURCE_PATHS) {
                Path nioPackagePath = nioModuleRootPath.resolve(src).resolve(packagePathSuffix);
                if (!Files.exists((Path)nioPackagePath, (LinkOption[])new LinkOption[0]) || resolvedPackages.contains(packagePathSuffix)) continue;
                return this.resolvePackage(Paths.convert((Path)nioPackagePath));
            }
        }
        return null;
    }

    public Package resolveDefaultWorkspacePackage(Module module) {
        org.uberfire.backend.vfs.Path moduleRootPath = module.getRootPath();
        GAV gav = module.getPom().getGav();
        String defaultWorkspacePackagePath = this.getDefaultWorkspacePath(gav);
        Path defaultWorkspacePath = Paths.convert((org.uberfire.backend.vfs.Path)moduleRootPath).resolve("src/main/resources/" + defaultWorkspacePackagePath);
        return this.resolvePackage(Paths.convert((Path)defaultWorkspacePath));
    }

    public Package resolveParentPackage(Package pkg) {
        HashSet<String> packageNames = new HashSet<String>();
        Path nioModuleRootPath = Paths.convert((org.uberfire.backend.vfs.Path)pkg.getModuleRootPath());
        packageNames.addAll(this.getPackageNames(nioModuleRootPath, Paths.convert((org.uberfire.backend.vfs.Path)pkg.getPackageMainSrcPath()).getParent(), true, false, false));
        packageNames.addAll(this.getPackageNames(nioModuleRootPath, Paths.convert((org.uberfire.backend.vfs.Path)pkg.getPackageMainResourcesPath()).getParent(), true, false, false));
        packageNames.addAll(this.getPackageNames(nioModuleRootPath, Paths.convert((org.uberfire.backend.vfs.Path)pkg.getPackageTestSrcPath()).getParent(), true, false, false));
        packageNames.addAll(this.getPackageNames(nioModuleRootPath, Paths.convert((org.uberfire.backend.vfs.Path)pkg.getPackageTestResourcesPath()).getParent(), true, false, false));
        for (String packagePathSuffix : packageNames) {
            for (String src : ModuleResourcePaths.SOURCE_PATHS) {
                if (packagePathSuffix == null) {
                    return null;
                }
                Path nioPackagePath = nioModuleRootPath.resolve(src).resolve(packagePathSuffix);
                if (!Files.exists((Path)nioPackagePath, (LinkOption[])new LinkOption[0])) continue;
                return this.resolvePackage(Paths.convert((Path)nioPackagePath));
            }
        }
        return null;
    }

    public org.uberfire.backend.vfs.Path resolveDefaultPath(Package pkg, String resourceType) {
        ModuleResourcePathResolver[] currentResolver = new ModuleResourcePathResolver[1];
        this.resourcePathResolvers.forEach(resolver -> {
            if (resolver.accept(resourceType) && (currentResolver[0] == null || currentResolver[0].getPriority() < resolver.getPriority())) {
                currentResolver[0] = resolver;
            }
        });
        if (currentResolver[0] == null) {
            throw new RuntimeException("No ModuleResourcePathResolver has been defined for resourceType: " + resourceType);
        }
        return currentResolver[0].resolveDefaultPath(pkg);
    }

    public boolean isPom(org.uberfire.backend.vfs.Path resource) {
        try {
            if (resource == null) {
                return false;
            }
            T module = this.resolveModule(resource);
            if (module == null) {
                return false;
            }
            Path path = Paths.convert((org.uberfire.backend.vfs.Path)resource).normalize();
            Path pomFilePath = Paths.convert((org.uberfire.backend.vfs.Path)module.getPomXMLPath());
            return path.startsWith(pomFilePath);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public Package resolvePackage(org.uberfire.backend.vfs.Path resource) {
        try {
            if (resource == null) {
                return null;
            }
            T module = this.resolveModule(resource);
            if (module == null) {
                return null;
            }
            if (this.isPom(resource)) {
                return null;
            }
            return this.makePackage((Module)module, resource);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public String getDefaultWorkspacePath(GAV gav) {
        return StringUtils.join((Object[])this.getLegalId(gav.getGroupId()), (String)"/") + "/" + StringUtils.join((Object[])this.getLegalId(gav.getArtifactId()), (String)"/");
    }

    public String[] getLegalId(String id) {
        return IdentifierUtils.convertMavenIdentifierToJavaIdentifier(id.split("\\.", -1));
    }

    protected boolean hasPom(Path path) {
        Path pomPath = path.resolve("pom.xml");
        return Files.exists((Path)pomPath, (LinkOption[])new LinkOption[0]);
    }

    protected T makeModule(Path nioModuleRootPath) {
        return this.simpleModuleInstance(nioModuleRootPath);
    }

    public abstract T simpleModuleInstance(Path var1);

    protected Package makePackage(Module module, org.uberfire.backend.vfs.Path resource) {
        org.uberfire.backend.vfs.Path moduleRoot = module.getRootPath();
        Path nioModuleRoot = Paths.convert((org.uberfire.backend.vfs.Path)moduleRoot);
        Path nioMainSrcPath = nioModuleRoot.resolve("src/main/java");
        Path nioTestSrcPath = nioModuleRoot.resolve("src/test/java");
        Path nioMainResourcesPath = nioModuleRoot.resolve("src/main/resources");
        Path nioTestResourcesPath = nioModuleRoot.resolve("src/test/resources");
        Path nioResource = Paths.convert((org.uberfire.backend.vfs.Path)resource);
        if (Files.isRegularFile((Path)nioResource, (LinkOption[])new LinkOption[0])) {
            nioResource = nioResource.getParent();
        }
        String packageName = null;
        Path packagePath = null;
        if (nioResource.startsWith(nioMainSrcPath)) {
            packagePath = nioMainSrcPath.relativize(nioResource);
            packageName = packagePath.toString().replaceAll("/", ".");
        } else if (nioResource.startsWith(nioTestSrcPath)) {
            packagePath = nioTestSrcPath.relativize(nioResource);
            packageName = packagePath.toString().replaceAll("/", ".");
        } else if (nioResource.startsWith(nioMainResourcesPath)) {
            packagePath = nioMainResourcesPath.relativize(nioResource);
            packageName = packagePath.toString().replaceAll("/", ".");
        } else if (nioResource.startsWith(nioTestResourcesPath)) {
            packagePath = nioTestResourcesPath.relativize(nioResource);
            packageName = packagePath.toString().replaceAll("/", ".");
        }
        if (packageName == null) {
            return null;
        }
        org.uberfire.backend.vfs.Path mainSrcPath = Paths.convert((Path)nioMainSrcPath.resolve(packagePath));
        org.uberfire.backend.vfs.Path testSrcPath = Paths.convert((Path)nioTestSrcPath.resolve(packagePath));
        org.uberfire.backend.vfs.Path mainResourcesPath = Paths.convert((Path)nioMainResourcesPath.resolve(packagePath));
        org.uberfire.backend.vfs.Path testResourcesPath = Paths.convert((Path)nioTestResourcesPath.resolve(packagePath));
        String displayName = this.getPackageDisplayName(packageName);
        Package pkg = new Package(module.getRootPath(), mainSrcPath, testSrcPath, mainResourcesPath, testResourcesPath, packageName, displayName, this.getPackageRelativeCaption(displayName, resource.getFileName()));
        return pkg;
    }

    private Set<String> getPackageNames(Path nioModuleRootPath, Path nioPackageSrcPath, boolean includeDefault, boolean includeChild, boolean recursive) {
        HashSet<String> packageNames = new HashSet<String>();
        if (!Files.exists((Path)nioPackageSrcPath, (LinkOption[])new LinkOption[0])) {
            return packageNames;
        }
        if (includeDefault || recursive) {
            packageNames.add(this.getPackagePathSuffix(nioModuleRootPath, nioPackageSrcPath));
        }
        if (!includeChild) {
            return packageNames;
        }
        LinkedMetaInfFolderFilter metaDataFileFilter = new LinkedMetaInfFolderFilter();
        LinkedDotFileFilter dotFileFilter = new LinkedDotFileFilter((LinkedFilter)metaDataFileFilter);
        LinkedDirectoryFilter directoryFilter = new LinkedDirectoryFilter((LinkedFilter)dotFileFilter);
        DirectoryStream nioChildPackageSrcPaths = this.ioService.newDirectoryStream(nioPackageSrcPath, (DirectoryStream.Filter)directoryFilter);
        for (Path nioChildPackageSrcPath : nioChildPackageSrcPaths) {
            if (recursive) {
                packageNames.addAll(this.getPackageNames(nioModuleRootPath, nioChildPackageSrcPath, includeDefault, includeChild, recursive));
                continue;
            }
            packageNames.add(this.getPackagePathSuffix(nioModuleRootPath, nioChildPackageSrcPath));
        }
        return packageNames;
    }

    private String getPackageDisplayName(String packageName) {
        return packageName.isEmpty() ? "<default>" : packageName;
    }

    private String getPackageRelativeCaption(String displayName, String relativeName) {
        return displayName.equals("<default>") ? "<default>" : relativeName;
    }

    private String resolvePkgName(String caption) {
        if (caption.equals("<default>")) {
            return "";
        }
        return caption.replaceAll("\\.", "/");
    }
}

