/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.backend.server;

import java.util.Optional;
import javax.enterprise.inject.Instance;
import org.guvnor.common.services.project.backend.server.WorkspaceProjectServiceImpl;
import org.guvnor.common.services.project.events.NewProjectEvent;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.common.services.project.service.DeploymentMode;
import org.guvnor.common.services.project.service.ModuleService;
import org.guvnor.common.services.project.service.WorkspaceProjectService;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.guvnor.structure.repositories.Branch;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryEnvironmentConfigurations;
import org.guvnor.structure.repositories.RepositoryService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.backend.vfs.Path;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.spaces.SpacesAPI;

@RunWith(value=MockitoJUnitRunner.class)
public class WorkspaceProjectServiceImplNewWorkspaceWorkspaceProjectTest {
    WorkspaceProjectService workspaceProjectService;
    @Mock
    RepositoryService repositoryService;
    @Mock
    Instance<ModuleService<? extends Module>> moduleServices;
    @Mock
    ModuleService moduleService;
    @Mock
    private OrganizationalUnit ou;
    @Mock
    private Repository repository;
    @Mock
    private Path repositoryRoot;
    @Mock
    private Branch branch;
    @Mock
    private EventSourceMock<NewProjectEvent> newProjectEvent;
    @Mock
    private Module module;
    @Mock
    private SpacesAPI spaces;
    private POM pom;

    @Before
    public void setUp() throws Exception {
        ((Repository)Mockito.doReturn(Optional.of(this.branch)).when((Object)this.repository)).getDefaultBranch();
        ((Branch)Mockito.doReturn((Object)this.repositoryRoot).when((Object)this.branch)).getPath();
        ((RepositoryService)Mockito.doReturn((Object)this.repository).when((Object)this.repositoryService)).createRepository((OrganizationalUnit)Matchers.eq((Object)this.ou), (String)Matchers.eq((Object)"git"), (String)Matchers.eq((Object)"my project"), (RepositoryEnvironmentConfigurations)Matchers.any(RepositoryEnvironmentConfigurations.class));
        this.pom = new POM("my project", "my description", "url", new GAV("groupId", "artifactId", "version"));
        ((Instance)Mockito.doReturn((Object)this.moduleService).when(this.moduleServices)).get();
        this.workspaceProjectService = new WorkspaceProjectServiceImpl((OrganizationalUnitService)Mockito.mock(OrganizationalUnitService.class), this.repositoryService, this.spaces, this.newProjectEvent, this.moduleServices);
    }

    @Test
    public void newProjectDefault() throws Exception {
        ((ModuleService)Mockito.doReturn((Object)this.module).when((Object)this.moduleService)).newModule((Path)Matchers.eq((Object)this.repositoryRoot), (POM)Matchers.eq((Object)this.pom), (DeploymentMode)Matchers.eq((Object)DeploymentMode.VALIDATED));
        WorkspaceProject workspaceProject = this.workspaceProjectService.newProject(this.ou, this.pom);
        this.assertProject(workspaceProject);
        ((EventSourceMock)Mockito.verify(this.newProjectEvent)).fire(Matchers.any());
    }

    @Test
    public void newProjectValidated() throws Exception {
        ((ModuleService)Mockito.doReturn((Object)this.module).when((Object)this.moduleService)).newModule((Path)Matchers.eq((Object)this.repositoryRoot), (POM)Matchers.eq((Object)this.pom), (DeploymentMode)Matchers.eq((Object)DeploymentMode.VALIDATED));
        WorkspaceProject workspaceProject = this.workspaceProjectService.newProject(this.ou, this.pom, DeploymentMode.VALIDATED);
        this.assertProject(workspaceProject);
        ((EventSourceMock)Mockito.verify(this.newProjectEvent)).fire(Matchers.any());
    }

    @Test
    public void newProjectForced() throws Exception {
        ((ModuleService)Mockito.doReturn((Object)this.module).when((Object)this.moduleService)).newModule((Path)Matchers.eq((Object)this.repositoryRoot), (POM)Matchers.eq((Object)this.pom), (DeploymentMode)Matchers.eq((Object)DeploymentMode.FORCED));
        WorkspaceProject workspaceProject = this.workspaceProjectService.newProject(this.ou, this.pom, DeploymentMode.FORCED);
        this.assertProject(workspaceProject);
        ((EventSourceMock)Mockito.verify(this.newProjectEvent)).fire(Matchers.any());
    }

    private void assertProject(WorkspaceProject workspaceProject) {
        Assert.assertEquals((Object)this.ou, (Object)workspaceProject.getOrganizationalUnit());
        Assert.assertEquals((Object)this.repository, (Object)workspaceProject.getRepository());
        Assert.assertEquals((Object)this.branch, (Object)workspaceProject.getBranch());
        Assert.assertEquals((Object)this.module, (Object)workspaceProject.getMainModule());
    }
}

