/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.backend.server.utils;

import java.util.Optional;
import org.guvnor.common.services.project.backend.server.utils.PathUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PathUtilTest {
    private PathUtil pathUtil;

    @Before
    public void setup() {
        this.pathUtil = new PathUtil();
    }

    @Test
    public void stripGitProtocolAndBranch() throws Exception {
        String result = this.pathUtil.stripProtocolAndBranch("git://master@space/repo/some/path");
        Assert.assertEquals((Object)"space/repo/some/path", (Object)result);
    }

    @Test
    public void stripDefaultProtocolAndBranch() throws Exception {
        String result = this.pathUtil.stripProtocolAndBranch("default://master@space/repo/some/path");
        Assert.assertEquals((Object)"space/repo/some/path", (Object)result);
    }

    @Test
    public void stripProtocolMissingBranch() throws Exception {
        String result = this.pathUtil.stripProtocolAndBranch("default://space/repo/some/path");
        Assert.assertEquals((Object)"space/repo/some/path", (Object)result);
    }

    @Test
    public void stripRepoNameAndSpace() throws Exception {
        String result = this.pathUtil.stripRepoNameAndSpace("space/repo/some/path");
        Assert.assertEquals((Object)"some/path", (Object)result);
    }

    @Test
    public void extractPresentBranchName() throws Exception {
        Optional result = this.pathUtil.extractBranch("git://master@space/repo/some/path");
        Assert.assertEquals(Optional.of("master"), (Object)result);
    }

    @Test
    public void extractMissingBranchName() throws Exception {
        Optional result = this.pathUtil.extractBranch("git://space/repo/some/path");
        Assert.assertEquals(Optional.empty(), (Object)result);
    }
}

