/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.backend.server;

import java.util.Collection;
import java.util.Optional;
import javax.enterprise.inject.Instance;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.guvnor.common.services.project.backend.server.WorkspaceProjectServiceImpl;
import org.guvnor.common.services.project.events.NewProjectEvent;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.common.services.project.service.DeploymentMode;
import org.guvnor.common.services.project.service.ModuleRepositoryResolver;
import org.guvnor.common.services.project.service.ModuleService;
import org.guvnor.common.services.project.service.WorkspaceProjectService;
import org.guvnor.common.services.shared.exceptions.GenericPortableException;
import org.guvnor.structure.backend.organizationalunit.config.SpaceConfigStorageRegistryImpl;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.guvnor.structure.organizationalunit.config.SpaceConfigStorage;
import org.guvnor.structure.organizationalunit.config.SpaceConfigStorageRegistry;
import org.guvnor.structure.repositories.Branch;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryEnvironmentConfigurations;
import org.guvnor.structure.repositories.RepositoryService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.Path;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.spaces.Space;
import org.uberfire.spaces.SpacesAPI;

@RunWith(value=MockitoJUnitRunner.class)
public class WorkspaceProjectServiceImplNewWorkspaceWorkspaceProjectTest {
    WorkspaceProjectService workspaceProjectService;
    @Mock
    RepositoryService repositoryService;
    @Mock
    Instance<ModuleService<? extends Module>> moduleServices;
    @Mock
    ModuleService moduleService;
    @Mock
    private OrganizationalUnit ou;
    @Mock
    private Space space;
    @Mock
    private Repository repository;
    @Mock
    private Path repositoryRoot;
    @Mock
    private Branch branch;
    @Mock
    private EventSourceMock<NewProjectEvent> newProjectEvent;
    @Mock
    private Module module;
    @Mock
    private SpacesAPI spaces;
    @Mock
    private ModuleRepositoryResolver repositoryResolver;
    @Mock
    private SpaceConfigStorageRegistry spaceConfigStorageRegistry;
    @Mock
    private SpaceConfigStorage spaceConfigStorage;
    private POM pom;

    @Before
    public void setUp() throws Exception {
        ((Repository)Mockito.doReturn(Optional.of(this.branch)).when((Object)this.repository)).getDefaultBranch();
        ((Branch)Mockito.doReturn((Object)this.repositoryRoot).when((Object)this.branch)).getPath();
        ((RepositoryService)Mockito.doReturn((Object)this.repository).when((Object)this.repositoryService)).createRepository((OrganizationalUnit)Matchers.eq((Object)this.ou), (String)Matchers.eq((Object)"git"), (String)Matchers.eq((Object)"myproject"), (RepositoryEnvironmentConfigurations)Matchers.any(RepositoryEnvironmentConfigurations.class));
        this.pom = new POM("my project", "my description", "url", new GAV("groupId", "artifactId", "version"));
        Mockito.when((Object)this.ou.getSpace()).thenReturn((Object)this.space);
        Mockito.when((Object)this.space.getName()).thenReturn((Object)"ou");
        Mockito.when((Object)this.repositoryService.createRepository((OrganizationalUnit)Matchers.any(), Matchers.anyString(), Matchers.anyString(), (RepositoryEnvironmentConfigurations)Matchers.any(), (Collection)Matchers.any())).thenReturn((Object)this.repository);
        ((Instance)Mockito.doReturn((Object)this.moduleService).when(this.moduleServices)).get();
        Mockito.when((Object)this.spaceConfigStorageRegistry.get(Matchers.anyString())).thenReturn((Object)this.spaceConfigStorage);
        Mockito.when((Object)this.spaceConfigStorageRegistry.getBatch(Matchers.anyString())).thenReturn((Object)new SpaceConfigStorageRegistryImpl.SpaceStorageBatchImpl(this.spaceConfigStorage));
        Mockito.when((Object)this.spaceConfigStorageRegistry.exist(Matchers.anyString())).thenReturn((Object)true);
        this.workspaceProjectService = new WorkspaceProjectServiceImpl((OrganizationalUnitService)Mockito.mock(OrganizationalUnitService.class), this.repositoryService, this.spaces, this.newProjectEvent, this.moduleServices, this.repositoryResolver, this.spaceConfigStorageRegistry);
    }

    @Test
    public void newProjectDefault() throws Exception {
        ((ModuleService)Mockito.doReturn((Object)this.module).when((Object)this.moduleService)).newModule((Path)Matchers.eq((Object)this.repositoryRoot), (POM)Matchers.eq((Object)this.pom), (DeploymentMode)Matchers.eq((Object)DeploymentMode.VALIDATED));
        WorkspaceProject workspaceProject = this.workspaceProjectService.newProject(this.ou, this.pom);
        this.assertProject(workspaceProject);
        ((EventSourceMock)Mockito.verify(this.newProjectEvent)).fire(Matchers.any());
        ((SpaceConfigStorage)Mockito.verify((Object)this.spaceConfigStorage)).startBatch();
        ((RepositoryService)Mockito.verify((Object)this.repositoryService)).createRepository((OrganizationalUnit)Matchers.eq((Object)this.ou), (String)Matchers.eq((Object)"git"), (String)Matchers.eq((Object)"myproject"), (RepositoryEnvironmentConfigurations)Matchers.any(), (Collection)Matchers.any());
        ((SpaceConfigStorage)Mockito.verify((Object)this.spaceConfigStorage)).endBatch();
    }

    @Test
    public void newProjectValidated() throws Exception {
        ((ModuleService)Mockito.doReturn((Object)this.module).when((Object)this.moduleService)).newModule((Path)Matchers.eq((Object)this.repositoryRoot), (POM)Matchers.eq((Object)this.pom), (DeploymentMode)Matchers.eq((Object)DeploymentMode.VALIDATED));
        WorkspaceProject workspaceProject = this.workspaceProjectService.newProject(this.ou, this.pom, DeploymentMode.VALIDATED);
        this.assertProject(workspaceProject);
        ((EventSourceMock)Mockito.verify(this.newProjectEvent)).fire(Matchers.any());
        ((SpaceConfigStorage)Mockito.verify((Object)this.spaceConfigStorage)).startBatch();
        ((RepositoryService)Mockito.verify((Object)this.repositoryService)).createRepository((OrganizationalUnit)Matchers.eq((Object)this.ou), (String)Matchers.eq((Object)"git"), (String)Matchers.eq((Object)"myproject"), (RepositoryEnvironmentConfigurations)Matchers.any(), (Collection)Matchers.any());
        ((SpaceConfigStorage)Mockito.verify((Object)this.spaceConfigStorage)).endBatch();
    }

    @Test
    public void testNewProjectErrorRepositoryWithoutDefaultBranch() {
        Mockito.when((Object)this.repository.getDefaultBranch()).thenReturn(Optional.empty());
        this.testNewProjectError(GenericPortableException.class, "New repository should always have a branch.");
    }

    @Test
    public void testNewProjectErrorCreatingModule() {
        String errorMessage = "Impossible to create module";
        ((ModuleService)Mockito.doThrow((Throwable)new IllegalStateException("Impossible to create module")).when((Object)this.moduleService)).newModule((Path)Matchers.any(), (POM)Matchers.any(), (DeploymentMode)Matchers.any());
        this.testNewProjectError(GenericPortableException.class, "Impossible to create module");
    }

    private void testNewProjectError(Class<? extends Exception> expectedExceptionType, String expectedMessage) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.workspaceProjectService.newProject(this.ou, this.pom)).isInstanceOf(expectedExceptionType)).hasMessage(expectedMessage);
        ((RepositoryService)Mockito.verify((Object)this.repositoryService)).removeRepository((Space)Matchers.any(), Matchers.anyString());
        ((EventSourceMock)Mockito.verify(this.newProjectEvent, (VerificationMode)Mockito.never())).fire(Matchers.any());
    }

    @Test
    public void newProjectForced() throws Exception {
        ((ModuleService)Mockito.doReturn((Object)this.module).when((Object)this.moduleService)).newModule((Path)Matchers.eq((Object)this.repositoryRoot), (POM)Matchers.eq((Object)this.pom), (DeploymentMode)Matchers.eq((Object)DeploymentMode.FORCED));
        WorkspaceProject workspaceProject = this.workspaceProjectService.newProject(this.ou, this.pom, DeploymentMode.FORCED);
        this.assertProject(workspaceProject);
        ((EventSourceMock)Mockito.verify(this.newProjectEvent)).fire(Matchers.any());
        ((SpaceConfigStorage)Mockito.verify((Object)this.spaceConfigStorage)).startBatch();
        ((RepositoryService)Mockito.verify((Object)this.repositoryService)).createRepository((OrganizationalUnit)Matchers.eq((Object)this.ou), (String)Matchers.eq((Object)"git"), (String)Matchers.eq((Object)"myproject"), (RepositoryEnvironmentConfigurations)Matchers.any(), (Collection)Matchers.any());
        ((SpaceConfigStorage)Mockito.verify((Object)this.spaceConfigStorage)).endBatch();
    }

    private void assertProject(WorkspaceProject workspaceProject) {
        Assert.assertEquals((Object)this.ou, (Object)workspaceProject.getOrganizationalUnit());
        Assert.assertEquals((Object)this.repository, (Object)workspaceProject.getRepository());
        Assert.assertEquals((Object)this.branch, (Object)workspaceProject.getBranch());
        Assert.assertEquals((Object)this.module, (Object)workspaceProject.getMainModule());
    }
}

