/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.backend.server;

import java.net.URI;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Instance;
import org.guvnor.common.services.project.backend.server.WorkspaceProjectServiceImpl;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.common.services.project.service.ModuleRepositoryResolver;
import org.guvnor.common.services.project.service.ModuleService;
import org.guvnor.common.services.project.service.WorkspaceProjectService;
import org.guvnor.structure.backend.organizationalunit.config.SpaceConfigStorageRegistryImpl;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.guvnor.structure.organizationalunit.config.SpaceConfigStorage;
import org.guvnor.structure.organizationalunit.config.SpaceConfigStorageRegistry;
import org.guvnor.structure.repositories.Branch;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryService;
import org.guvnor.structure.repositories.impl.git.GitRepository;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.io.IOService;
import org.uberfire.io.impl.IOServiceDotFileImpl;
import org.uberfire.java.nio.file.Path;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.spaces.Space;
import org.uberfire.spaces.SpacesAPI;

@RunWith(value=MockitoJUnitRunner.class)
public class WorkspaceProjectServiceImplResolveWorkspaceWorkspaceProjectTest {
    WorkspaceProjectService workspaceProjectService;
    @Mock
    RepositoryService repositoryService;
    @Mock
    Instance<ModuleService<? extends Module>> moduleServices;
    @Mock
    ModuleService moduleService;
    @Mock
    OrganizationalUnitService organizationalUnitService;
    @Mock
    OrganizationalUnit ou;
    @Mock
    Repository repository;
    @Mock
    SpacesAPI spaces;
    @Mock
    Branch branch;
    @Mock
    Module module;
    @Mock
    ModuleRepositoryResolver repositoryResolver;
    @Mock
    SpaceConfigStorageRegistry spaceConfigStorageRegistry;
    @Mock
    SpaceConfigStorage spaceConfigStorage;
    private org.uberfire.backend.vfs.Path path;
    private org.uberfire.backend.vfs.Path branchRoot;
    private Branch masterBranch;
    private IOService ioService;
    private Space space;

    @Before
    public void setUp() throws Exception {
        this.ioService = new IOServiceDotFileImpl();
        this.path = PathFactory.newPath((String)"testFile", (String)"file:///files/TestDataObject.java");
        this.branchRoot = PathFactory.newPath((String)"testFile", (String)"file:///branchRoot/");
        this.space = new Space("test-realm");
        ((OrganizationalUnitService)Mockito.doReturn((Object)this.ou).when((Object)this.organizationalUnitService)).getParentOrganizationalUnit(this.repository);
        ((OrganizationalUnit)Mockito.doReturn((Object)this.space.getName()).when((Object)this.ou)).getName();
        ((OrganizationalUnitService)Mockito.doReturn((Object)this.ou).when((Object)this.organizationalUnitService)).getOrganizationalUnit(this.space.getName());
        ((Repository)Mockito.doReturn(Optional.of(this.branch)).when((Object)this.repository)).getDefaultBranch();
        ((Branch)Mockito.doReturn((Object)this.branchRoot).when((Object)this.branch)).getPath();
        ((RepositoryService)Mockito.doReturn((Object)this.repository).when((Object)this.repositoryService)).getRepository((Space)Mockito.eq((Object)this.space), (org.uberfire.backend.vfs.Path)Matchers.any(org.uberfire.backend.vfs.Path.class));
        ((Repository)Mockito.doReturn((Object)this.space).when((Object)this.repository)).getSpace();
        ((ModuleService)Mockito.doReturn((Object)this.module).when((Object)this.moduleService)).resolveModule((org.uberfire.backend.vfs.Path)Matchers.any());
        this.masterBranch = new Branch("master", this.path);
        ((Instance)Mockito.doReturn((Object)this.moduleService).when(this.moduleServices)).get();
        Mockito.when((Object)this.spaceConfigStorageRegistry.get(Matchers.anyString())).thenReturn((Object)this.spaceConfigStorage);
        Mockito.when((Object)this.spaceConfigStorageRegistry.getBatch(Matchers.anyString())).thenReturn((Object)new SpaceConfigStorageRegistryImpl.SpaceStorageBatchImpl(this.spaceConfigStorage));
        Mockito.when((Object)this.spaceConfigStorageRegistry.exist(Matchers.anyString())).thenReturn((Object)true);
        this.workspaceProjectService = new WorkspaceProjectServiceImpl(this.organizationalUnitService, this.repositoryService, this.spaces, (Event)new EventSourceMock(), this.moduleServices, this.repositoryResolver, this.spaceConfigStorageRegistry);
    }

    @Test
    public void resolveProjectPath() throws Exception {
        WorkspaceProject workspaceProject = this.workspaceProjectService.resolveProject(this.space, this.path);
        Assert.assertEquals((Object)this.ou, (Object)workspaceProject.getOrganizationalUnit());
        Assert.assertEquals((Object)this.repository, (Object)workspaceProject.getRepository());
        Assert.assertEquals((Object)this.branch, (Object)workspaceProject.getBranch());
        Assert.assertEquals((Object)this.module, (Object)workspaceProject.getMainModule());
    }

    @Test(expected=RuntimeException.class)
    public void resolveProjectPathOfInexistentRepository() throws Exception {
        ((RepositoryService)Mockito.doReturn(null).when((Object)this.repositoryService)).getRepository((Space)Mockito.eq((Object)this.space), (org.uberfire.backend.vfs.Path)Matchers.any(org.uberfire.backend.vfs.Path.class));
        WorkspaceProject workspaceProject = this.workspaceProjectService.resolveProject(this.space, this.path);
    }

    @Test
    public void resolveProjectModule() throws Exception {
        WorkspaceProject workspaceProject = this.workspaceProjectService.resolveProject(this.space, new Module(this.path, (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class), (POM)Mockito.mock(POM.class)));
        Assert.assertEquals((Object)this.ou, (Object)workspaceProject.getOrganizationalUnit());
        Assert.assertEquals((Object)this.repository, (Object)workspaceProject.getRepository());
        Assert.assertEquals((Object)this.branch, (Object)workspaceProject.getBranch());
        Assert.assertEquals((Object)this.module, (Object)workspaceProject.getMainModule());
    }

    @Test
    public void resolveProjectRepository() throws Exception {
        GitRepository repository = new GitRepository("alias", this.space);
        HashMap<String, Branch> branches = new HashMap<String, Branch>();
        branches.put("master", new Branch("master", this.path));
        repository.setBranches(branches);
        WorkspaceProject workspaceProject = this.workspaceProjectService.resolveProject((Repository)repository);
        Assert.assertEquals((Object)this.ou, (Object)workspaceProject.getOrganizationalUnit());
        Assert.assertEquals((Object)this.repository, (Object)workspaceProject.getRepository());
        Assert.assertEquals((Object)this.branch, (Object)workspaceProject.getBranch());
        Assert.assertEquals((Object)this.module, (Object)workspaceProject.getMainModule());
    }

    @Test
    public void resolveProjectBranch() throws Exception {
        WorkspaceProject workspaceProject = this.workspaceProjectService.resolveProject(this.space, this.masterBranch);
        Assert.assertEquals((Object)this.ou, (Object)workspaceProject.getOrganizationalUnit());
        Assert.assertEquals((Object)this.repository, (Object)workspaceProject.getRepository());
        Assert.assertEquals((Object)this.branch, (Object)workspaceProject.getBranch());
        Assert.assertEquals((Object)this.module, (Object)workspaceProject.getMainModule());
    }

    @Test(expected=IllegalArgumentException.class)
    public void resolveNullProjectAndNullBranch() {
        this.mockRepositoriesAndBranches();
        WorkspaceProject workspaceProject = this.workspaceProjectService.resolveProject(this.space, null, null);
        Assert.assertNull((Object)workspaceProject);
    }

    @Test(expected=IllegalArgumentException.class)
    public void resolveNonExistingProject() {
        this.mockRepositoriesAndBranches();
        WorkspaceProject workspaceProject = this.workspaceProjectService.resolveProject(this.space, "project7", null);
    }

    @Test
    public void resolveProjectAndNullBranch() {
        this.mockRepositoriesAndBranches();
        WorkspaceProject workspaceProject = this.workspaceProjectService.resolveProject(this.space, "project2", null);
        Assert.assertNotNull((Object)workspaceProject);
        Assert.assertNotNull((Object)workspaceProject.getBranch());
        Assert.assertEquals((Object)"master", (Object)workspaceProject.getBranch().getName());
        Assert.assertNotNull((Object)workspaceProject.getMainModule());
    }

    @Test
    public void resolveProjectAndMasterBranch() {
        this.mockRepositoriesAndBranches();
        WorkspaceProject workspaceProject = this.workspaceProjectService.resolveProject(this.space, "project2", "master");
        Assert.assertNotNull((Object)workspaceProject);
        Assert.assertNotNull((Object)workspaceProject.getBranch());
        Assert.assertEquals((Object)"master", (Object)workspaceProject.getBranch().getName());
        Assert.assertNotNull((Object)workspaceProject.getMainModule());
    }

    @Test(expected=IllegalArgumentException.class)
    public void resolveProjectAndNonExistingBranch() {
        this.mockRepositoriesAndBranches();
        WorkspaceProject workspaceProject = this.workspaceProjectService.resolveProject(this.space, "project2", "branch7");
        Assert.assertNotNull((Object)workspaceProject);
        Assert.assertNotNull((Object)workspaceProject.getBranch());
        Assert.assertEquals((Object)"master", (Object)workspaceProject.getBranch().getName());
        Assert.assertNull((Object)workspaceProject.getMainModule());
    }

    @Test
    public void resolveProjectAndBranch() {
        this.mockRepositoriesAndBranches();
        WorkspaceProject workspaceProject = this.workspaceProjectService.resolveProject(this.space, "project2", "branch4");
        Assert.assertNotNull((Object)workspaceProject);
        Assert.assertNotNull((Object)workspaceProject.getBranch());
        Assert.assertEquals((Object)"branch4", (Object)workspaceProject.getBranch().getName());
        Assert.assertNotNull((Object)workspaceProject.getMainModule());
    }

    private void mockRepositoriesAndBranches() {
        Branch branch1 = this.createBranch("master");
        Branch branch2 = this.createBranch("branch2");
        Branch branch3 = this.createBranch("master");
        Branch branch4 = this.createBranch("branch4");
        Branch branch5 = this.createBranch("branch5");
        Repository project1 = (Repository)Mockito.mock(Repository.class);
        Mockito.when((Object)project1.getAlias()).thenReturn((Object)"project1");
        Mockito.when((Object)project1.getSpace()).thenReturn((Object)this.space);
        Mockito.when((Object)project1.getDefaultBranch()).thenReturn(Optional.of(branch1));
        Mockito.when((Object)project1.getBranches()).thenReturn(Arrays.asList(branch1, branch2));
        Repository project2 = (Repository)Mockito.mock(Repository.class);
        Mockito.when((Object)project2.getAlias()).thenReturn((Object)"project2");
        Mockito.when((Object)project2.getSpace()).thenReturn((Object)this.space);
        Mockito.when((Object)project2.getDefaultBranch()).thenReturn(Optional.of(branch3));
        Mockito.when((Object)project2.getBranches()).thenReturn(Arrays.asList(branch3, branch4, branch5));
        Mockito.when((Object)this.repositoryService.getRepository((Space)Matchers.any(), (org.uberfire.backend.vfs.Path)Matchers.any())).thenReturn((Object)project2);
        Mockito.when((Object)this.repositoryService.getAllRepositories((Space)Matchers.any(), Matchers.anyBoolean())).thenReturn(Arrays.asList(project1, project2));
    }

    private Branch createBranch(String name) {
        org.uberfire.backend.vfs.Path path = Paths.convert((Path)((Path)this.ioService.newFileSystem(URI.create("git://test/" + name + new Date().getTime()), (Map)new HashMap<String, Object>(){
            {
                this.put("init", Boolean.TRUE);
            }
        }).getRootDirectories().iterator().next()));
        Branch branch = (Branch)Mockito.mock(Branch.class);
        Mockito.when((Object)branch.getName()).thenReturn((Object)name);
        Mockito.when((Object)branch.getPath()).thenReturn((Object)path);
        return branch;
    }
}

