/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.backend.server;

import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import org.guvnor.common.services.project.backend.server.WorkspaceProjectSearchServiceImpl;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.common.services.project.service.WorkspaceProjectSearchService;
import org.guvnor.common.services.project.service.WorkspaceProjectService;
import org.guvnor.structure.repositories.Branch;
import org.guvnor.structure.repositories.Repository;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.backend.vfs.Path;

@RunWith(value=MockitoJUnitRunner.class)
public class WorkspaceWorkspaceProjectSearchServiceTest {
    @Mock
    WorkspaceProjectService workspaceProjectService;
    @Mock
    WorkspaceProject itemA;
    @Mock
    WorkspaceProject itemB;
    private WorkspaceProjectSearchService searchService;

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.itemA.getName()).thenReturn((Object)"Item A");
        Mockito.when((Object)this.itemB.getName()).thenReturn((Object)"Item B");
        Repository repository = (Repository)Mockito.mock(Repository.class);
        Path repositoryRoot = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)repository.getDefaultBranch()).thenReturn(Optional.of(new Branch("master", repositoryRoot)));
        Mockito.when((Object)this.workspaceProjectService.getAllWorkspaceProjects()).thenReturn((Object)new HashSet(){
            {
                this.add(WorkspaceWorkspaceProjectSearchServiceTest.this.itemA);
                this.add(WorkspaceWorkspaceProjectSearchServiceTest.this.itemB);
            }
        });
        this.searchService = new WorkspaceProjectSearchServiceImpl(this.workspaceProjectService);
    }

    @Test
    public void testSearchByAlias() throws Exception {
        Collection result = this.searchService.searchByName("Item", 10, true);
        Assert.assertEquals((long)result.size(), (long)2L);
    }

    @Test
    public void testSearchCaseSensitiveEmpty() throws Exception {
        Collection result = this.searchService.searchByName("item", 10, true);
        Assert.assertEquals((long)result.size(), (long)0L);
    }

    @Test
    public void testSearchCaseUnsensitive() throws Exception {
        Collection result = this.searchService.searchByName("item", 10, false);
        Assert.assertEquals((long)result.size(), (long)2L);
    }

    @Test
    public void testSearchMaxItems() throws Exception {
        Collection result = this.searchService.searchByName("item", 1, false);
        Assert.assertEquals((long)result.size(), (long)1L);
    }
}

