/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.backend.server.utils;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.maven.model.Model;
import org.guvnor.common.services.project.backend.server.utils.DependencyUpdater;
import org.guvnor.common.services.project.model.Dependency;
import org.junit.Assert;
import org.junit.Test;

public class DependencyUpdaterTest {
    @Test
    public void testEmptyDependency() throws Exception {
        Model model = new Model();
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        dependencies.add(new Dependency());
        Assert.assertTrue((boolean)model.getDependencies().isEmpty());
        new DependencyUpdater(model.getDependencies()).updateDependencies(dependencies);
        Assert.assertEquals((long)1L, (long)model.getDependencies().size());
        Assert.assertNull((Object)((org.apache.maven.model.Dependency)model.getDependencies().get(0)).getGroupId());
        Assert.assertNull((Object)((org.apache.maven.model.Dependency)model.getDependencies().get(0)).getArtifactId());
        Assert.assertNull((Object)((org.apache.maven.model.Dependency)model.getDependencies().get(0)).getVersion());
    }

    @Test
    public void testAdd() throws Exception {
        Model model = new Model();
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        dependencies.add(this.makeWorkbenchDependency("group", "artifact-id", "1.0"));
        Assert.assertTrue((boolean)model.getDependencies().isEmpty());
        new DependencyUpdater(model.getDependencies()).updateDependencies(dependencies);
        Assert.assertEquals((long)1L, (long)model.getDependencies().size());
        Assert.assertEquals((Object)"group", (Object)((org.apache.maven.model.Dependency)model.getDependencies().get(0)).getGroupId());
        Assert.assertEquals((Object)"artifact-id", (Object)((org.apache.maven.model.Dependency)model.getDependencies().get(0)).getArtifactId());
        Assert.assertEquals((Object)"1.0", (Object)((org.apache.maven.model.Dependency)model.getDependencies().get(0)).getVersion());
    }

    @Test
    public void testRemove() throws Exception {
        Model model = new Model();
        model.getDependencies().add(this.makeMavenDependency("group", "artifact-id", "1.0"));
        Assert.assertFalse((boolean)model.getDependencies().isEmpty());
        new DependencyUpdater(model.getDependencies()).updateDependencies(Collections.EMPTY_LIST);
        Assert.assertTrue((boolean)model.getDependencies().isEmpty());
    }

    @Test
    public void testUpdate() throws Exception {
        Model model = new Model();
        model.getDependencies().add(this.makeMavenDependency("group", "artifact-id", "1.0"));
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        dependencies.add(this.makeWorkbenchDependency("group", "artifact-id", "2.0"));
        Assert.assertFalse((boolean)model.getDependencies().isEmpty());
        new DependencyUpdater(model.getDependencies()).updateDependencies(dependencies);
        Assert.assertEquals((long)1L, (long)model.getDependencies().size());
        Assert.assertEquals((Object)"group", (Object)((org.apache.maven.model.Dependency)model.getDependencies().get(0)).getGroupId());
        Assert.assertEquals((Object)"artifact-id", (Object)((org.apache.maven.model.Dependency)model.getDependencies().get(0)).getArtifactId());
        Assert.assertEquals((Object)"2.0", (Object)((org.apache.maven.model.Dependency)model.getDependencies().get(0)).getVersion());
    }

    private org.apache.maven.model.Dependency makeMavenDependency(String group, String artifactId, String version) {
        org.apache.maven.model.Dependency dependency = new org.apache.maven.model.Dependency();
        dependency.setGroupId(group);
        dependency.setArtifactId(artifactId);
        dependency.setVersion(version);
        return dependency;
    }

    private Dependency makeWorkbenchDependency(String group, String artifactId, String version) {
        Dependency dependency = new Dependency();
        dependency.setGroupId(group);
        dependency.setArtifactId(artifactId);
        dependency.setVersion(version);
        return dependency;
    }
}

