/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.backend.server;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import org.guvnor.common.services.project.model.GAV;

public class MavenLocalRepositoryUtils {
    public static Path getRepositoryPath(GAV gav) throws IOException {
        Path tempLocalRepositoryBasePath = Files.createTempDirectory("m2-" + MavenLocalRepositoryUtils.toFileName(gav), new FileAttribute[0]);
        return tempLocalRepositoryBasePath;
    }

    private static String toFileName(GAV gav) {
        StringBuilder sb = new StringBuilder();
        sb.append("m2-").append(gav.getGroupId() + "-" + gav.getArtifactId() + "-" + gav.getVersion());
        return sb.toString();
    }

    public static void tearDownMavenRepository(Path m2Folder) {
        if (m2Folder != null) {
            try {
                Files.walkFileTree(m2Folder, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        Files.delete(file);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                        Files.delete(dir);
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

