/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.backend.server;

import java.io.File;
import java.util.Collection;
import java.util.Optional;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Instance;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.guvnor.common.services.project.backend.server.WorkspaceProjectServiceImpl;
import org.guvnor.common.services.project.backend.server.utils.PathUtil;
import org.guvnor.common.services.project.events.NewProjectEvent;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.common.services.project.service.DeploymentMode;
import org.guvnor.common.services.project.service.ModuleRepositoryResolver;
import org.guvnor.common.services.project.service.ModuleService;
import org.guvnor.common.services.project.service.POMService;
import org.guvnor.common.services.project.service.WorkspaceProjectService;
import org.guvnor.common.services.shared.exceptions.GenericPortableException;
import org.guvnor.structure.backend.organizationalunit.config.SpaceConfigStorageRegistryImpl;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.guvnor.structure.organizationalunit.config.SpaceConfigStorage;
import org.guvnor.structure.organizationalunit.config.SpaceConfigStorageRegistry;
import org.guvnor.structure.repositories.Branch;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryEnvironmentConfigurations;
import org.guvnor.structure.repositories.RepositoryService;
import org.guvnor.structure.repositories.changerequest.ChangeRequestService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.fs.jgit.JGitFileSystem;
import org.uberfire.java.nio.fs.jgit.JGitFileSystemProvider;
import org.uberfire.java.nio.fs.jgit.JGitPathImpl;
import org.uberfire.java.nio.fs.jgit.util.Git;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.spaces.Space;
import org.uberfire.spaces.SpacesAPI;

@RunWith(value=MockitoJUnitRunner.class)
public class WorkspaceProjectServiceImplNewWorkspaceWorkspaceProjectTest {
    WorkspaceProjectService workspaceProjectService;
    @Mock
    RepositoryService repositoryService;
    @Mock
    Instance<ModuleService<? extends Module>> moduleServices;
    @Mock
    ModuleService moduleService;
    @Mock
    private OrganizationalUnit ou;
    @Mock
    private Space space;
    @Mock
    private Repository repository;
    @Mock
    private Path repositoryRoot;
    @Mock
    private Branch branch;
    @Mock
    private EventSourceMock<NewProjectEvent> newProjectEvent;
    @Mock
    private Module module;
    @Mock
    private SpacesAPI spaces;
    @Mock
    private ModuleRepositoryResolver repositoryResolver;
    @Mock
    private SpaceConfigStorageRegistry spaceConfigStorageRegistry;
    @Mock
    private SpaceConfigStorage spaceConfigStorage;
    @Mock
    IOService ioService;
    @Mock
    PathUtil pathUtil;
    @Mock
    ChangeRequestService changeRequestService;
    @Mock
    POMService pomService;
    @Mock
    SessionInfo sessionInfo;
    private POM pom;

    @Before
    public void setUp() throws Exception {
        ((Repository)Mockito.doReturn(Optional.of(this.branch)).when((Object)this.repository)).getDefaultBranch();
        ((Branch)Mockito.doReturn((Object)this.repositoryRoot).when((Object)this.branch)).getPath();
        ((RepositoryService)Mockito.doReturn((Object)this.repository).when((Object)this.repositoryService)).createRepository((OrganizationalUnit)Matchers.eq((Object)this.ou), (String)Matchers.eq((Object)"git"), (String)Matchers.eq((Object)"myproject"), (RepositoryEnvironmentConfigurations)Matchers.any(RepositoryEnvironmentConfigurations.class));
        this.pom = this.createPOM("my project");
        Mockito.when((Object)this.ou.getSpace()).thenReturn((Object)this.space);
        Mockito.when((Object)this.space.getName()).thenReturn((Object)"ou");
        Mockito.when((Object)this.repositoryService.createRepository((OrganizationalUnit)Matchers.any(), Matchers.anyString(), Matchers.anyString(), (RepositoryEnvironmentConfigurations)Matchers.any(), (Collection)Matchers.any())).thenReturn((Object)this.repository);
        ((Instance)Mockito.doReturn((Object)this.moduleService).when(this.moduleServices)).get();
        Mockito.when((Object)this.spaceConfigStorageRegistry.get(Matchers.anyString())).thenReturn((Object)this.spaceConfigStorage);
        Mockito.when((Object)this.spaceConfigStorageRegistry.getBatch(Matchers.anyString())).thenReturn((Object)new SpaceConfigStorageRegistryImpl.SpaceStorageBatchImpl(this.spaceConfigStorage));
        Mockito.when((Object)this.spaceConfigStorageRegistry.exist(Matchers.anyString())).thenReturn((Object)true);
        this.workspaceProjectService = new WorkspaceProjectServiceImpl((OrganizationalUnitService)Mockito.mock(OrganizationalUnitService.class), this.repositoryService, this.spaces, this.newProjectEvent, (Event)new EventSourceMock(), (Event)new EventSourceMock(), this.moduleServices, this.repositoryResolver, this.ioService, this.spaceConfigStorageRegistry, this.pathUtil, this.changeRequestService, this.pomService);
    }

    @Test
    public void newProjectDefault() throws Exception {
        ((ModuleService)Mockito.doReturn((Object)this.module).when((Object)this.moduleService)).newModule((Path)Matchers.eq((Object)this.repositoryRoot), (POM)Matchers.eq((Object)this.pom), (DeploymentMode)Matchers.eq((Object)DeploymentMode.VALIDATED));
        WorkspaceProject workspaceProject = this.workspaceProjectService.newProject(this.ou, this.pom);
        this.assertProject(workspaceProject);
        ((EventSourceMock)Mockito.verify(this.newProjectEvent)).fire(Matchers.any());
        ((SpaceConfigStorage)Mockito.verify((Object)this.spaceConfigStorage)).startBatch();
        ((RepositoryService)Mockito.verify((Object)this.repositoryService)).createRepository((OrganizationalUnit)Matchers.eq((Object)this.ou), (String)Matchers.eq((Object)"git"), (String)Matchers.eq((Object)"myproject"), (RepositoryEnvironmentConfigurations)Matchers.any(), (Collection)Matchers.any());
        ((SpaceConfigStorage)Mockito.verify((Object)this.spaceConfigStorage)).endBatch();
    }

    @Test
    public void newProjectFromTemplateTest() {
        WorkspaceProjectServiceImpl impl = (WorkspaceProjectServiceImpl)Mockito.spy((Object)this.workspaceProjectService);
        Repository templateRepository = (Repository)Mockito.mock(Repository.class);
        Branch templateRepositoryBranch = (Branch)Mockito.mock(Branch.class);
        ((Repository)Mockito.doReturn(Optional.of(templateRepositoryBranch)).when((Object)templateRepository)).getDefaultBranch();
        ((Branch)Mockito.doReturn((Object)this.repositoryRoot).when((Object)templateRepositoryBranch)).getPath();
        JGitPathImpl nioPath = (JGitPathImpl)Mockito.mock(JGitPathImpl.class);
        JGitFileSystem fs = (JGitFileSystem)Mockito.mock(JGitFileSystem.class);
        Git git = (Git)Mockito.mock(Git.class);
        ((Git)Mockito.doNothing().when((Object)git)).removeRemote(Matchers.anyString(), Matchers.anyString());
        ((JGitFileSystem)Mockito.doReturn((Object)git).when((Object)fs)).getGit();
        ((JGitPathImpl)Mockito.doReturn((Object)fs).when((Object)nioPath)).getFileSystem();
        ((PathUtil)Mockito.doReturn((Object)nioPath).when((Object)this.pathUtil)).convert((Path)Matchers.any(Path.class));
        org.eclipse.jgit.lib.Repository gitRepository = (org.eclipse.jgit.lib.Repository)Mockito.mock(org.eclipse.jgit.lib.Repository.class);
        File repositoryDirectory = new File("repositoryDirectory");
        ((org.eclipse.jgit.lib.Repository)Mockito.doReturn((Object)repositoryDirectory).when((Object)gitRepository)).getDirectory();
        ((Git)Mockito.doReturn((Object)gitRepository).when((Object)git)).getRepository();
        Path pomPath = (Path)Mockito.mock(Path.class);
        ((WorkspaceProjectServiceImpl)Mockito.doReturn((Object)pomPath).when((Object)impl)).resolvePathFromParent((Path)Matchers.any(Path.class), (String)Matchers.eq((Object)"pom.xml"));
        POM templatePom = this.createPOM("my template");
        ((POMService)Mockito.doReturn((Object)templatePom).when((Object)this.pomService)).load(pomPath);
        ((ModuleService)Mockito.doNothing().when((Object)this.moduleService)).createModuleDirectories((Path)Matchers.any(Path.class));
        ((ModuleService)Mockito.doReturn((Object)this.module).when((Object)this.moduleService)).resolveModule((Path)Matchers.any(Path.class));
        Path branchRoot = PathFactory.newPath((String)"testFile", (String)"file:///branchRoot/");
        ((Branch)Mockito.doReturn((Object)branchRoot).when((Object)this.branch)).getPath();
        WorkspaceProject workspaceProject = impl.newProject(this.ou, this.pom, DeploymentMode.VALIDATED, null, templateRepository);
        this.assertProject(workspaceProject);
        ((EventSourceMock)Mockito.verify(this.newProjectEvent)).fire(Matchers.any());
        ((SpaceConfigStorage)Mockito.verify((Object)this.spaceConfigStorage)).startBatch();
        ((RepositoryService)Mockito.verify((Object)this.repositoryService)).createRepository((OrganizationalUnit)Matchers.eq((Object)this.ou), (String)Matchers.eq((Object)"git"), (String)Matchers.eq((Object)"myproject"), (RepositoryEnvironmentConfigurations)Matchers.any(), (Collection)Matchers.any());
        ((SpaceConfigStorage)Mockito.verify((Object)this.spaceConfigStorage)).endBatch();
    }

    @Test
    public void newProjectFromTemplateWithRemoteUrlTest() {
        String remoteUrl = "myUrl";
        WorkspaceProjectServiceImpl impl = (WorkspaceProjectServiceImpl)Mockito.spy((Object)this.workspaceProjectService);
        Repository templateRepository = (Repository)Mockito.mock(Repository.class);
        Branch templateRepositoryBranch = (Branch)Mockito.mock(Branch.class);
        ((Repository)Mockito.doReturn(Optional.of(templateRepositoryBranch)).when((Object)templateRepository)).getDefaultBranch();
        ((Branch)Mockito.doReturn((Object)this.repositoryRoot).when((Object)templateRepositoryBranch)).getPath();
        JGitPathImpl nioPath = (JGitPathImpl)Mockito.mock(JGitPathImpl.class);
        JGitFileSystem fs = (JGitFileSystem)Mockito.mock(JGitFileSystem.class);
        JGitFileSystemProvider provider = (JGitFileSystemProvider)Mockito.mock(JGitFileSystemProvider.class);
        Git git = (Git)Mockito.mock(Git.class);
        ((Git)Mockito.doNothing().when((Object)git)).removeRemote(Matchers.anyString(), Matchers.anyString());
        ((Git)Mockito.doNothing().when((Object)git)).addRemote(Matchers.anyString(), Matchers.anyString());
        ((JGitFileSystem)Mockito.doReturn((Object)git).when((Object)fs)).getGit();
        ((JGitPathImpl)Mockito.doReturn((Object)fs).when((Object)nioPath)).getFileSystem();
        ((JGitFileSystem)Mockito.doReturn((Object)provider).when((Object)fs)).provider();
        ((JGitFileSystemProvider)Mockito.doNothing().when((Object)provider)).executePostCommitHook(fs);
        ((PathUtil)Mockito.doReturn((Object)nioPath).when((Object)this.pathUtil)).convert((Path)Matchers.any(Path.class));
        org.eclipse.jgit.lib.Repository gitRepository = (org.eclipse.jgit.lib.Repository)Mockito.mock(org.eclipse.jgit.lib.Repository.class);
        File repositoryDirectory = new File("repositoryDirectory");
        ((org.eclipse.jgit.lib.Repository)Mockito.doReturn((Object)repositoryDirectory).when((Object)gitRepository)).getDirectory();
        ((Git)Mockito.doReturn((Object)gitRepository).when((Object)git)).getRepository();
        Path pomPath = (Path)Mockito.mock(Path.class);
        ((WorkspaceProjectServiceImpl)Mockito.doReturn((Object)pomPath).when((Object)impl)).resolvePathFromParent((Path)Matchers.any(Path.class), (String)Matchers.eq((Object)"pom.xml"));
        POM templatePom = this.createPOM("my template");
        ((POMService)Mockito.doReturn((Object)templatePom).when((Object)this.pomService)).load(pomPath);
        ((ModuleService)Mockito.doNothing().when((Object)this.moduleService)).createModuleDirectories((Path)Matchers.any(Path.class));
        ((ModuleService)Mockito.doReturn((Object)this.module).when((Object)this.moduleService)).resolveModule((Path)Matchers.any(Path.class));
        Path branchRoot = PathFactory.newPath((String)"testFile", (String)"file:///branchRoot/");
        ((Branch)Mockito.doReturn((Object)branchRoot).when((Object)this.branch)).getPath();
        WorkspaceProject workspaceProject = impl.newProject(this.ou, this.pom, DeploymentMode.VALIDATED, null, templateRepository, "myUrl");
        this.assertProject(workspaceProject);
        ((EventSourceMock)Mockito.verify(this.newProjectEvent)).fire(Matchers.any());
        ((SpaceConfigStorage)Mockito.verify((Object)this.spaceConfigStorage)).startBatch();
        ((RepositoryService)Mockito.verify((Object)this.repositoryService)).createRepository((OrganizationalUnit)Matchers.eq((Object)this.ou), (String)Matchers.eq((Object)"git"), (String)Matchers.eq((Object)"myproject"), (RepositoryEnvironmentConfigurations)Matchers.any(), (Collection)Matchers.any());
        ((SpaceConfigStorage)Mockito.verify((Object)this.spaceConfigStorage)).endBatch();
        ((JGitFileSystemProvider)Mockito.verify((Object)provider)).executePostCommitHook(fs);
        ((Git)Mockito.verify((Object)git)).addRemote(Matchers.anyString(), (String)Matchers.eq((Object)"myUrl"));
    }

    @Test
    public void newProjectValidated() throws Exception {
        ((ModuleService)Mockito.doReturn((Object)this.module).when((Object)this.moduleService)).newModule((Path)Matchers.eq((Object)this.repositoryRoot), (POM)Matchers.eq((Object)this.pom), (DeploymentMode)Matchers.eq((Object)DeploymentMode.VALIDATED));
        WorkspaceProject workspaceProject = this.workspaceProjectService.newProject(this.ou, this.pom, DeploymentMode.VALIDATED);
        this.assertProject(workspaceProject);
        ((EventSourceMock)Mockito.verify(this.newProjectEvent)).fire(Matchers.any());
        ((SpaceConfigStorage)Mockito.verify((Object)this.spaceConfigStorage)).startBatch();
        ((RepositoryService)Mockito.verify((Object)this.repositoryService)).createRepository((OrganizationalUnit)Matchers.eq((Object)this.ou), (String)Matchers.eq((Object)"git"), (String)Matchers.eq((Object)"myproject"), (RepositoryEnvironmentConfigurations)Matchers.any(), (Collection)Matchers.any());
        ((SpaceConfigStorage)Mockito.verify((Object)this.spaceConfigStorage)).endBatch();
    }

    @Test
    public void testNewProjectErrorRepositoryWithoutDefaultBranch() {
        Mockito.when((Object)this.repository.getDefaultBranch()).thenReturn(Optional.empty());
        this.testNewProjectError(GenericPortableException.class, "New repository should always have a branch.");
    }

    @Test
    public void testNewProjectErrorCreatingModule() {
        String errorMessage = "Impossible to create module";
        ((ModuleService)Mockito.doThrow((Throwable)new IllegalStateException("Impossible to create module")).when((Object)this.moduleService)).newModule((Path)Matchers.any(), (POM)Matchers.any(), (DeploymentMode)Matchers.any());
        this.testNewProjectError(GenericPortableException.class, "Impossible to create module");
    }

    private void testNewProjectError(Class<? extends Exception> expectedExceptionType, String expectedMessage) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.workspaceProjectService.newProject(this.ou, this.pom)).isInstanceOf(expectedExceptionType)).hasMessage(expectedMessage);
        ((RepositoryService)Mockito.verify((Object)this.repositoryService)).removeRepository((Space)Matchers.any(), Matchers.anyString());
        ((EventSourceMock)Mockito.verify(this.newProjectEvent, (VerificationMode)Mockito.never())).fire(Matchers.any());
    }

    @Test
    public void newProjectForced() throws Exception {
        ((ModuleService)Mockito.doReturn((Object)this.module).when((Object)this.moduleService)).newModule((Path)Matchers.eq((Object)this.repositoryRoot), (POM)Matchers.eq((Object)this.pom), (DeploymentMode)Matchers.eq((Object)DeploymentMode.FORCED));
        WorkspaceProject workspaceProject = this.workspaceProjectService.newProject(this.ou, this.pom, DeploymentMode.FORCED);
        this.assertProject(workspaceProject);
        ((EventSourceMock)Mockito.verify(this.newProjectEvent)).fire(Matchers.any());
        ((SpaceConfigStorage)Mockito.verify((Object)this.spaceConfigStorage)).startBatch();
        ((RepositoryService)Mockito.verify((Object)this.repositoryService)).createRepository((OrganizationalUnit)Matchers.eq((Object)this.ou), (String)Matchers.eq((Object)"git"), (String)Matchers.eq((Object)"myproject"), (RepositoryEnvironmentConfigurations)Matchers.any(), (Collection)Matchers.any());
        ((SpaceConfigStorage)Mockito.verify((Object)this.spaceConfigStorage)).endBatch();
    }

    private void assertProject(WorkspaceProject workspaceProject) {
        Assert.assertEquals((Object)this.ou, (Object)workspaceProject.getOrganizationalUnit());
        Assert.assertEquals((Object)this.repository, (Object)workspaceProject.getRepository());
        Assert.assertEquals((Object)this.branch, (Object)workspaceProject.getBranch());
        Assert.assertEquals((Object)this.module, (Object)workspaceProject.getMainModule());
    }

    private POM createPOM(String name) {
        return new POM(name, "my description", "url", new GAV("groupId", "artifactId", "version"));
    }
}

