/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.backend.server;

import org.guvnor.common.services.backend.util.CommentedOptionFactory;
import org.guvnor.common.services.project.backend.server.POMServiceImpl;
import org.guvnor.common.services.project.backend.server.PomEnhancer;
import org.guvnor.common.services.project.backend.server.utils.POMContentHandler;
import org.guvnor.common.services.project.events.ModuleUpdatedEvent;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.service.ModuleService;
import org.guvnor.common.services.shared.metadata.MetadataService;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.guvnor.m2repo.service.M2RepoService;
import org.guvnor.test.TestFileSystem;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Option;
import org.uberfire.java.nio.file.Path;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=MockitoJUnitRunner.class)
public class POMServiceImplSaveTest {
    @Mock
    private IOService ioService;
    @Mock
    private POMContentHandler pomContentHandler;
    @Mock
    private ModuleService moduleService;
    @Mock
    private EventSourceMock<ModuleUpdatedEvent> moduleUpdatedEvent;
    @Captor
    private ArgumentCaptor<Path> pathArgumentCaptor;
    private TestFileSystem testFileSystem;
    private POMServiceImpl service;

    @Before
    public void setUp() throws Exception {
        this.testFileSystem = new TestFileSystem();
        ((POMContentHandler)Mockito.doReturn((Object)new POM("mymodule", "desctiption", "url", new GAV())).when((Object)this.pomContentHandler)).toModel((String)Matchers.any());
        ((POMContentHandler)Mockito.doReturn((Object)"").when((Object)this.pomContentHandler)).toString((POM)Matchers.any(), (String)Matchers.any());
        ((ModuleService)Mockito.doReturn((Object)Mockito.mock(Module.class)).when((Object)this.moduleService)).resolveModule((org.uberfire.backend.vfs.Path)Matchers.any());
        this.service = new POMServiceImpl(this.ioService, this.pomContentHandler, (M2RepoService)Mockito.mock(M2RepoService.class), (MetadataService)Mockito.mock(MetadataService.class), this.moduleUpdatedEvent, this.moduleService, (CommentedOptionFactory)Mockito.mock(CommentedOptionFactory.class), (PomEnhancer)Mockito.mock(PomEnhancer.class));
    }

    @After
    public void tearDown() throws Exception {
        this.testFileSystem.tearDown();
    }

    @Test
    public void whenProjectSavedWithoutChanges_ModuleUpdatedEventNotFired() throws Exception {
        org.uberfire.backend.vfs.Path path = this.testFileSystem.createTempFile("testproject/pom.xml");
        POM originalPOM = new POM("mymodule", "desctiption", "url", new GAV());
        this.service.save(path, originalPOM, (Metadata)Mockito.mock(Metadata.class), "");
        ((IOService)Mockito.verify((Object)this.ioService)).startBatch((FileSystem)Matchers.any(), (Option[])Matchers.any());
        ((IOService)Mockito.verify((Object)this.ioService)).write((Path)this.pathArgumentCaptor.capture(), Matchers.anyString(), Matchers.anyMap(), new OpenOption[0]);
        ((IOService)Mockito.verify((Object)this.ioService)).endBatch();
        ((EventSourceMock)Mockito.verify(this.moduleUpdatedEvent, (VerificationMode)Mockito.never())).fire(Matchers.any());
        Assert.assertTrue((boolean)path.toURI().endsWith(((Path)this.pathArgumentCaptor.getValue()).toString()));
    }

    @Test
    public void whenProjectRenamed_ModuleUpdatedEventIsFired() throws Exception {
        org.uberfire.backend.vfs.Path path = this.testFileSystem.createTempFile("testproject/pom.xml");
        this.service.save(path, new POM("newName", "desctiption", "url", new GAV()), (Metadata)Mockito.mock(Metadata.class), "");
        ((EventSourceMock)Mockito.verify(this.moduleUpdatedEvent)).fire(Matchers.any());
    }
}

