/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.backend.server;

import java.io.IOException;
import java.net.URI;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.enterprise.inject.Instance;
import org.guvnor.common.services.backend.util.CommentedOptionFactory;
import org.guvnor.common.services.project.backend.server.ModuleResourcePathResolver;
import org.guvnor.common.services.project.backend.server.ResourceResolver;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.service.POMService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.junit.MockitoJUnitRunner;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.mocks.FileSystemTestingUtils;

@RunWith(value=MockitoJUnitRunner.class)
public class ResourceResolverResolvePackagesTest {
    private static FileSystemTestingUtils fsUtils = new FileSystemTestingUtils();
    @Mock
    private POMService pomService;
    @Mock
    private CommentedOptionFactory commentedOptionFactory;
    @Mock
    private Instance<ModuleResourcePathResolver> resourcePathResolversInstance;
    private Module module;
    private ResourceResolver resourceResolver;

    @Before
    public void setUp() throws IOException {
        fsUtils.setup(false);
        Path root = fsUtils.getIoService().get(URI.create("git://amend-repo-test"));
        Path pomPath = fsUtils.getIoService().get(URI.create("git://amend-repo-test/pom.xml"));
        Path mainJava = fsUtils.getIoService().get(URI.create("git://amend-repo-test/src/main/java/org/test/.keep"));
        Path mainResource = fsUtils.getIoService().get(URI.create("git://amend-repo-test/src/main/resources/org/test/.keep"));
        Path testJava = fsUtils.getIoService().get(URI.create("git://amend-repo-test/src/test/java/org/test/.keep"));
        Path testResource = fsUtils.getIoService().get(URI.create("git://amend-repo-test/src/test/resources/org/test/.keep"));
        fsUtils.getIoService().write(pomPath, "", new OpenOption[0]);
        fsUtils.getIoService().write(mainJava, "", new OpenOption[0]);
        fsUtils.getIoService().write(mainResource, "", new OpenOption[0]);
        fsUtils.getIoService().write(testJava, "", new OpenOption[0]);
        fsUtils.getIoService().write(testResource, "", new OpenOption[0]);
        this.module = new Module(Paths.convert((Path)root), Paths.convert((Path)pomPath));
        this.resourceResolver = new ResourceResolver(fsUtils.getIoService(), this.pomService, this.commentedOptionFactory, this.resourcePathResolversInstance){

            public Module resolveModule(org.uberfire.backend.vfs.Path resource, boolean loadPOM) {
                return ResourceResolverResolvePackagesTest.this.module;
            }

            public Module simpleModuleInstance(Path nioModuleRootPath) {
                return null;
            }
        };
    }

    @After
    public void cleanupFileSystem() {
        fsUtils.cleanup();
    }

    @Test
    public void testResolvePackages() {
        Set packages = this.resourceResolver.resolvePackages(this.module);
        Assert.assertEquals((long)3L, (long)packages.size());
        this.assertContains("", packages);
        this.assertContains("org", packages);
        this.assertContains("org.test", packages);
    }

    @Test
    public void testResolvePackagesWithPackageNames() {
        HashSet<String> packageNames = new HashSet<String>();
        packageNames.add("");
        packageNames.add("org");
        packageNames.add("org.test");
        Set packages = this.resourceResolver.resolvePackages(this.module, packageNames);
        Assert.assertEquals((long)3L, (long)packages.size());
        this.assertContains("", packages);
        this.assertContains("org", packages);
        this.assertContains("org.test", packages);
    }

    @Test
    public void testResolvePackagesWithPackageNamesEmpty() {
        Set packages = this.resourceResolver.resolvePackages(this.module, new HashSet());
        Assert.assertEquals((long)0L, (long)packages.size());
    }

    @Test
    public void testResolvePackagesWhenModuleNull() {
        Set packages = this.resourceResolver.resolvePackages(null, new HashSet());
        Assert.assertEquals((long)0L, (long)packages.size());
    }

    private void assertContains(String pkgName, Set<Package> packages) {
        for (Package aPackage : packages) {
            if (!Objects.equals(aPackage.getPackageName(), pkgName)) continue;
            return;
        }
        Assert.fail((String)("Could not find package " + pkgName));
    }
}

