/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.backend.server;

import java.util.HashSet;
import org.guvnor.common.services.backend.util.CommentedOptionFactory;
import org.guvnor.common.services.project.backend.server.AbstractModuleRepositoriesServiceImpl;
import org.guvnor.common.services.project.backend.server.ModuleRepositoriesContentHandler;
import org.guvnor.common.services.project.model.MavenRepositoryMetadata;
import org.guvnor.common.services.project.model.MavenRepositorySource;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.model.ModuleRepositories;
import org.guvnor.common.services.project.service.ModuleRepositoriesService;
import org.guvnor.common.services.project.service.ModuleRepositoryResolver;
import org.guvnor.common.services.project.service.ModuleResourceResolver;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Option;
import org.uberfire.java.nio.file.Path;

@RunWith(value=MockitoJUnitRunner.class)
public class AbstractModuleRepositoriesServiceImplTest {
    @Mock
    private IOService ioService;
    @Mock
    private ModuleRepositoryResolver repositoryResolver;
    @Mock
    private ModuleResourceResolver resourceResolver;
    @Mock
    private CommentedOptionFactory commentedOptionFactory;
    private ModuleRepositoriesService service;
    private ModuleRepositoriesContentHandler contentHandler;

    @BeforeClass
    public static void setupSystemProperties() {
        System.setProperty("org.uberfire.nio.git.daemon.enabled", "false");
        System.setProperty("org.uberfire.nio.git.ssh.enabled", "false");
        System.setProperty("org.uberfire.sys.repo.monitor.disabled", "true");
    }

    @Before
    public void setup() {
        this.contentHandler = (ModuleRepositoriesContentHandler)Mockito.spy((Object)new ModuleRepositoriesContentHandler());
        this.service = new AbstractModuleRepositoriesServiceImpl<Module>(this.ioService, this.repositoryResolver, this.contentHandler, this.commentedOptionFactory){

            protected Module getModule(org.uberfire.backend.vfs.Path path) {
                return AbstractModuleRepositoriesServiceImplTest.this.resourceResolver.resolveModule(path);
            }
        };
    }

    @Test
    public void testCreateWithoutProject() {
        String xml = "<project-repositories>\n  <repositories>\n    <repository>\n      <include>true</include>\n      <metadata>\n        <id>local</id>\n        <url>local-url</url>\n        <source>LOCAL</source>\n      </metadata>\n    </repository>\n  </repositories>\n</project-repositories>";
        org.uberfire.backend.vfs.Path path = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        Mockito.when((Object)path.toURI()).thenReturn((Object)"file://p0/project.repositories");
        Path nioPath = Paths.convert((org.uberfire.backend.vfs.Path)path);
        HashSet<MavenRepositoryMetadata> metadata = new HashSet<MavenRepositoryMetadata>();
        metadata.add(new MavenRepositoryMetadata("local", "local-url", MavenRepositorySource.LOCAL));
        Mockito.when((Object)this.repositoryResolver.getRemoteRepositoriesMetaData()).thenReturn(metadata);
        Mockito.when((Object)this.resourceResolver.resolveModule(path)).thenReturn(null);
        this.service.create(path);
        ((ModuleResourceResolver)Mockito.verify((Object)this.resourceResolver, (VerificationMode)Mockito.times((int)1))).resolveModule(path);
        ((ModuleRepositoryResolver)Mockito.verify((Object)this.repositoryResolver, (VerificationMode)Mockito.times((int)1))).getRemoteRepositoriesMetaData();
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)1))).startBatch((FileSystem)Mockito.any(FileSystem.class), (Option[])Mockito.any());
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)1))).write((Path)Mockito.eq((Object)nioPath), (String)Mockito.eq((Object)"<project-repositories>\n  <repositories>\n    <repository>\n      <include>true</include>\n      <metadata>\n        <id>local</id>\n        <url>local-url</url>\n        <source>LOCAL</source>\n      </metadata>\n    </repository>\n  </repositories>\n</project-repositories>"), new OpenOption[0]);
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)1))).endBatch();
    }

    @Test
    public void testCreateWithProject() {
        String xml = "<project-repositories>\n  <repositories>\n    <repository>\n      <include>true</include>\n      <metadata>\n        <id>local</id>\n        <url>local-url</url>\n        <source>LOCAL</source>\n      </metadata>\n    </repository>\n  </repositories>\n</project-repositories>";
        org.uberfire.backend.vfs.Path path = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        Mockito.when((Object)path.toURI()).thenReturn((Object)"file://p0/project.repositories");
        Path nioPath = Paths.convert((org.uberfire.backend.vfs.Path)path);
        Module module = (Module)Mockito.mock(Module.class);
        HashSet<MavenRepositoryMetadata> metadata = new HashSet<MavenRepositoryMetadata>();
        metadata.add(new MavenRepositoryMetadata("local", "local-url", MavenRepositorySource.LOCAL));
        Mockito.when((Object)this.repositoryResolver.getRemoteRepositoriesMetaData((Module)Mockito.eq((Object)module))).thenReturn(metadata);
        Mockito.when((Object)this.resourceResolver.resolveModule(path)).thenReturn((Object)module);
        this.service.create(path);
        ((ModuleResourceResolver)Mockito.verify((Object)this.resourceResolver, (VerificationMode)Mockito.times((int)1))).resolveModule(path);
        ((ModuleRepositoryResolver)Mockito.verify((Object)this.repositoryResolver, (VerificationMode)Mockito.times((int)1))).getRemoteRepositoriesMetaData((Module)Mockito.eq((Object)module));
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)1))).startBatch((FileSystem)Mockito.any(), (Option[])Mockito.any());
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)1))).write((Path)Mockito.eq((Object)nioPath), (String)Mockito.eq((Object)"<project-repositories>\n  <repositories>\n    <repository>\n      <include>true</include>\n      <metadata>\n        <id>local</id>\n        <url>local-url</url>\n        <source>LOCAL</source>\n      </metadata>\n    </repository>\n  </repositories>\n</project-repositories>"), new OpenOption[0]);
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)1))).endBatch();
    }

    @Test
    public void testLoadExisting() {
        String xml = "<project-repositories>\n  <repositories>\n    <repository>\n      <include>true</include>\n      <metadata>\n        <id>id</id>\n        <url>url</url>\n        <source>LOCAL</source>\n      </metadata>\n    </repository>\n  </repositories>\n</project-repositories>";
        org.uberfire.backend.vfs.Path path = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        Mockito.when((Object)path.toURI()).thenReturn((Object)"file://p0/project.repositories");
        Path nioPath = Paths.convert((org.uberfire.backend.vfs.Path)path);
        Mockito.when((Object)this.ioService.exists((Path)Mockito.eq((Object)nioPath))).thenReturn((Object)true);
        Mockito.when((Object)this.ioService.readAllString((Path)Mockito.eq((Object)nioPath))).thenReturn((Object)"<project-repositories>\n  <repositories>\n    <repository>\n      <include>true</include>\n      <metadata>\n        <id>id</id>\n        <url>url</url>\n        <source>LOCAL</source>\n      </metadata>\n    </repository>\n  </repositories>\n</project-repositories>");
        ModuleRepositories repositories = (ModuleRepositories)this.service.load(path);
        Assert.assertNotNull((Object)repositories);
        Assert.assertNotNull((Object)repositories.getRepositories());
        Assert.assertEquals((long)1L, (long)repositories.getRepositories().size());
        ModuleRepositories.ModuleRepository repository = (ModuleRepositories.ModuleRepository)repositories.getRepositories().iterator().next();
        Assert.assertEquals((Object)"id", (Object)repository.getMetadata().getId());
        Assert.assertEquals((Object)"url", (Object)repository.getMetadata().getUrl());
        Assert.assertEquals((Object)MavenRepositorySource.LOCAL, (Object)repository.getMetadata().getSource());
        Assert.assertEquals((Object)true, (Object)repository.isIncluded());
        ((ModuleRepositoriesContentHandler)Mockito.verify((Object)this.contentHandler, (VerificationMode)Mockito.times((int)1))).toModel((String)Mockito.eq((Object)"<project-repositories>\n  <repositories>\n    <repository>\n      <include>true</include>\n      <metadata>\n        <id>id</id>\n        <url>url</url>\n        <source>LOCAL</source>\n      </metadata>\n    </repository>\n  </repositories>\n</project-repositories>"));
    }

    @Test
    public void testLoadNonExisting() {
        String xml = "<project-repositories>\n  <repositories>\n    <repository>\n      <include>true</include>\n      <metadata>\n        <id>local</id>\n        <url>local-url</url>\n        <source>LOCAL</source>\n      </metadata>\n    </repository>\n  </repositories>\n</project-repositories>";
        org.uberfire.backend.vfs.Path path = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        Mockito.when((Object)path.toURI()).thenReturn((Object)"file://p0/project.repositories");
        Path nioPath = Paths.convert((org.uberfire.backend.vfs.Path)path);
        Mockito.when((Object)this.ioService.exists((Path)Mockito.eq((Object)nioPath))).thenReturn((Object)false);
        HashSet<MavenRepositoryMetadata> metadata = new HashSet<MavenRepositoryMetadata>();
        metadata.add(new MavenRepositoryMetadata("local", "local-url", MavenRepositorySource.LOCAL));
        Mockito.when((Object)this.repositoryResolver.getRemoteRepositoriesMetaData()).thenReturn(metadata);
        ModuleRepositories repositories = (ModuleRepositories)this.service.load(path);
        Assert.assertNotNull((Object)repositories);
        Assert.assertNotNull((Object)repositories.getRepositories());
        Assert.assertEquals((long)1L, (long)repositories.getRepositories().size());
        ModuleRepositories.ModuleRepository repository = (ModuleRepositories.ModuleRepository)repositories.getRepositories().iterator().next();
        Assert.assertEquals((Object)"local", (Object)repository.getMetadata().getId());
        Assert.assertEquals((Object)"local-url", (Object)repository.getMetadata().getUrl());
        Assert.assertEquals((Object)MavenRepositorySource.LOCAL, (Object)repository.getMetadata().getSource());
        Assert.assertEquals((Object)true, (Object)repository.isIncluded());
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)1))).startBatch((FileSystem)Mockito.any(FileSystem.class), (Option[])Mockito.any());
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)1))).write((Path)Mockito.eq((Object)nioPath), (String)Mockito.eq((Object)"<project-repositories>\n  <repositories>\n    <repository>\n      <include>true</include>\n      <metadata>\n        <id>local</id>\n        <url>local-url</url>\n        <source>LOCAL</source>\n      </metadata>\n    </repository>\n  </repositories>\n</project-repositories>"), new OpenOption[0]);
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)1))).endBatch();
    }

    @Test
    public void testSave() {
        HashSet<ModuleRepositories.ModuleRepository> repositories = new HashSet<ModuleRepositories.ModuleRepository>();
        repositories.add(new ModuleRepositories.ModuleRepository(true, new MavenRepositoryMetadata("id", "url", MavenRepositorySource.LOCAL)));
        ModuleRepositories moduleRepositories = new ModuleRepositories(repositories);
        String xml = "<project-repositories>\n  <repositories>\n    <repository>\n      <include>true</include>\n      <metadata>\n        <id>id</id>\n        <url>url</url>\n        <source>LOCAL</source>\n      </metadata>\n    </repository>\n  </repositories>\n</project-repositories>";
        org.uberfire.backend.vfs.Path path = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        Mockito.when((Object)path.toURI()).thenReturn((Object)"file://p0/project.repositories");
        Path nioPath = Paths.convert((org.uberfire.backend.vfs.Path)path);
        this.service.save(path, moduleRepositories, "comment");
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)1))).write((Path)Mockito.eq((Object)nioPath), (String)Mockito.eq((Object)"<project-repositories>\n  <repositories>\n    <repository>\n      <include>true</include>\n      <metadata>\n        <id>id</id>\n        <url>url</url>\n        <source>LOCAL</source>\n      </metadata>\n    </repository>\n  </repositories>\n</project-repositories>"), new OpenOption[0]);
    }

    @Test
    public void testFiltered() {
        String xml = "<project-repositories>\n  <repositories>\n    <repository>\n      <include>true</include>\n      <metadata>\n        <id>id1</id>\n        <url>url1</url>\n        <source>LOCAL</source>\n      </metadata>\n    </repository>\n    <repository>\n      <include>false</include>\n      <metadata>\n        <id>id2</id>\n        <url>url2</url>\n        <source>LOCAL</source>\n      </metadata>\n    </repository>\n  </repositories>\n</project-repositories>";
        org.uberfire.backend.vfs.Path path = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        Mockito.when((Object)path.toURI()).thenReturn((Object)"file://p0/project.repositories");
        Path nioPath = Paths.convert((org.uberfire.backend.vfs.Path)path);
        Mockito.when((Object)this.ioService.exists((Path)Mockito.eq((Object)nioPath))).thenReturn((Object)true);
        Mockito.when((Object)this.ioService.readAllString((Path)Mockito.eq((Object)nioPath))).thenReturn((Object)"<project-repositories>\n  <repositories>\n    <repository>\n      <include>true</include>\n      <metadata>\n        <id>id1</id>\n        <url>url1</url>\n        <source>LOCAL</source>\n      </metadata>\n    </repository>\n    <repository>\n      <include>false</include>\n      <metadata>\n        <id>id2</id>\n        <url>url2</url>\n        <source>LOCAL</source>\n      </metadata>\n    </repository>\n  </repositories>\n</project-repositories>");
        ModuleRepositories repositories = (ModuleRepositories)this.service.load(path);
        Assert.assertNotNull((Object)repositories);
        Assert.assertNotNull((Object)repositories.getRepositories());
        Assert.assertEquals((long)2L, (long)repositories.getRepositories().size());
        MavenRepositoryMetadata[] metadatas = repositories.filterByIncluded();
        Assert.assertEquals((long)1L, (long)metadatas.length);
        MavenRepositoryMetadata metadata = metadatas[0];
        Assert.assertEquals((Object)"id1", (Object)metadata.getId());
        Assert.assertEquals((Object)"url1", (Object)metadata.getUrl());
        Assert.assertEquals((Object)MavenRepositorySource.LOCAL, (Object)metadata.getSource());
    }
}

