/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.backend.server;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.guvnor.common.services.project.backend.server.WorkspaceProjectMigrationServiceImpl;
import org.guvnor.common.services.project.backend.server.utils.PathUtil;
import org.guvnor.common.services.project.events.NewProjectEvent;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.common.services.project.service.ModuleService;
import org.guvnor.common.services.project.service.WorkspaceProjectService;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.guvnor.structure.organizationalunit.config.SpaceConfigStorage;
import org.guvnor.structure.organizationalunit.config.SpaceConfigStorageRegistry;
import org.guvnor.structure.organizationalunit.config.SpaceInfo;
import org.guvnor.structure.repositories.Branch;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryEnvironmentConfigurations;
import org.guvnor.structure.repositories.RepositoryService;
import org.guvnor.structure.repositories.impl.git.GitRepository;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.Path;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.spaces.Space;
import org.uberfire.spaces.SpacesAPI;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class WorkspaceProjectMigrationServiceImplTest {
    private static final String NIOGIT_PATH = "/home/someone/somehwere/.niogit";
    private static final String SPACE = "testspace";
    private static final String REPO = "testrepo";
    private WorkspaceProjectMigrationServiceImpl service;
    @Mock
    private ModuleService<?> moduleService;
    @Mock
    private RepositoryService repositoryService;
    @Mock
    private EventSourceMock<NewProjectEvent> newProjectEvent;
    @Mock
    private IOService ioService;
    @Mock
    private org.uberfire.backend.vfs.Path legacyMainBranchProject1RootPath;
    @Mock
    private org.uberfire.backend.vfs.Path legacyDevBranchProject1RootPath;
    @Mock
    private org.uberfire.backend.vfs.Path legacyDevBranchProject2RootPath;
    @Mock
    private OrganizationalUnitService organizationalUnitService;
    @Mock
    private OrganizationalUnit organizationalUnit;
    @Mock
    private PathUtil pathUtil;
    @Mock
    private WorkspaceProjectService workspaceProjectService;
    @Mock
    private Space space;
    @Mock
    private SpaceConfigStorage spaceConfigStorage;
    @Mock
    private SpaceConfigStorageRegistry spaceConfigStorageRegistry;
    @Captor
    private ArgumentCaptor<NewProjectEvent> newProjectEventArgumentCaptor;
    @Captor
    private ArgumentCaptor<RepositoryEnvironmentConfigurations> configsCaptor;
    private Branch legacyMainBranch;
    private Branch legacyDevBranch;

    @Before
    public void setUp() throws Exception {
        SpaceInfo spaceInfo = (SpaceInfo)Mockito.mock(SpaceInfo.class);
        ((SpaceInfo)Mockito.doAnswer(invocation -> null).when((Object)spaceInfo)).removeRepository((String)ArgumentMatchers.any());
        ((SpaceInfo)Mockito.doAnswer(invocation -> null).when((Object)spaceInfo)).getRepositories((Predicate)ArgumentMatchers.any());
        ((SpaceConfigStorage)Mockito.doReturn((Object)spaceInfo).when((Object)this.spaceConfigStorage)).loadSpaceInfo();
        Mockito.when((Object)this.spaceConfigStorageRegistry.get((String)ArgumentMatchers.any())).thenReturn((Object)this.spaceConfigStorage);
        ((WorkspaceProjectService)Mockito.doReturn((Object)Mockito.mock(WorkspaceProject.class)).when((Object)this.workspaceProjectService)).resolveProject((Repository)Mockito.any());
        ((IOService)Mockito.doAnswer(invocationOnMock -> Paths.convert((org.uberfire.backend.vfs.Path)PathFactory.newPath((String)"file", (String)invocationOnMock.getArguments()[0].toString()))).when((Object)this.ioService)).get((URI)ArgumentMatchers.any());
        Mockito.when((Object)this.pathUtil.normalizePath((org.uberfire.backend.vfs.Path)ArgumentMatchers.any())).then(inv -> (org.uberfire.backend.vfs.Path)inv.getArgument(0, org.uberfire.backend.vfs.Path.class));
        Mockito.when((Object)this.pathUtil.convert((org.uberfire.backend.vfs.Path)Mockito.any())).then(inv -> {
            org.uberfire.backend.vfs.Path path = (org.uberfire.backend.vfs.Path)inv.getArgument(0, org.uberfire.backend.vfs.Path.class);
            Path retVal = (Path)Mockito.mock(Path.class);
            Mockito.when((Object)retVal.toUri()).then(inv1 -> URI.create(path.toURI()));
            return retVal;
        });
        Mockito.when((Object)this.pathUtil.getNiogitRepoPath((Path)ArgumentMatchers.any())).thenReturn((Object)NIOGIT_PATH);
        this.service = (WorkspaceProjectMigrationServiceImpl)Mockito.spy((Object)new WorkspaceProjectMigrationServiceImpl(this.workspaceProjectService, this.repositoryService, this.organizationalUnitService, this.pathUtil, this.newProjectEvent, this.moduleService, this.spaceConfigStorageRegistry));
        ((WorkspaceProjectMigrationServiceImpl)Mockito.doAnswer(invocation -> null).when((Object)this.service)).cleanupOrigin((Repository)ArgumentMatchers.any());
        this.legacyMainBranch = this.mockBranch("legacyMainBranch");
        this.legacyDevBranch = this.mockBranch("legacyDevBranch");
        Mockito.when((Object)this.legacyDevBranchProject1RootPath.toURI()).thenReturn((Object)this.uri("legacyDevBranch", "legacyProject1"));
        Mockito.when((Object)this.legacyDevBranchProject2RootPath.toURI()).thenReturn((Object)this.uri("legacyDevBranch", "legacyProject2"));
        Mockito.when((Object)this.legacyMainBranchProject1RootPath.toURI()).thenReturn((Object)this.uri("legacyMainBranch", "legacyProject1"));
        Repository legacyRepository = this.mockLegacyRepository();
        ((OrganizationalUnit)Mockito.doReturn((Object)new Space("space")).when((Object)this.organizationalUnit)).getSpace();
        WorkspaceProject legacyWorkspaceProject = new WorkspaceProject(this.organizationalUnit, legacyRepository, this.legacyMainBranch, null);
        this.setUpMainBranch();
        this.setUpDevBranch();
        this.mockRepository(this.organizationalUnit);
        this.service.migrate(legacyWorkspaceProject);
    }

    private String uri(String branch, String repo) {
        return "git://" + branch + "@" + SPACE + "/" + REPO + "/" + repo;
    }

    @Test
    public void createOnlyTwoRepositories() throws Exception {
        ((RepositoryService)Mockito.verify((Object)this.repositoryService, (VerificationMode)Mockito.times((int)2))).createRepository((OrganizationalUnit)ArgumentMatchers.any(OrganizationalUnit.class), (String)ArgumentMatchers.eq((Object)GitRepository.SCHEME.toString()), ArgumentMatchers.anyString(), (RepositoryEnvironmentConfigurations)this.configsCaptor.capture());
        List allValues = this.configsCaptor.getAllValues();
        HashSet observedSubdirectories = new HashSet();
        allValues.forEach(configs -> {
            List<String> expectedBranches;
            Assert.assertEquals((Object)NIOGIT_PATH, (Object)this.assertInstanceOf(configs.getOrigin(), String.class));
            Assert.assertFalse((boolean)this.assertInstanceOf(configs.getInit(), Boolean.class));
            Assert.assertFalse((boolean)this.assertInstanceOf(configs.getMirror(), Boolean.class));
            String subdirectory = this.assertInstanceOf(configs.getSubdirectory(), String.class);
            observedSubdirectories.add(subdirectory);
            List branches = this.assertInstanceOf(configs.getBranches(), List.class);
            if (subdirectory.equals("legacyProject1")) {
                expectedBranches = Arrays.asList("legacyMainBranch", "legacyDevBranch");
            } else if (subdirectory.equals("legacyProject2")) {
                expectedBranches = Arrays.asList("legacyDevBranch");
            } else {
                throw new AssertionError((Object)("Unrecognized subdirectory: " + subdirectory));
            }
            ((WorkspaceProjectMigrationServiceImpl)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)2))).cleanupOrigin((Repository)ArgumentMatchers.any());
            Assert.assertEquals((String)("Unexpected branches for subdirectory " + subdirectory), new HashSet<String>(expectedBranches), new HashSet(branches));
        });
        Assert.assertEquals(new HashSet<String>(Arrays.asList("legacyProject1", "legacyProject2")), observedSubdirectories);
    }

    @Test
    public void fireNewProjectEvents() throws Exception {
        ((EventSourceMock)Mockito.verify(this.newProjectEvent, (VerificationMode)Mockito.times((int)2))).fire(this.newProjectEventArgumentCaptor.capture());
        List allValues = this.newProjectEventArgumentCaptor.getAllValues();
        Assert.assertNotNull((Object)((NewProjectEvent)allValues.get(0)).getWorkspaceProject());
        Assert.assertNotNull((Object)((NewProjectEvent)allValues.get(1)).getWorkspaceProject());
    }

    private <T> T assertInstanceOf(Object value, Class<T> clazz) {
        Assert.assertTrue((boolean)clazz.isInstance(value));
        return clazz.cast(value);
    }

    private void setUpDevBranch() {
        HashSet<Module> devBranchModules = new HashSet<Module>();
        Module mockModule = this.mockModule("legacyProject1", this.legacyDevBranchProject1RootPath);
        devBranchModules.add(mockModule);
        Module mockModule2 = this.mockModule("legacyProject2", this.legacyDevBranchProject2RootPath);
        devBranchModules.add(mockModule2);
        ((ModuleService)Mockito.doReturn(devBranchModules).when(this.moduleService)).getAllModules(this.legacyDevBranch);
    }

    private void setUpMainBranch() {
        HashSet<Module> mainBranchModules = new HashSet<Module>();
        Module mockModule = this.mockModule("legacyProject1", this.legacyMainBranchProject1RootPath);
        mainBranchModules.add(mockModule);
        ((ModuleService)Mockito.doReturn(mainBranchModules).when(this.moduleService)).getAllModules(this.legacyMainBranch);
        org.uberfire.backend.vfs.Path mainRoot = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        Mockito.when((Object)this.legacyMainBranch.getPath()).thenReturn((Object)mainRoot);
    }

    private Branch mockBranch(String branchName) {
        Branch mainBranch = (Branch)Mockito.mock(Branch.class);
        ((Branch)Mockito.doReturn((Object)branchName).when((Object)mainBranch)).getName();
        return mainBranch;
    }

    private Repository mockLegacyRepository() {
        Repository legacyRepository = (Repository)Mockito.mock(Repository.class);
        ArrayList<Branch> branches = new ArrayList<Branch>();
        branches.add(this.legacyMainBranch);
        branches.add(this.legacyDevBranch);
        ((Repository)Mockito.doReturn(branches).when((Object)legacyRepository)).getBranches();
        ArrayList<OrganizationalUnit> ous = new ArrayList<OrganizationalUnit>();
        ous.add(this.organizationalUnit);
        ((OrganizationalUnitService)Mockito.doReturn(ous).when((Object)this.organizationalUnitService)).getOrganizationalUnits(legacyRepository);
        Mockito.when((Object)legacyRepository.getDefaultBranch()).thenReturn(Optional.of(this.legacyMainBranch));
        ((Repository)Mockito.doReturn((Object)this.space).when((Object)legacyRepository)).getSpace();
        return legacyRepository;
    }

    private void mockRepository(OrganizationalUnit organizationalUnit) {
        ((RepositoryService)Mockito.doAnswer((Answer)new Answer<Repository>(){

            public Repository answer(InvocationOnMock invocationOnMock) throws Throwable {
                Repository newRepository = (Repository)Mockito.mock(Repository.class);
                ((Repository)Mockito.doReturn((Object)invocationOnMock.getArguments()[2]).when((Object)newRepository)).getAlias();
                ((Repository)Mockito.doReturn((Object)SpacesAPI.Scheme.FILE).when((Object)newRepository)).getScheme();
                ((Repository)Mockito.doReturn((Object)WorkspaceProjectMigrationServiceImplTest.this.space).when((Object)newRepository)).getSpace();
                return newRepository;
            }
        }).when((Object)this.repositoryService)).createRepository((OrganizationalUnit)ArgumentMatchers.eq((Object)organizationalUnit), (String)ArgumentMatchers.eq((Object)GitRepository.SCHEME.toString()), ArgumentMatchers.anyString(), (RepositoryEnvironmentConfigurations)ArgumentMatchers.any(RepositoryEnvironmentConfigurations.class));
    }

    private Module mockModule(String myOldProject, org.uberfire.backend.vfs.Path myOldProjectRootPath) {
        Module module = (Module)Mockito.mock(Module.class);
        Mockito.when((Object)module.getModuleName()).thenReturn((Object)myOldProject);
        Mockito.when((Object)module.getRootPath()).thenReturn((Object)myOldProjectRootPath);
        return module;
    }
}

