/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.backend.server;

import javax.enterprise.event.Event;
import org.guvnor.common.services.backend.util.CommentedOptionFactory;
import org.guvnor.common.services.project.backend.server.AbstractModuleService;
import org.guvnor.common.services.project.backend.server.ModuleFinder;
import org.guvnor.common.services.project.backend.server.ResourceResolver;
import org.guvnor.common.services.project.builder.events.InvalidateDMOModuleCacheEvent;
import org.guvnor.common.services.project.events.NewModuleEvent;
import org.guvnor.common.services.project.events.NewPackageEvent;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.service.DeploymentMode;
import org.guvnor.common.services.project.service.POMService;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryService;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.Paths;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.spaces.Space;

@RunWith(value=MockitoJUnitRunner.class)
public class AbstractModuleServiceTest {
    @Mock
    ModuleFinder moduleFinder;
    @Mock
    private IOService ioService;
    @Mock
    private POMService pomService;
    @Mock
    private RepositoryService repoService;
    @Mock
    private Event<NewModuleEvent> newProjectEvent;
    @Mock
    private Event<NewPackageEvent> newPackageEvent;
    @Mock
    private Event<InvalidateDMOModuleCacheEvent> invalidateDMOCache;
    @Mock
    private SessionInfo sessionInfo;
    @Mock
    private AuthorizationManager authorizationManager;
    @Mock
    private CommentedOptionFactory commentedOptionFactory;
    @Mock
    private ResourceResolver resourceResolver;
    @Mock
    private org.uberfire.backend.vfs.Path path;
    @Mock
    private Module module;
    private AbstractModuleService<Module> abstractProjectService;

    @Before
    public void setup() {
        this.abstractProjectService = new AbstractModuleService<Module>(this.ioService, this.pomService, this.repoService, this.newProjectEvent, this.newPackageEvent, this.invalidateDMOCache, this.sessionInfo, this.commentedOptionFactory, this.moduleFinder, this.resourceResolver){

            public Module newModule(org.uberfire.backend.vfs.Path repositoryRoot, POM pom) {
                return null;
            }

            public Module newModule(org.uberfire.backend.vfs.Path repositoryRoot, POM pom, DeploymentMode mode) {
                return null;
            }

            public Module simpleModuleInstance(Path parent) {
                return null;
            }
        };
    }

    @Test
    public void testReImport() throws Exception {
        Mockito.when((Object)this.path.toURI()).thenReturn((Object)"file://project1/pom.xml");
        Mockito.when((Object)this.resourceResolver.resolveModule((org.uberfire.backend.vfs.Path)ArgumentMatchers.any(org.uberfire.backend.vfs.Path.class))).thenReturn((Object)this.module);
        this.abstractProjectService.reImport(this.path);
        ((Event)Mockito.verify(this.invalidateDMOCache)).fire((Object)((InvalidateDMOModuleCacheEvent)ArgumentMatchers.any(InvalidateDMOModuleCacheEvent.class)));
    }

    @Test
    public void testUseRepoServiceToDeleteRootModule() {
        Mockito.when((Object)this.path.toURI()).thenReturn((Object)"file:///space/project1/pom.xml");
        Mockito.when((Object)this.resourceResolver.resolveModule((org.uberfire.backend.vfs.Path)ArgumentMatchers.any(org.uberfire.backend.vfs.Path.class))).thenReturn((Object)this.module);
        Repository repo = (Repository)Mockito.mock(Repository.class);
        Mockito.when((Object)this.repoService.getRepository((org.uberfire.backend.vfs.Path)Mockito.eq((Object)org.uberfire.backend.server.util.Paths.convert((Path)Paths.get((String)"file:///space/project1", (String[])new String[0]))))).thenReturn((Object)repo);
        String alias = "repo-alias";
        Mockito.when((Object)repo.getAlias()).thenReturn((Object)alias);
        Space space = new Space("space");
        Mockito.when((Object)repo.getSpace()).thenReturn((Object)space);
        this.abstractProjectService.delete(this.path, "");
        ((RepositoryService)Mockito.verify((Object)this.repoService)).removeRepository((Space)Mockito.eq((Object)space), (String)Mockito.eq((Object)alias));
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)0))).delete((Path)ArgumentMatchers.any(), (DeleteOption[])ArgumentMatchers.any());
    }

    @Test
    public void testUseIOServiceToDeleteSubModule() {
        Mockito.when((Object)this.path.toURI()).thenReturn((Object)"file://space/project1/subproject/pom.xml");
        Mockito.when((Object)this.ioService.exists((Path)ArgumentMatchers.any())).thenReturn((Object)true);
        Mockito.when((Object)this.resourceResolver.resolveModule((org.uberfire.backend.vfs.Path)ArgumentMatchers.any(org.uberfire.backend.vfs.Path.class))).thenReturn((Object)this.module);
        Mockito.when((Object)((POM)this.pomService.load((org.uberfire.backend.vfs.Path)ArgumentMatchers.any()))).thenReturn((Object)((POM)Mockito.mock(POM.class)));
        this.abstractProjectService.delete(this.path, "");
        ((RepositoryService)Mockito.verify((Object)this.repoService, (VerificationMode)Mockito.times((int)0))).removeRepository((Space)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
        ((IOService)Mockito.verify((Object)this.ioService)).delete((Path)Mockito.eq((Object)Paths.get((String)"file://space/project1/subproject", (String[])new String[0])), (DeleteOption[])Mockito.anyVararg());
    }

    @Test
    public void createModuleDirectoriesTest() {
        String workspacePath = "workspacePath";
        Package defaultPackage = (Package)Mockito.mock(Package.class);
        Mockito.when((Object)this.path.toURI()).thenReturn((Object)"file://space/project1/");
        Mockito.when((Object)((POM)this.pomService.load((org.uberfire.backend.vfs.Path)ArgumentMatchers.any()))).thenReturn((Object)((POM)Mockito.mock(POM.class)));
        Mockito.when((Object)this.resourceResolver.getDefaultWorkspacePath((GAV)ArgumentMatchers.any())).thenReturn((Object)"workspacePath");
        Mockito.when((Object)this.resourceResolver.resolvePackage((org.uberfire.backend.vfs.Path)ArgumentMatchers.any())).thenReturn((Object)defaultPackage);
        this.abstractProjectService.createModuleDirectories(this.path);
        ((ResourceResolver)Mockito.verify((Object)this.resourceResolver)).newPackage(defaultPackage, "workspacePath", false);
    }
}

