/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.backend.server.utils;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.model.Plugin;
import org.guvnor.common.services.project.backend.server.utils.MavenPluginUpdater;
import org.guvnor.common.services.project.backend.server.utils.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class MavenPluginUpdaterTest {
    @Test
    public void testIgnorePluginsThatHaveNoGroupIdOrArtifactId() throws Exception {
        List to = new ArrayList();
        ArrayList<org.guvnor.common.services.project.model.Plugin> from = new ArrayList<org.guvnor.common.services.project.model.Plugin>();
        from.add(TestUtils.makeGuvnorPlugin(null, null, null));
        from.add(TestUtils.makeGuvnorPlugin(null, null, "1.0"));
        from.add(TestUtils.makeGuvnorPlugin("myGroup", null, "1.0"));
        from.add(TestUtils.makeGuvnorPlugin(null, "myArtifact", "1.0"));
        to = new MavenPluginUpdater(to).update(from);
        Assert.assertTrue((boolean)to.isEmpty());
    }

    @Test
    public void testChangeVersion() throws Exception {
        List to = new ArrayList<Plugin>();
        to.add(TestUtils.makeMavenPlugin("myPlugin", "myArtifact", "1.0"));
        ArrayList<org.guvnor.common.services.project.model.Plugin> from = new ArrayList<org.guvnor.common.services.project.model.Plugin>();
        from.add(TestUtils.makeGuvnorPlugin("myPlugin", "myArtifact", "2.0"));
        to = new MavenPluginUpdater(to).update(from);
        Assert.assertEquals((long)1L, (long)to.size());
        Assert.assertEquals((Object)"2.0", (Object)((Plugin)to.get(0)).getVersion());
    }

    @Test
    public void testAddNew() throws Exception {
        List to = new ArrayList<Plugin>();
        to.add(TestUtils.makeMavenPlugin("myPlugin", "myArtifact", "1.0"));
        ArrayList<org.guvnor.common.services.project.model.Plugin> from = new ArrayList<org.guvnor.common.services.project.model.Plugin>();
        from.add(TestUtils.makeGuvnorPlugin("myPlugin", "myArtifact", "1.0"));
        from.add(TestUtils.makeGuvnorPlugin("junit", "junit", "1.44"));
        to = new MavenPluginUpdater(to).update(from);
        Assert.assertEquals((long)2L, (long)to.size());
        Assert.assertEquals((Object)"1.0", (Object)((Plugin)to.get(0)).getVersion());
        Assert.assertEquals((Object)"1.44", (Object)((Plugin)to.get(1)).getVersion());
    }

    @Test
    public void testRemove() throws Exception {
        List to = new ArrayList<Plugin>();
        to.add(TestUtils.makeMavenPlugin("myPlugin", "myArtifact", "1.0"));
        to.add(TestUtils.makeMavenPlugin("junit", "junit", "1.44"));
        ArrayList<org.guvnor.common.services.project.model.Plugin> from = new ArrayList<org.guvnor.common.services.project.model.Plugin>();
        from.add(TestUtils.makeGuvnorPlugin("myPlugin", "myArtifact", "1.0"));
        to = new MavenPluginUpdater(to).update(from);
        Assert.assertEquals((long)1L, (long)to.size());
        Assert.assertEquals((Object)"1.0", (Object)((Plugin)to.get(0)).getVersion());
    }
}

