/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.backend.server;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Instance;
import org.guvnor.common.services.project.backend.server.WorkspaceProjectServiceImpl;
import org.guvnor.common.services.project.backend.server.utils.PathUtil;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.common.services.project.service.DeploymentMode;
import org.guvnor.common.services.project.service.ModuleRepositoryResolver;
import org.guvnor.common.services.project.service.ModuleService;
import org.guvnor.common.services.project.service.POMService;
import org.guvnor.common.services.project.service.WorkspaceProjectService;
import org.guvnor.structure.backend.organizationalunit.config.SpaceConfigStorageRegistryImpl;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.guvnor.structure.organizationalunit.config.SpaceConfigStorage;
import org.guvnor.structure.organizationalunit.config.SpaceConfigStorageRegistry;
import org.guvnor.structure.organizationalunit.impl.OrganizationalUnitImpl;
import org.guvnor.structure.repositories.Branch;
import org.guvnor.structure.repositories.NewBranchEvent;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryEnvironmentConfigurations;
import org.guvnor.structure.repositories.RepositoryService;
import org.guvnor.structure.repositories.RepositoryUpdatedEvent;
import org.guvnor.structure.repositories.changerequest.ChangeRequestService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.uberfire.backend.server.spaces.SpacesAPIImpl;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.CopyOption;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.spi.FileSystemProvider;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mocks.SessionInfoMock;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.spaces.Space;
import org.uberfire.spaces.SpacesAPI;

@RunWith(value=MockitoJUnitRunner.class)
public class WorkspaceProjectServiceImplTest {
    WorkspaceProjectService workspaceProjectService;
    @Mock
    OrganizationalUnitService organizationalUnitService;
    @Mock
    RepositoryService repositoryService;
    @Mock
    Instance<ModuleService<? extends Module>> moduleServices;
    @Mock
    Repository repository1;
    @Mock
    Repository repository2;
    @Mock
    Repository repository3;
    @Mock
    ModuleService moduleService;
    @Mock
    ModuleRepositoryResolver repositoryResolver;
    @Mock
    SpaceConfigStorageRegistry spaceConfigStorageRegistry;
    @Mock
    SpaceConfigStorage spaceConfigStorage;
    @Mock
    IOService ioService;
    @Mock
    PathUtil pathUtil;
    @Mock
    ChangeRequestService changeRequestService;
    @Mock
    POMService pomService;
    @Mock
    EventSourceMock<RepositoryUpdatedEvent> repositoryUpdatedEvent;
    @Mock
    Event<NewBranchEvent> newBranchEvent;
    @Mock
    SessionInfo sessionInfo;
    SpacesAPI spaces = new SpacesAPIImpl();
    Space space1;
    Space space2;
    private OrganizationalUnit ou1;
    private OrganizationalUnit ou2;
    private List<Repository> allRepositories;

    @Before
    public void setUp() throws Exception {
        this.setUpOUs();
        this.setUpRepositories();
        this.sessionInfo = new SessionInfoMock();
        ((Instance)Mockito.doReturn((Object)this.moduleService).when(this.moduleServices)).get();
        Mockito.when((Object)this.spaceConfigStorageRegistry.getBatch(Mockito.anyString())).thenReturn((Object)new SpaceConfigStorageRegistryImpl.SpaceStorageBatchImpl(this.spaceConfigStorage));
        this.workspaceProjectService = new WorkspaceProjectServiceImpl(this.organizationalUnitService, this.repositoryService, this.spaces, (Event)new EventSourceMock(), this.repositoryUpdatedEvent, this.newBranchEvent, this.moduleServices, this.repositoryResolver, this.ioService, this.spaceConfigStorageRegistry, this.pathUtil, this.changeRequestService, this.pomService);
    }

    private void setUpOUs() {
        this.ou1 = new OrganizationalUnitImpl("ou1", "defaultGroupID");
        this.ou2 = new OrganizationalUnitImpl("ou2", "defaultGroupID");
        this.space1 = this.spaces.getSpace("ou1");
        this.space2 = this.spaces.getSpace("ou2");
        ArrayList<OrganizationalUnit> allOUs = new ArrayList<OrganizationalUnit>();
        allOUs.add(this.ou1);
        allOUs.add(this.ou2);
        ((OrganizationalUnitService)Mockito.doReturn(allOUs).when((Object)this.organizationalUnitService)).getOrganizationalUnits();
        this.ou1.getRepositories().add(this.repository1);
        this.ou1.getRepositories().add(this.repository2);
        this.ou2.getRepositories().add(this.repository3);
    }

    private void setUpRepositories() {
        ((Repository)Mockito.doReturn(Optional.of((Branch)Mockito.mock(Branch.class))).when((Object)this.repository1)).getDefaultBranch();
        ((Repository)Mockito.doReturn((Object)"repository1").when((Object)this.repository1)).getAlias();
        ((Repository)Mockito.doReturn((Object)"space1/repository1").when((Object)this.repository1)).getIdentifier();
        ((Repository)Mockito.doReturn(Optional.of((Branch)Mockito.mock(Branch.class))).when((Object)this.repository2)).getDefaultBranch();
        ((Repository)Mockito.doReturn((Object)"repository-with-same-alias").when((Object)this.repository2)).getAlias();
        ((Repository)Mockito.doReturn((Object)"space1/repository-with-same-alias").when((Object)this.repository2)).getIdentifier();
        ((Repository)Mockito.doReturn(Optional.of((Branch)Mockito.mock(Branch.class))).when((Object)this.repository3)).getDefaultBranch();
        this.allRepositories = new ArrayList<Repository>();
        this.allRepositories.add(this.repository1);
        this.allRepositories.add(this.repository2);
        this.allRepositories.add(this.repository3);
        ((RepositoryService)Mockito.doReturn(Arrays.asList(this.repository1, this.repository2)).when((Object)this.repositoryService)).getAllRepositories((Space)Mockito.eq((Object)this.space1), Mockito.anyBoolean());
        ((RepositoryService)Mockito.doReturn(Arrays.asList(this.repository3)).when((Object)this.repositoryService)).getAllRepositories((Space)Mockito.eq((Object)this.space2), Mockito.anyBoolean());
    }

    @Test
    public void getAllProjects() {
        Collection allWorkspaceProjects = this.workspaceProjectService.getAllWorkspaceProjects();
        Assert.assertEquals((long)3L, (long)allWorkspaceProjects.size());
    }

    @Test
    public void getAllProjectsForOU1() {
        Collection allWorkspaceProjects = this.workspaceProjectService.getAllWorkspaceProjects(this.ou1);
        this.assertContains(this.repository1, allWorkspaceProjects);
        this.assertContains(this.repository2, allWorkspaceProjects);
        Assert.assertEquals((long)2L, (long)allWorkspaceProjects.size());
    }

    @Test
    public void getAllProjectsForOU2() {
        Collection allWorkspaceProjects = this.workspaceProjectService.getAllWorkspaceProjects(this.ou2);
        this.assertContains(this.repository3, allWorkspaceProjects);
        Assert.assertEquals((long)1L, (long)allWorkspaceProjects.size());
    }

    @Test
    public void getAllProjectsWithName() {
        Collection allWorkspaceProjects = this.workspaceProjectService.getAllWorkspaceProjectsByName(this.ou1, "repository-with-same-alias");
        this.assertContains(this.repository2, allWorkspaceProjects);
        Assert.assertEquals((long)1L, (long)allWorkspaceProjects.size());
    }

    @Test
    public void spaceHasProjectsWithName() {
        boolean hasNoProjects = this.workspaceProjectService.spaceHasNoProjectsWithName(this.ou1, "repository1", new WorkspaceProject(this.ou1, this.repository2, (Branch)this.repository2.getDefaultBranch().get(), null));
        Assert.assertFalse((boolean)hasNoProjects);
    }

    @Test
    public void spaceHasNoProjectsWithName() throws Exception {
        boolean hasNoProjects = this.workspaceProjectService.spaceHasNoProjectsWithName(this.ou1, "other-project", new WorkspaceProject(this.ou1, this.repository1, (Branch)this.repository1.getDefaultBranch().get(), null));
        Assert.assertTrue((boolean)hasNoProjects);
    }

    @Test
    public void spaceHasProjectsWithNameSameProject() throws Exception {
        boolean hasNoProjects = this.workspaceProjectService.spaceHasNoProjectsWithName(this.ou1, "repository1", new WorkspaceProject(this.ou1, this.repository1, (Branch)this.repository1.getDefaultBranch().get(), null));
        Assert.assertTrue((boolean)hasNoProjects);
    }

    @Test
    public void noProjects() {
        OrganizationalUnit organizationalUnit = (OrganizationalUnit)Mockito.mock(OrganizationalUnit.class);
        ((OrganizationalUnit)Mockito.doReturn((Object)"myOU").when((Object)organizationalUnit)).getName();
        Assert.assertTrue((boolean)this.workspaceProjectService.getAllWorkspaceProjects(organizationalUnit).isEmpty());
    }

    @Test
    public void testReturnSameNameIfProjectDoesNotExist() {
        String projectName = "projectA";
        POM pom = new POM(projectName, "description", "url", null);
        WorkspaceProjectServiceImpl impl = (WorkspaceProjectServiceImpl)this.workspaceProjectService;
        String newName = impl.createFreshProjectName(this.ou1, pom.getName());
        Assert.assertEquals((Object)projectName, (Object)newName);
    }

    @Test
    public void testCreateNewNameIfProjectExists() {
        POM pom = new POM("repository1", "description", "url", null);
        WorkspaceProjectServiceImpl impl = (WorkspaceProjectServiceImpl)this.workspaceProjectService;
        String newName = impl.createFreshProjectName(this.ou1, pom.getName());
        Assert.assertEquals((Object)"repository1-1", (Object)newName);
        ((Repository)Mockito.doReturn(Optional.of((Branch)Mockito.mock(Branch.class))).when((Object)this.repository2)).getDefaultBranch();
        ((Repository)Mockito.doReturn((Object)"repository1-1").when((Object)this.repository2)).getAlias();
        pom = new POM("repository1", "description", "url", null);
        impl = (WorkspaceProjectServiceImpl)this.workspaceProjectService;
        newName = impl.createFreshProjectName(this.ou1, pom.getName());
        Assert.assertEquals((Object)"repository1-2", (Object)newName);
    }

    @Test
    public void testReturnSameNameIfRepositoryDoesNotExist() {
        String repositoryName = "repositoryA";
        WorkspaceProjectServiceImpl impl = (WorkspaceProjectServiceImpl)this.workspaceProjectService;
        String newName = impl.createFreshRepositoryAlias(this.ou1, repositoryName);
        Assert.assertEquals((Object)repositoryName, (Object)newName);
    }

    @Test
    public void testCreateNewNameIfRepositoryExists() {
        String repositoryName = "repository1";
        WorkspaceProjectServiceImpl impl = (WorkspaceProjectServiceImpl)this.workspaceProjectService;
        String newName = impl.createFreshProjectName(this.ou1, repositoryName);
        Assert.assertEquals((Object)"repository1-1", (Object)newName);
        ((Repository)Mockito.doReturn(Optional.of((Branch)Mockito.mock(Branch.class))).when((Object)this.repository2)).getDefaultBranch();
        ((Repository)Mockito.doReturn((Object)"repository1-1").when((Object)this.repository2)).getAlias();
        WorkspaceProjectServiceImpl impl2 = (WorkspaceProjectServiceImpl)this.workspaceProjectService;
        String newName2 = impl2.createFreshProjectName(this.ou1, "repository1");
        Assert.assertEquals((Object)"repository1-2", (Object)newName2);
    }

    @Test
    public void testErrorWhenNewProject() {
        String repository1 = "repository1";
        POM pom = new POM(repository1, "description", "url", null);
        Mockito.when((Object)this.repositoryService.createRepository((OrganizationalUnit)Mockito.any(), Mockito.anyString(), Mockito.anyString(), (RepositoryEnvironmentConfigurations)Mockito.any(), (Collection)Mockito.any())).thenReturn((Object)this.repository2);
        ((Repository)Mockito.doReturn(Optional.of((Branch)Mockito.mock(Branch.class))).when((Object)this.repository2)).getDefaultBranch();
        Mockito.when((Object)this.repository2.getAlias()).thenReturn((Object)repository1);
        Mockito.when((Object)this.moduleService.newModule((org.uberfire.backend.vfs.Path)Mockito.any(), (POM)Mockito.any(), (DeploymentMode)Mockito.any())).thenThrow(new Throwable[]{new RuntimeException("Expected error")});
        try {
            this.workspaceProjectService.newProject(this.ou1, pom);
        }
        catch (Exception e) {
            ((RepositoryService)Mockito.verify((Object)this.repositoryService)).removeRepository(new Space(this.ou1.getName()), repository1);
        }
    }

    @Test
    public void addBranchTest() throws URISyntaxException {
        WorkspaceProject project = (WorkspaceProject)Mockito.mock(WorkspaceProject.class);
        ((WorkspaceProject)Mockito.doReturn((Object)this.repository1).when((Object)project)).getRepository();
        ((RepositoryService)Mockito.doReturn((Object)this.repository1).when((Object)this.repositoryService)).getRepositoryFromSpace((Space)Mockito.any(), (String)Mockito.any());
        List<Branch> repo1Branches = Arrays.asList(this.makeBranch("repo1-branch1", this.repository1.getAlias()), this.makeBranch("repo1-branch2", this.repository1.getAlias()));
        Mockito.when((Object)this.repository1.getBranches()).thenReturn(repo1Branches);
        Mockito.when((Object)this.repository1.getBranch(Mockito.anyString())).then(inv -> repo1Branches.stream().filter(b -> b.getName().equals(inv.getArgument(0, String.class))).findFirst());
        ((WorkspaceProject)Mockito.doReturn((Object)new Space("my-space")).when((Object)project)).getSpace();
        ((SpaceConfigStorageRegistry)Mockito.doReturn((Object)Mockito.mock(SpaceConfigStorage.class)).when((Object)this.spaceConfigStorageRegistry)).get("my-space");
        Path baseBranchPath = (Path)Mockito.mock(Path.class);
        org.uberfire.backend.vfs.Path path = this.repository1.getBranches().stream().filter(b -> b.getName().equals("repo1-branch1")).findFirst().get().getPath();
        FileSystem fileSystem = (FileSystem)Mockito.mock(FileSystem.class);
        FileSystemProvider fileSystemProvider = (FileSystemProvider)Mockito.mock(FileSystemProvider.class);
        ((FileSystem)Mockito.doReturn((Object)fileSystemProvider).when((Object)fileSystem)).provider();
        ((Path)Mockito.doReturn((Object)fileSystem).when((Object)baseBranchPath)).getFileSystem();
        ((PathUtil)Mockito.doReturn((Object)baseBranchPath).when((Object)this.pathUtil)).convert(path);
        Path newBranchPath = (Path)Mockito.mock(Path.class);
        ((IOService)Mockito.doReturn((Object)newBranchPath).when((Object)this.ioService)).get(new URI("default://new-branch@repo1/"));
        ((PathUtil)Mockito.doReturn((Object)"default://new-branch@repo1/").when((Object)this.pathUtil)).replaceBranch(Mockito.anyString(), Mockito.anyString());
        ArgumentCaptor newBranchEventArgumentCaptor = ArgumentCaptor.forClass(NewBranchEvent.class);
        this.workspaceProjectService.addBranch("new-branch", "repo1-branch1", project, "user");
        ((FileSystemProvider)Mockito.verify((Object)fileSystemProvider)).copy(baseBranchPath, newBranchPath, new CopyOption[0]);
        ((EventSourceMock)Mockito.verify(this.repositoryUpdatedEvent)).fire((Object)((RepositoryUpdatedEvent)Mockito.any()));
        ((Event)Mockito.verify(this.newBranchEvent)).fire((Object)((NewBranchEvent)newBranchEventArgumentCaptor.capture()));
        NewBranchEvent newBranchEvent = (NewBranchEvent)newBranchEventArgumentCaptor.getValue();
        Assert.assertEquals((Object)"new-branch", (Object)newBranchEvent.getNewBranchName());
        Assert.assertEquals((Object)"repo1-branch1", (Object)newBranchEvent.getFromBranchName());
        Assert.assertEquals((Object)this.repository1, (Object)newBranchEvent.getRepository());
    }

    @Test
    public void removeBranchTest() {
        Branch otherBranch = this.makeBranch("repo1-branch1", "repo1");
        Path baseBranchPath = (Path)Mockito.mock(Path.class);
        FileSystem fileSystem = (FileSystem)Mockito.mock(FileSystem.class);
        FileSystemProvider fileSystemProvider = (FileSystemProvider)Mockito.mock(FileSystemProvider.class);
        ((Path)Mockito.doReturn((Object)fileSystem).when((Object)baseBranchPath)).getFileSystem();
        ((PathUtil)Mockito.doReturn((Object)baseBranchPath).when((Object)this.pathUtil)).convert((org.uberfire.backend.vfs.Path)Mockito.any(org.uberfire.backend.vfs.Path.class));
        List<Branch> repo1Branches = Arrays.asList(this.makeBranch("repo1-branch1", this.repository1.getAlias()), this.makeBranch("repo1-branch2", this.repository1.getAlias()));
        Mockito.when((Object)this.repository1.getBranch(Mockito.anyString())).then(inv -> repo1Branches.stream().filter(b -> b.getName().equals(inv.getArgument(0, String.class))).findFirst());
        WorkspaceProject project = (WorkspaceProject)Mockito.mock(WorkspaceProject.class);
        ((WorkspaceProject)Mockito.doReturn((Object)this.repository1).when((Object)project)).getRepository();
        Space space = new Space("my-space");
        ((WorkspaceProject)Mockito.doReturn((Object)space).when((Object)project)).getSpace();
        ((SpaceConfigStorageRegistry)Mockito.doReturn((Object)Mockito.mock(SpaceConfigStorage.class)).when((Object)this.spaceConfigStorageRegistry)).get("my-space");
        ((RepositoryService)Mockito.doReturn((Object)this.repository1).when((Object)this.repositoryService)).getRepositoryFromSpace(space, "repository1");
        this.workspaceProjectService.removeBranch(otherBranch.getName(), project, "user");
        ((IOService)Mockito.verify((Object)this.ioService)).startBatch(fileSystem);
        ((IOService)Mockito.verify((Object)this.ioService)).delete(baseBranchPath, new DeleteOption[0]);
        ((IOService)Mockito.verify((Object)this.ioService)).endBatch();
        ((EventSourceMock)Mockito.verify(this.repositoryUpdatedEvent)).fire((Object)((RepositoryUpdatedEvent)Mockito.any()));
    }

    private Branch makeBranch(String branchName, String repoName) {
        org.uberfire.backend.vfs.Path path = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        ((org.uberfire.backend.vfs.Path)Mockito.doReturn((Object)("default://" + branchName + "@" + repoName + "/")).when((Object)path)).toURI();
        return new Branch(branchName, path);
    }

    private void assertContains(Repository repository, Collection<WorkspaceProject> allWorkspaceProjects) {
        for (WorkspaceProject workspaceProject : allWorkspaceProjects) {
            if (!workspaceProject.getRepository().equals(repository)) continue;
            return;
        }
        Assert.fail((String)("Could not find " + repository));
    }
}

