/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.backend.server.utils;

import java.io.File;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Singleton;
import org.guvnor.structure.backend.repositories.git.GitPathUtil;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.java.nio.file.Path;

@Singleton
public class PathUtil {
    private final Pattern repoAndSpace = Pattern.compile("^[^/]+/[^/]+/");
    private final Pattern protocolAndBranch = Pattern.compile("^[A-Za-z]+://([^@]+@)?");
    private final Pattern branchNameReplacer = Pattern.compile("(^[A-Za-z]+://)([^@]+)(@.*)");

    public org.uberfire.backend.vfs.Path normalizePath(org.uberfire.backend.vfs.Path path) {
        return Paths.normalizePath((org.uberfire.backend.vfs.Path)path);
    }

    public Path convert(org.uberfire.backend.vfs.Path path) {
        return Paths.convert((org.uberfire.backend.vfs.Path)path);
    }

    public org.uberfire.backend.vfs.Path convert(Path path) {
        return Paths.convert((Path)path);
    }

    public String stripProtocolAndBranch(String uri) {
        return this.protocolAndBranch.matcher(uri).replaceFirst("");
    }

    public String stripRepoNameAndSpace(String strippedPath) {
        return this.repoAndSpace.matcher(strippedPath).replaceFirst("");
    }

    public String getNiogitRepoPath(Path path) {
        try {
            Path p = path.getFileSystem().getPath(path.toString(), new String[0]);
            File directory = p.toFile();
            return directory.toURI().toString();
        }
        catch (ClassCastException cce) {
            throw new IllegalArgumentException("Cannot get .niogit directory for non-jgit path.", cce);
        }
    }

    public Optional<String> extractBranch(String uri) {
        return GitPathUtil.extractBranch((String)uri);
    }

    public String replaceBranch(String newBranchName, String uri) {
        Matcher matcher = this.branchNameReplacer.matcher(uri);
        return matcher.replaceFirst("$1" + newBranchName.replace("$", "\\$") + "$3");
    }
}

