/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.backend.server;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Set;
import javax.enterprise.inject.Instance;
import org.apache.maven.project.MavenProject;
import org.appformer.maven.integration.embedder.MavenProjectLoader;
import org.appformer.maven.integration.embedder.MavenSettings;
import org.guvnor.common.services.project.backend.server.MavenLocalRepositoryUtils;
import org.guvnor.common.services.project.backend.server.ModuleRepositoryResolverImpl;
import org.guvnor.common.services.project.backend.server.RepositoryResolverTestUtils;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.common.services.project.model.MavenRepositoryMetadata;
import org.guvnor.common.services.project.model.MavenRepositorySource;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.preferences.GAVPreferences;
import org.guvnor.common.services.shared.preferences.WorkbenchPreferenceScopeResolutionStrategies;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.Path;

@RunWith(value=MockitoJUnitRunner.class)
public class ModuleMavenRepositoryResolverImplTest {
    @Mock
    private IOService ioService;
    @Mock
    private Instance<GAVPreferences> gavPreferencesProvider;
    @Mock
    private GAVPreferences gavPreferences;
    @Mock
    private WorkbenchPreferenceScopeResolutionStrategies scopeResolutionStrategies;
    private ModuleRepositoryResolverImpl service;
    private static java.nio.file.Path m2Folder = null;
    private static java.nio.file.Path settingsXmlPath = null;

    @BeforeClass
    public static void setupSystemProperties() {
        System.setProperty("org.uberfire.nio.git.daemon.enabled", "false");
        System.setProperty("org.uberfire.nio.git.ssh.enabled", "false");
        System.setProperty("org.uberfire.sys.repo.monitor.disabled", "true");
    }

    @BeforeClass
    public static void setupMavenRepository() {
        try {
            m2Folder = Files.createTempDirectory("temp-m2", new FileAttribute[0]);
            settingsXmlPath = RepositoryResolverTestUtils.generateSettingsXml(m2Folder);
        }
        catch (IOException ioe) {
            Assert.fail((String)ioe.getMessage());
        }
    }

    @Before
    public void setup() {
        this.service = new ModuleRepositoryResolverImpl(this.ioService, this.gavPreferencesProvider, this.scopeResolutionStrategies);
        ((Instance)Mockito.doReturn((Object)this.gavPreferences).when(this.gavPreferencesProvider)).get();
    }

    @AfterClass
    public static void teardownMavenRepository() {
        MavenLocalRepositoryUtils.tearDownMavenRepository((java.nio.file.Path)m2Folder);
        MavenSettings.reinitSettings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetRemoteRepositoriesMetaData_WithoutExplicitProjectRepository() {
        Module module = (Module)Mockito.mock(Module.class);
        org.uberfire.backend.vfs.Path pomXmlPath = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        String pomXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\" xmlns=\"http://maven.apache.org/POM/4.0.0\"\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n  <modelVersion>4.0.0</modelVersion>\n  <groupId>org.guvnor</groupId>\n  <artifactId>test</artifactId>\n  <version>0.0.1</version>\n</project>";
        Mockito.when((Object)module.getPomXMLPath()).thenReturn((Object)pomXmlPath);
        Mockito.when((Object)pomXmlPath.toURI()).thenReturn((Object)"file://p0/pom.xml");
        Mockito.when((Object)this.ioService.readAllString((Path)Mockito.any(Path.class))).thenReturn((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\" xmlns=\"http://maven.apache.org/POM/4.0.0\"\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n  <modelVersion>4.0.0</modelVersion>\n  <groupId>org.guvnor</groupId>\n  <artifactId>test</artifactId>\n  <version>0.0.1</version>\n</project>");
        String oldSettingsXmlPath = System.getProperty("kie.maven.settings.custom");
        try {
            System.setProperty("kie.maven.settings.custom", settingsXmlPath.toString());
            Set metadata = this.service.getRemoteRepositoriesMetaData(module);
            Assert.assertNotNull((Object)metadata);
            Assert.assertEquals((long)6L, (long)metadata.size());
            this.assertContainsRepository("local", m2Folder.toString(), MavenRepositorySource.LOCAL, metadata);
            this.assertContainsRepository("jboss-developer-repository-group", "https://repository.jboss.org/nexus/content/groups/developer/", MavenRepositorySource.SETTINGS, metadata);
            this.assertContainsRepository("jboss-public-repository-group", "http://repository.jboss.org/nexus/content/groups/public/", MavenRepositorySource.SETTINGS, metadata);
            this.assertContainsRepository("jboss-snapshots-repository-group", "https://repository.jboss.org/nexus/content/repositories/snapshots/", MavenRepositorySource.SETTINGS, metadata);
            this.assertContainsRepository("jboss-public-repository-group", "https://repository.jboss.org/nexus/content/repositories/snapshots/", MavenRepositorySource.SETTINGS, metadata);
            this.assertContainsRepository("central", "https://repo.maven.apache.org/maven2", MavenRepositorySource.PROJECT, metadata);
        }
        finally {
            this.resetSystemProperty("kie.maven.settings.custom", oldSettingsXmlPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetRemoteRepositoriesMetaData_WithExplicitProjectRepository() {
        Module module = (Module)Mockito.mock(Module.class);
        org.uberfire.backend.vfs.Path pomXmlPath = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        String pomXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\" xmlns=\"http://maven.apache.org/POM/4.0.0\"\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n  <modelVersion>4.0.0</modelVersion>\n  <groupId>org.guvnor</groupId>\n  <artifactId>test</artifactId>\n  <version>0.0.2</version>\n  <repositories>\n    <repository>\n      <id>explicit-repo</id>\n      <name>Explicit Repository</name>\n      <url>http://localhost/maven2/</url>\n    </repository>\n  </repositories>\n</project>";
        Mockito.when((Object)module.getPomXMLPath()).thenReturn((Object)pomXmlPath);
        Mockito.when((Object)pomXmlPath.toURI()).thenReturn((Object)"file://p0/pom.xml");
        Mockito.when((Object)this.ioService.readAllString((Path)Mockito.any(Path.class))).thenReturn((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\" xmlns=\"http://maven.apache.org/POM/4.0.0\"\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n  <modelVersion>4.0.0</modelVersion>\n  <groupId>org.guvnor</groupId>\n  <artifactId>test</artifactId>\n  <version>0.0.2</version>\n  <repositories>\n    <repository>\n      <id>explicit-repo</id>\n      <name>Explicit Repository</name>\n      <url>http://localhost/maven2/</url>\n    </repository>\n  </repositories>\n</project>");
        String oldSettingsXmlPath = System.getProperty("kie.maven.settings.custom");
        try {
            System.setProperty("kie.maven.settings.custom", settingsXmlPath.toString());
            Set metadata = this.service.getRemoteRepositoriesMetaData(module);
            Assert.assertNotNull((Object)metadata);
            Assert.assertEquals((long)7L, (long)metadata.size());
            this.assertContainsRepository("local", m2Folder.toString(), MavenRepositorySource.LOCAL, metadata);
            this.assertContainsRepository("jboss-developer-repository-group", "https://repository.jboss.org/nexus/content/groups/developer/", MavenRepositorySource.SETTINGS, metadata);
            this.assertContainsRepository("jboss-public-repository-group", "http://repository.jboss.org/nexus/content/groups/public/", MavenRepositorySource.SETTINGS, metadata);
            this.assertContainsRepository("jboss-snapshots-repository-group", "https://repository.jboss.org/nexus/content/repositories/snapshots/", MavenRepositorySource.SETTINGS, metadata);
            this.assertContainsRepository("jboss-public-repository-group", "https://repository.jboss.org/nexus/content/repositories/snapshots/", MavenRepositorySource.SETTINGS, metadata);
            this.assertContainsRepository("central", "https://repo.maven.apache.org/maven2", MavenRepositorySource.PROJECT, metadata);
            this.assertContainsRepository("explicit-repo", "http://localhost/maven2/", MavenRepositorySource.PROJECT, metadata);
        }
        finally {
            this.resetSystemProperty("kie.maven.settings.custom", oldSettingsXmlPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetRemoteRepositoriesMetaData_WithDistributionManagementRepository() {
        Module module = (Module)Mockito.mock(Module.class);
        org.uberfire.backend.vfs.Path pomXmlPath = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        String pomXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\" xmlns=\"http://maven.apache.org/POM/4.0.0\"\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n  <modelVersion>4.0.0</modelVersion>\n  <groupId>org.guvnor</groupId>\n  <artifactId>test</artifactId>\n  <version>0.0.3</version>\n  <distributionManagement>\n    <repository>\n      <id>distribution-repo</id>\n      <name>Distribution Repository</name>\n      <url>http://distribution-host/maven2/</url>\n    </repository>\n  </distributionManagement>\n</project>";
        Mockito.when((Object)module.getPomXMLPath()).thenReturn((Object)pomXmlPath);
        Mockito.when((Object)pomXmlPath.toURI()).thenReturn((Object)"file://p0/pom.xml");
        Mockito.when((Object)this.ioService.readAllString((Path)Mockito.any(Path.class))).thenReturn((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\" xmlns=\"http://maven.apache.org/POM/4.0.0\"\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n  <modelVersion>4.0.0</modelVersion>\n  <groupId>org.guvnor</groupId>\n  <artifactId>test</artifactId>\n  <version>0.0.3</version>\n  <distributionManagement>\n    <repository>\n      <id>distribution-repo</id>\n      <name>Distribution Repository</name>\n      <url>http://distribution-host/maven2/</url>\n    </repository>\n  </distributionManagement>\n</project>");
        String oldSettingsXmlPath = System.getProperty("kie.maven.settings.custom");
        try {
            System.setProperty("kie.maven.settings.custom", settingsXmlPath.toString());
            Set metadata = this.service.getRemoteRepositoriesMetaData(module);
            Assert.assertNotNull((Object)metadata);
            Assert.assertEquals((long)7L, (long)metadata.size());
            this.assertContainsRepository("local", m2Folder.toString(), MavenRepositorySource.LOCAL, metadata);
            this.assertContainsRepository("jboss-developer-repository-group", "https://repository.jboss.org/nexus/content/groups/developer/", MavenRepositorySource.SETTINGS, metadata);
            this.assertContainsRepository("jboss-public-repository-group", "http://repository.jboss.org/nexus/content/groups/public/", MavenRepositorySource.SETTINGS, metadata);
            this.assertContainsRepository("jboss-snapshots-repository-group", "https://repository.jboss.org/nexus/content/repositories/snapshots/", MavenRepositorySource.SETTINGS, metadata);
            this.assertContainsRepository("jboss-public-repository-group", "https://repository.jboss.org/nexus/content/repositories/snapshots/", MavenRepositorySource.SETTINGS, metadata);
            this.assertContainsRepository("central", "https://repo.maven.apache.org/maven2", MavenRepositorySource.PROJECT, metadata);
            this.assertContainsRepository("distribution-repo", "http://distribution-host/maven2/", MavenRepositorySource.DISTRIBUTION_MANAGEMENT, metadata);
        }
        finally {
            this.resetSystemProperty("kie.maven.settings.custom", oldSettingsXmlPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetRemoteRepositoriesMetaData_WithDistributionManagementSnapshotRepository_NonSnapshotVersion() {
        Module module = (Module)Mockito.mock(Module.class);
        org.uberfire.backend.vfs.Path pomXmlPath = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        String pomXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\" xmlns=\"http://maven.apache.org/POM/4.0.0\"\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n  <modelVersion>4.0.0</modelVersion>\n  <groupId>org.guvnor</groupId>\n  <artifactId>test</artifactId>\n  <version>0.0.4</version>\n  <distributionManagement>\n    <snapshotRepository>\n      <id>distribution-repo</id>\n      <name>Distribution Repository</name>\n      <url>http://distribution-host/maven2/</url>\n    </snapshotRepository>\n  </distributionManagement>\n</project>";
        Mockito.when((Object)module.getPomXMLPath()).thenReturn((Object)pomXmlPath);
        Mockito.when((Object)pomXmlPath.toURI()).thenReturn((Object)"file://p0/pom.xml");
        Mockito.when((Object)this.ioService.readAllString((Path)Mockito.any(Path.class))).thenReturn((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\" xmlns=\"http://maven.apache.org/POM/4.0.0\"\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n  <modelVersion>4.0.0</modelVersion>\n  <groupId>org.guvnor</groupId>\n  <artifactId>test</artifactId>\n  <version>0.0.4</version>\n  <distributionManagement>\n    <snapshotRepository>\n      <id>distribution-repo</id>\n      <name>Distribution Repository</name>\n      <url>http://distribution-host/maven2/</url>\n    </snapshotRepository>\n  </distributionManagement>\n</project>");
        String oldSettingsXmlPath = System.getProperty("kie.maven.settings.custom");
        try {
            System.setProperty("kie.maven.settings.custom", settingsXmlPath.toString());
            Set metadata = this.service.getRemoteRepositoriesMetaData(module);
            Assert.assertNotNull((Object)metadata);
            Assert.assertEquals((long)6L, (long)metadata.size());
            this.assertContainsRepository("local", m2Folder.toString(), MavenRepositorySource.LOCAL, metadata);
            this.assertContainsRepository("jboss-developer-repository-group", "https://repository.jboss.org/nexus/content/groups/developer/", MavenRepositorySource.SETTINGS, metadata);
            this.assertContainsRepository("jboss-public-repository-group", "http://repository.jboss.org/nexus/content/groups/public/", MavenRepositorySource.SETTINGS, metadata);
            this.assertContainsRepository("jboss-snapshots-repository-group", "https://repository.jboss.org/nexus/content/repositories/snapshots/", MavenRepositorySource.SETTINGS, metadata);
            this.assertContainsRepository("jboss-public-repository-group", "https://repository.jboss.org/nexus/content/repositories/snapshots/", MavenRepositorySource.SETTINGS, metadata);
            this.assertContainsRepository("central", "https://repo.maven.apache.org/maven2", MavenRepositorySource.PROJECT, metadata);
        }
        finally {
            this.resetSystemProperty("kie.maven.settings.custom", oldSettingsXmlPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetRemoteRepositoriesMetaData_WithDistributionManagementSnapshotRepository_SnapshotVersion() {
        Module module = (Module)Mockito.mock(Module.class);
        org.uberfire.backend.vfs.Path pomXmlPath = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        String pomXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\" xmlns=\"http://maven.apache.org/POM/4.0.0\"\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n  <modelVersion>4.0.0</modelVersion>\n  <groupId>org.guvnor</groupId>\n  <artifactId>test</artifactId>\n  <version>0.0.1-SNAPSHOT</version>\n  <distributionManagement>\n    <snapshotRepository>\n      <id>distribution-repo</id>\n      <name>Distribution Repository</name>\n      <url>http://distribution-host/maven2/</url>\n    </snapshotRepository>\n  </distributionManagement>\n</project>";
        Mockito.when((Object)module.getPomXMLPath()).thenReturn((Object)pomXmlPath);
        Mockito.when((Object)pomXmlPath.toURI()).thenReturn((Object)"file://p0/pom.xml");
        Mockito.when((Object)this.ioService.readAllString((Path)Mockito.any(Path.class))).thenReturn((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\" xmlns=\"http://maven.apache.org/POM/4.0.0\"\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n  <modelVersion>4.0.0</modelVersion>\n  <groupId>org.guvnor</groupId>\n  <artifactId>test</artifactId>\n  <version>0.0.1-SNAPSHOT</version>\n  <distributionManagement>\n    <snapshotRepository>\n      <id>distribution-repo</id>\n      <name>Distribution Repository</name>\n      <url>http://distribution-host/maven2/</url>\n    </snapshotRepository>\n  </distributionManagement>\n</project>");
        String oldSettingsXmlPath = System.getProperty("kie.maven.settings.custom");
        try {
            System.setProperty("kie.maven.settings.custom", settingsXmlPath.toString());
            Set metadata = this.service.getRemoteRepositoriesMetaData(module);
            Assert.assertNotNull((Object)metadata);
            Assert.assertEquals((long)7L, (long)metadata.size());
            this.assertContainsRepository("local", m2Folder.toString(), MavenRepositorySource.LOCAL, metadata);
            this.assertContainsRepository("jboss-developer-repository-group", "https://repository.jboss.org/nexus/content/groups/developer/", MavenRepositorySource.SETTINGS, metadata);
            this.assertContainsRepository("jboss-public-repository-group", "http://repository.jboss.org/nexus/content/groups/public/", MavenRepositorySource.SETTINGS, metadata);
            this.assertContainsRepository("jboss-snapshots-repository-group", "https://repository.jboss.org/nexus/content/repositories/snapshots/", MavenRepositorySource.SETTINGS, metadata);
            this.assertContainsRepository("jboss-public-repository-group", "https://repository.jboss.org/nexus/content/repositories/snapshots/", MavenRepositorySource.SETTINGS, metadata);
            this.assertContainsRepository("central", "https://repo.maven.apache.org/maven2", MavenRepositorySource.PROJECT, metadata);
            this.assertContainsRepository("distribution-repo", "http://distribution-host/maven2/", MavenRepositorySource.DISTRIBUTION_MANAGEMENT, metadata);
        }
        finally {
            this.resetSystemProperty("kie.maven.settings.custom", oldSettingsXmlPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetRepositoriesResolvingArtifact_NewGAV_NotInstalledNotDeployed() {
        String oldSettingsXmlPath = System.getProperty("kie.maven.settings.custom");
        try {
            GAV gav = new GAV("org.guvnor", "test", "0.0.5");
            System.setProperty("kie.maven.settings.custom", settingsXmlPath.toString());
            Set metadata = this.service.getRepositoriesResolvingArtifact(gav, new MavenRepositoryMetadata[0]);
            Assert.assertNotNull((Object)metadata);
            Assert.assertEquals((long)0L, (long)metadata.size());
        }
        finally {
            this.resetSystemProperty("kie.maven.settings.custom", oldSettingsXmlPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetRepositoriesResolvingArtifact_NewGAV_IsInstalledNotDeployed() {
        String oldSettingsXmlPath = System.getProperty("kie.maven.settings.custom");
        try {
            String pomXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\" xmlns=\"http://maven.apache.org/POM/4.0.0\"\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n  <modelVersion>4.0.0</modelVersion>\n  <groupId>org.guvnor</groupId>\n  <artifactId>test</artifactId>\n  <version>0.0.6</version>\n</project>";
            GAV gav = new GAV("org.guvnor", "test", "0.0.6");
            System.setProperty("kie.maven.settings.custom", settingsXmlPath.toString());
            ByteArrayInputStream pomStream = new ByteArrayInputStream("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\" xmlns=\"http://maven.apache.org/POM/4.0.0\"\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n  <modelVersion>4.0.0</modelVersion>\n  <groupId>org.guvnor</groupId>\n  <artifactId>test</artifactId>\n  <version>0.0.6</version>\n</project>".getBytes(StandardCharsets.UTF_8));
            MavenProject mavenProject = MavenProjectLoader.parseMavenPom((InputStream)pomStream);
            RepositoryResolverTestUtils.installArtifact(mavenProject, "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\" xmlns=\"http://maven.apache.org/POM/4.0.0\"\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n  <modelVersion>4.0.0</modelVersion>\n  <groupId>org.guvnor</groupId>\n  <artifactId>test</artifactId>\n  <version>0.0.6</version>\n</project>");
            Set metadata = this.service.getRepositoriesResolvingArtifact(gav, new MavenRepositoryMetadata[0]);
            Assert.assertNotNull((Object)metadata);
            Assert.assertEquals((long)1L, (long)metadata.size());
            this.assertContainsRepository("local", m2Folder.toString(), MavenRepositorySource.LOCAL, metadata);
        }
        finally {
            this.resetSystemProperty("kie.maven.settings.custom", oldSettingsXmlPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetRepositoriesResolvingArtifact_NewGAV_IsInstalledIsDeployed() {
        String oldSettingsXmlPath = System.getProperty("kie.maven.settings.custom");
        java.nio.file.Path remoteRepositoryFolder = null;
        try {
            remoteRepositoryFolder = Files.createTempDirectory("distribution-repo", new FileAttribute[0]);
            String pomXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\" xmlns=\"http://maven.apache.org/POM/4.0.0\"\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n  <modelVersion>4.0.0</modelVersion>\n  <groupId>org.guvnor</groupId>\n  <artifactId>test</artifactId>\n  <version>0.0.7</version>\n  <distributionManagement>\n    <repository>\n      <id>distribution-repo</id>\n      <name>Distribution Repository</name>\n      <url>file://" + remoteRepositoryFolder.toString() + "</url>\n    </repository>\n  </distributionManagement>\n</project>";
            GAV gav = new GAV("org.guvnor", "test", "0.0.7");
            System.setProperty("kie.maven.settings.custom", settingsXmlPath.toString());
            ByteArrayInputStream pomStream = new ByteArrayInputStream(pomXml.getBytes(StandardCharsets.UTF_8));
            MavenProject mavenProject = MavenProjectLoader.parseMavenPom((InputStream)pomStream);
            RepositoryResolverTestUtils.installArtifact(mavenProject, pomXml);
            RepositoryResolverTestUtils.deployArtifact(mavenProject, pomXml);
            Set metadata = this.service.getRepositoriesResolvingArtifact(gav, new MavenRepositoryMetadata[0]);
            Assert.assertNotNull((Object)metadata);
            Assert.assertEquals((long)1L, (long)metadata.size());
            this.assertContainsRepository("local", m2Folder.toString(), MavenRepositorySource.LOCAL, metadata);
        }
        catch (IOException ioe) {
            try {
                Assert.fail((String)ioe.getMessage());
            }
            catch (Throwable throwable) {
                MavenLocalRepositoryUtils.tearDownMavenRepository(remoteRepositoryFolder);
                this.resetSystemProperty("kie.maven.settings.custom", oldSettingsXmlPath);
                throw throwable;
            }
            MavenLocalRepositoryUtils.tearDownMavenRepository((java.nio.file.Path)remoteRepositoryFolder);
            this.resetSystemProperty("kie.maven.settings.custom", oldSettingsXmlPath);
        }
        MavenLocalRepositoryUtils.tearDownMavenRepository((java.nio.file.Path)remoteRepositoryFolder);
        this.resetSystemProperty("kie.maven.settings.custom", oldSettingsXmlPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetRepositoriesResolvingArtifact_NewGAV_NotInstalledIsDeployed() {
        String oldSettingsXmlPath = System.getProperty("kie.maven.settings.custom");
        java.nio.file.Path remoteRepositoryFolder = null;
        try {
            remoteRepositoryFolder = Files.createTempDirectory("distribution-repo", new FileAttribute[0]);
            String pomXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\" xmlns=\"http://maven.apache.org/POM/4.0.0\"\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n  <modelVersion>4.0.0</modelVersion>\n  <groupId>org.guvnor</groupId>\n  <artifactId>test</artifactId>\n  <version>0.0.8</version>\n  <distributionManagement>\n    <repository>\n      <id>distribution-repo</id>\n      <name>Distribution Repository</name>\n      <url>file://" + remoteRepositoryFolder.toString() + "</url>\n    </repository>\n  </distributionManagement>\n</project>";
            GAV gav = new GAV("org.guvnor", "test", "0.0.8");
            System.setProperty("kie.maven.settings.custom", settingsXmlPath.toString());
            ByteArrayInputStream pomStream = new ByteArrayInputStream(pomXml.getBytes(StandardCharsets.UTF_8));
            MavenProject mavenProject = MavenProjectLoader.parseMavenPom((InputStream)pomStream);
            RepositoryResolverTestUtils.deployArtifact(mavenProject, pomXml);
            Set metadata = this.service.getRepositoriesResolvingArtifact(gav, new MavenRepositoryMetadata[0]);
            Assert.assertNotNull((Object)metadata);
            Assert.assertEquals((long)0L, (long)metadata.size());
        }
        catch (IOException ioe) {
            try {
                Assert.fail((String)ioe.getMessage());
            }
            catch (Throwable throwable) {
                MavenLocalRepositoryUtils.tearDownMavenRepository(remoteRepositoryFolder);
                this.resetSystemProperty("kie.maven.settings.custom", oldSettingsXmlPath);
                throw throwable;
            }
            MavenLocalRepositoryUtils.tearDownMavenRepository((java.nio.file.Path)remoteRepositoryFolder);
            this.resetSystemProperty("kie.maven.settings.custom", oldSettingsXmlPath);
        }
        MavenLocalRepositoryUtils.tearDownMavenRepository((java.nio.file.Path)remoteRepositoryFolder);
        this.resetSystemProperty("kie.maven.settings.custom", oldSettingsXmlPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetRepositoriesResolvingArtifact_NewGAV_IsInstalledIsDeployed_Filtered() {
        String oldSettingsXmlPath = System.getProperty("kie.maven.settings.custom");
        java.nio.file.Path remoteRepositoryFolder = null;
        try {
            remoteRepositoryFolder = Files.createTempDirectory("distribution-repo", new FileAttribute[0]);
            String pomXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\" xmlns=\"http://maven.apache.org/POM/4.0.0\"\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n  <modelVersion>4.0.0</modelVersion>\n  <groupId>org.guvnor</groupId>\n  <artifactId>test</artifactId>\n  <version>0.0.9</version>\n  <distributionManagement>\n    <repository>\n      <id>distribution-repo</id>\n      <name>Distribution Repository</name>\n      <url>file://" + remoteRepositoryFolder.toString() + "</url>\n    </repository>\n  </distributionManagement>\n</project>";
            GAV gav = new GAV("org.guvnor", "test", "0.0.9");
            System.setProperty("kie.maven.settings.custom", settingsXmlPath.toString());
            ByteArrayInputStream pomStream = new ByteArrayInputStream(pomXml.getBytes(StandardCharsets.UTF_8));
            MavenProject mavenProject = MavenProjectLoader.parseMavenPom((InputStream)pomStream);
            RepositoryResolverTestUtils.installArtifact(mavenProject, pomXml);
            RepositoryResolverTestUtils.deployArtifact(mavenProject, pomXml);
            Set metadata = this.service.getRepositoriesResolvingArtifact(gav, new MavenRepositoryMetadata[]{new MavenRepositoryMetadata("local", m2Folder.toString(), MavenRepositorySource.LOCAL)});
            Assert.assertNotNull((Object)metadata);
            Assert.assertEquals((long)1L, (long)metadata.size());
            this.assertContainsRepository("local", m2Folder.toString(), MavenRepositorySource.LOCAL, metadata);
        }
        catch (IOException ioe) {
            try {
                Assert.fail((String)ioe.getMessage());
            }
            catch (Throwable throwable) {
                MavenLocalRepositoryUtils.tearDownMavenRepository(remoteRepositoryFolder);
                this.resetSystemProperty("kie.maven.settings.custom", oldSettingsXmlPath);
                throw throwable;
            }
            MavenLocalRepositoryUtils.tearDownMavenRepository((java.nio.file.Path)remoteRepositoryFolder);
            this.resetSystemProperty("kie.maven.settings.custom", oldSettingsXmlPath);
        }
        MavenLocalRepositoryUtils.tearDownMavenRepository((java.nio.file.Path)remoteRepositoryFolder);
        this.resetSystemProperty("kie.maven.settings.custom", oldSettingsXmlPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetRepositoriesResolvingArtifact_ExplicitGAV_NotInstalledNotDeployed() {
        Module module = (Module)Mockito.mock(Module.class);
        org.uberfire.backend.vfs.Path pomXmlPath = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        String pomXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\" xmlns=\"http://maven.apache.org/POM/4.0.0\"\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n  <modelVersion>4.0.0</modelVersion>\n  <groupId>org.guvnor</groupId>\n  <artifactId>test</artifactId>\n  <version>0.0.10</version>\n</project>";
        GAV gav = new GAV("org.guvnor", "test", "0.0.10");
        Mockito.when((Object)module.getPomXMLPath()).thenReturn((Object)pomXmlPath);
        Mockito.when((Object)pomXmlPath.toURI()).thenReturn((Object)"file://p0/pom.xml");
        Mockito.when((Object)this.ioService.readAllString((Path)Mockito.any(Path.class))).thenReturn((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\" xmlns=\"http://maven.apache.org/POM/4.0.0\"\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n  <modelVersion>4.0.0</modelVersion>\n  <groupId>org.guvnor</groupId>\n  <artifactId>test</artifactId>\n  <version>0.0.10</version>\n</project>");
        String oldSettingsXmlPath = System.getProperty("kie.maven.settings.custom");
        try {
            System.setProperty("kie.maven.settings.custom", settingsXmlPath.toString());
            Set metadata = this.service.getRepositoriesResolvingArtifact(gav, module, new MavenRepositoryMetadata[0]);
            Assert.assertNotNull((Object)metadata);
            Assert.assertEquals((long)0L, (long)metadata.size());
        }
        finally {
            this.resetSystemProperty("kie.maven.settings.custom", oldSettingsXmlPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetRepositoriesResolvingArtifact_ExplicitGAV_IsInstalledNotDeployed() {
        Module module = (Module)Mockito.mock(Module.class);
        org.uberfire.backend.vfs.Path vfsPomXmlPath = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        String oldSettingsXmlPath = System.getProperty("kie.maven.settings.custom");
        try {
            String pomXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\" xmlns=\"http://maven.apache.org/POM/4.0.0\"\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n  <modelVersion>4.0.0</modelVersion>\n  <groupId>org.guvnor</groupId>\n  <artifactId>test</artifactId>\n  <version>0.0.11</version>\n</project>";
            GAV gav = new GAV("org.guvnor", "test", "0.0.11");
            Mockito.when((Object)module.getPomXMLPath()).thenReturn((Object)vfsPomXmlPath);
            Mockito.when((Object)vfsPomXmlPath.toURI()).thenReturn((Object)"file://p0/pom.xml");
            Mockito.when((Object)this.ioService.readAllString((Path)Mockito.any(Path.class))).thenReturn((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\" xmlns=\"http://maven.apache.org/POM/4.0.0\"\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n  <modelVersion>4.0.0</modelVersion>\n  <groupId>org.guvnor</groupId>\n  <artifactId>test</artifactId>\n  <version>0.0.11</version>\n</project>");
            System.setProperty("kie.maven.settings.custom", settingsXmlPath.toString());
            ByteArrayInputStream pomStream = new ByteArrayInputStream("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\" xmlns=\"http://maven.apache.org/POM/4.0.0\"\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n  <modelVersion>4.0.0</modelVersion>\n  <groupId>org.guvnor</groupId>\n  <artifactId>test</artifactId>\n  <version>0.0.11</version>\n</project>".getBytes(StandardCharsets.UTF_8));
            MavenProject mavenProject = MavenProjectLoader.parseMavenPom((InputStream)pomStream);
            RepositoryResolverTestUtils.installArtifact(mavenProject, "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\" xmlns=\"http://maven.apache.org/POM/4.0.0\"\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n  <modelVersion>4.0.0</modelVersion>\n  <groupId>org.guvnor</groupId>\n  <artifactId>test</artifactId>\n  <version>0.0.11</version>\n</project>");
            Set metadata = this.service.getRepositoriesResolvingArtifact(gav, module, new MavenRepositoryMetadata[0]);
            Assert.assertNotNull((Object)metadata);
            Assert.assertEquals((long)1L, (long)metadata.size());
            this.assertContainsRepository("local", m2Folder.toString(), MavenRepositorySource.LOCAL, metadata);
        }
        finally {
            this.resetSystemProperty("kie.maven.settings.custom", oldSettingsXmlPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetRepositoriesResolvingArtifact_ExplicitGAV_IsInstalledIsDeployed() {
        Module module = (Module)Mockito.mock(Module.class);
        org.uberfire.backend.vfs.Path vfsPomXmlPath = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        String oldSettingsXmlPath = System.getProperty("kie.maven.settings.custom");
        java.nio.file.Path remoteRepositoryFolder = null;
        try {
            remoteRepositoryFolder = Files.createTempDirectory("distribution-repo", new FileAttribute[0]);
            String pomXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\" xmlns=\"http://maven.apache.org/POM/4.0.0\"\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n  <modelVersion>4.0.0</modelVersion>\n  <groupId>org.guvnor</groupId>\n  <artifactId>test</artifactId>\n  <version>0.0.12</version>\n  <distributionManagement>\n    <repository>\n      <id>distribution-repo</id>\n      <name>Distribution Repository</name>\n      <url>file://" + remoteRepositoryFolder.toString() + "</url>\n    </repository>\n  </distributionManagement>\n</project>";
            GAV gav = new GAV("org.guvnor", "test", "0.0.12");
            Mockito.when((Object)module.getPomXMLPath()).thenReturn((Object)vfsPomXmlPath);
            Mockito.when((Object)vfsPomXmlPath.toURI()).thenReturn((Object)"file://p0/pom.xml");
            Mockito.when((Object)this.ioService.readAllString((Path)Mockito.any(Path.class))).thenReturn((Object)pomXml);
            System.setProperty("kie.maven.settings.custom", settingsXmlPath.toString());
            ByteArrayInputStream pomStream = new ByteArrayInputStream(pomXml.getBytes(StandardCharsets.UTF_8));
            MavenProject mavenProject = MavenProjectLoader.parseMavenPom((InputStream)pomStream);
            RepositoryResolverTestUtils.installArtifact(mavenProject, pomXml);
            RepositoryResolverTestUtils.deployArtifact(mavenProject, pomXml);
            Set metadata = this.service.getRepositoriesResolvingArtifact(gav, module, new MavenRepositoryMetadata[0]);
            Assert.assertNotNull((Object)metadata);
            Assert.assertEquals((long)2L, (long)metadata.size());
            this.assertContainsRepository("local", m2Folder.toString(), MavenRepositorySource.LOCAL, metadata);
            this.assertContainsRepository("distribution-repo", "file://" + remoteRepositoryFolder.toString(), MavenRepositorySource.DISTRIBUTION_MANAGEMENT, metadata);
        }
        catch (IOException ioe) {
            try {
                Assert.fail((String)ioe.getMessage());
            }
            catch (Throwable throwable) {
                MavenLocalRepositoryUtils.tearDownMavenRepository(remoteRepositoryFolder);
                this.resetSystemProperty("kie.maven.settings.custom", oldSettingsXmlPath);
                throw throwable;
            }
            MavenLocalRepositoryUtils.tearDownMavenRepository((java.nio.file.Path)remoteRepositoryFolder);
            this.resetSystemProperty("kie.maven.settings.custom", oldSettingsXmlPath);
        }
        MavenLocalRepositoryUtils.tearDownMavenRepository((java.nio.file.Path)remoteRepositoryFolder);
        this.resetSystemProperty("kie.maven.settings.custom", oldSettingsXmlPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetRepositoriesResolvingArtifact_ExplicitGAV_NotInstalledIsDeployed() {
        Module module = (Module)Mockito.mock(Module.class);
        org.uberfire.backend.vfs.Path vfsPomXmlPath = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        String oldSettingsXmlPath = System.getProperty("kie.maven.settings.custom");
        java.nio.file.Path remoteRepositoryFolder = null;
        try {
            remoteRepositoryFolder = Files.createTempDirectory("distribution-repo", new FileAttribute[0]);
            String pomXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\" xmlns=\"http://maven.apache.org/POM/4.0.0\"\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n  <modelVersion>4.0.0</modelVersion>\n  <groupId>org.guvnor</groupId>\n  <artifactId>test</artifactId>\n  <version>0.0.13</version>\n  <distributionManagement>\n    <repository>\n      <id>distribution-repo</id>\n      <name>Distribution Repository</name>\n      <url>file://" + remoteRepositoryFolder.toString() + "</url>\n    </repository>\n  </distributionManagement>\n</project>";
            GAV gav = new GAV("org.guvnor", "test", "0.0.13");
            Mockito.when((Object)module.getPomXMLPath()).thenReturn((Object)vfsPomXmlPath);
            Mockito.when((Object)vfsPomXmlPath.toURI()).thenReturn((Object)"file://p0/pom.xml");
            Mockito.when((Object)this.ioService.readAllString((Path)Mockito.any(Path.class))).thenReturn((Object)pomXml);
            System.setProperty("kie.maven.settings.custom", settingsXmlPath.toString());
            ByteArrayInputStream pomStream = new ByteArrayInputStream(pomXml.getBytes(StandardCharsets.UTF_8));
            MavenProject mavenProject = MavenProjectLoader.parseMavenPom((InputStream)pomStream);
            RepositoryResolverTestUtils.deployArtifact(mavenProject, pomXml);
            Set metadata = this.service.getRepositoriesResolvingArtifact(gav, module, new MavenRepositoryMetadata[0]);
            Assert.assertNotNull((Object)metadata);
            Assert.assertEquals((long)1L, (long)metadata.size());
            this.assertContainsRepository("distribution-repo", "file://" + remoteRepositoryFolder.toString(), MavenRepositorySource.DISTRIBUTION_MANAGEMENT, metadata);
            Set metadata2 = this.service.getRepositoriesResolvingArtifact(gav, module, new MavenRepositoryMetadata[0]);
            Assert.assertNotNull((Object)metadata2);
            Assert.assertEquals((long)1L, (long)metadata2.size());
            this.assertContainsRepository("distribution-repo", "file://" + remoteRepositoryFolder.toString(), MavenRepositorySource.DISTRIBUTION_MANAGEMENT, metadata2);
        }
        catch (IOException ioe) {
            try {
                Assert.fail((String)ioe.getMessage());
            }
            catch (Throwable throwable) {
                MavenLocalRepositoryUtils.tearDownMavenRepository(remoteRepositoryFolder);
                this.resetSystemProperty("kie.maven.settings.custom", oldSettingsXmlPath);
                throw throwable;
            }
            MavenLocalRepositoryUtils.tearDownMavenRepository((java.nio.file.Path)remoteRepositoryFolder);
            this.resetSystemProperty("kie.maven.settings.custom", oldSettingsXmlPath);
        }
        MavenLocalRepositoryUtils.tearDownMavenRepository((java.nio.file.Path)remoteRepositoryFolder);
        this.resetSystemProperty("kie.maven.settings.custom", oldSettingsXmlPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetRepositoriesResolvingArtifact_ExplicitGAV_IsInstalledIsDeployed_Filtered() {
        Module module = (Module)Mockito.mock(Module.class);
        org.uberfire.backend.vfs.Path vfsPomXmlPath = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        String oldSettingsXmlPath = System.getProperty("kie.maven.settings.custom");
        java.nio.file.Path remoteRepositoryFolder = null;
        try {
            remoteRepositoryFolder = Files.createTempDirectory("distribution-repo", new FileAttribute[0]);
            String pomXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\" xmlns=\"http://maven.apache.org/POM/4.0.0\"\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n  <modelVersion>4.0.0</modelVersion>\n  <groupId>org.guvnor</groupId>\n  <artifactId>test</artifactId>\n  <version>0.0.14</version>\n  <distributionManagement>\n    <repository>\n      <id>distribution-repo</id>\n      <name>Distribution Repository</name>\n      <url>file://" + remoteRepositoryFolder.toString() + "</url>\n    </repository>\n  </distributionManagement>\n</project>";
            GAV gav = new GAV("org.guvnor", "test", "0.0.14");
            Mockito.when((Object)module.getPomXMLPath()).thenReturn((Object)vfsPomXmlPath);
            Mockito.when((Object)vfsPomXmlPath.toURI()).thenReturn((Object)"file://p0/pom.xml");
            Mockito.when((Object)this.ioService.readAllString((Path)Mockito.any(Path.class))).thenReturn((Object)pomXml);
            System.setProperty("kie.maven.settings.custom", settingsXmlPath.toString());
            ByteArrayInputStream pomStream = new ByteArrayInputStream(pomXml.getBytes(StandardCharsets.UTF_8));
            MavenProject mavenProject = MavenProjectLoader.parseMavenPom((InputStream)pomStream);
            RepositoryResolverTestUtils.installArtifact(mavenProject, pomXml);
            RepositoryResolverTestUtils.deployArtifact(mavenProject, pomXml);
            Set metadata = this.service.getRepositoriesResolvingArtifact(gav, module, new MavenRepositoryMetadata[]{new MavenRepositoryMetadata("distribution-repo", "file://" + remoteRepositoryFolder.toString(), MavenRepositorySource.DISTRIBUTION_MANAGEMENT)});
            Assert.assertNotNull((Object)metadata);
            Assert.assertEquals((long)1L, (long)metadata.size());
            this.assertContainsRepository("distribution-repo", "file://" + remoteRepositoryFolder.toString(), MavenRepositorySource.DISTRIBUTION_MANAGEMENT, metadata);
        }
        catch (IOException ioe) {
            try {
                Assert.fail((String)ioe.getMessage());
            }
            catch (Throwable throwable) {
                MavenLocalRepositoryUtils.tearDownMavenRepository(remoteRepositoryFolder);
                this.resetSystemProperty("kie.maven.settings.custom", oldSettingsXmlPath);
                throw throwable;
            }
            MavenLocalRepositoryUtils.tearDownMavenRepository((java.nio.file.Path)remoteRepositoryFolder);
            this.resetSystemProperty("kie.maven.settings.custom", oldSettingsXmlPath);
        }
        MavenLocalRepositoryUtils.tearDownMavenRepository((java.nio.file.Path)remoteRepositoryFolder);
        this.resetSystemProperty("kie.maven.settings.custom", oldSettingsXmlPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetRepositoriesResolvingArtifact_ImplicitGAV_NotInstalledNotDeployed() {
        Module module = (Module)Mockito.mock(Module.class);
        org.uberfire.backend.vfs.Path pomXmlPath = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        String pomXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\" xmlns=\"http://maven.apache.org/POM/4.0.0\"\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n  <modelVersion>4.0.0</modelVersion>\n  <groupId>org.guvnor</groupId>\n  <artifactId>test</artifactId>\n  <version>0.0.15</version>\n</project>";
        String oldSettingsXmlPath = System.getProperty("kie.maven.settings.custom");
        try {
            System.setProperty("kie.maven.settings.custom", settingsXmlPath.toString());
            Set metadata = this.service.getRepositoriesResolvingArtifact("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\" xmlns=\"http://maven.apache.org/POM/4.0.0\"\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n  <modelVersion>4.0.0</modelVersion>\n  <groupId>org.guvnor</groupId>\n  <artifactId>test</artifactId>\n  <version>0.0.15</version>\n</project>", new MavenRepositoryMetadata[0]);
            Assert.assertNotNull((Object)metadata);
            Assert.assertEquals((long)0L, (long)metadata.size());
        }
        finally {
            this.resetSystemProperty("kie.maven.settings.custom", oldSettingsXmlPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetRepositoriesResolvingArtifact_ImplicitGAV_IsInstalledNotDeployed() {
        Module module = (Module)Mockito.mock(Module.class);
        org.uberfire.backend.vfs.Path vfsPomXmlPath = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        String oldSettingsXmlPath = System.getProperty("kie.maven.settings.custom");
        try {
            String pomXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\" xmlns=\"http://maven.apache.org/POM/4.0.0\"\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n  <modelVersion>4.0.0</modelVersion>\n  <groupId>org.guvnor</groupId>\n  <artifactId>test</artifactId>\n  <version>0.0.16</version>\n</project>";
            System.setProperty("kie.maven.settings.custom", settingsXmlPath.toString());
            ByteArrayInputStream pomStream = new ByteArrayInputStream("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\" xmlns=\"http://maven.apache.org/POM/4.0.0\"\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n  <modelVersion>4.0.0</modelVersion>\n  <groupId>org.guvnor</groupId>\n  <artifactId>test</artifactId>\n  <version>0.0.16</version>\n</project>".getBytes(StandardCharsets.UTF_8));
            MavenProject mavenProject = MavenProjectLoader.parseMavenPom((InputStream)pomStream);
            RepositoryResolverTestUtils.installArtifact(mavenProject, "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\" xmlns=\"http://maven.apache.org/POM/4.0.0\"\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n  <modelVersion>4.0.0</modelVersion>\n  <groupId>org.guvnor</groupId>\n  <artifactId>test</artifactId>\n  <version>0.0.16</version>\n</project>");
            Set metadata = this.service.getRepositoriesResolvingArtifact("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\" xmlns=\"http://maven.apache.org/POM/4.0.0\"\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n  <modelVersion>4.0.0</modelVersion>\n  <groupId>org.guvnor</groupId>\n  <artifactId>test</artifactId>\n  <version>0.0.16</version>\n</project>", new MavenRepositoryMetadata[0]);
            Assert.assertNotNull((Object)metadata);
            Assert.assertEquals((long)1L, (long)metadata.size());
            this.assertContainsRepository("local", m2Folder.toString(), MavenRepositorySource.LOCAL, metadata);
        }
        finally {
            this.resetSystemProperty("kie.maven.settings.custom", oldSettingsXmlPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetRepositoriesResolvingArtifact_ImplicitGAV_IsInstalledIsDeployed() {
        Module module = (Module)Mockito.mock(Module.class);
        org.uberfire.backend.vfs.Path vfsPomXmlPath = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        String oldSettingsXmlPath = System.getProperty("kie.maven.settings.custom");
        java.nio.file.Path remoteRepositoryFolder = null;
        try {
            remoteRepositoryFolder = Files.createTempDirectory("distribution-repo", new FileAttribute[0]);
            String pomXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\" xmlns=\"http://maven.apache.org/POM/4.0.0\"\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n  <modelVersion>4.0.0</modelVersion>\n  <groupId>org.guvnor</groupId>\n  <artifactId>test</artifactId>\n  <version>0.0.17</version>\n  <distributionManagement>\n    <repository>\n      <id>distribution-repo</id>\n      <name>Distribution Repository</name>\n      <url>file://" + remoteRepositoryFolder.toString() + "</url>\n    </repository>\n  </distributionManagement>\n</project>";
            System.setProperty("kie.maven.settings.custom", settingsXmlPath.toString());
            ByteArrayInputStream pomStream = new ByteArrayInputStream(pomXml.getBytes(StandardCharsets.UTF_8));
            MavenProject mavenProject = MavenProjectLoader.parseMavenPom((InputStream)pomStream);
            RepositoryResolverTestUtils.installArtifact(mavenProject, pomXml);
            RepositoryResolverTestUtils.deployArtifact(mavenProject, pomXml);
            Set metadata = this.service.getRepositoriesResolvingArtifact(pomXml, new MavenRepositoryMetadata[0]);
            Assert.assertNotNull((Object)metadata);
            Assert.assertEquals((long)2L, (long)metadata.size());
            this.assertContainsRepository("local", m2Folder.toString(), MavenRepositorySource.LOCAL, metadata);
            this.assertContainsRepository("distribution-repo", "file://" + remoteRepositoryFolder.toString(), MavenRepositorySource.DISTRIBUTION_MANAGEMENT, metadata);
        }
        catch (IOException ioe) {
            try {
                Assert.fail((String)ioe.getMessage());
            }
            catch (Throwable throwable) {
                MavenLocalRepositoryUtils.tearDownMavenRepository(remoteRepositoryFolder);
                this.resetSystemProperty("kie.maven.settings.custom", oldSettingsXmlPath);
                throw throwable;
            }
            MavenLocalRepositoryUtils.tearDownMavenRepository((java.nio.file.Path)remoteRepositoryFolder);
            this.resetSystemProperty("kie.maven.settings.custom", oldSettingsXmlPath);
        }
        MavenLocalRepositoryUtils.tearDownMavenRepository((java.nio.file.Path)remoteRepositoryFolder);
        this.resetSystemProperty("kie.maven.settings.custom", oldSettingsXmlPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetRepositoriesResolvingArtifact_ImplicitGAV_NotInstalledIsDeployed() {
        Module module = (Module)Mockito.mock(Module.class);
        org.uberfire.backend.vfs.Path vfsPomXmlPath = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        String oldSettingsXmlPath = System.getProperty("kie.maven.settings.custom");
        java.nio.file.Path remoteRepositoryFolder = null;
        try {
            remoteRepositoryFolder = Files.createTempDirectory("distribution-repo", new FileAttribute[0]);
            String pomXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\" xmlns=\"http://maven.apache.org/POM/4.0.0\"\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n  <modelVersion>4.0.0</modelVersion>\n  <groupId>org.guvnor</groupId>\n  <artifactId>test</artifactId>\n  <version>0.0.18</version>\n  <distributionManagement>\n    <repository>\n      <id>distribution-repo</id>\n      <name>Distribution Repository</name>\n      <url>file://" + remoteRepositoryFolder.toString() + "</url>\n    </repository>\n  </distributionManagement>\n</project>";
            System.setProperty("kie.maven.settings.custom", settingsXmlPath.toString());
            ByteArrayInputStream pomStream = new ByteArrayInputStream(pomXml.getBytes(StandardCharsets.UTF_8));
            MavenProject mavenProject = MavenProjectLoader.parseMavenPom((InputStream)pomStream);
            RepositoryResolverTestUtils.deployArtifact(mavenProject, pomXml);
            Set metadata = this.service.getRepositoriesResolvingArtifact(pomXml, new MavenRepositoryMetadata[0]);
            Assert.assertNotNull((Object)metadata);
            Assert.assertEquals((long)1L, (long)metadata.size());
            this.assertContainsRepository("distribution-repo", "file://" + remoteRepositoryFolder.toString(), MavenRepositorySource.DISTRIBUTION_MANAGEMENT, metadata);
            Set metadata2 = this.service.getRepositoriesResolvingArtifact(pomXml, new MavenRepositoryMetadata[0]);
            Assert.assertNotNull((Object)metadata2);
            Assert.assertEquals((long)1L, (long)metadata2.size());
            this.assertContainsRepository("distribution-repo", "file://" + remoteRepositoryFolder.toString(), MavenRepositorySource.DISTRIBUTION_MANAGEMENT, metadata2);
        }
        catch (IOException ioe) {
            try {
                Assert.fail((String)ioe.getMessage());
            }
            catch (Throwable throwable) {
                MavenLocalRepositoryUtils.tearDownMavenRepository(remoteRepositoryFolder);
                this.resetSystemProperty("kie.maven.settings.custom", oldSettingsXmlPath);
                throw throwable;
            }
            MavenLocalRepositoryUtils.tearDownMavenRepository((java.nio.file.Path)remoteRepositoryFolder);
            this.resetSystemProperty("kie.maven.settings.custom", oldSettingsXmlPath);
        }
        MavenLocalRepositoryUtils.tearDownMavenRepository((java.nio.file.Path)remoteRepositoryFolder);
        this.resetSystemProperty("kie.maven.settings.custom", oldSettingsXmlPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetRepositoriesResolvingArtifact_ImplicitGAV_IsInstalledIsDeployed_Filtered() {
        Module module = (Module)Mockito.mock(Module.class);
        org.uberfire.backend.vfs.Path vfsPomXmlPath = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        String oldSettingsXmlPath = System.getProperty("kie.maven.settings.custom");
        java.nio.file.Path remoteRepositoryFolder = null;
        try {
            remoteRepositoryFolder = Files.createTempDirectory("distribution-repo", new FileAttribute[0]);
            String pomXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\" xmlns=\"http://maven.apache.org/POM/4.0.0\"\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n  <modelVersion>4.0.0</modelVersion>\n  <groupId>org.guvnor</groupId>\n  <artifactId>test</artifactId>\n  <version>0.0.19</version>\n  <distributionManagement>\n    <repository>\n      <id>distribution-repo</id>\n      <name>Distribution Repository</name>\n      <url>file://" + remoteRepositoryFolder.toString() + "</url>\n    </repository>\n  </distributionManagement>\n</project>";
            System.setProperty("kie.maven.settings.custom", settingsXmlPath.toString());
            ByteArrayInputStream pomStream = new ByteArrayInputStream(pomXml.getBytes(StandardCharsets.UTF_8));
            MavenProject mavenProject = MavenProjectLoader.parseMavenPom((InputStream)pomStream);
            RepositoryResolverTestUtils.installArtifact(mavenProject, pomXml);
            RepositoryResolverTestUtils.deployArtifact(mavenProject, pomXml);
            Set metadata = this.service.getRepositoriesResolvingArtifact(pomXml, new MavenRepositoryMetadata[]{new MavenRepositoryMetadata("distribution-repo", "file://" + remoteRepositoryFolder.toString(), MavenRepositorySource.DISTRIBUTION_MANAGEMENT)});
            Assert.assertNotNull((Object)metadata);
            Assert.assertEquals((long)1L, (long)metadata.size());
            this.assertContainsRepository("distribution-repo", "file://" + remoteRepositoryFolder.toString(), MavenRepositorySource.DISTRIBUTION_MANAGEMENT, metadata);
        }
        catch (IOException ioe) {
            try {
                Assert.fail((String)ioe.getMessage());
            }
            catch (Throwable throwable) {
                MavenLocalRepositoryUtils.tearDownMavenRepository(remoteRepositoryFolder);
                this.resetSystemProperty("kie.maven.settings.custom", oldSettingsXmlPath);
                throw throwable;
            }
            MavenLocalRepositoryUtils.tearDownMavenRepository((java.nio.file.Path)remoteRepositoryFolder);
            this.resetSystemProperty("kie.maven.settings.custom", oldSettingsXmlPath);
        }
        MavenLocalRepositoryUtils.tearDownMavenRepository((java.nio.file.Path)remoteRepositoryFolder);
        this.resetSystemProperty("kie.maven.settings.custom", oldSettingsXmlPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetRepositoriesResolvingArtifact_Disabled1() {
        String oldSettingsXmlPath = System.getProperty("kie.maven.settings.custom");
        try {
            String pomXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\" xmlns=\"http://maven.apache.org/POM/4.0.0\"\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n  <modelVersion>4.0.0</modelVersion>\n  <groupId>org.guvnor</groupId>\n  <artifactId>test</artifactId>\n  <version>0.0.20</version>\n</project>";
            GAV gav = new GAV("org.guvnor", "test", "0.0.20");
            System.setProperty("kie.maven.settings.custom", settingsXmlPath.toString());
            ((GAVPreferences)Mockito.doReturn((Object)true).when((Object)this.gavPreferences)).isConflictingGAVCheckDisabled();
            this.service = new ModuleRepositoryResolverImpl(this.ioService, this.gavPreferencesProvider, this.scopeResolutionStrategies);
            ByteArrayInputStream pomStream = new ByteArrayInputStream("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\" xmlns=\"http://maven.apache.org/POM/4.0.0\"\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n  <modelVersion>4.0.0</modelVersion>\n  <groupId>org.guvnor</groupId>\n  <artifactId>test</artifactId>\n  <version>0.0.20</version>\n</project>".getBytes(StandardCharsets.UTF_8));
            MavenProject mavenProject = MavenProjectLoader.parseMavenPom((InputStream)pomStream);
            RepositoryResolverTestUtils.installArtifact(mavenProject, "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\" xmlns=\"http://maven.apache.org/POM/4.0.0\"\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n  <modelVersion>4.0.0</modelVersion>\n  <groupId>org.guvnor</groupId>\n  <artifactId>test</artifactId>\n  <version>0.0.20</version>\n</project>");
            Set metadata = this.service.getRepositoriesResolvingArtifact(gav, new MavenRepositoryMetadata[0]);
            Assert.assertNotNull((Object)metadata);
            Assert.assertEquals((long)0L, (long)metadata.size());
        }
        finally {
            this.resetSystemProperty("kie.maven.settings.custom", oldSettingsXmlPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetRepositoriesResolvingArtifact_Disabled2() {
        Module module = (Module)Mockito.mock(Module.class);
        ((Module)Mockito.doReturn((Object)"file://main@a/a%20b").when((Object)module)).getIdentifier();
        ((Module)Mockito.doCallRealMethod().when((Object)module)).getEncodedIdentifier();
        org.uberfire.backend.vfs.Path vfsPomXmlPath = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        String oldSettingsXmlPath = System.getProperty("kie.maven.settings.custom");
        try {
            String pomXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\" xmlns=\"http://maven.apache.org/POM/4.0.0\"\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n  <modelVersion>4.0.0</modelVersion>\n  <groupId>org.guvnor</groupId>\n  <artifactId>test</artifactId>\n  <version>0.0.21</version>\n</project>";
            GAV gav = new GAV("org.guvnor", "test", "0.0.21");
            System.setProperty("kie.maven.settings.custom", settingsXmlPath.toString());
            ((GAVPreferences)Mockito.doReturn((Object)true).when((Object)this.gavPreferences)).isConflictingGAVCheckDisabled();
            this.service = new ModuleRepositoryResolverImpl(this.ioService, this.gavPreferencesProvider, this.scopeResolutionStrategies);
            ByteArrayInputStream pomStream = new ByteArrayInputStream("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\" xmlns=\"http://maven.apache.org/POM/4.0.0\"\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n  <modelVersion>4.0.0</modelVersion>\n  <groupId>org.guvnor</groupId>\n  <artifactId>test</artifactId>\n  <version>0.0.21</version>\n</project>".getBytes(StandardCharsets.UTF_8));
            MavenProject mavenProject = MavenProjectLoader.parseMavenPom((InputStream)pomStream);
            RepositoryResolverTestUtils.installArtifact(mavenProject, "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\" xmlns=\"http://maven.apache.org/POM/4.0.0\"\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n  <modelVersion>4.0.0</modelVersion>\n  <groupId>org.guvnor</groupId>\n  <artifactId>test</artifactId>\n  <version>0.0.21</version>\n</project>");
            Set metadata = this.service.getRepositoriesResolvingArtifact(gav, module, new MavenRepositoryMetadata[0]);
            Assert.assertNotNull((Object)metadata);
            Assert.assertEquals((long)0L, (long)metadata.size());
        }
        finally {
            this.resetSystemProperty("kie.maven.settings.custom", oldSettingsXmlPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetRepositoriesResolvingArtifact_Disabled3() {
        Module module = (Module)Mockito.mock(Module.class);
        org.uberfire.backend.vfs.Path vfsPomXmlPath = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        String oldSettingsXmlPath = System.getProperty("kie.maven.settings.custom");
        try {
            String pomXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\" xmlns=\"http://maven.apache.org/POM/4.0.0\"\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n  <modelVersion>4.0.0</modelVersion>\n  <groupId>org.guvnor</groupId>\n  <artifactId>test</artifactId>\n  <version>0.0.22</version>\n</project>";
            System.setProperty("kie.maven.settings.custom", settingsXmlPath.toString());
            ((GAVPreferences)Mockito.doReturn((Object)true).when((Object)this.gavPreferences)).isConflictingGAVCheckDisabled();
            this.service = new ModuleRepositoryResolverImpl(this.ioService, this.gavPreferencesProvider, this.scopeResolutionStrategies);
            ByteArrayInputStream pomStream = new ByteArrayInputStream("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\" xmlns=\"http://maven.apache.org/POM/4.0.0\"\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n  <modelVersion>4.0.0</modelVersion>\n  <groupId>org.guvnor</groupId>\n  <artifactId>test</artifactId>\n  <version>0.0.22</version>\n</project>".getBytes(StandardCharsets.UTF_8));
            MavenProject mavenProject = MavenProjectLoader.parseMavenPom((InputStream)pomStream);
            RepositoryResolverTestUtils.installArtifact(mavenProject, "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\" xmlns=\"http://maven.apache.org/POM/4.0.0\"\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n  <modelVersion>4.0.0</modelVersion>\n  <groupId>org.guvnor</groupId>\n  <artifactId>test</artifactId>\n  <version>0.0.22</version>\n</project>");
            Set metadata = this.service.getRepositoriesResolvingArtifact("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\" xmlns=\"http://maven.apache.org/POM/4.0.0\"\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n  <modelVersion>4.0.0</modelVersion>\n  <groupId>org.guvnor</groupId>\n  <artifactId>test</artifactId>\n  <version>0.0.22</version>\n</project>", new MavenRepositoryMetadata[0]);
            Assert.assertNotNull((Object)metadata);
            Assert.assertEquals((long)0L, (long)metadata.size());
        }
        finally {
            this.resetSystemProperty("kie.maven.settings.custom", oldSettingsXmlPath);
        }
    }

    private void assertContainsRepository(String id, String url, MavenRepositorySource source, Collection<MavenRepositoryMetadata> metadata) {
        for (MavenRepositoryMetadata md : metadata) {
            if (!md.getId().equals(id) || !md.getUrl().equals(url) || !md.getSource().equals((Object)source)) continue;
            return;
        }
        Assert.fail((String)("Repository Id '" + id + "' not found."));
    }

    private void resetSystemProperty(String systemPropertyName, String oldSystemPropertyValue) {
        if (oldSystemPropertyValue != null) {
            System.setProperty(systemPropertyName, oldSystemPropertyValue);
        } else {
            System.clearProperty(systemPropertyName);
        }
    }
}

