/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.rest.backend;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import javax.enterprise.event.Event;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.common.services.project.service.ModuleService;
import org.guvnor.common.services.project.service.WorkspaceProjectService;
import org.guvnor.common.services.shared.test.Failure;
import org.guvnor.common.services.shared.test.TestResultMessage;
import org.guvnor.common.services.shared.test.TestRunnerService;
import org.guvnor.rest.backend.JobRequestHelper;
import org.guvnor.rest.client.CloneProjectRequest;
import org.guvnor.rest.client.JobResult;
import org.guvnor.rest.client.JobStatus;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.guvnor.structure.repositories.Branch;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryEnvironmentConfigurations;
import org.guvnor.structure.repositories.RepositoryService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.backend.vfs.Path;
import org.uberfire.spaces.Space;
import org.uberfire.spaces.SpacesAPI;

@RunWith(value=MockitoJUnitRunner.class)
public class JobRequestHelperTest {
    @InjectMocks
    JobRequestHelper helper;
    @Mock
    Repository repository;
    @Captor
    ArgumentCaptor<Event<TestResultMessage>> captor;
    @Mock
    private TestRunnerService testService;
    @Mock
    private RepositoryService repositoryService;
    @Mock
    private ModuleService<MyModule> moduleService;
    @Mock
    private WorkspaceProjectService workspaceProjectService;
    @Mock
    private WorkspaceProject workspaceProject;
    @Mock
    private SpacesAPI spaces;
    @Mock
    private OrganizationalUnitService organizationalUnitService;
    private Space space = new Space("space");
    @Captor
    ArgumentCaptor<RepositoryEnvironmentConfigurations> repositoryEnvironmentConfigurationsCaptor;

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.workspaceProjectService.resolveProject((Space)Matchers.eq((Object)this.space), (String)Matchers.eq((Object)"project"))).thenReturn((Object)this.workspaceProject);
        Mockito.when((Object)this.repositoryService.getRepositoryFromSpace((Space)Matchers.eq((Object)this.space), (String)Matchers.eq((Object)"repositoryAlias"))).thenReturn((Object)this.repository);
        Mockito.when((Object)this.spaces.getSpace((String)Matchers.eq((Object)"space"))).thenReturn((Object)this.space);
    }

    @Test
    public void cloneProject() throws Exception {
        ((OrganizationalUnitService)Mockito.doReturn((Object)Mockito.mock(OrganizationalUnit.class)).when((Object)this.organizationalUnitService)).getOrganizationalUnit("space");
        CloneProjectRequest cloneProjectRequest = new CloneProjectRequest();
        cloneProjectRequest.setName("myName");
        this.helper.cloneProject("jobId", "space", cloneProjectRequest);
        ((RepositoryService)Mockito.verify((Object)this.repositoryService)).createRepository((OrganizationalUnit)Matchers.any(), (String)Matchers.eq((Object)"git"), (String)Matchers.eq((Object)"myName"), (RepositoryEnvironmentConfigurations)this.repositoryEnvironmentConfigurationsCaptor.capture());
        RepositoryEnvironmentConfigurations config = (RepositoryEnvironmentConfigurations)this.repositoryEnvironmentConfigurationsCaptor.getValue();
        Assert.assertEquals((Object)false, (Object)config.getMirror());
        Assert.assertEquals((Object)false, (Object)config.getInit());
    }

    @Test
    public void resourceDoesNotExist() throws Exception {
        JobResult jobResult = this.helper.testProject(null, null, null);
        Assert.assertEquals((Object)JobStatus.RESOURCE_NOT_EXIST, (Object)jobResult.getStatus());
    }

    @Test
    public void projectDoesNotExist() throws Exception {
        Path path = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)path.getFileName()).thenReturn((Object)"");
        Mockito.when((Object)path.toURI()).thenReturn((Object)"file://project/");
        Branch masterBranch = new Branch("master", path);
        Mockito.when((Object)this.repository.getDefaultBranch()).thenReturn(Optional.of(masterBranch));
        Mockito.when((Object)this.repository.getBranch("master")).thenReturn(Optional.of(masterBranch));
        JobResult jobResult = this.helper.testProject(null, this.space.getName(), "project");
        Assert.assertEquals((Object)JobStatus.RESOURCE_NOT_EXIST, (Object)jobResult.getStatus());
    }

    @Test
    public void allTestsPass() throws Exception {
        this.whenProjectExists();
        this.thenExpectMessageWithStatus(new TestResultMessage("JobRequestHelper", 10, 1000L, Collections.emptyList()), JobStatus.SUCCESS);
    }

    @Test
    public void testsFail() throws Exception {
        this.whenProjectExists();
        ArrayList<Failure> failures = new ArrayList<Failure>();
        failures.add(new Failure());
        this.thenExpectMessageWithStatus(new TestResultMessage("JobRequestHelper", 10, 1000L, failures), JobStatus.FAIL);
    }

    private void thenExpectMessageWithStatus(TestResultMessage message, JobStatus status) {
        JobResult jobResult = this.helper.testProject(null, this.space.getName(), "project");
        ((TestRunnerService)Mockito.verify((Object)this.testService)).runAllTests((String)Matchers.eq((Object)"JobRequestHelper"), (Path)Matchers.any(Path.class), (Event)this.captor.capture());
        ((Event)this.captor.getValue()).fire((Object)message);
        Assert.assertEquals((Object)status, (Object)jobResult.getStatus());
    }

    private void whenProjectExists() {
        Mockito.when((Object)this.workspaceProject.getMainModule()).thenReturn(Mockito.mock(MyModule.class));
    }

    class MyModule
    extends Module {
        MyModule() {
        }
    }
}

