/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.rest.backend;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.security.RolesAllowed;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.core.Variant;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.common.services.project.service.WorkspaceProjectService;
import org.guvnor.rest.backend.JobRequestScheduler;
import org.guvnor.rest.backend.JobResultManager;
import org.guvnor.rest.client.CloneProjectJobRequest;
import org.guvnor.rest.client.CloneProjectRequest;
import org.guvnor.rest.client.CompileProjectRequest;
import org.guvnor.rest.client.CreateProjectJobRequest;
import org.guvnor.rest.client.CreateProjectRequest;
import org.guvnor.rest.client.DeleteProjectRequest;
import org.guvnor.rest.client.DeployProjectRequest;
import org.guvnor.rest.client.InstallProjectRequest;
import org.guvnor.rest.client.JobRequest;
import org.guvnor.rest.client.JobResult;
import org.guvnor.rest.client.JobStatus;
import org.guvnor.rest.client.ProjectResponse;
import org.guvnor.rest.client.PublicURI;
import org.guvnor.rest.client.RemoveSpaceRequest;
import org.guvnor.rest.client.Space;
import org.guvnor.rest.client.SpaceRequest;
import org.guvnor.rest.client.TestProjectRequest;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.io.IOService;
import org.uberfire.spaces.SpacesAPI;

@Path(value="/")
@Named
@ApplicationScoped
public class ProjectResource {
    private static final Logger logger = LoggerFactory.getLogger(ProjectResource.class);
    private Variant defaultVariant = this.getDefaultVariant();
    @Context
    protected UriInfo uriInfo;
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    private OrganizationalUnitService organizationalUnitService;
    @Inject
    private WorkspaceProjectService workspaceProjectService;
    @Inject
    private JobRequestScheduler jobRequestObserver;
    @Inject
    private JobResultManager jobManager;
    @Inject
    private SpacesAPI spacesAPI;
    private AtomicLong counter = new AtomicLong(0L);

    protected Variant getDefaultVariant() {
        return (Variant)Variant.mediaTypes((MediaType[])new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).add().build().get(0);
    }

    private void addAcceptedJobResult(String jobId) {
        JobResult jobResult = new JobResult();
        jobResult.setJobId(jobId);
        jobResult.setStatus(JobStatus.ACCEPTED);
        this.jobManager.putJob(jobResult);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/jobs/{jobId}")
    @RolesAllowed(value={"rest-all", "rest-project"})
    public JobResult getJobStatus(@PathParam(value="jobId") String jobId) {
        logger.debug("-----getJobStatus--- , jobId: {}", (Object)jobId);
        JobResult job = this.jobManager.getJob(jobId);
        if (job == null) {
            logger.debug("-----getJobStatus--- , can not find jobId: " + jobId + ", the job has gone probably because its done and has been removed.");
            job = new JobResult();
            job.setStatus(JobStatus.GONE);
            return job;
        }
        return job;
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/jobs/{jobId}")
    @RolesAllowed(value={"rest-all", "rest-project"})
    public JobResult removeJob(@PathParam(value="jobId") String jobId) {
        logger.debug("-----removeJob--- , jobId: {}", (Object)jobId);
        JobResult job = this.getJobResult(jobId);
        job.setStatus(JobStatus.GONE);
        return job;
    }

    private JobResult getJobResult(String jobId) {
        JobResult job = this.jobManager.removeJob(jobId);
        if (job == null) {
            logger.debug("-----removeJob--- , can not find jobId: " + jobId + ", the job has gone probably because its done and has been removed.");
            return new JobResult();
        }
        return job;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/spaces/{spaceName}/git/clone")
    @RolesAllowed(value={"rest-all", "rest-project"})
    public Response cloneProject(@PathParam(value="spaceName") String spaceName, CloneProjectRequest cloneProjectRequest) {
        logger.debug("-----cloneProject--- , CloneProjectRequest name: {}", (Object)cloneProjectRequest.getName());
        String id = this.newId();
        CloneProjectJobRequest jobRequest = new CloneProjectJobRequest();
        jobRequest.setStatus(JobStatus.ACCEPTED);
        jobRequest.setJobId(id);
        jobRequest.setSpaceName(spaceName);
        jobRequest.setCloneProjectRequest(cloneProjectRequest);
        this.addAcceptedJobResult(id);
        this.jobRequestObserver.cloneProjectRequest(jobRequest);
        return this.createAcceptedStatusResponse((JobRequest)jobRequest);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/spaces/{spaceName}/projects")
    @RolesAllowed(value={"rest-all", "rest-project"})
    public Response createProject(@PathParam(value="spaceName") String spaceName, CreateProjectRequest createProjectRequest) {
        logger.debug("-----createProject--- , spaceName: {} , project name: {}", (Object)spaceName, (Object)createProjectRequest.getName());
        this.assertObjectExists(this.organizationalUnitService.getOrganizationalUnit(spaceName), "space", spaceName);
        String id = this.newId();
        CreateProjectJobRequest jobRequest = new CreateProjectJobRequest();
        jobRequest.setStatus(JobStatus.ACCEPTED);
        jobRequest.setJobId(id);
        jobRequest.setSpaceName(spaceName);
        jobRequest.setProjectName(createProjectRequest.getName());
        jobRequest.setProjectGroupId(createProjectRequest.getGroupId());
        jobRequest.setProjectVersion(createProjectRequest.getVersion());
        jobRequest.setDescription(createProjectRequest.getDescription());
        this.addAcceptedJobResult(id);
        this.jobRequestObserver.createProjectRequest(jobRequest);
        return this.createAcceptedStatusResponse((JobRequest)jobRequest);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/spaces/{spaceName}/projects")
    @RolesAllowed(value={"rest-all", "rest-project"})
    public Collection<ProjectResponse> getProjects(@PathParam(value="spaceName") String spaceName) {
        logger.info("-----getProjects--- , spaceName: {}", (Object)spaceName);
        OrganizationalUnit organizationalUnit = this.organizationalUnitService.getOrganizationalUnit(spaceName);
        this.assertObjectExists(organizationalUnit, "space", spaceName);
        Collection projects = this.workspaceProjectService.getAllWorkspaceProjects(organizationalUnit);
        ArrayList<ProjectResponse> projectRequests = new ArrayList<ProjectResponse>(projects.size());
        for (WorkspaceProject project : projects) {
            projectRequests.add(this.getProjectResponse(project));
        }
        return projectRequests;
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/spaces/{spaceName}/projects/{projectName}")
    @RolesAllowed(value={"rest-all", "rest-project"})
    public Response deleteProject(@PathParam(value="spaceName") String spaceName, @PathParam(value="projectName") String projectName) {
        logger.debug("-----deleteProject--- , space name: {}, project name: {}", (Object)spaceName, (Object)projectName);
        org.uberfire.spaces.Space space = this.spacesAPI.getSpace(spaceName);
        this.assertObjectExists(this.organizationalUnitService.getOrganizationalUnit(spaceName), "space", spaceName);
        this.assertObjectExists(this.workspaceProjectService.resolveProject(space, projectName), "project", projectName);
        String id = this.newId();
        DeleteProjectRequest jobRequest = new DeleteProjectRequest();
        jobRequest.setStatus(JobStatus.ACCEPTED);
        jobRequest.setJobId(id);
        jobRequest.setProjectName(projectName);
        jobRequest.setSpaceName(spaceName);
        this.addAcceptedJobResult(id);
        this.jobRequestObserver.deleteProjectRequest(jobRequest);
        return this.createAcceptedStatusResponse((JobRequest)jobRequest);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/spaces/{spaceName}/projects/{projectName}")
    @RolesAllowed(value={"rest-all", "rest-project"})
    public ProjectResponse getProject(@PathParam(value="spaceName") String spaceName, @PathParam(value="projectName") String projectName) {
        logger.debug("-----getProject---, space name: {}, project name: {}", (Object)spaceName, (Object)projectName);
        this.assertObjectExists(this.organizationalUnitService.getOrganizationalUnit(spaceName), "space", spaceName);
        WorkspaceProject workspaceProject = this.workspaceProjectService.resolveProject(this.spacesAPI.getSpace(spaceName), projectName);
        this.assertObjectExists(workspaceProject, "project", projectName);
        ProjectResponse projectResponse = this.getProjectResponse(workspaceProject);
        return projectResponse;
    }

    private ProjectResponse getProjectResponse(WorkspaceProject workspaceProject) {
        ProjectResponse projectResponse = new ProjectResponse();
        projectResponse.setName(workspaceProject.getName());
        projectResponse.setSpaceName(workspaceProject.getOrganizationalUnit().getName());
        if (workspaceProject.getMainModule() != null) {
            projectResponse.setGroupId(workspaceProject.getMainModule().getPom().getGav().getGroupId());
            projectResponse.setVersion(workspaceProject.getMainModule().getPom().getGav().getVersion());
            projectResponse.setDescription(workspaceProject.getMainModule().getPom().getDescription());
        }
        ArrayList<PublicURI> publicURIs = new ArrayList<PublicURI>();
        for (org.guvnor.structure.repositories.PublicURI publicURI : workspaceProject.getRepository().getPublicURIs()) {
            PublicURI responseURI = new PublicURI();
            responseURI.setProtocol(publicURI.getProtocol());
            responseURI.setUri(publicURI.getURI());
            publicURIs.add(responseURI);
        }
        projectResponse.setPublicURIs(publicURIs);
        return projectResponse;
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/spaces/{spaceName}/projects/{projectName}/maven/compile")
    @RolesAllowed(value={"rest-all", "rest-project"})
    public Response compileProject(@PathParam(value="spaceName") String spaceName, @PathParam(value="projectName") String projectName) {
        logger.debug("-----compileProject--- , space name: {}, project name: {}", (Object)spaceName, (Object)projectName);
        String id = this.newId();
        CompileProjectRequest jobRequest = new CompileProjectRequest();
        jobRequest.setStatus(JobStatus.ACCEPTED);
        jobRequest.setJobId(id);
        jobRequest.setProjectName(projectName);
        jobRequest.setSpaceName(spaceName);
        this.addAcceptedJobResult(id);
        this.jobRequestObserver.compileProjectRequest(jobRequest);
        return this.createAcceptedStatusResponse((JobRequest)jobRequest);
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/spaces/{spaceName}/projects/{projectName}/maven/install")
    @RolesAllowed(value={"rest-all", "rest-project"})
    public Response installProject(@PathParam(value="spaceName") String spaceName, @PathParam(value="projectName") String projectName) {
        logger.debug("-----installProject--- , project name: {}", (Object)projectName);
        PortablePreconditions.checkNotNull((String)"spaceName", (Object)spaceName);
        PortablePreconditions.checkNotNull((String)"projectName", (Object)projectName);
        String id = this.newId();
        InstallProjectRequest jobRequest = new InstallProjectRequest();
        jobRequest.setStatus(JobStatus.ACCEPTED);
        jobRequest.setJobId(id);
        jobRequest.setSpaceName(spaceName);
        jobRequest.setProjectName(projectName);
        this.addAcceptedJobResult(id);
        this.jobRequestObserver.installProjectRequest(jobRequest);
        return this.createAcceptedStatusResponse((JobRequest)jobRequest);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/spaces/{spaceName}/projects/{projectName}/maven/test")
    @RolesAllowed(value={"rest-all", "rest-project"})
    public Response testProject(@PathParam(value="spaceName") String spaceName, @PathParam(value="projectName") String projectName) {
        logger.debug("-----testProject--- , project name: {}", (Object)projectName);
        String id = this.newId();
        TestProjectRequest jobRequest = new TestProjectRequest();
        jobRequest.setStatus(JobStatus.ACCEPTED);
        jobRequest.setJobId(id);
        jobRequest.setProjectName(projectName);
        jobRequest.setSpaceName(spaceName);
        this.addAcceptedJobResult(id);
        this.jobRequestObserver.testProjectRequest(jobRequest);
        return this.createAcceptedStatusResponse((JobRequest)jobRequest);
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/spaces/{spaceName}/projects/{projectName}/maven/deploy")
    @RolesAllowed(value={"rest-all", "rest-project"})
    public Response deployProject(@PathParam(value="spaceName") String spaceName, @PathParam(value="projectName") String projectName) {
        logger.debug("-----deployProject--- , project name: {}", (Object)projectName);
        String id = this.newId();
        DeployProjectRequest jobRequest = new DeployProjectRequest();
        jobRequest.setStatus(JobStatus.ACCEPTED);
        jobRequest.setJobId(id);
        jobRequest.setProjectName(projectName);
        jobRequest.setSpaceName(spaceName);
        this.addAcceptedJobResult(id);
        this.jobRequestObserver.deployProjectRequest(jobRequest);
        return this.createAcceptedStatusResponse((JobRequest)jobRequest);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/spaces")
    @RolesAllowed(value={"rest-all", "rest-project"})
    public Collection<Space> getSpaces() {
        logger.debug("-----getSpaces--- ");
        ArrayList<Space> spaces = new ArrayList<Space>();
        for (OrganizationalUnit ou : this.organizationalUnitService.getOrganizationalUnits()) {
            spaces.add(this.getSpace(ou));
        }
        return spaces;
    }

    private Space getSpace(OrganizationalUnit ou) {
        Space space = new Space();
        space.setName(ou.getName());
        space.setOwner(ou.getOwner());
        space.setDefaultGroupId(ou.getDefaultGroupId());
        ArrayList<ProjectResponse> repoNames = new ArrayList<ProjectResponse>();
        for (WorkspaceProject workspaceProject : this.workspaceProjectService.getAllWorkspaceProjects(ou)) {
            repoNames.add(this.getProjectResponse(workspaceProject));
        }
        space.setProjects(repoNames);
        return space;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/spaces/{spaceName}")
    @RolesAllowed(value={"rest-all", "rest-project"})
    public Space getSpace(@PathParam(value="spaceName") String spaceName) {
        logger.debug("-----getSpace ---, Space name: {}", (Object)spaceName);
        OrganizationalUnit ou = this.organizationalUnitService.getOrganizationalUnit(spaceName);
        this.assertObjectExists(ou, "space", spaceName);
        return this.getSpace(ou);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/spaces")
    @RolesAllowed(value={"rest-all", "rest-project"})
    public Response createSpace(Space space) {
        logger.debug("-----createSpace--- , Space name: {}, Space owner: {}, Default group id : {}", new Object[]{space.getName(), space.getOwner(), space.getDefaultGroupId()});
        String id = this.newId();
        SpaceRequest jobRequest = new SpaceRequest();
        jobRequest.setStatus(JobStatus.ACCEPTED);
        jobRequest.setJobId(id);
        jobRequest.setSpaceName(space.getName());
        jobRequest.setOwner(space.getOwner());
        jobRequest.setDefaultGroupId(space.getDefaultGroupId());
        this.addAcceptedJobResult(id);
        this.jobRequestObserver.createSpaceRequest(jobRequest);
        return this.createAcceptedStatusResponse((JobRequest)jobRequest);
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/spaces/{spaceName}")
    @RolesAllowed(value={"rest-all", "rest-project"})
    public Response deleteSpace(@PathParam(value="spaceName") String spaceName) {
        logger.debug("-----deleteSpace--- , Space name: {}", (Object)spaceName);
        this.assertObjectExists(this.organizationalUnitService.getOrganizationalUnit(spaceName), "space", spaceName);
        String id = this.newId();
        RemoveSpaceRequest jobRequest = new RemoveSpaceRequest();
        jobRequest.setStatus(JobStatus.ACCEPTED);
        jobRequest.setJobId(id);
        jobRequest.setSpaceName(spaceName);
        this.addAcceptedJobResult(id);
        this.jobRequestObserver.removeSpaceRequest(jobRequest);
        return this.createAcceptedStatusResponse((JobRequest)jobRequest);
    }

    protected void assertObjectExists(Object o, String objectInfo, String objectName) {
        if (o == null) {
            throw new WebApplicationException(String.format("Could not find %s with name %s.", objectInfo, objectName), Response.status((Response.Status)Response.Status.NOT_FOUND).build());
        }
    }

    protected Response createAcceptedStatusResponse(JobRequest jobRequest) {
        return Response.status((Response.Status)Response.Status.ACCEPTED).entity((Object)jobRequest).variant(this.defaultVariant).build();
    }

    private String newId() {
        return "" + System.currentTimeMillis() + "-" + this.counter.incrementAndGet();
    }
}

