/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.rest.backend;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.project.builder.model.BuildMessage;
import org.guvnor.common.services.project.builder.model.BuildResults;
import org.guvnor.common.services.project.builder.service.BuildService;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.common.services.project.model.MavenRepositoryMetadata;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.common.services.project.service.GAVAlreadyExistsException;
import org.guvnor.common.services.project.service.WorkspaceProjectService;
import org.guvnor.common.services.shared.test.TestResultMessage;
import org.guvnor.common.services.shared.test.TestRunnerService;
import org.guvnor.rest.client.CloneProjectRequest;
import org.guvnor.rest.client.JobResult;
import org.guvnor.rest.client.JobStatus;
import org.guvnor.structure.contributors.Contributor;
import org.guvnor.structure.contributors.ContributorType;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.guvnor.structure.organizationalunit.impl.OrganizationalUnitImpl;
import org.guvnor.structure.repositories.Branch;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryEnvironmentConfigurations;
import org.guvnor.structure.repositories.RepositoryService;
import org.guvnor.structure.repositories.impl.git.GitRepository;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.FileAlreadyExistsException;
import org.uberfire.java.nio.file.Path;
import org.uberfire.spaces.Space;
import org.uberfire.spaces.SpacesAPI;

@ApplicationScoped
public class JobRequestHelper {
    private static final Logger logger = LoggerFactory.getLogger(JobRequestHelper.class);
    @Inject
    private RepositoryService repositoryService;
    @Inject
    private WorkspaceProjectService workspaceProjectService;
    @Inject
    private BuildService buildService;
    @Inject
    private SpacesAPI spacesAPI;
    @Inject
    @Named(value="ioStrategy")
    private IOService ioSystemService;
    @Inject
    private OrganizationalUnitService organizationalUnitService;
    @Inject
    private TestRunnerService testService;

    public JobResult cloneProject(String jobId, String spaceName, CloneProjectRequest cloneProjectRequest) {
        JobResult result = new JobResult();
        result.setJobId(jobId);
        String scheme = "git";
        OrganizationalUnit orgUnit = this.organizationalUnitService.getOrganizationalUnit(spaceName);
        if (orgUnit == null) {
            result.setStatus(JobStatus.BAD_REQUEST);
            result.setResult("Space '" + spaceName + "' does not exist!");
            return result;
        }
        if (cloneProjectRequest.getName() == null || "".equals(cloneProjectRequest.getName()) || cloneProjectRequest.getGitURL() == null || "".equals(cloneProjectRequest.getGitURL())) {
            result.setStatus(JobStatus.BAD_REQUEST);
            result.setResult("Repository name and GitURL must be provided");
        }
        RepositoryEnvironmentConfigurations configuration = new RepositoryEnvironmentConfigurations();
        if (cloneProjectRequest.getUserName() != null && !"".equals(cloneProjectRequest.getUserName())) {
            configuration.setUserName(cloneProjectRequest.getUserName());
        }
        if (cloneProjectRequest.getPassword() != null && !"".equals(cloneProjectRequest.getPassword())) {
            configuration.setPassword(cloneProjectRequest.getPassword());
        }
        configuration.setInit(false);
        configuration.setMirror(false);
        configuration.setOrigin(cloneProjectRequest.getGitURL());
        Repository newlyCreatedRepo = this.repositoryService.createRepository(orgUnit, "git", cloneProjectRequest.getName(), configuration);
        if (newlyCreatedRepo != null) {
            result.setStatus(JobStatus.SUCCESS);
            result.setResult("Alias: " + newlyCreatedRepo.getAlias() + ", Scheme: " + newlyCreatedRepo.getScheme() + ", Uri: " + newlyCreatedRepo.getUri());
        } else {
            result.setStatus(JobStatus.FAIL);
        }
        return result;
    }

    public JobResult createProject(String jobId, String spaceName, String projectName, String projectGroupId, String projectVersion, String projectDescription) {
        JobResult result = new JobResult();
        result.setJobId(jobId);
        OrganizationalUnit organizationalUnit = this.organizationalUnitService.getOrganizationalUnit(spaceName);
        if (organizationalUnit == null) {
            result.setStatus(JobStatus.RESOURCE_NOT_EXIST);
            result.setResult("Space [" + spaceName + "] does not exist");
        } else {
            if (projectGroupId == null || projectGroupId.trim().isEmpty()) {
                projectGroupId = projectName;
            }
            if (projectVersion == null || projectVersion.trim().isEmpty()) {
                projectVersion = "1.0";
            }
            POM pom = new POM();
            pom.getGav().setArtifactId(projectName);
            pom.getGav().setGroupId(projectGroupId);
            pom.getGav().setVersion(projectVersion);
            pom.setDescription(projectDescription);
            pom.setName(projectName);
            try {
                this.workspaceProjectService.newProject(organizationalUnit, pom);
            }
            catch (GAVAlreadyExistsException gae) {
                result.setStatus(JobStatus.DUPLICATE_RESOURCE);
                result.setResult("Project's GAV [" + gae.getGAV().toString() + "] already exists at [" + this.toString(gae.getRepositories()) + "]");
                return result;
            }
            catch (FileAlreadyExistsException e) {
                result.setStatus(JobStatus.DUPLICATE_RESOURCE);
                result.setResult("Project [" + projectName + "] already exists");
                return result;
            }
            result.setStatus(JobStatus.SUCCESS);
        }
        return result;
    }

    private String toString(Set<MavenRepositoryMetadata> repositories) {
        StringBuilder sb = new StringBuilder();
        for (MavenRepositoryMetadata md : repositories) {
            sb.append(md.getId()).append(" : ").append(md.getUrl()).append(" : ").append(md.getSource()).append(", ");
        }
        sb.delete(sb.length() - 2, sb.length() - 1);
        return sb.toString();
    }

    public JobResult deleteProject(String jobId, String spaceName, String projectName) {
        JobResult result = new JobResult();
        result.setJobId(jobId);
        Space space = this.spacesAPI.getSpace(spaceName);
        WorkspaceProject workspaceProject = this.workspaceProjectService.resolveProject(space, projectName);
        if (workspaceProject == null) {
            result.setStatus(JobStatus.RESOURCE_NOT_EXIST);
            result.setResult("Project [" + projectName + "] does not exist");
            return result;
        }
        try {
            this.repositoryService.removeRepository(space, workspaceProject.getRepository().getAlias());
        }
        catch (Exception e) {
            result.setStatus(JobStatus.FAIL);
            result.setResult("Project [" + projectName + "] could not be deleted: " + e.getMessage());
            logger.error("Unable to delete project '" + projectName + "': " + e.getMessage(), (Throwable)e);
            return result;
        }
        result.setStatus(JobStatus.SUCCESS);
        return result;
    }

    public JobResult compileProject(String jobId, String spaceName, String projectName, String branchName) {
        WorkspaceProject workspaceProject = this.workspaceProjectService.resolveProject(this.spacesAPI.getSpace(spaceName), projectName, branchName);
        if (workspaceProject == null) {
            return this.projectDoesNotExistError(jobId, projectName);
        }
        Module module = workspaceProject.getMainModule();
        if (module == null) {
            if (branchName == null) {
                return this.projectHasNoMainModuleError(jobId, projectName);
            }
            return this.projectHasNoModuleError(jobId, projectName, branchName);
        }
        BuildResults buildResults = this.buildService.build(module);
        JobResult result = new JobResult();
        result.setJobId(jobId);
        result.setDetailedResult(this.buildResultsToDetailedStringMessages(buildResults.getMessages()));
        result.setStatus(buildResults.getErrorMessages().isEmpty() ? JobStatus.SUCCESS : JobStatus.FAIL);
        return result;
    }

    private List<String> buildResultsToDetailedStringMessages(List<BuildMessage> messages) {
        ArrayList<String> result = new ArrayList<String>();
        for (BuildMessage message : messages) {
            String detailedStringMessage = "level:" + message.getLevel() + ", path:" + message.getPath() + ", text:" + message.getText();
            result.add(detailedStringMessage);
        }
        return result;
    }

    public JobResult installProject(String jobId, String spaceName, String projectName, String branchName) {
        PortablePreconditions.checkNotNull((String)"jobId", (Object)jobId);
        PortablePreconditions.checkNotNull((String)"spaceName", (Object)spaceName);
        PortablePreconditions.checkNotNull((String)"projectName", (Object)projectName);
        JobResult result = new JobResult();
        result.setJobId(jobId);
        OrganizationalUnit organizationalUnit = this.organizationalUnitService.getOrganizationalUnit(spaceName);
        if (organizationalUnit == null) {
            result.setStatus(JobStatus.RESOURCE_NOT_EXIST);
            result.setResult("Space [" + spaceName + "] does not exist");
            return result;
        }
        WorkspaceProject workspaceProject = this.workspaceProjectService.resolveProject(this.spacesAPI.getSpace(spaceName), projectName, branchName);
        if (workspaceProject == null) {
            return this.projectDoesNotExistError(jobId, projectName);
        }
        Module module = workspaceProject.getMainModule();
        if (module == null) {
            if (branchName == null) {
                return this.projectHasNoMainModuleError(jobId, projectName);
            }
            return this.projectHasNoModuleError(jobId, projectName, branchName);
        }
        try {
            BuildResults buildResults = this.buildService.buildAndDeploy(module);
            result.setDetailedResult(buildResults == null ? null : this.deployResultToDetailedStringMessages(buildResults));
            result.setStatus(buildResults != null && buildResults.getErrorMessages().isEmpty() ? JobStatus.SUCCESS : JobStatus.FAIL);
        }
        catch (Throwable t) {
            Optional<GAVAlreadyExistsException> gaeOpt = this.findCause(t, GAVAlreadyExistsException.class);
            if (gaeOpt.isPresent()) {
                GAVAlreadyExistsException gae = gaeOpt.get();
                result.setStatus(JobStatus.DUPLICATE_RESOURCE);
                result.setResult("Project's GAV [" + gae.getGAV() + "] already exists at [" + this.toString(gae.getRepositories()) + "]");
            }
            ArrayList<String> errorResult = new ArrayList<String>();
            errorResult.add(t.getMessage());
            result.setDetailedResult(errorResult);
            result.setStatus(JobStatus.FAIL);
        }
        return result;
    }

    private List<String> deployResultToDetailedStringMessages(BuildResults deployResult) {
        GAV gav = deployResult.getGAV();
        List<String> result = this.buildResultsToDetailedStringMessages(deployResult.getErrorMessages());
        String detailedStringMessage = "artifactID:" + gav.getArtifactId() + ", groupId:" + gav.getGroupId() + ", version:" + gav.getVersion();
        result.add(detailedStringMessage);
        return result;
    }

    public JobResult testProject(String jobId, String spaceName, String projectName, String branchName) {
        JobResult result = new JobResult();
        result.setJobId(jobId);
        WorkspaceProject workspaceProject = this.workspaceProjectService.resolveProject(this.spacesAPI.getSpace(spaceName), projectName, branchName);
        if (workspaceProject == null) {
            return this.projectDoesNotExistError(jobId, projectName);
        }
        Module module = workspaceProject.getMainModule();
        if (module == null) {
            if (branchName == null) {
                return this.projectHasNoMainModuleError(jobId, projectName);
            }
            return this.projectHasNoModuleError(jobId, projectName, branchName);
        }
        this.testService.runAllTests("JobRequestHelper", module.getPomXMLPath(), this.getCustomTestResultEvent(result));
        return result;
    }

    private Event<TestResultMessage> getCustomTestResultEvent(final JobResult result) {
        return new Event<TestResultMessage>(){

            public void fire(TestResultMessage event) {
                result.setDetailedResult(event.getResultStrings());
                result.setStatus(event.wasSuccessful() ? JobStatus.SUCCESS : JobStatus.FAIL);
            }

            public Event<TestResultMessage> select(Annotation ... qualifiers) {
                return null;
            }

            public <U extends TestResultMessage> Event<U> select(Class<U> subtype, Annotation ... qualifiers) {
                return null;
            }
        };
    }

    public JobResult deployProject(String jobId, String spaceName, String projectName, String branchName) {
        JobResult result = new JobResult();
        result.setJobId(jobId);
        WorkspaceProject workspaceProject = this.workspaceProjectService.resolveProject(this.spacesAPI.getSpace(spaceName), projectName, branchName);
        if (workspaceProject == null) {
            return this.projectDoesNotExistError(jobId, projectName);
        }
        Module module = workspaceProject.getMainModule();
        if (module == null) {
            if (branchName == null) {
                return this.projectHasNoMainModuleError(jobId, projectName);
            }
            return this.projectHasNoModuleError(jobId, projectName, branchName);
        }
        try {
            BuildResults buildResults = this.buildService.buildAndDeploy(module);
            result.setDetailedResult(buildResults == null ? null : this.deployResultToDetailedStringMessages(buildResults));
            result.setStatus(buildResults != null && buildResults.getErrorMessages().isEmpty() ? JobStatus.SUCCESS : JobStatus.FAIL);
        }
        catch (RuntimeException ex) {
            GAVAlreadyExistsException gae = this.findCause(ex, GAVAlreadyExistsException.class).orElseThrow(() -> ex);
            result.setStatus(JobStatus.DUPLICATE_RESOURCE);
            result.setResult("Project's GAV [" + gae.getGAV() + "] already exists at [" + this.toString(gae.getRepositories()) + "]");
            return result;
        }
        return result;
    }

    public JobResult removeSpace(String jobId, String spaceName) {
        JobResult result = new JobResult();
        result.setJobId(jobId);
        if (spaceName == null) {
            result.setStatus(JobStatus.BAD_REQUEST);
            result.setResult("Space name must be provided");
            return result;
        }
        try {
            this.organizationalUnitService.removeOrganizationalUnit(spaceName);
            result.setStatus(JobStatus.SUCCESS);
        }
        catch (Exception e) {
            result.setStatus(JobStatus.FAIL);
            String errMsg = e.getClass().getSimpleName() + " thrown when trying to remove '" + spaceName + "': " + e.getMessage();
            result.setResult(errMsg);
            logger.error(errMsg, (Throwable)e);
        }
        return result;
    }

    public JobResult createSpace(String jobId, String spaceName, String spaceOwner, String defaultGroupId) {
        JobResult result = new JobResult();
        result.setJobId(jobId);
        if (spaceName == null || spaceOwner == null) {
            result.setStatus(JobStatus.BAD_REQUEST);
            result.setResult("Space name and owner must be provided");
            return result;
        }
        String _defaultGroupId = null;
        if (defaultGroupId == null || defaultGroupId.trim().isEmpty()) {
            _defaultGroupId = this.organizationalUnitService.getSanitizedDefaultGroupId(spaceName);
            logger.warn("No default group id was provided, reverting to the space unit name");
        } else {
            if (!this.organizationalUnitService.isValidGroupId(defaultGroupId).booleanValue()) {
                result.setStatus(JobStatus.BAD_REQUEST);
                result.setResult("Invalid default group id, only alphanumerical characters are admitted, as well as '\"_\"', '\"-\"' or '\".\"'.");
                return result;
            }
            _defaultGroupId = defaultGroupId;
        }
        OrganizationalUnit organizationalUnit = this.organizationalUnitService.getOrganizationalUnit(spaceName);
        if (organizationalUnit != null) {
            result.setStatus(JobStatus.BAD_REQUEST);
            result.setResult("Space with name " + spaceName + " already exists");
            return result;
        }
        organizationalUnit = this.organizationalUnitService.createOrganizationalUnit(spaceName, _defaultGroupId, Collections.emptyList(), Collections.singletonList(new Contributor(spaceOwner, ContributorType.OWNER)));
        if (organizationalUnit != null) {
            result.setResult("Space " + organizationalUnit.getName() + " is created successfully.");
            result.setStatus(JobStatus.SUCCESS);
        } else {
            result.setStatus(JobStatus.FAIL);
        }
        return result;
    }

    public JobResult addBranch(String jobId, String spaceName, String projectName, String newBranchName, String baseBranchName, String userIdentifier) {
        JobResult result = new JobResult();
        result.setJobId(jobId);
        WorkspaceProject project = this.workspaceProjectService.resolveProject(this.spacesAPI.getSpace(spaceName), projectName);
        if (project == null) {
            result.setStatus(JobStatus.RESOURCE_NOT_EXIST);
            result.setResult("Project [" + projectName + "] does not exist");
            return result;
        }
        try {
            this.workspaceProjectService.addBranch(newBranchName, baseBranchName, project, userIdentifier);
            result.setStatus(JobStatus.SUCCESS);
        }
        catch (FileAlreadyExistsException e) {
            result.setStatus(JobStatus.DUPLICATE_RESOURCE);
            result.setResult("Branch [" + newBranchName + "] already exists.");
        }
        catch (Exception e) {
            result.setStatus(JobStatus.FAIL);
            result.setResult(e.getMessage());
        }
        return result;
    }

    public JobResult removeBranch(String jobId, String spaceName, String projectName, String branchName, String userIdentifier) {
        JobResult result = new JobResult();
        result.setJobId(jobId);
        WorkspaceProject project = this.workspaceProjectService.resolveProject(this.spacesAPI.getSpace(spaceName), projectName);
        if (project == null) {
            result.setStatus(JobStatus.RESOURCE_NOT_EXIST);
            result.setResult("Project [" + projectName + "] does not exist");
            return result;
        }
        try {
            this.workspaceProjectService.removeBranch(branchName, project, userIdentifier);
            result.setStatus(JobStatus.SUCCESS);
        }
        catch (Exception e) {
            result.setStatus(JobStatus.FAIL);
            result.setResult(e.getMessage());
        }
        return result;
    }

    public JobResult addProjectToSpace(String jobId, String spaceName, String projectName) {
        JobResult result = new JobResult();
        result.setJobId(jobId);
        if (spaceName == null || projectName == null) {
            result.setStatus(JobStatus.BAD_REQUEST);
            result.setResult("Space name and Project name must be provided");
            return result;
        }
        Path projectRootPath = this.getProjectRootPath(this.spacesAPI.getSpace(spaceName), projectName);
        if (projectRootPath == null) {
            result.setStatus(JobStatus.RESOURCE_NOT_EXIST);
            result.setResult("Project [" + projectName + "] does not exist");
            return result;
        }
        OrganizationalUnitImpl organizationalUnit = new OrganizationalUnitImpl(spaceName, null);
        GitRepository repo = new GitRepository(projectName, this.spacesAPI.getSpace(organizationalUnit.getName()));
        try {
            this.organizationalUnitService.addRepository((OrganizationalUnit)organizationalUnit, (Repository)repo);
        }
        catch (IllegalArgumentException e) {
            result.setStatus(JobStatus.BAD_REQUEST);
            result.setResult("Space " + organizationalUnit.getName() + " not found");
            return result;
        }
        result.setStatus(JobStatus.SUCCESS);
        return result;
    }

    private Path getProjectRootPath(Space space, String projectName) {
        Repository repository = this.repositoryService.getRepositoryFromSpace(space, projectName);
        if (repository == null || !repository.getDefaultBranch().isPresent()) {
            return null;
        }
        return Paths.convert((org.uberfire.backend.vfs.Path)((Branch)repository.getDefaultBranch().get()).getPath());
    }

    private <T> Optional<T> findCause(Throwable t, Class<T> causeClass) {
        if (t == null) {
            return Optional.empty();
        }
        if (t.getClass().equals(causeClass)) {
            return Optional.of(t);
        }
        return this.findCause(t.getCause(), causeClass);
    }

    private JobResult projectDoesNotExistError(String jobId, String projectName) {
        JobResult jobResult = new JobResult();
        jobResult.setJobId(jobId);
        jobResult.setStatus(JobStatus.RESOURCE_NOT_EXIST);
        jobResult.setResult("Project [" + projectName + "] does not exist.");
        return jobResult;
    }

    private JobResult projectHasNoMainModuleError(String jobId, String projectName) {
        JobResult jobResult = new JobResult();
        jobResult.setJobId(jobId);
        jobResult.setStatus(JobStatus.RESOURCE_NOT_EXIST);
        jobResult.setResult("Project [" + projectName + "] has no main module.");
        return jobResult;
    }

    private JobResult projectHasNoModuleError(String jobId, String projectName, String branchName) {
        JobResult jobResult = new JobResult();
        jobResult.setJobId(jobId);
        jobResult.setStatus(JobStatus.RESOURCE_NOT_EXIST);
        jobResult.setResult("Project [" + projectName + "] has no module [" + branchName + "].");
        return jobResult;
    }
}

