/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.rest.backend;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import javax.enterprise.event.Event;
import org.guvnor.common.services.project.builder.model.BuildMessage;
import org.guvnor.common.services.project.builder.model.BuildResults;
import org.guvnor.common.services.project.builder.service.BuildService;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.common.services.project.service.ModuleService;
import org.guvnor.common.services.project.service.WorkspaceProjectService;
import org.guvnor.common.services.shared.test.Failure;
import org.guvnor.common.services.shared.test.TestResultMessage;
import org.guvnor.common.services.shared.test.TestRunnerService;
import org.guvnor.rest.backend.JobRequestHelper;
import org.guvnor.rest.client.CloneProjectRequest;
import org.guvnor.rest.client.JobResult;
import org.guvnor.rest.client.JobStatus;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.guvnor.structure.repositories.Branch;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryEnvironmentConfigurations;
import org.guvnor.structure.repositories.RepositoryService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.backend.vfs.Path;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.spaces.Space;
import org.uberfire.spaces.SpacesAPI;

@RunWith(value=MockitoJUnitRunner.class)
public class JobRequestHelperTest {
    @InjectMocks
    JobRequestHelper helper;
    @Mock
    Repository repository;
    @Captor
    ArgumentCaptor<Event<TestResultMessage>> captor;
    @Mock
    private TestRunnerService testService;
    @Mock
    private BuildService buildService;
    @Mock
    private RepositoryService repositoryService;
    @Mock
    private ModuleService<MyModule> moduleService;
    @Mock
    private WorkspaceProjectService workspaceProjectService;
    @Mock
    private WorkspaceProject workspaceProject;
    @Mock
    private SpacesAPI spaces;
    @Mock
    private OrganizationalUnitService organizationalUnitService;
    @Mock
    private SessionInfo sessionInfo;
    private Space space = new Space("space");
    @Captor
    ArgumentCaptor<RepositoryEnvironmentConfigurations> repositoryEnvironmentConfigurationsCaptor;

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.workspaceProjectService.resolveProject((Space)Matchers.eq((Object)this.space), (String)Matchers.eq((Object)"project"))).thenReturn((Object)this.workspaceProject);
        Mockito.when((Object)this.workspaceProjectService.resolveProject((Space)Matchers.eq((Object)this.space), (String)Matchers.eq((Object)"project"), (String)Matchers.any())).thenReturn((Object)this.workspaceProject);
        Mockito.when((Object)this.repositoryService.getRepositoryFromSpace((Space)Matchers.eq((Object)this.space), (String)Matchers.eq((Object)"repositoryAlias"))).thenReturn((Object)this.repository);
        Mockito.when((Object)this.spaces.getSpace((String)Matchers.eq((Object)"space"))).thenReturn((Object)this.space);
    }

    @Test
    public void cloneProject() throws Exception {
        ((OrganizationalUnitService)Mockito.doReturn((Object)Mockito.mock(OrganizationalUnit.class)).when((Object)this.organizationalUnitService)).getOrganizationalUnit("space");
        CloneProjectRequest cloneProjectRequest = new CloneProjectRequest();
        cloneProjectRequest.setName("myName");
        this.helper.cloneProject("jobId", "space", cloneProjectRequest);
        ((RepositoryService)Mockito.verify((Object)this.repositoryService)).createRepository((OrganizationalUnit)Matchers.any(), (String)Matchers.eq((Object)"git"), (String)Matchers.eq((Object)"myName"), (RepositoryEnvironmentConfigurations)this.repositoryEnvironmentConfigurationsCaptor.capture());
        RepositoryEnvironmentConfigurations config = (RepositoryEnvironmentConfigurations)this.repositoryEnvironmentConfigurationsCaptor.getValue();
        Assert.assertEquals((Object)false, (Object)config.getMirror());
        Assert.assertEquals((Object)false, (Object)config.getInit());
    }

    @Test
    public void resourceDoesNotExist() throws Exception {
        JobResult jobResult = this.helper.testProject(null, null, null, null);
        Assert.assertEquals((Object)JobStatus.RESOURCE_NOT_EXIST, (Object)jobResult.getStatus());
    }

    @Test
    public void projectDoesNotExist() throws Exception {
        Path path = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)path.getFileName()).thenReturn((Object)"");
        Mockito.when((Object)path.toURI()).thenReturn((Object)"file://project/");
        Branch masterBranch = new Branch("master", path);
        Mockito.when((Object)this.repository.getDefaultBranch()).thenReturn(Optional.of(masterBranch));
        Mockito.when((Object)this.repository.getBranch("master")).thenReturn(Optional.of(masterBranch));
        JobResult jobResult = this.helper.testProject(null, this.space.getName(), "project", null);
        Assert.assertEquals((Object)JobStatus.RESOURCE_NOT_EXIST, (Object)jobResult.getStatus());
    }

    @Test
    public void allTestsPass() throws Exception {
        this.whenProjectExists();
        this.thenExpectMessageWithStatus(new TestResultMessage("JobRequestHelper", 10, 1000L, Collections.emptyList()), JobStatus.SUCCESS);
    }

    @Test
    public void testsFail() throws Exception {
        this.whenProjectExists();
        ArrayList<Failure> failures = new ArrayList<Failure>();
        failures.add(new Failure());
        this.thenExpectMessageWithStatus(new TestResultMessage("JobRequestHelper", 10, 1000L, failures), JobStatus.FAIL);
    }

    @Test
    public void testCompileProject() {
        this.whenProjectExists();
        BuildResults buildResults = (BuildResults)Mockito.mock(BuildResults.class);
        Mockito.when((Object)buildResults.getMessages()).thenReturn(new ArrayList());
        Mockito.when((Object)this.buildService.build((Module)Matchers.any())).thenReturn((Object)buildResults);
        JobResult jobResult = this.helper.compileProject(null, this.space.getName(), "project", null);
        Assert.assertEquals((Object)JobStatus.SUCCESS, (Object)jobResult.getStatus());
    }

    @Test
    public void testCompileProjectFail() {
        this.whenProjectExists();
        BuildResults buildResults = (BuildResults)Mockito.mock(BuildResults.class);
        Mockito.when((Object)buildResults.getMessages()).thenReturn(new ArrayList());
        Mockito.when((Object)buildResults.getErrorMessages()).thenReturn(Arrays.asList((BuildMessage)Mockito.mock(BuildMessage.class)));
        Mockito.when((Object)this.buildService.build((Module)Matchers.any())).thenReturn((Object)buildResults);
        JobResult jobResult = this.helper.compileProject(null, this.space.getName(), "project", null);
        Assert.assertEquals((Object)JobStatus.FAIL, (Object)jobResult.getStatus());
    }

    @Test
    public void testInstallProject() {
        this.whenProjectExists();
        ((OrganizationalUnitService)Mockito.doReturn((Object)Mockito.mock(OrganizationalUnit.class)).when((Object)this.organizationalUnitService)).getOrganizationalUnit("space");
        BuildResults buildResults = (BuildResults)Mockito.mock(BuildResults.class);
        Mockito.when((Object)buildResults.getGAV()).thenReturn(Mockito.mock(GAV.class));
        Mockito.when((Object)this.buildService.buildAndDeploy((Module)Matchers.any())).thenReturn((Object)buildResults);
        JobResult jobResult = this.helper.installProject("job123", this.space.getName(), "project", null);
        Assert.assertEquals((Object)JobStatus.SUCCESS, (Object)jobResult.getStatus());
    }

    @Test
    public void testInstallProjectFail() {
        this.whenProjectExists();
        ((OrganizationalUnitService)Mockito.doReturn((Object)Mockito.mock(OrganizationalUnit.class)).when((Object)this.organizationalUnitService)).getOrganizationalUnit("space");
        BuildResults buildResults = (BuildResults)Mockito.mock(BuildResults.class);
        Mockito.when((Object)buildResults.getGAV()).thenReturn(Mockito.mock(GAV.class));
        Mockito.when((Object)buildResults.getErrorMessages()).thenReturn(Arrays.asList((BuildMessage)Mockito.mock(BuildMessage.class)));
        Mockito.when((Object)this.buildService.buildAndDeploy((Module)Matchers.any())).thenReturn((Object)buildResults);
        JobResult jobResult = this.helper.installProject("job123", this.space.getName(), "project", null);
        Assert.assertEquals((Object)JobStatus.FAIL, (Object)jobResult.getStatus());
    }

    @Test
    public void testDeployProject() {
        this.whenProjectExists();
        BuildResults buildResults = (BuildResults)Mockito.mock(BuildResults.class);
        Mockito.when((Object)buildResults.getGAV()).thenReturn(Mockito.mock(GAV.class));
        Mockito.when((Object)this.buildService.buildAndDeploy((Module)Matchers.any())).thenReturn((Object)buildResults);
        JobResult jobResult = this.helper.deployProject(null, this.space.getName(), "project", null);
        Assert.assertEquals((Object)JobStatus.SUCCESS, (Object)jobResult.getStatus());
    }

    @Test
    public void testDeployProjectFail() {
        this.whenProjectExists();
        BuildResults buildResults = (BuildResults)Mockito.mock(BuildResults.class);
        Mockito.when((Object)buildResults.getGAV()).thenReturn(Mockito.mock(GAV.class));
        Mockito.when((Object)buildResults.getErrorMessages()).thenReturn(Arrays.asList((BuildMessage)Mockito.mock(BuildMessage.class)));
        Mockito.when((Object)this.buildService.buildAndDeploy((Module)Matchers.any())).thenReturn((Object)buildResults);
        JobResult jobResult = this.helper.deployProject(null, this.space.getName(), "project", null);
        Assert.assertEquals((Object)JobStatus.FAIL, (Object)jobResult.getStatus());
    }

    @Test
    public void testAddBranchProjectDoesNotExists() {
        Mockito.when((Object)this.workspaceProjectService.resolveProject((Space)Matchers.eq((Object)this.space), (String)Matchers.eq((Object)"project"))).thenReturn(null);
        JobResult jobResult = this.helper.addBranch(null, this.space.getName(), "project", "new-branch", "ref-branch", "user");
        Assert.assertEquals((Object)JobStatus.RESOURCE_NOT_EXIST, (Object)jobResult.getStatus());
    }

    @Test
    public void testAddBranchFail() {
        ((WorkspaceProjectService)Mockito.doThrow(Exception.class).when((Object)this.workspaceProjectService)).addBranch((String)Matchers.any(), (String)Matchers.any(), (WorkspaceProject)Matchers.any(), (String)Matchers.any());
        JobResult jobResult = this.helper.addBranch(null, this.space.getName(), "project", "new-branch", "ref-branch", "user");
        Assert.assertEquals((Object)JobStatus.FAIL, (Object)jobResult.getStatus());
    }

    @Test
    public void testAddBranch() {
        JobResult jobResult = this.helper.addBranch(null, this.space.getName(), "project", "new-branch", "ref-branch", "user");
        Assert.assertEquals((Object)JobStatus.SUCCESS, (Object)jobResult.getStatus());
    }

    @Test
    public void testCreateSpace() {
        Mockito.when((Object)this.organizationalUnitService.isValidGroupId("org.space.newspace")).thenReturn((Object)true);
        Mockito.when((Object)this.organizationalUnitService.createOrganizationalUnit((String)Matchers.any(), (String)Matchers.any(), (Collection)Matchers.any(), (Collection)Matchers.any(), (String)Matchers.any())).thenReturn(Mockito.mock(OrganizationalUnit.class));
        JobResult jobResult = this.helper.createSpace(null, this.space.getName(), "this is a new space", "admin", "org.space.newspace");
        Assert.assertEquals((Object)JobStatus.SUCCESS, (Object)jobResult.getStatus());
    }

    @Test
    public void testUpdateSpace() {
        Mockito.when((Object)this.organizationalUnitService.isValidGroupId("org.space.newspace")).thenReturn((Object)true);
        Mockito.when((Object)this.organizationalUnitService.getOrganizationalUnit(this.space.getName())).thenReturn(Mockito.mock(OrganizationalUnit.class));
        Mockito.when((Object)this.organizationalUnitService.updateOrganizationalUnit(Matchers.anyString(), Matchers.anyString(), (Collection)Matchers.any(), Matchers.anyString())).thenReturn(Mockito.mock(OrganizationalUnit.class));
        JobResult jobResult = this.helper.updateSpace(null, this.space.getName(), "this is a new space", "admin", "org.space.newspace");
        Assert.assertEquals((Object)JobStatus.SUCCESS, (Object)jobResult.getStatus());
    }

    @Test
    public void testRemoveSpace() {
        JobResult jobResult = this.helper.removeSpace(null, this.space.getName());
        Assert.assertEquals((Object)JobStatus.SUCCESS, (Object)jobResult.getStatus());
    }

    @Test
    public void testRemoveBranchProjectDoesNotExists() {
        Mockito.when((Object)this.workspaceProjectService.resolveProject((Space)Matchers.eq((Object)this.space), (String)Matchers.eq((Object)"project"))).thenReturn(null);
        JobResult jobResult = this.helper.removeBranch(null, this.space.getName(), "project", "new-branch", "user");
        Assert.assertEquals((Object)JobStatus.RESOURCE_NOT_EXIST, (Object)jobResult.getStatus());
    }

    @Test
    public void testRemoveBranchFail() {
        ((WorkspaceProjectService)Mockito.doThrow(Exception.class).when((Object)this.workspaceProjectService)).removeBranch((String)Matchers.any(), (WorkspaceProject)Matchers.any(), (String)Matchers.any());
        JobResult jobResult = this.helper.removeBranch(null, this.space.getName(), "project", "new-branch", "user");
        Assert.assertEquals((Object)JobStatus.FAIL, (Object)jobResult.getStatus());
    }

    @Test
    public void testRemoveBranch() {
        JobResult jobResult = this.helper.removeBranch(null, this.space.getName(), "project", "new-branch", "user");
        Assert.assertEquals((Object)JobStatus.SUCCESS, (Object)jobResult.getStatus());
    }

    private void thenExpectMessageWithStatus(TestResultMessage message, JobStatus status) {
        JobResult jobResult = this.helper.testProject(null, this.space.getName(), "project", null);
        ((TestRunnerService)Mockito.verify((Object)this.testService)).runAllTests((String)Matchers.eq((Object)"JobRequestHelper"), (Path)Matchers.any(Path.class), (Event)this.captor.capture());
        ((Event)this.captor.getValue()).fire((Object)message);
        Assert.assertEquals((Object)status, (Object)jobResult.getStatus());
    }

    private void whenProjectExists() {
        Mockito.when((Object)this.workspaceProject.getMainModule()).thenReturn(Mockito.mock(MyModule.class));
    }

    class MyModule
    extends Module {
        MyModule() {
        }
    }
}

