/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.rest.backend.cmd;

import java.util.Locale;
import java.util.Map;
import org.guvnor.rest.backend.JobRequestHelper;
import org.guvnor.rest.backend.JobResultManager;
import org.guvnor.rest.backend.cmd.AbstractJobCommand;
import org.guvnor.rest.client.CreateProjectJobRequest;
import org.guvnor.rest.client.JobRequest;
import org.guvnor.rest.client.JobResult;
import org.guvnor.rest.client.JobStatus;
import org.guvnor.structure.backend.LocaleContext;

public class CreateProjectCmd
extends AbstractJobCommand {
    public CreateProjectCmd(JobRequestHelper jobRequestHelper, JobResultManager jobResultManager, Map<String, Object> context) {
        super(jobRequestHelper, jobResultManager, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JobResult internalExecute(JobRequest request) throws Exception {
        JobStatus jobStatus;
        JobRequestHelper helper = this.getHelper();
        CreateProjectJobRequest jobRequest = (CreateProjectJobRequest)request;
        LocaleContext.set((Locale)((Locale)this.context.get("acceptLanguage")));
        JobResult result = null;
        try {
            result = helper.createProject(jobRequest.getJobId(), jobRequest.getSpaceName(), jobRequest.getProjectName(), jobRequest.getProjectGroupId(), jobRequest.getProjectVersion(), jobRequest.getDescription());
            jobStatus = result != null ? result.getStatus() : JobStatus.SERVER_ERROR;
        }
        catch (Throwable throwable) {
            JobStatus status = result != null ? result.getStatus() : JobStatus.SERVER_ERROR;
            String groupId = jobRequest.getProjectGroupId() == null ? jobRequest.getProjectName() : jobRequest.getProjectGroupId();
            String version = jobRequest.getProjectVersion() == null ? "1.0" : jobRequest.getProjectVersion();
            logger.debug("-----createProject--- , SpaceName: {}, project : {}:{}:{} [{}]", new Object[]{jobRequest.getSpaceName(), jobRequest.getProjectName(), groupId, version, status});
            throw throwable;
        }
        JobStatus status = jobStatus;
        String groupId = jobRequest.getProjectGroupId() == null ? jobRequest.getProjectName() : jobRequest.getProjectGroupId();
        String version = jobRequest.getProjectVersion() == null ? "1.0" : jobRequest.getProjectVersion();
        logger.debug("-----createProject--- , SpaceName: {}, project : {}:{}:{} [{}]", new Object[]{jobRequest.getSpaceName(), jobRequest.getProjectName(), groupId, version, status});
        return result;
    }
}

