/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.rest.backend;

import java.util.Arrays;
import javax.ws.rs.core.Response;
import org.guvnor.common.services.project.service.WorkspaceProjectService;
import org.guvnor.rest.backend.ResourceTypePermissionValidator;
import org.guvnor.rest.backend.UserManagementResourceHelper;
import org.guvnor.rest.client.NewUser;
import org.guvnor.rest.client.PermissionResponse;
import org.guvnor.rest.client.UberfireRestResponse;
import org.guvnor.rest.client.UpdateSettingRequest;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.jboss.errai.security.shared.api.Group;
import org.jboss.errai.security.shared.api.GroupImpl;
import org.jboss.errai.security.shared.api.Role;
import org.jboss.errai.security.shared.api.RoleImpl;
import org.jboss.errai.security.shared.api.identity.User;
import org.jboss.errai.security.shared.api.identity.UserImpl;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.soup.commons.util.Lists;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.uberfire.backend.authz.AuthorizationService;
import org.uberfire.ext.security.management.api.exception.GroupNotFoundException;
import org.uberfire.ext.security.management.api.exception.SecurityManagementException;
import org.uberfire.ext.security.management.api.exception.UserNotFoundException;
import org.uberfire.ext.security.management.api.service.GroupManagerService;
import org.uberfire.ext.security.management.api.service.RoleManagerService;
import org.uberfire.ext.security.management.api.service.UserManagerService;
import org.uberfire.security.authz.AuthorizationPolicy;
import org.uberfire.security.authz.PermissionCollection;
import org.uberfire.security.authz.PermissionManager;
import org.uberfire.security.authz.VotingStrategy;

@RunWith(value=MockitoJUnitRunner.class)
public class UserManagementHelperTest {
    @InjectMocks
    private UserManagementResourceHelper helper;
    @Mock
    private GroupManagerService groupManagerService;
    @Mock
    private RoleManagerService roleManagerService;
    @Mock
    private UserManagerService userManagerService;
    @Mock
    private OrganizationalUnitService organizationalUnitService;
    @Mock
    private WorkspaceProjectService projectService;
    @Mock
    private ResourceTypePermissionValidator permissionValidator;
    @Mock
    private AuthorizationService authorizationService;
    @Mock
    private PermissionManager permissionManager;

    @Test
    public void testGroupNotFoundWhenUpdateGroupPermission() {
        ((GroupManagerService)Mockito.doThrow(GroupNotFoundException.class).when((Object)this.groupManagerService)).get("testGroup");
        UberfireRestResponse response = this.helper.updateGroupPermissions("testGroup", (UpdateSettingRequest)Mockito.mock(UpdateSettingRequest.class));
        Assert.assertEquals((Object)Response.Status.BAD_REQUEST, (Object)response.getStatus());
    }

    @Test
    public void testCreateGroup() {
        ((GroupManagerService)Mockito.doThrow(GroupNotFoundException.class).when((Object)this.groupManagerService)).get("testGroup");
        Mockito.when((Object)this.groupManagerService.create((Object)new GroupImpl("testGroup"))).thenReturn(Mockito.mock(Group.class));
        Mockito.when((Object)this.userManagerService.get("testUser")).thenReturn(Mockito.mock(User.class));
        UberfireRestResponse response = this.helper.createGroup("testGroup", Arrays.asList("testUser"));
        Assert.assertEquals((Object)Response.Status.OK, (Object)response.getStatus());
    }

    @Test
    public void testCreateGroupWithInvalidUser() {
        ((GroupManagerService)Mockito.doThrow(GroupNotFoundException.class).when((Object)this.groupManagerService)).get("testGroup");
        ((UserManagerService)Mockito.doThrow(UserNotFoundException.class).when((Object)this.userManagerService)).get("testUser");
        UberfireRestResponse response = this.helper.createGroup("testGroup", Arrays.asList("testUser"));
        Assert.assertEquals((Object)Response.Status.BAD_REQUEST, (Object)response.getStatus());
    }

    @Test
    public void testCreateUser() {
        ((UserManagerService)Mockito.doThrow(UserNotFoundException.class).when((Object)this.userManagerService)).get("testUser");
        Mockito.when((Object)this.userManagerService.create((Object)new UserImpl("testUser"))).thenReturn(Mockito.mock(User.class));
        NewUser newUser = new NewUser();
        newUser.setName("testUser");
        UberfireRestResponse response = this.helper.createUser(newUser);
        Assert.assertEquals((Object)Response.Status.OK, (Object)response.getStatus());
    }

    @Test
    public void testChangePassword() {
        ((UserManagerService)Mockito.doThrow(SecurityManagementException.class).when((Object)this.userManagerService)).changePassword("testUser", "testpassword");
        UberfireRestResponse response = this.helper.changePassword("testUser", "testpassword");
        Assert.assertEquals((Object)Response.Status.INTERNAL_SERVER_ERROR, (Object)response.getStatus());
    }

    @Test
    public void testCreateUserWithInvalidGroup() {
        ((GroupManagerService)Mockito.doThrow(GroupNotFoundException.class).when((Object)this.groupManagerService)).get("testGroup");
        NewUser newUser = new NewUser();
        newUser.setName("testUser");
        newUser.setGroups(new Lists.Builder().add((Object)"testGroup").build());
        UberfireRestResponse response = this.helper.createUser(newUser);
        Assert.assertEquals((Object)Response.Status.BAD_REQUEST, (Object)response.getStatus());
    }

    @Test
    public void testRemoveGroup() {
        UberfireRestResponse response = this.helper.removeGroup("testGroup");
        Assert.assertEquals((Object)Response.Status.OK, (Object)response.getStatus());
    }

    @Test
    public void testRemoveUser() {
        UberfireRestResponse response = this.helper.removeUser("testUser");
        Assert.assertEquals((Object)Response.Status.OK, (Object)response.getStatus());
    }

    @Test
    public void testAssignGroupsToUser() {
        Mockito.when((Object)this.groupManagerService.get("testGroup")).thenReturn(Mockito.mock(Group.class));
        UberfireRestResponse response = this.helper.assignGroupsToUser("testUser", new Lists.Builder().add((Object)"testGroup").build());
        Assert.assertEquals((Object)Response.Status.OK, (Object)response.getStatus());
    }

    @Test
    public void testAssignInvalidGroupsToUser() {
        ((GroupManagerService)Mockito.doThrow(GroupNotFoundException.class).when((Object)this.groupManagerService)).get("testGroup");
        UberfireRestResponse response = this.helper.assignGroupsToUser("testUser", new Lists.Builder().add((Object)"testGroup").build());
        Assert.assertEquals((Object)Response.Status.BAD_REQUEST, (Object)response.getStatus());
    }

    @Test
    public void testAssignRolesToUser() {
        Mockito.when((Object)this.roleManagerService.get("testRole")).thenReturn(Mockito.mock(Role.class));
        UberfireRestResponse response = this.helper.assignRolesToUser("testUser", new Lists.Builder().add((Object)"testRole").build());
        Assert.assertEquals((Object)Response.Status.OK, (Object)response.getStatus());
    }

    @Test
    public void testUpdateRolePermission() {
        Mockito.when((Object)this.permissionManager.getAuthorizationPolicy()).thenReturn(Mockito.mock(AuthorizationPolicy.class));
        Mockito.when((Object)this.roleManagerService.get("testRole")).thenReturn((Object)new RoleImpl("testRole"));
        UpdateSettingRequest request = (UpdateSettingRequest)Mockito.mock(UpdateSettingRequest.class);
        UberfireRestResponse response = this.helper.updateRolePermissions("testRole", request);
        Assert.assertEquals((Object)Response.Status.OK, (Object)response.getStatus());
    }

    @Test
    public void testUpdateGroupPermission() {
        Mockito.when((Object)this.permissionManager.getAuthorizationPolicy()).thenReturn(Mockito.mock(AuthorizationPolicy.class));
        Mockito.when((Object)this.groupManagerService.get("testGroup")).thenReturn((Object)new GroupImpl("testGroup"));
        UpdateSettingRequest request = (UpdateSettingRequest)Mockito.mock(UpdateSettingRequest.class);
        UberfireRestResponse response = this.helper.updateGroupPermissions("testGroup", request);
        Assert.assertEquals((Object)Response.Status.OK, (Object)response.getStatus());
    }

    @Test
    public void testGetGroupPermission() {
        Group group = (Group)Mockito.mock(Group.class);
        AuthorizationPolicy authz = (AuthorizationPolicy)Mockito.mock(AuthorizationPolicy.class);
        Mockito.when((Object)authz.getHomePerspective(group)).thenReturn((Object)"Home");
        Mockito.when((Object)authz.getPriority(group)).thenReturn((Object)10);
        Mockito.when((Object)authz.getPermissions(group)).thenReturn(Mockito.mock(PermissionCollection.class));
        Mockito.when((Object)this.permissionManager.getAuthorizationPolicy()).thenReturn((Object)authz);
        Mockito.when((Object)this.groupManagerService.get("testGroup")).thenReturn((Object)group);
        PermissionResponse response = this.helper.getGroupPermissions("testGroup");
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)"Home", (Object)response.getHomePage());
        Assert.assertEquals((Object)new Integer(10), (Object)response.getPriority());
    }

    @Test
    public void testGetRolePermission() {
        Role role = (Role)Mockito.mock(Role.class);
        AuthorizationPolicy authz = (AuthorizationPolicy)Mockito.mock(AuthorizationPolicy.class);
        Mockito.when((Object)authz.getHomePerspective(role)).thenReturn((Object)"Home");
        Mockito.when((Object)authz.getPriority(role)).thenReturn((Object)10);
        Mockito.when((Object)authz.getPermissions(role)).thenReturn(Mockito.mock(PermissionCollection.class));
        Mockito.when((Object)this.permissionManager.getAuthorizationPolicy()).thenReturn((Object)authz);
        Mockito.when((Object)this.roleManagerService.get("testRole")).thenReturn((Object)role);
        PermissionResponse response = this.helper.getRolePermissions("testRole");
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)"Home", (Object)response.getHomePage());
        Assert.assertEquals((Object)new Integer(10), (Object)response.getPriority());
    }

    @Test
    public void testGetUserPermission() {
        User user = (User)Mockito.mock(User.class);
        AuthorizationPolicy authz = (AuthorizationPolicy)Mockito.mock(AuthorizationPolicy.class);
        Mockito.when((Object)this.permissionManager.resolvePermissions(user, VotingStrategy.PRIORITY)).thenReturn(Mockito.mock(PermissionCollection.class));
        Mockito.when((Object)this.userManagerService.get("testUser")).thenReturn((Object)user);
        PermissionResponse response = this.helper.getUserPermissions("testUser");
        Assert.assertNotNull((Object)response);
    }
}

