/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.rest.backend;

import java.util.List;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.common.services.project.service.WorkspaceProjectService;
import org.guvnor.rest.backend.PermissionAction;
import org.guvnor.rest.backend.ResourceTypePermissionValidator;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.guvnor.structure.organizationalunit.impl.OrganizationalUnitImpl;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.security.RepositoryAction;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.soup.commons.util.Lists;
import org.kie.soup.commons.util.Sets;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.uberfire.security.ResourceAction;
import org.uberfire.security.ResourceType;
import org.uberfire.security.authz.Permission;
import org.uberfire.security.authz.PermissionCollection;
import org.uberfire.security.authz.PermissionManager;
import org.uberfire.workbench.model.ActivityResourceType;
import org.uberfire.workbench.model.AppFormerActivities;

@RunWith(value=MockitoJUnitRunner.class)
public class ResourceTypePermissionValidatorTest {
    @Mock
    private OrganizationalUnitService organizationalUnitService;
    @Mock
    private WorkspaceProjectService projectService;
    @Mock
    private AppFormerActivities appFormerActivities;
    @Mock
    private PermissionManager permissionManager;
    @InjectMocks
    private ResourceTypePermissionValidator permissionValidator;

    @Test
    public void testIsPermissionAllowed() {
        Assert.assertTrue((boolean)this.permissionValidator.isPermissionAllowed((ResourceType)OrganizationalUnit.RESOURCE_TYPE, ResourceAction.READ));
        Assert.assertTrue((boolean)this.permissionValidator.isPermissionAllowed((ResourceType)ActivityResourceType.PERSPECTIVE, ResourceAction.READ));
        Assert.assertFalse((boolean)this.permissionValidator.isPermissionAllowed((ResourceType)ActivityResourceType.EDITOR, (ResourceAction)RepositoryAction.CREATE));
        Assert.assertTrue((boolean)this.permissionValidator.isPermissionAllowed((ResourceType)Repository.RESOURCE_TYPE, (ResourceAction)RepositoryAction.BUILD));
    }

    @Test
    public void testResourceDependancy() {
        Assert.assertEquals((Object)((PermissionAction)this.permissionValidator.resourceDependancy((ResourceType)OrganizationalUnit.RESOURCE_TYPE, (ResourceAction)RepositoryAction.UPDATE).get()).getDependantAction(), (Object)ResourceAction.READ);
        Assert.assertNull((Object)((PermissionAction)this.permissionValidator.resourceDependancy((ResourceType)ActivityResourceType.PERSPECTIVE, ResourceAction.READ).get()).getDependantAction());
        Assert.assertEquals((Object)((PermissionAction)this.permissionValidator.resourceDependancy((ResourceType)Repository.RESOURCE_TYPE, (ResourceAction)RepositoryAction.UPDATE).get()).getDependantAction(), (Object)ResourceAction.READ);
        Assert.assertFalse((boolean)this.permissionValidator.resourceDependancy((ResourceType)ActivityResourceType.EDITOR, (ResourceAction)RepositoryAction.UPDATE).isPresent());
    }

    @Test
    public void testSatisfyDependancy() {
        PermissionCollection permissionCollection = (PermissionCollection)Mockito.mock(PermissionCollection.class);
        Permission p = (Permission)Mockito.mock(Permission.class);
        Mockito.when((Object)this.permissionManager.createPermission((ResourceType)OrganizationalUnit.RESOURCE_TYPE, ResourceAction.READ, true)).thenReturn((Object)p);
        Mockito.when((Object)permissionCollection.implies(p)).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.permissionValidator.satisfyDependancies(permissionCollection, (ResourceType)OrganizationalUnit.RESOURCE_TYPE, (ResourceAction)RepositoryAction.UPDATE));
        Assert.assertTrue((boolean)this.permissionValidator.satisfyDependancies(permissionCollection, (ResourceType)OrganizationalUnit.RESOURCE_TYPE, (ResourceAction)RepositoryAction.CREATE));
        Assert.assertTrue((boolean)this.permissionValidator.satisfyDependancies(permissionCollection, (ResourceType)OrganizationalUnit.RESOURCE_TYPE, (ResourceAction)RepositoryAction.BUILD));
    }

    @Test
    public void testIsValidSpaceType() {
        OrganizationalUnitImpl ou1 = new OrganizationalUnitImpl("ou1", "defaultGroupID");
        OrganizationalUnitImpl ou2 = new OrganizationalUnitImpl("ou2", "defaultGroupID");
        List allOUs = new Lists.Builder().add((Object)ou2).add((Object)ou1).build();
        ((OrganizationalUnitService)Mockito.doReturn((Object)allOUs).when((Object)this.organizationalUnitService)).getOrganizationalUnits();
        Assert.assertTrue((boolean)this.permissionValidator.isValidResourceType((ResourceType)OrganizationalUnit.RESOURCE_TYPE, "ou1"));
    }

    @Test
    public void testIsValidPerpectiveType() {
        ((AppFormerActivities)Mockito.doReturn((Object)new Lists.Builder().add((Object)"ExperimentalFeaturesPerspective").build()).when((Object)this.appFormerActivities)).getAllPerpectivesIds();
        Assert.assertTrue((boolean)this.permissionValidator.isValidResourceType((ResourceType)ActivityResourceType.PERSPECTIVE, "ExperimentalFeaturesPerspective"));
        Assert.assertFalse((boolean)this.permissionValidator.isValidResourceType((ResourceType)ActivityResourceType.PERSPECTIVE, "TestPerspective"));
    }

    @Test
    public void testIsValidEditorType() {
        ((AppFormerActivities)Mockito.doReturn((Object)new Lists.Builder().add((Object)"BPMNDiagramEditor").build()).when((Object)this.appFormerActivities)).getAllEditorIds();
        Assert.assertTrue((boolean)this.permissionValidator.isValidResourceType((ResourceType)ActivityResourceType.EDITOR, "BPMNDiagramEditor"));
        Assert.assertFalse((boolean)this.permissionValidator.isValidResourceType((ResourceType)ActivityResourceType.EDITOR, "TestEditor"));
    }

    @Test
    public void testIsValidRepositoryType() {
        WorkspaceProject itemB = (WorkspaceProject)Mockito.mock(WorkspaceProject.class);
        Mockito.when((Object)itemB.getName()).thenReturn((Object)"Item B");
        Mockito.when((Object)this.projectService.getAllWorkspaceProjects()).thenReturn((Object)new Sets.Builder().add((Object)itemB).build());
        Assert.assertTrue((boolean)this.permissionValidator.isValidResourceType((ResourceType)Repository.RESOURCE_TYPE, "Item B"));
        Assert.assertFalse((boolean)this.permissionValidator.isValidResourceType((ResourceType)Repository.RESOURCE_TYPE, "Item A"));
    }
}

