/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.plugin.backend;

import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Instance;
import org.jboss.errai.security.shared.api.identity.User;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.Spy;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.ext.editor.commons.backend.validation.DefaultFileNameValidator;
import org.uberfire.ext.plugin.backend.MediaServletURI;
import org.uberfire.ext.plugin.backend.PluginServicesImpl;
import org.uberfire.ext.plugin.event.MediaDeleted;
import org.uberfire.ext.plugin.event.PluginAdded;
import org.uberfire.ext.plugin.event.PluginDeleted;
import org.uberfire.ext.plugin.event.PluginRenamed;
import org.uberfire.ext.plugin.event.PluginSaved;
import org.uberfire.ext.plugin.exception.PluginAlreadyExists;
import org.uberfire.ext.plugin.model.Framework;
import org.uberfire.ext.plugin.model.PluginSimpleContent;
import org.uberfire.ext.plugin.model.PluginType;
import org.uberfire.ext.plugin.model.RuntimePlugin;
import org.uberfire.io.impl.IOServiceDotFileImpl;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.mocks.FileSystemTestingUtils;
import org.uberfire.rpc.SessionInfo;

public class PluginServicesImplTest {
    private static FileSystemTestingUtils fileSystemTestingUtils = new FileSystemTestingUtils();
    @Mock(name="MediaServletURI")
    private Instance<MediaServletURI> mediaServletURI;
    @Mock
    private transient SessionInfo sessionInfo;
    @Mock
    private Event<PluginAdded> pluginAddedEvent;
    @Mock
    private Event<PluginDeleted> pluginDeletedEvent;
    @Mock
    private Event<PluginSaved> pluginSavedEvent;
    @Mock
    private Event<PluginRenamed> pluginRenamedEvent;
    @Mock
    private Event<MediaDeleted> mediaDeletedEvent;
    @Spy
    private DefaultFileNameValidator defaultFileNameValidator;
    @Mock
    private User identity;
    private IOServiceDotFileImpl ioService;
    @Spy
    @InjectMocks
    private PluginServicesImpl pluginServices;

    @After
    public void cleanupFileSystem() {
        fileSystemTestingUtils.cleanup();
    }

    @Before
    public void setup() throws IOException {
        fileSystemTestingUtils.setup();
        MockitoAnnotations.initMocks((Object)this);
        this.ioService = (IOServiceDotFileImpl)Mockito.spy((Object)((IOServiceDotFileImpl)fileSystemTestingUtils.getIoService()));
        ((IOServiceDotFileImpl)Mockito.doReturn((Object)fileSystemTestingUtils.getFileSystem()).when((Object)this.ioService)).getFileSystem((URI)Mockito.any(URI.class));
        ((IOServiceDotFileImpl)Mockito.doNothing().when((Object)this.ioService)).startBatch((FileSystem)Mockito.any(FileSystem.class));
        ((IOServiceDotFileImpl)Mockito.doNothing().when((Object)this.ioService)).endBatch();
        ((PluginServicesImpl)Mockito.doReturn((Object)"script").when((Object)this.pluginServices)).getFrameworkScript((Framework)Mockito.any(Framework.class));
        ((PluginServicesImpl)Mockito.doReturn((Object)this.ioService).when((Object)this.pluginServices)).getIoService();
        this.pluginServices.init();
    }

    @Test(expected=PluginAlreadyExists.class)
    public void testCreateTwoPluginsWithTheSameName() {
        this.createPlugin("pluginName", PluginType.SCREEN, null);
        this.createPlugin("pluginName", PluginType.EDITOR, null);
    }

    @Test
    public void testListRuntimePluginsOfEmptyScreen() {
        this.createPlugin("emptyScreen", PluginType.SCREEN, null);
        Collection runtimePlugins = this.pluginServices.listRuntimePlugins();
        Assert.assertEquals((long)1L, (long)runtimePlugins.size());
        Assert.assertTrue((boolean)this.contains(runtimePlugins, "emptyScreen"));
    }

    @Test
    public void testListRuntimePluginsOfScreenWithFramework() {
        this.createPlugin("angularScreen", PluginType.SCREEN, Framework.ANGULAR);
        Collection runtimePlugins = this.pluginServices.listRuntimePlugins();
        Assert.assertEquals((long)2L, (long)runtimePlugins.size());
        Assert.assertTrue((boolean)this.contains(runtimePlugins, "angularScreen"));
    }

    @Test
    public void testListRuntimePluginsOfMultipleScreens() {
        this.createPlugin("emptyScreen", PluginType.SCREEN, null);
        this.createPlugin("angularScreen", PluginType.SCREEN, Framework.ANGULAR);
        this.createPlugin("knockoutScreen", PluginType.SCREEN, Framework.KNOCKOUT);
        Collection runtimePlugins = this.pluginServices.listRuntimePlugins();
        Assert.assertEquals((long)5L, (long)runtimePlugins.size());
        Assert.assertTrue((boolean)this.contains(runtimePlugins, "emptyScreen"));
        Assert.assertTrue((boolean)this.contains(runtimePlugins, "angularScreen"));
        Assert.assertTrue((boolean)this.contains(runtimePlugins, "knockoutScreen"));
    }

    @Test
    public void testCopyPlugin() {
        Path pluginPath = this.createPlugin("emptyScreen", PluginType.SCREEN, null);
        this.pluginServices.copy(pluginPath, "newEmptyScreen", "");
        ((Event)Mockito.verify(this.pluginAddedEvent, (VerificationMode)Mockito.times((int)1))).fire(Mockito.any(PluginAdded.class));
        Collection runtimePlugins = this.pluginServices.listRuntimePlugins();
        Assert.assertEquals((long)2L, (long)runtimePlugins.size());
        Assert.assertTrue((boolean)this.contains(runtimePlugins, "emptyScreen"));
        Assert.assertTrue((boolean)this.contains(runtimePlugins, "newEmptyScreen"));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testCopyPluginToAnotherDirectory() {
        Path pluginPath = this.createPlugin("emptyScreen", PluginType.SCREEN, null);
        this.pluginServices.copy(pluginPath, "newEmptyScreen", pluginPath, "");
    }

    @Test
    public void testRenamePlugin() {
        Path pluginPath = this.createPlugin("emptyScreen", PluginType.SCREEN, null);
        this.pluginServices.rename(pluginPath, "newEmptyScreen", "");
        ((Event)Mockito.verify(this.pluginRenamedEvent, (VerificationMode)Mockito.times((int)1))).fire(Mockito.any(PluginRenamed.class));
        Collection runtimePlugins = this.pluginServices.listRuntimePlugins();
        Assert.assertEquals((long)1L, (long)runtimePlugins.size());
        Assert.assertTrue((boolean)this.contains(runtimePlugins, "newEmptyScreen"));
    }

    @Test
    public void testDeletePlugin() {
        Path pluginPath = this.createPlugin("emptyScreen", PluginType.SCREEN, null);
        this.pluginServices.delete(pluginPath, "");
        ((Event)Mockito.verify(this.pluginDeletedEvent, (VerificationMode)Mockito.times((int)1))).fire(Mockito.any(PluginDeleted.class));
        Collection runtimePlugins = this.pluginServices.listRuntimePlugins();
        Assert.assertEquals((long)0L, (long)runtimePlugins.size());
    }

    private Path createPlugin(String name, PluginType type, Framework framework) {
        this.pluginServices.createNewPlugin(name, type);
        ((Event)Mockito.verify(this.pluginAddedEvent, (VerificationMode)Mockito.times((int)1))).fire(Mockito.any(PluginAdded.class));
        Mockito.reset((Object[])new Event[]{this.pluginAddedEvent});
        PluginSimpleContent pluginSimpleContent = this.buildPlugin(name, type, framework);
        this.pluginServices.save(pluginSimpleContent, "");
        ((Event)Mockito.verify(this.pluginSavedEvent, (VerificationMode)Mockito.times((int)1))).fire(Mockito.any(PluginSaved.class));
        Mockito.reset((Object[])new Event[]{this.pluginSavedEvent});
        return pluginSimpleContent.getPath();
    }

    private PluginSimpleContent buildPlugin(String name, PluginType type, Framework framework) {
        HashSet<Framework> frameworks = new HashSet<Framework>();
        if (framework != null) {
            frameworks.add(framework);
        }
        return new PluginSimpleContent(name, type, PathFactory.newPath((String)(type.name().toLowerCase() + ".plugin"), (String)("git://amend-repo-test/" + name + "/" + type.name().toLowerCase() + ".plugin")), null, null, new HashMap(), frameworks, null);
    }

    private boolean contains(Collection<RuntimePlugin> runtimePlugins, String pluginName) {
        for (RuntimePlugin runtimePlugin : runtimePlugins) {
            if (!runtimePlugin.getScript().contains("$registerPlugin({id:\"" + pluginName)) continue;
            return true;
        }
        return false;
    }
}

