/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.plugin.backend;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadException;
import org.junit.Test;
import org.mockito.Mockito;
import org.uberfire.ext.plugin.backend.PluginMediaServlet;

public class PluginMediaServletTest {
    @Test
    public void testDoPost() throws Exception {
        FileItem fileItem = this.fileMock("C:\\Users\\user\\Desktop\\image.jpg");
        PluginMediaServlet servlet = (PluginMediaServlet)Mockito.spy((Object)this.fakeServlet(fileItem));
        HttpServletRequest request = this.requestMock("/plugins/screen");
        HttpServletResponse response = this.responseMock();
        servlet.doPost(request, response);
        ((PluginMediaServlet)Mockito.verify((Object)servlet)).resolve("/screen/media/image.jpg");
    }

    private HttpServletResponse responseMock() {
        return (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
    }

    private HttpServletRequest requestMock(String requestURI) {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.getRequestURI()).thenReturn((Object)requestURI);
        Mockito.when((Object)request.getContextPath()).thenReturn((Object)"");
        return request;
    }

    private FileItem fileMock(String fileName) {
        FileItem fileItem = (FileItem)Mockito.mock(FileItem.class);
        Mockito.when((Object)fileItem.getName()).thenReturn((Object)fileName);
        return fileItem;
    }

    private PluginMediaServlet fakeServlet(final FileItem fileItem) {
        return new PluginMediaServlet(){

            protected FileItem getFileItem(HttpServletRequest request) throws FileUploadException {
                return fileItem;
            }

            protected void writeResponse(HttpServletResponse response, String ok) throws IOException {
            }
        };
    }
}

