/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.plugin.backend;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.io.IOUtils;
import org.jboss.errai.bus.server.annotations.Service;
import org.jboss.errai.security.shared.api.identity.User;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.ext.editor.commons.backend.service.SaveAndRenameServiceImpl;
import org.uberfire.ext.editor.commons.backend.validation.DefaultFileNameValidator;
import org.uberfire.ext.editor.commons.file.DefaultMetadata;
import org.uberfire.ext.editor.commons.service.support.SupportsSaveAndRename;
import org.uberfire.ext.plugin.backend.JSRegistry;
import org.uberfire.ext.plugin.backend.MediaServletURI;
import org.uberfire.ext.plugin.event.MediaDeleted;
import org.uberfire.ext.plugin.event.PluginAdded;
import org.uberfire.ext.plugin.event.PluginDeleted;
import org.uberfire.ext.plugin.event.PluginRenamed;
import org.uberfire.ext.plugin.event.PluginSaved;
import org.uberfire.ext.plugin.exception.PluginAlreadyExists;
import org.uberfire.ext.plugin.model.CodeType;
import org.uberfire.ext.plugin.model.DynamicMenu;
import org.uberfire.ext.plugin.model.DynamicMenuItem;
import org.uberfire.ext.plugin.model.Framework;
import org.uberfire.ext.plugin.model.Language;
import org.uberfire.ext.plugin.model.LayoutEditorModel;
import org.uberfire.ext.plugin.model.Media;
import org.uberfire.ext.plugin.model.Plugin;
import org.uberfire.ext.plugin.model.PluginContent;
import org.uberfire.ext.plugin.model.PluginSimpleContent;
import org.uberfire.ext.plugin.model.PluginType;
import org.uberfire.ext.plugin.model.RuntimePlugin;
import org.uberfire.ext.plugin.service.PluginServices;
import org.uberfire.ext.plugin.type.TypeConverterUtil;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.base.options.CommentedOption;
import org.uberfire.java.nio.file.CopyOption;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.FileAlreadyExistsException;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.FileVisitResult;
import org.uberfire.java.nio.file.FileVisitor;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.NotDirectoryException;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Option;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.SimpleFileVisitor;
import org.uberfire.java.nio.file.StandardDeleteOption;
import org.uberfire.java.nio.file.attribute.BasicFileAttributes;
import org.uberfire.rpc.SessionInfo;

@Service
@ApplicationScoped
public class PluginServicesImpl
implements PluginServices {
    private static final Logger logger = LoggerFactory.getLogger(PluginServicesImpl.class);
    private static final String MENU_ITEM_DELIMITER = " / ";
    protected Gson gson;
    private IOService ioService;
    private Instance<MediaServletURI> mediaServletURI;
    private transient SessionInfo sessionInfo;
    private Event<PluginAdded> pluginAddedEvent;
    private Event<PluginDeleted> pluginDeletedEvent;
    private Event<PluginSaved> pluginSavedEvent;
    private Event<PluginRenamed> pluginRenamedEvent;
    private Event<MediaDeleted> mediaDeletedEvent;
    private DefaultFileNameValidator defaultFileNameValidator;
    private User identity;
    private SaveAndRenameServiceImpl<Plugin, DefaultMetadata> saveAndRenameService;
    private FileSystem fileSystem;
    private Path root;

    public PluginServicesImpl() {
    }

    @Inject
    public PluginServicesImpl(@Named(value="ioStrategy") IOService ioService, @Named(value="MediaServletURI") Instance<MediaServletURI> mediaServletURI, SessionInfo sessionInfo, Event<PluginAdded> pluginAddedEvent, Event<PluginDeleted> pluginDeletedEvent, Event<PluginSaved> pluginSavedEvent, Event<PluginRenamed> pluginRenamedEvent, Event<MediaDeleted> mediaDeletedEvent, DefaultFileNameValidator defaultFileNameValidator, User identity, @Named(value="pluginsFS") FileSystem fileSystem, SaveAndRenameServiceImpl<Plugin, DefaultMetadata> saveAndRenameService) {
        this.ioService = ioService;
        this.mediaServletURI = mediaServletURI;
        this.sessionInfo = sessionInfo;
        this.pluginAddedEvent = pluginAddedEvent;
        this.pluginDeletedEvent = pluginDeletedEvent;
        this.pluginSavedEvent = pluginSavedEvent;
        this.pluginRenamedEvent = pluginRenamedEvent;
        this.mediaDeletedEvent = mediaDeletedEvent;
        this.defaultFileNameValidator = defaultFileNameValidator;
        this.identity = identity;
        this.fileSystem = fileSystem;
        this.saveAndRenameService = saveAndRenameService;
    }

    @PostConstruct
    public void init() {
        this.gson = new GsonBuilder().setPrettyPrinting().create();
        this.root = this.resolveRoot();
        this.saveAndRenameService.init((SupportsSaveAndRename)this);
    }

    Path resolveRoot() {
        return (Path)this.fileSystem.getRootDirectories().iterator().next();
    }

    public String getMediaServletURI() {
        return ((MediaServletURI)this.mediaServletURI.get()).getURI();
    }

    public Collection<RuntimePlugin> listRuntimePlugins() {
        return this.listRuntimePlugins(this.root);
    }

    public Collection<RuntimePlugin> listPluginRuntimePlugins(org.uberfire.backend.vfs.Path pluginPath) {
        return this.listRuntimePlugins(Paths.convert((org.uberfire.backend.vfs.Path)pluginPath).getParent());
    }

    private Collection<RuntimePlugin> listRuntimePlugins(Path path) {
        final ArrayList<RuntimePlugin> result = new ArrayList<RuntimePlugin>();
        if (this.getIoService().exists(path)) {
            Files.walkFileTree((Path)((Path)PortablePreconditions.checkNotNull((String)"path", (Object)path)), (FileVisitor)new SimpleFileVisitor<Path>(){

                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    try {
                        PortablePreconditions.checkNotNull((String)"file", (Object)file);
                        PortablePreconditions.checkNotNull((String)"attrs", (Object)attrs);
                        if (attrs.isRegularFile()) {
                            result.addAll(PluginServicesImpl.this.buildPluginRuntimePlugins(file));
                        }
                    }
                    catch (Exception ex) {
                        logger.error("An unexpected exception was thrown: ", (Throwable)ex);
                        return FileVisitResult.TERMINATE;
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        return result;
    }

    private Collection<RuntimePlugin> buildPluginRuntimePlugins(Path pluginPath) {
        ArrayList<RuntimePlugin> result = new ArrayList<RuntimePlugin>();
        if (pluginPath.getFileName().toString().endsWith(".registry.js")) {
            String pluginName = pluginPath.getParent().getFileName().toString();
            result.addAll(this.buildRuntimePluginsFromFrameworks(this.loadFramework(pluginName)));
            result.add(new RuntimePlugin(this.loadCss(pluginName), this.getIoService().readAllString(pluginPath)));
        }
        return result;
    }

    private Collection<RuntimePlugin> buildRuntimePluginsFromFrameworks(Collection<Framework> frameworks) {
        ArrayList<RuntimePlugin> result = new ArrayList<RuntimePlugin>();
        try {
            for (Framework framework : frameworks) {
                result.add(new RuntimePlugin("", this.getFrameworkScript(framework)));
            }
        }
        catch (java.io.IOException e) {
            logger.error("An unexpected exception was thrown: ", (Throwable)e);
        }
        return result;
    }

    String getFrameworkScript(Framework framework) throws java.io.IOException {
        StringWriter writer = new StringWriter();
        InputStream frameworkStream = this.getClass().getClassLoader().getResourceAsStream("/frameworks/" + framework.toString().toLowerCase() + ".dependency");
        IOUtils.copy((InputStream)frameworkStream, (Writer)writer);
        return writer.toString();
    }

    public Collection<Plugin> listPlugins() {
        final ArrayList<Plugin> result = new ArrayList<Plugin>();
        if (this.getIoService().exists(this.root)) {
            Files.walkFileTree((Path)((Path)PortablePreconditions.checkNotNull((String)"root", (Object)this.root)), (FileVisitor)new SimpleFileVisitor<Path>(){

                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    try {
                        PortablePreconditions.checkNotNull((String)"file", (Object)file);
                        PortablePreconditions.checkNotNull((String)"attrs", (Object)attrs);
                        if (file.getFileName().toString().endsWith(".plugin") && attrs.isRegularFile()) {
                            org.uberfire.backend.vfs.Path path = Paths.convert((Path)file);
                            result.add(new Plugin(file.getParent().getFileName().toString(), TypeConverterUtil.fromPath((org.uberfire.backend.vfs.Path)path), path));
                        }
                    }
                    catch (Exception ex) {
                        return FileVisitResult.TERMINATE;
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        return result;
    }

    public Plugin createNewPlugin(String pluginName, PluginType type) {
        PortablePreconditions.checkNotEmpty((String)"pluginName", (String)pluginName);
        PortablePreconditions.checkCondition((String)"valid plugin name", (boolean)this.defaultFileNameValidator.isValid(pluginName));
        Path pluginRoot = this.getPluginPath(pluginName);
        if (this.getIoService().exists(pluginRoot)) {
            throw new PluginAlreadyExists();
        }
        Path pluginPath = pluginRoot.resolve(type.toString().toLowerCase() + ".plugin");
        Plugin plugin = new Plugin(pluginName, type, Paths.convert((Path)pluginPath));
        this.updatePlugin(pluginPath, plugin, true);
        return plugin;
    }

    private void updatePlugin(Path pluginPath, Plugin plugin, boolean isNewPlugIn) {
        this.updatePlugin(pluginPath, plugin, isNewPlugIn, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePlugin(Path pluginPath, Plugin plugin, boolean isNewPlugIn, String registry) {
        try {
            this.getIoService().startBatch(this.fileSystem);
            this.getIoService().write(pluginPath, new Date().toString(), new OpenOption[0]);
        }
        finally {
            this.getIoService().endBatch();
        }
        if (isNewPlugIn) {
            this.pluginAddedEvent.fire((Object)new PluginAdded(plugin, this.sessionInfo));
        } else {
            this.pluginSavedEvent.fire((Object)new PluginSaved(plugin, this.sessionInfo));
        }
    }

    public PluginContent getPluginContent(org.uberfire.backend.vfs.Path path) {
        String pluginName = Paths.convert((org.uberfire.backend.vfs.Path)path).getParent().getFileName().toString();
        return new PluginContent(pluginName, TypeConverterUtil.fromPath((org.uberfire.backend.vfs.Path)path), path, this.loadTemplate(pluginName), this.loadCss(pluginName), this.loadCodeMap(pluginName), this.loadFramework(pluginName), Language.JAVASCRIPT, this.loadMediaLibrary(pluginName));
    }

    public org.uberfire.backend.vfs.Path save(Plugin plugin, String commitMessage) {
        if (plugin instanceof PluginSimpleContent) {
            return this.save((PluginSimpleContent)plugin, commitMessage);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.uberfire.backend.vfs.Path save(PluginSimpleContent plugin, String commitMessage) {
        Path pluginPath = Paths.convert((org.uberfire.backend.vfs.Path)plugin.getPath());
        boolean isNewPlugin = !this.getIoService().exists(pluginPath);
        try {
            this.getIoService().startBatch(this.fileSystem, new Option[]{this.commentedOption(commitMessage)});
            this.saveCodeMap(plugin.getName(), plugin.getCodeMap());
            if (plugin.getTemplate() != null) {
                this.getIoService().write(this.getTemplatePath(this.getPluginPath(plugin.getName())), plugin.getTemplate(), new OpenOption[0]);
            }
            if (plugin.getCss() != null) {
                this.getIoService().write(this.getCssPath(this.getPluginPath(plugin.getName())), plugin.getCss(), new OpenOption[0]);
            }
            this.clearDirectory(this.getPluginPath(plugin.getName()).resolve("dependencies"));
            if (plugin.getFrameworks() != null && !plugin.getFrameworks().isEmpty()) {
                Framework framework = (Framework)plugin.getFrameworks().iterator().next();
                this.getIoService().write(this.getDependencyPath(this.getPluginPath(plugin.getName()), framework), "--", new OpenOption[0]);
            }
            this.createRegistry(plugin);
            this.updatePlugin(pluginPath, (Plugin)plugin, isNewPlugin);
        }
        finally {
            this.getIoService().endBatch();
        }
        return plugin.getPath();
    }

    private void clearDirectory(Path directory) {
        if (this.getIoService().exists(directory)) {
            for (Path path : this.getIoService().newDirectoryStream(directory)) {
                boolean bl = this.getIoService().deleteIfExists(path, new DeleteOption[0]);
            }
        }
    }

    private Path getDependencyPath(Path pluginPath, Framework framework) {
        return pluginPath.resolve("dependencies").resolve(framework.toString() + ".dependency");
    }

    private String createRegistry(PluginSimpleContent plugin) {
        Path path = this.getPluginPath(plugin.getName());
        new JSRegistry();
        String registry = JSRegistry.convertToJSRegistry(plugin);
        this.getIoService().write(path.resolve(plugin.getName() + ".registry.js"), registry, new OpenOption[0]);
        return registry;
    }

    private void saveCodeMap(String pluginName, Map<CodeType, String> codeMap) {
        Path rootPlugin = this.getPluginPath(pluginName);
        for (Map.Entry<CodeType, String> entry : codeMap.entrySet()) {
            Path codePath = this.getCodePath(rootPlugin, entry.getKey());
            this.getIoService().write(codePath, entry.getValue(), new OpenOption[0]);
        }
    }

    private Map<CodeType, String> loadCodeMap(String pluginName) {
        try {
            Path rootPlugin = this.getPluginPath(pluginName);
            DirectoryStream stream = this.getIoService().newDirectoryStream(this.getCodeRoot(rootPlugin), (DirectoryStream.Filter)new DirectoryStream.Filter<Path>(){

                public boolean accept(Path entry) throws IOException {
                    return entry.getFileName().toString().endsWith(".code");
                }
            });
            HashMap<CodeType, String> result = new HashMap<CodeType, String>();
            for (Path path : stream) {
                CodeType type = this.getCodeType(path);
                if (type == null) continue;
                result.put(type, this.getIoService().readAllString(path));
            }
            return result;
        }
        catch (NotDirectoryException exception) {
            return Collections.emptyMap();
        }
    }

    private Set<Media> loadMediaLibrary(String pluginName) {
        try {
            Path rootPlugin = this.getPluginPath(pluginName);
            DirectoryStream stream = this.getIoService().newDirectoryStream(this.getMediaRoot(rootPlugin));
            HashSet<Media> result = new HashSet<Media>();
            for (Path path : stream) {
                result.add(new Media(this.getMediaServletURI() + pluginName + "/media/" + path.getFileName(), Paths.convert((Path)path)));
            }
            return result;
        }
        catch (NotDirectoryException exception) {
            return Collections.emptySet();
        }
    }

    private String loadTemplate(String pluginName) {
        Path template = this.getTemplatePath(this.getPluginPath(pluginName));
        if (this.getIoService().exists(template)) {
            return this.getIoService().readAllString(template);
        }
        return "";
    }

    private String loadCss(String pluginName) {
        Path css = this.getCssPath(this.getPluginPath(pluginName));
        if (this.getIoService().exists(css)) {
            return this.getIoService().readAllString(css);
        }
        return "";
    }

    private Set<Framework> loadFramework(String pluginName) {
        try {
            HashSet<Framework> result = new HashSet<Framework>();
            DirectoryStream stream = this.getIoService().newDirectoryStream(this.getPluginPath(pluginName).resolve("dependencies"));
            for (Path path : stream) {
                try {
                    result.add(Framework.valueOf((String)path.getFileName().toString().replace(".dependency", "").toUpperCase()));
                }
                catch (Exception exception) {}
            }
            return result;
        }
        catch (NotDirectoryException exception) {
            return Collections.emptySet();
        }
    }

    private Path getTemplatePath(Path rootPlugin) {
        return rootPlugin.resolve("template.html");
    }

    private Path getCssPath(Path rootPlugin) {
        return rootPlugin.resolve("css").resolve("style.css");
    }

    private Path getCodePath(Path rootPlugin, CodeType codeType) {
        return this.getCodeRoot(rootPlugin).resolve(codeType.toString().toLowerCase() + ".code");
    }

    private CodeType getCodeType(Path path) {
        try {
            return CodeType.valueOf((String)path.getFileName().toString().replace(".code", "").toUpperCase());
        }
        catch (Exception exception) {
            return null;
        }
    }

    private Path getCodeRoot(Path rootPlugin) {
        return rootPlugin.resolve("code");
    }

    private Path getMediaRoot(Path rootPlugin) {
        return rootPlugin.resolve("media");
    }

    private Path getPluginPath(String name) {
        return this.root.resolve(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(org.uberfire.backend.vfs.Path path, String comment) {
        PluginContent plugin = this.getPluginContent(path);
        Path pluginPath = Paths.convert((org.uberfire.backend.vfs.Path)plugin.getPath());
        if (this.getIoService().exists(pluginPath)) {
            try {
                this.getIoService().startBatch(this.fileSystem, new Option[]{this.commentedOption(comment)});
                this.getIoService().deleteIfExists(pluginPath.getParent(), new DeleteOption[]{StandardDeleteOption.NON_EMPTY_DIRECTORIES});
            }
            finally {
                this.getIoService().endBatch();
            }
            this.pluginDeletedEvent.fire((Object)new PluginDeleted((Plugin)plugin, this.sessionInfo));
        }
    }

    public org.uberfire.backend.vfs.Path copy(org.uberfire.backend.vfs.Path path, String newName, String comment) {
        return this.copy(path, newName, null, comment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.uberfire.backend.vfs.Path copy(org.uberfire.backend.vfs.Path path, String newName, org.uberfire.backend.vfs.Path targetDirectory, String comment) {
        Path newPath;
        Path path2 = newPath = targetDirectory == null ? this.getPluginPath(newName) : Paths.convert((org.uberfire.backend.vfs.Path)targetDirectory);
        if (this.getIoService().exists(newPath)) {
            throw new FileAlreadyExistsException(newPath.toString());
        }
        try {
            this.getIoService().startBatch(this.fileSystem, new Option[]{this.commentedOption(comment)});
            this.getIoService().copy(Paths.convert((org.uberfire.backend.vfs.Path)path).getParent(), newPath, new CopyOption[0]);
        }
        finally {
            this.getIoService().endBatch();
        }
        org.uberfire.backend.vfs.Path result = Paths.convert((Path)newPath.resolve(path.getFileName()));
        PluginContent pluginContent = this.getPluginContent(result);
        this.removeRegistry(newPath);
        String registry = this.createRegistry((PluginSimpleContent)pluginContent);
        this.pluginAddedEvent.fire((Object)new PluginAdded((Plugin)pluginContent, this.sessionInfo));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.uberfire.backend.vfs.Path rename(org.uberfire.backend.vfs.Path path, String newName, String comment) {
        Path newPath = this.getPluginPath(newName);
        if (this.getIoService().exists(newPath)) {
            throw new FileAlreadyExistsException(newPath.toString());
        }
        try {
            this.getIoService().startBatch(this.fileSystem, new Option[]{this.commentedOption(comment)});
            this.removeRegistry(Paths.convert((org.uberfire.backend.vfs.Path)path).getParent());
            this.getIoService().move(Paths.convert((org.uberfire.backend.vfs.Path)path).getParent(), newPath, new CopyOption[0]);
        }
        finally {
            this.getIoService().endBatch();
        }
        String oldPluginName = Paths.convert((org.uberfire.backend.vfs.Path)path).getParent().getFileName().toString();
        org.uberfire.backend.vfs.Path result = Paths.convert((Path)newPath.resolve(path.getFileName()));
        PluginContent pluginContent = this.getPluginContent(result);
        String registry = this.createRegistry((PluginSimpleContent)pluginContent);
        this.pluginRenamedEvent.fire((Object)new PluginRenamed(oldPluginName, (Plugin)pluginContent, this.sessionInfo));
        return result;
    }

    private void removeRegistry(Path path) {
        Files.walkFileTree((Path)path, (FileVisitor)new SimpleFileVisitor<Path>(){

            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                try {
                    PortablePreconditions.checkNotNull((String)"file", (Object)file);
                    PortablePreconditions.checkNotNull((String)"attrs", (Object)attrs);
                    if (file.getFileName().toString().endsWith(".registry.js") && attrs.isRegularFile()) {
                        org.uberfire.backend.vfs.Path path = Paths.convert((Path)file);
                        PluginServicesImpl.this.getIoService().delete(file, new DeleteOption[0]);
                    }
                }
                catch (Exception ex) {
                    return FileVisitResult.TERMINATE;
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private CommentedOption commentedOption(String comment) {
        return new CommentedOption(this.sessionInfo != null ? this.sessionInfo.getId() : "--", this.identity.getIdentifier(), null, comment);
    }

    public void deleteMedia(Media media) {
        Path mediaPath = Paths.convert((org.uberfire.backend.vfs.Path)media.getPath());
        try {
            this.getIoService().startBatch(this.fileSystem);
            this.getIoService().delete(mediaPath, new DeleteOption[0]);
        }
        finally {
            this.getIoService().endBatch();
        }
        this.mediaDeletedEvent.fire((Object)new MediaDeleted(mediaPath.getParent().getParent().getFileName().toString(), media));
    }

    public DynamicMenu getDynamicMenuContent(org.uberfire.backend.vfs.Path path) {
        String pluginName = Paths.convert((org.uberfire.backend.vfs.Path)path).getParent().getFileName().toString();
        return new DynamicMenu(pluginName, TypeConverterUtil.fromPath((org.uberfire.backend.vfs.Path)path), path, this.loadMenuItems(pluginName));
    }

    public LayoutEditorModel getLayoutEditor(org.uberfire.backend.vfs.Path path, PluginType pluginType) {
        String pluginName = Paths.convert((org.uberfire.backend.vfs.Path)path).getParent().getFileName().toString();
        return this.loadLayoutEditor(pluginName, path, pluginType);
    }

    private LayoutEditorModel loadLayoutEditor(String pluginName, org.uberfire.backend.vfs.Path path, PluginType type) {
        Path path1 = this.getLayoutEditorPath(this.getPluginPath(pluginName), type.toString().toLowerCase());
        if (this.getIoService().exists(path1)) {
            String fileContent = this.getIoService().readAllString(path1);
            return new LayoutEditorModel(pluginName, PluginType.PERSPECTIVE_LAYOUT, path, fileContent);
        }
        return new LayoutEditorModel(pluginName, PluginType.PERSPECTIVE_LAYOUT, path, null).emptyLayout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.uberfire.backend.vfs.Path saveMenu(DynamicMenu plugin, String commitMessage) {
        Path pluginPath = Paths.convert((org.uberfire.backend.vfs.Path)plugin.getPath());
        boolean isNewPlugin = !this.getIoService().exists(pluginPath);
        try {
            this.getIoService().startBatch(this.fileSystem, new Option[]{this.commentedOption(commitMessage)});
            Path menuItemsPath = this.getMenuItemsPath(this.getPluginPath(plugin.getName()));
            StringBuilder sb = new StringBuilder();
            for (DynamicMenuItem item : plugin.getMenuItems()) {
                sb.append(item.getActivityId()).append(MENU_ITEM_DELIMITER).append(item.getMenuLabel()).append("\n");
            }
            this.getIoService().write(menuItemsPath, sb.toString(), new OpenOption[0]);
            this.updatePlugin(pluginPath, (Plugin)plugin, isNewPlugin);
        }
        finally {
            this.getIoService().endBatch();
        }
        return plugin.getPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.uberfire.backend.vfs.Path saveLayout(LayoutEditorModel plugin, String commitMessage) {
        Path pluginPath = Paths.convert((org.uberfire.backend.vfs.Path)plugin.getPath());
        boolean isNewPlugin = !this.getIoService().exists(pluginPath);
        try {
            this.getIoService().startBatch(this.fileSystem, new Option[]{this.commentedOption(commitMessage)});
            Path itemsPath = this.getLayoutEditorPath(this.getPluginPath(plugin.getName()), plugin.getType().toString().toLowerCase());
            this.getIoService().write(itemsPath, plugin.getLayoutEditorModel(), new OpenOption[0]);
            this.updatePlugin(pluginPath, (Plugin)plugin, isNewPlugin);
        }
        finally {
            this.getIoService().endBatch();
        }
        return plugin.getPath();
    }

    private Path getLayoutEditorPath(Path rootPlugin, String type) {
        return rootPlugin.resolve(type);
    }

    public Collection<DynamicMenu> listDynamicMenus() {
        final ArrayList<DynamicMenu> result = new ArrayList<DynamicMenu>();
        if (this.getIoService().exists(this.root)) {
            Files.walkFileTree((Path)((Path)PortablePreconditions.checkNotNull((String)"root", (Object)this.root)), (FileVisitor)new SimpleFileVisitor<Path>(){

                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    try {
                        PortablePreconditions.checkNotNull((String)"file", (Object)file);
                        PortablePreconditions.checkNotNull((String)"attrs", (Object)attrs);
                        if (file.getFileName().toString().equalsIgnoreCase("info.dynamic") && attrs.isRegularFile()) {
                            String pluginName = file.getParent().getFileName().toString();
                            result.add(new DynamicMenu(pluginName, PluginType.DYNAMIC_MENU, Paths.convert((Path)file.getParent()), PluginServicesImpl.this.loadMenuItems(pluginName)));
                        }
                    }
                    catch (Exception ex) {
                        return FileVisitResult.TERMINATE;
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        return result;
    }

    public Collection<LayoutEditorModel> listLayoutEditor(final PluginType pluginType) {
        final ArrayList<LayoutEditorModel> result = new ArrayList<LayoutEditorModel>();
        if (this.getIoService().exists(this.root)) {
            Files.walkFileTree((Path)((Path)PortablePreconditions.checkNotNull((String)"root", (Object)this.root)), (FileVisitor)new SimpleFileVisitor<Path>(){

                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    try {
                        PortablePreconditions.checkNotNull((String)"file", (Object)file);
                        PortablePreconditions.checkNotNull((String)"attrs", (Object)attrs);
                        if (file.getFileName().toString().equalsIgnoreCase(pluginType.toString().toLowerCase()) && attrs.isRegularFile()) {
                            LayoutEditorModel layoutEditorModel = PluginServicesImpl.this.getLayoutEditor(Paths.convert((Path)file), pluginType);
                            result.add(layoutEditorModel);
                        }
                    }
                    catch (Exception ex) {
                        return FileVisitResult.TERMINATE;
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        return result;
    }

    private Collection<DynamicMenuItem> loadMenuItems(String pluginName) {
        ArrayList<DynamicMenuItem> result = new ArrayList<DynamicMenuItem>();
        Path menuItemsPath = this.getMenuItemsPath(this.getPluginPath(pluginName));
        if (this.getIoService().exists(menuItemsPath)) {
            List value = this.getIoService().readAllLines(menuItemsPath);
            for (String s : value) {
                String[] items = s.split(MENU_ITEM_DELIMITER);
                if (items.length != 2) continue;
                result.add(new DynamicMenuItem(items[0], items[1]));
            }
        }
        return result;
    }

    IOService getIoService() {
        return this.ioService;
    }

    private Path getMenuItemsPath(Path rootPlugin) {
        return rootPlugin.resolve("info.dynamic");
    }

    public org.uberfire.backend.vfs.Path save(org.uberfire.backend.vfs.Path _path, Plugin content, DefaultMetadata _metadata, String comment) {
        return this.save(content, comment);
    }

    public org.uberfire.backend.vfs.Path saveAndRename(org.uberfire.backend.vfs.Path path, String newFileName, DefaultMetadata metadata, Plugin content, String comment) {
        return this.saveAndRenameService.saveAndRename(path, newFileName, (Object)metadata, (Object)content, comment);
    }
}

