/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.plugin.backend;

import org.junit.Assert;
import org.junit.Test;
import org.uberfire.ext.plugin.backend.JSRegistry;
import org.uberfire.ext.plugin.backend.PluginSamples;
import org.uberfire.ext.plugin.model.CodeType;
import org.uberfire.ext.plugin.model.PluginSimpleContent;

public class JSRegistryTest {
    @Test
    public void createEmptyScreenRegistry() {
        PluginSimpleContent pluginContent = PluginSamples.getEmptyScreen();
        Assert.assertEquals((Object)PluginSamples.loadSample("empty_screen_registry.txt"), (Object)JSRegistry.convertToJSRegistry((PluginSimpleContent)pluginContent));
    }

    @Test
    public void createScreenWithTitleRegistry() {
        PluginSimpleContent pluginContent = PluginSamples.getScreenWithTitle();
        Assert.assertEquals((Object)PluginSamples.loadSample("screen_with_title_registry.txt"), (Object)JSRegistry.convertToJSRegistry((PluginSimpleContent)pluginContent));
    }

    @Test
    public void createScreenWithTitleAndMainRegistry() {
        PluginSimpleContent pluginContent = PluginSamples.getScreenWithMainAndTitle();
        Assert.assertEquals((Object)PluginSamples.loadSample("screen_with_title_and_name_registry.txt"), (Object)JSRegistry.convertToJSRegistry((PluginSimpleContent)pluginContent));
    }

    @Test
    public void createAngularScreenRegistry() {
        PluginSimpleContent pluginContent = PluginSamples.getTodoAngularPluginSimpleContent();
        Assert.assertEquals((Object)PluginSamples.loadSample("angular_todo_registry.txt"), (Object)JSRegistry.convertToJSRegistry((PluginSimpleContent)pluginContent));
    }

    @Test
    public void createSplashScreenRegistry() {
        PluginSimpleContent pluginContent = PluginSamples.getSplashScreen();
        Assert.assertEquals((Object)PluginSamples.loadSample("splash_screen_registry.txt"), (Object)JSRegistry.convertToJSRegistry((PluginSimpleContent)pluginContent));
    }

    @Test
    public void prepareTextualEntry() {
        Assert.assertEquals((Object)"function (){return \"\";}", (Object)JSRegistry.prepareEntryValue((CodeType)CodeType.TITLE, null));
        Assert.assertEquals((Object)"function (){return \"\";}", (Object)JSRegistry.prepareEntryValue((CodeType)CodeType.TITLE, (String)""));
        Assert.assertEquals((Object)"function (){return \" \";}", (Object)JSRegistry.prepareEntryValue((CodeType)CodeType.TITLE, (String)" "));
        Assert.assertEquals((Object)"function (){return \"Title\";}", (Object)JSRegistry.prepareEntryValue((CodeType)CodeType.TITLE, (String)"Title"));
        Assert.assertEquals((Object)"function (){return \"Title\";}", (Object)JSRegistry.prepareEntryValue((CodeType)CodeType.TITLE, (String)"\"Title\""));
        Assert.assertEquals((Object)"function (){return \"Long Title\";}", (Object)JSRegistry.prepareEntryValue((CodeType)CodeType.TITLE, (String)"\"Long Title\""));
    }

    @Test
    public void prepareJSEntry() {
        Assert.assertEquals((Object)"function () { return \"ko\";}", (Object)JSRegistry.prepareEntryValue((CodeType)CodeType.TITLE, (String)"function () { return \"ko\";}"));
        Assert.assertEquals((Object)"function (){alert('hi');;}", (Object)JSRegistry.prepareEntryValue((CodeType)CodeType.ON_CLOSE, (String)"alert('hi');"));
    }
}

