/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.plugin.backend;

import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Instance;
import org.jboss.errai.security.shared.api.identity.User;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.Spy;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.ext.editor.commons.backend.service.SaveAndRenameServiceImpl;
import org.uberfire.ext.editor.commons.backend.validation.DefaultFileNameValidator;
import org.uberfire.ext.editor.commons.file.DefaultMetadata;
import org.uberfire.ext.plugin.backend.MediaServletURI;
import org.uberfire.ext.plugin.backend.PluginServicesImpl;
import org.uberfire.ext.plugin.event.MediaDeleted;
import org.uberfire.ext.plugin.event.PluginAdded;
import org.uberfire.ext.plugin.event.PluginDeleted;
import org.uberfire.ext.plugin.event.PluginRenamed;
import org.uberfire.ext.plugin.event.PluginSaved;
import org.uberfire.ext.plugin.exception.PluginAlreadyExists;
import org.uberfire.ext.plugin.model.DynamicMenu;
import org.uberfire.ext.plugin.model.Framework;
import org.uberfire.ext.plugin.model.LayoutEditorModel;
import org.uberfire.ext.plugin.model.Plugin;
import org.uberfire.ext.plugin.model.PluginSimpleContent;
import org.uberfire.ext.plugin.model.PluginType;
import org.uberfire.ext.plugin.model.RuntimePlugin;
import org.uberfire.io.IOService;
import org.uberfire.io.impl.IOServiceDotFileImpl;
import org.uberfire.java.nio.file.FileAlreadyExistsException;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.Path;
import org.uberfire.mocks.FileSystemTestingUtils;
import org.uberfire.rpc.SessionInfo;

public class PluginServicesImplTest {
    private static FileSystemTestingUtils fileSystemTestingUtils = new FileSystemTestingUtils();
    @Mock(name="MediaServletURI")
    private Instance<MediaServletURI> mediaServletURI;
    @Mock
    private transient SessionInfo sessionInfo;
    @Mock
    private Event<PluginAdded> pluginAddedEvent;
    @Mock
    private Event<PluginDeleted> pluginDeletedEvent;
    @Mock
    private Event<PluginSaved> pluginSavedEvent;
    @Mock
    private Event<PluginRenamed> pluginRenamedEvent;
    @Mock
    private Event<MediaDeleted> mediaDeletedEvent;
    @Mock(name="pluginsFS")
    private FileSystem fileSystem;
    @Spy
    private DefaultFileNameValidator defaultFileNameValidator;
    @Mock
    private SaveAndRenameServiceImpl<Plugin, DefaultMetadata> saveAndRenameService;
    @Mock
    private User identity;
    private IOServiceDotFileImpl ioService;
    private PluginServicesImpl pluginServices;

    @After
    public void cleanupFileSystem() {
        fileSystemTestingUtils.cleanup();
    }

    @Before
    public void setup() throws IOException {
        fileSystemTestingUtils.setup();
        MockitoAnnotations.initMocks((Object)this);
        this.ioService = (IOServiceDotFileImpl)Mockito.spy((Object)((IOServiceDotFileImpl)fileSystemTestingUtils.getIoService()));
        ((IOServiceDotFileImpl)Mockito.doReturn((Object)fileSystemTestingUtils.getFileSystem()).when((Object)this.ioService)).getFileSystem((URI)Mockito.any(URI.class));
        ((FileSystem)Mockito.doReturn((Object)fileSystemTestingUtils.getFileSystem().getRootDirectories()).when((Object)this.fileSystem)).getRootDirectories();
        ((IOServiceDotFileImpl)Mockito.doNothing().when((Object)this.ioService)).startBatch((FileSystem)Mockito.any(FileSystem.class));
        ((IOServiceDotFileImpl)Mockito.doNothing().when((Object)this.ioService)).endBatch();
        this.pluginServices = (PluginServicesImpl)Mockito.spy((Object)new PluginServicesImpl((IOService)this.ioService, this.mediaServletURI, this.sessionInfo, this.pluginAddedEvent, this.pluginDeletedEvent, this.pluginSavedEvent, this.pluginRenamedEvent, this.mediaDeletedEvent, this.defaultFileNameValidator, this.identity, fileSystemTestingUtils.getFileSystem(), this.saveAndRenameService){

            String getFrameworkScript(Framework framework) throws IOException {
                return "script";
            }

            IOService getIoService() {
                return PluginServicesImplTest.this.ioService;
            }
        });
        this.pluginServices.init();
    }

    @Test(expected=PluginAlreadyExists.class)
    public void testCreateTwoPluginsWithTheSameName() {
        this.createPlugin("pluginName", PluginType.SCREEN, null);
        this.createPlugin("pluginName", PluginType.EDITOR, null);
    }

    @Test
    public void testListRuntimePluginsOfEmptyScreen() {
        this.createPlugin("emptyScreen", PluginType.SCREEN, null);
        Collection runtimePlugins = this.pluginServices.listRuntimePlugins();
        Assert.assertEquals((long)1L, (long)runtimePlugins.size());
        Assert.assertTrue((boolean)this.contains(runtimePlugins, "emptyScreen"));
    }

    @Test
    public void testListRuntimePluginsOfScreenWithFramework() {
        this.createPlugin("angularScreen", PluginType.SCREEN, Framework.ANGULAR);
        Collection runtimePlugins = this.pluginServices.listRuntimePlugins();
        Assert.assertEquals((long)2L, (long)runtimePlugins.size());
        Assert.assertTrue((boolean)this.contains(runtimePlugins, "angularScreen"));
    }

    @Test
    public void testListRuntimePluginsOfMultipleScreens() {
        this.createPlugin("emptyScreen", PluginType.SCREEN, null);
        this.createPlugin("angularScreen", PluginType.SCREEN, Framework.ANGULAR);
        this.createPlugin("knockoutScreen", PluginType.SCREEN, Framework.KNOCKOUT);
        Collection runtimePlugins = this.pluginServices.listRuntimePlugins();
        Assert.assertEquals((long)5L, (long)runtimePlugins.size());
        Assert.assertTrue((boolean)this.contains(runtimePlugins, "emptyScreen"));
        Assert.assertTrue((boolean)this.contains(runtimePlugins, "angularScreen"));
        Assert.assertTrue((boolean)this.contains(runtimePlugins, "knockoutScreen"));
    }

    @Test
    public void testCopyPlugin() {
        org.uberfire.backend.vfs.Path pluginPath = this.createPlugin("emptyScreen", PluginType.SCREEN, null);
        this.pluginServices.copy(pluginPath, "newEmptyScreen", "");
        ((Event)Mockito.verify(this.pluginAddedEvent, (VerificationMode)Mockito.times((int)1))).fire(Mockito.any(PluginAdded.class));
        Collection runtimePlugins = this.pluginServices.listRuntimePlugins();
        Assert.assertEquals((long)2L, (long)runtimePlugins.size());
        Assert.assertTrue((boolean)this.contains(runtimePlugins, "emptyScreen"));
        Assert.assertTrue((boolean)this.contains(runtimePlugins, "newEmptyScreen"));
    }

    @Test
    public void testCopyPluginToAnotherDirectory() {
        org.uberfire.backend.vfs.Path pluginPath = this.createPlugin("emptyScreen", PluginType.SCREEN, null);
        PluginSimpleContent targetPlugin = this.buildPlugin("newEmptyScreen", PluginType.SCREEN, null);
        org.uberfire.backend.vfs.Path targetDir = Paths.convert((Path)Paths.convert((org.uberfire.backend.vfs.Path)targetPlugin.getPath()).getParent());
        org.uberfire.backend.vfs.Path resultPath = this.pluginServices.copy(pluginPath, "newEmptyScreen", targetDir, "");
        Assert.assertEquals((Object)Paths.convert((org.uberfire.backend.vfs.Path)resultPath), (Object)Paths.convert((org.uberfire.backend.vfs.Path)targetPlugin.getPath()));
        ((Event)Mockito.verify(this.pluginAddedEvent, (VerificationMode)Mockito.times((int)1))).fire(Mockito.any(PluginAdded.class));
        Collection runtimePlugins = this.pluginServices.listRuntimePlugins();
        Assert.assertEquals((long)2L, (long)runtimePlugins.size());
        Assert.assertTrue((boolean)this.contains(runtimePlugins, "emptyScreen"));
        Assert.assertTrue((boolean)this.contains(runtimePlugins, "newEmptyScreen"));
    }

    @Test(expected=FileAlreadyExistsException.class)
    public void testCopyPluginAlreadyExists() {
        org.uberfire.backend.vfs.Path pluginPath = this.createPlugin("emptyScreen", PluginType.SCREEN, null);
        this.pluginServices.copy(pluginPath, "emptyScreen", pluginPath, "");
    }

    @Test
    public void testRenamePlugin() {
        org.uberfire.backend.vfs.Path pluginPath = this.createPlugin("emptyScreen", PluginType.SCREEN, null);
        this.pluginServices.rename(pluginPath, "newEmptyScreen", "");
        ((Event)Mockito.verify(this.pluginRenamedEvent, (VerificationMode)Mockito.times((int)1))).fire(Mockito.any(PluginRenamed.class));
        Collection runtimePlugins = this.pluginServices.listRuntimePlugins();
        Assert.assertEquals((long)1L, (long)runtimePlugins.size());
        Assert.assertTrue((boolean)this.contains(runtimePlugins, "newEmptyScreen"));
    }

    @Test
    public void testDeletePlugin() {
        org.uberfire.backend.vfs.Path pluginPath = this.createPlugin("emptyScreen", PluginType.SCREEN, null);
        this.pluginServices.delete(pluginPath, "");
        ((Event)Mockito.verify(this.pluginDeletedEvent, (VerificationMode)Mockito.times((int)1))).fire(Mockito.any(PluginDeleted.class));
        Collection runtimePlugins = this.pluginServices.listRuntimePlugins();
        Assert.assertEquals((long)0L, (long)runtimePlugins.size());
    }

    @Test
    public void testLoadEmptyLayout() {
        org.uberfire.backend.vfs.Path pluginPath = this.createPlugin("emptyLayout", PluginType.PERSPECTIVE_LAYOUT, null);
        LayoutEditorModel layoutEditorModel = this.pluginServices.getLayoutEditor(pluginPath, PluginType.PERSPECTIVE_LAYOUT);
        Assert.assertEquals((Object)layoutEditorModel.getName(), (Object)"emptyLayout");
        Assert.assertEquals((Object)layoutEditorModel.getPath(), (Object)pluginPath);
        Assert.assertTrue((boolean)layoutEditorModel.isEmptyLayout());
    }

    @Test
    public void testSimpleSaveWithPluginSimpleContent() {
        org.uberfire.backend.vfs.Path expected = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        PluginSimpleContent content = (PluginSimpleContent)Mockito.mock(PluginSimpleContent.class);
        String comment = "comment";
        ((PluginServicesImpl)Mockito.doReturn((Object)expected).when((Object)this.pluginServices)).save(content, "comment");
        org.uberfire.backend.vfs.Path actual = this.pluginServices.save((Plugin)content, "comment");
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testSimpleSaveWithoutPluginSimpleContent() {
        DynamicMenu content = (DynamicMenu)Mockito.mock(DynamicMenu.class);
        String comment = "comment";
        org.uberfire.backend.vfs.Path actual = this.pluginServices.save((Plugin)content, "comment");
        Assert.assertNull((Object)actual);
    }

    @Test
    public void testSave() {
        org.uberfire.backend.vfs.Path expected = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        org.uberfire.backend.vfs.Path path = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        DefaultMetadata metadata = (DefaultMetadata)Mockito.mock(DefaultMetadata.class);
        PluginSimpleContent content = (PluginSimpleContent)Mockito.mock(PluginSimpleContent.class);
        String comment = "comment";
        ((PluginServicesImpl)Mockito.doReturn((Object)expected).when((Object)this.pluginServices)).save(content, "comment");
        org.uberfire.backend.vfs.Path actual = this.pluginServices.save(path, (Plugin)content, metadata, "comment");
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testSaveAndRename() {
        org.uberfire.backend.vfs.Path expected = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        org.uberfire.backend.vfs.Path path = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        String newFileName = "newFileName";
        DefaultMetadata metadata = (DefaultMetadata)Mockito.mock(DefaultMetadata.class);
        PluginSimpleContent content = (PluginSimpleContent)Mockito.mock(PluginSimpleContent.class);
        String comment = "comment";
        ((SaveAndRenameServiceImpl)Mockito.doReturn((Object)expected).when(this.saveAndRenameService)).saveAndRename(path, "newFileName", (Object)metadata, (Object)content, "comment");
        org.uberfire.backend.vfs.Path actual = this.pluginServices.saveAndRename(path, "newFileName", metadata, (Plugin)content, "comment");
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    private org.uberfire.backend.vfs.Path createPlugin(String name, PluginType type, Framework framework) {
        this.pluginServices.createNewPlugin(name, type);
        ((Event)Mockito.verify(this.pluginAddedEvent, (VerificationMode)Mockito.times((int)1))).fire(Mockito.any(PluginAdded.class));
        Mockito.reset((Object[])new Event[]{this.pluginAddedEvent});
        PluginSimpleContent pluginSimpleContent = this.buildPlugin(name, type, framework);
        this.pluginServices.save(pluginSimpleContent, "");
        ((Event)Mockito.verify(this.pluginSavedEvent, (VerificationMode)Mockito.times((int)1))).fire(Mockito.any(PluginSaved.class));
        Mockito.reset((Object[])new Event[]{this.pluginSavedEvent});
        return pluginSimpleContent.getPath();
    }

    private PluginSimpleContent buildPlugin(String name, PluginType type, Framework framework) {
        HashSet<Framework> frameworks = new HashSet<Framework>();
        if (framework != null) {
            frameworks.add(framework);
        }
        return new PluginSimpleContent(name, type, PathFactory.newPath((String)(type.name().toLowerCase() + ".plugin"), (String)("git://amend-repo-test/" + name + "/" + type.name().toLowerCase() + ".plugin")), null, null, new HashMap(), frameworks, null);
    }

    private boolean contains(Collection<RuntimePlugin> runtimePlugins, String pluginName) {
        for (RuntimePlugin runtimePlugin : runtimePlugins) {
            if (!runtimePlugin.getScript().contains("$registerPlugin({id:\"" + pluginName)) continue;
            return true;
        }
        return false;
    }
}

