/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.plugin.backend;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Instance;
import org.jboss.errai.security.shared.api.identity.User;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.Spy;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.ext.editor.commons.backend.service.SaveAndRenameServiceImpl;
import org.uberfire.ext.editor.commons.backend.validation.DefaultFileNameValidator;
import org.uberfire.ext.editor.commons.file.DefaultMetadata;
import org.uberfire.ext.plugin.backend.MediaServletURI;
import org.uberfire.ext.plugin.backend.PluginServicesImpl;
import org.uberfire.ext.plugin.event.MediaDeleted;
import org.uberfire.ext.plugin.event.PluginAdded;
import org.uberfire.ext.plugin.event.PluginDeleted;
import org.uberfire.ext.plugin.event.PluginRenamed;
import org.uberfire.ext.plugin.event.PluginSaved;
import org.uberfire.ext.plugin.exception.PluginAlreadyExists;
import org.uberfire.ext.plugin.model.DynamicMenu;
import org.uberfire.ext.plugin.model.Framework;
import org.uberfire.ext.plugin.model.LayoutEditorModel;
import org.uberfire.ext.plugin.model.Plugin;
import org.uberfire.ext.plugin.model.PluginSimpleContent;
import org.uberfire.ext.plugin.model.PluginType;
import org.uberfire.ext.plugin.model.RuntimePlugin;
import org.uberfire.io.IOService;
import org.uberfire.io.impl.IOServiceDotFileImpl;
import org.uberfire.java.nio.file.FileAlreadyExistsException;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.Path;
import org.uberfire.mocks.FileSystemTestingUtils;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.spaces.SpacesAPI;

public class PluginServicesImplTest {
    private static FileSystemTestingUtils pluginsFSUtils = new FileSystemTestingUtils();
    private static FileSystemTestingUtils perspectivesFSUtils = new FileSystemTestingUtils();
    @Mock(name="MediaServletURI")
    private Instance<MediaServletURI> mediaServletURI;
    @Mock
    private transient SessionInfo sessionInfo;
    @Mock
    private Event<PluginAdded> pluginAddedEvent;
    @Mock
    private Event<PluginDeleted> pluginDeletedEvent;
    @Mock
    private Event<PluginSaved> pluginSavedEvent;
    @Mock
    private Event<PluginRenamed> pluginRenamedEvent;
    @Mock
    private Event<MediaDeleted> mediaDeletedEvent;
    @Mock(name="pluginsFS")
    private FileSystem pluginsFS;
    @Mock(name="perspectivesFS")
    private FileSystem perspectivesFS;
    @Spy
    private DefaultFileNameValidator defaultFileNameValidator;
    @Mock
    private SaveAndRenameServiceImpl<Plugin, DefaultMetadata> saveAndRenameService;
    @Mock
    private User identity;
    @Mock
    private SpacesAPI spacesAPI;
    private IOServiceDotFileImpl ioService;
    private PluginServicesImpl pluginServices;
    private String PLUGINS_PATH = "git://plugins";
    private String PLUGINS_REPO_PATH = "git://master@plugins";
    private String PERSPECTIVES_PATH = "git://perspectives";
    private String PERSPECTIVES_REPO_PATH = "git://master@perspectives";

    @After
    public void cleanupFileSystem() {
        pluginsFSUtils.cleanup();
        perspectivesFSUtils.cleanup();
    }

    @Before
    public void setup() throws IOException {
        pluginsFSUtils.setup(this.PLUGINS_PATH);
        perspectivesFSUtils.setup(this.PERSPECTIVES_PATH);
        MockitoAnnotations.initMocks((Object)this);
        this.ioService = (IOServiceDotFileImpl)Mockito.spy((Object)((IOServiceDotFileImpl)pluginsFSUtils.getIoService()));
        ((FileSystem)Mockito.doReturn((Object)"plugins").when((Object)this.pluginsFS)).getName();
        ((FileSystem)Mockito.doReturn((Object)"perspectives").when((Object)this.perspectivesFS)).getName();
        this.pluginServices = (PluginServicesImpl)Mockito.spy((Object)new PluginServicesImpl((IOService)this.ioService, this.mediaServletURI, this.sessionInfo, this.pluginAddedEvent, this.pluginDeletedEvent, this.pluginSavedEvent, this.pluginRenamedEvent, this.mediaDeletedEvent, this.defaultFileNameValidator, this.identity, pluginsFSUtils.getFileSystem(), perspectivesFSUtils.getFileSystem(), this.saveAndRenameService, this.spacesAPI){

            String getFrameworkScript(Framework framework) throws IOException {
                return "script";
            }

            IOService getIoService() {
                return PluginServicesImplTest.this.ioService;
            }
        });
        this.pluginServices.init();
    }

    @Test(expected=PluginAlreadyExists.class)
    public void testCreateTwoPluginsWithTheSameName() {
        this.createPlugin("pluginName", PluginType.SCREEN, null);
        this.createPlugin("pluginName", PluginType.EDITOR, null);
    }

    @Test
    public void testListRuntimePluginsOfEmptyScreen() {
        this.createPlugin("emptyScreen", PluginType.SCREEN, null);
        Collection runtimePlugins = this.pluginServices.listRuntimePlugins();
        Assert.assertEquals((long)1L, (long)runtimePlugins.size());
        Assert.assertTrue((boolean)this.contains(runtimePlugins, "emptyScreen"));
    }

    @Test
    public void testListRuntimePluginsOfScreenWithFramework() {
        this.createPlugin("angularScreen", PluginType.SCREEN, Framework.ANGULAR);
        Collection runtimePlugins = this.pluginServices.listRuntimePlugins();
        Assert.assertEquals((long)2L, (long)runtimePlugins.size());
        Assert.assertTrue((boolean)this.contains(runtimePlugins, "angularScreen"));
    }

    @Test
    public void testListRuntimePluginsOfMultipleScreens() {
        this.createPlugin("emptyScreen", PluginType.SCREEN, null);
        this.createPlugin("angularScreen", PluginType.SCREEN, Framework.ANGULAR);
        this.createPlugin("knockoutScreen", PluginType.SCREEN, Framework.KNOCKOUT);
        Collection runtimePlugins = this.pluginServices.listRuntimePlugins();
        Assert.assertEquals((long)5L, (long)runtimePlugins.size());
        Assert.assertTrue((boolean)this.contains(runtimePlugins, "emptyScreen"));
        Assert.assertTrue((boolean)this.contains(runtimePlugins, "angularScreen"));
        Assert.assertTrue((boolean)this.contains(runtimePlugins, "knockoutScreen"));
    }

    @Test
    public void testCopyPlugin() {
        org.uberfire.backend.vfs.Path pluginPath = this.createPlugin("emptyScreen", PluginType.SCREEN, null);
        this.pluginServices.copy(pluginPath, "newEmptyScreen", "");
        ((Event)Mockito.verify(this.pluginAddedEvent, (VerificationMode)Mockito.times((int)1))).fire(Mockito.any(PluginAdded.class));
        Collection runtimePlugins = this.pluginServices.listRuntimePlugins();
        Assert.assertEquals((long)2L, (long)runtimePlugins.size());
        Assert.assertTrue((boolean)this.contains(runtimePlugins, "emptyScreen"));
        Assert.assertTrue((boolean)this.contains(runtimePlugins, "newEmptyScreen"));
    }

    @Test
    public void testCopyPluginToAnotherDirectory() {
        org.uberfire.backend.vfs.Path pluginPath = this.createPlugin("emptyScreen", PluginType.SCREEN, null);
        PluginSimpleContent targetPlugin = this.buildPlugin("newEmptyScreen", PluginType.SCREEN, null);
        org.uberfire.backend.vfs.Path targetDir = Paths.convert((Path)Paths.convert((org.uberfire.backend.vfs.Path)targetPlugin.getPath()).getParent());
        org.uberfire.backend.vfs.Path resultPath = this.pluginServices.copy(pluginPath, "newEmptyScreen", targetDir, "");
        Assert.assertEquals((Object)Paths.convert((org.uberfire.backend.vfs.Path)resultPath), (Object)Paths.convert((org.uberfire.backend.vfs.Path)targetPlugin.getPath()));
        ((Event)Mockito.verify(this.pluginAddedEvent, (VerificationMode)Mockito.times((int)1))).fire(Mockito.any(PluginAdded.class));
        Collection runtimePlugins = this.pluginServices.listRuntimePlugins();
        Assert.assertEquals((long)2L, (long)runtimePlugins.size());
        Assert.assertTrue((boolean)this.contains(runtimePlugins, "emptyScreen"));
        Assert.assertTrue((boolean)this.contains(runtimePlugins, "newEmptyScreen"));
    }

    @Test(expected=FileAlreadyExistsException.class)
    public void testCopyPluginAlreadyExists() {
        org.uberfire.backend.vfs.Path pluginPath = this.createPlugin("emptyScreen", PluginType.SCREEN, null);
        this.pluginServices.copy(pluginPath, "emptyScreen", pluginPath, "");
    }

    @Test
    public void testRenamePlugin() {
        org.uberfire.backend.vfs.Path pluginPath = this.createPlugin("emptyScreen", PluginType.SCREEN, null);
        this.pluginServices.rename(pluginPath, "newEmptyScreen", "");
        ((Event)Mockito.verify(this.pluginRenamedEvent, (VerificationMode)Mockito.times((int)1))).fire(Mockito.any(PluginRenamed.class));
        Collection runtimePlugins = this.pluginServices.listRuntimePlugins();
        Assert.assertEquals((long)1L, (long)runtimePlugins.size());
        Assert.assertTrue((boolean)this.contains(runtimePlugins, "newEmptyScreen"));
    }

    @Test
    public void testDeletePlugin() {
        org.uberfire.backend.vfs.Path pluginPath = this.createPlugin("emptyScreen", PluginType.SCREEN, null);
        this.pluginServices.delete(pluginPath, "");
        ((Event)Mockito.verify(this.pluginDeletedEvent, (VerificationMode)Mockito.times((int)1))).fire(Mockito.any(PluginDeleted.class));
        Collection runtimePlugins = this.pluginServices.listRuntimePlugins();
        Assert.assertEquals((long)0L, (long)runtimePlugins.size());
    }

    @Test
    public void testLoadEmptyLayout() {
        org.uberfire.backend.vfs.Path pluginPath = this.createPlugin("emptyLayout", PluginType.PERSPECTIVE_LAYOUT, null);
        LayoutEditorModel layoutEditorModel = this.pluginServices.getLayoutEditor(pluginPath, PluginType.PERSPECTIVE_LAYOUT);
        Assert.assertEquals((Object)layoutEditorModel.getName(), (Object)"emptyLayout");
        Assert.assertEquals((Object)layoutEditorModel.getPath(), (Object)pluginPath);
        Assert.assertTrue((boolean)layoutEditorModel.isEmptyLayout());
    }

    @Test
    public void testSimpleSaveWithPluginSimpleContent() {
        org.uberfire.backend.vfs.Path expected = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        PluginSimpleContent content = (PluginSimpleContent)Mockito.mock(PluginSimpleContent.class);
        String comment = "comment";
        ((PluginServicesImpl)Mockito.doReturn((Object)expected).when((Object)this.pluginServices)).save(content, "comment");
        org.uberfire.backend.vfs.Path actual = this.pluginServices.save((Plugin)content, "comment");
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testSimpleSaveWithoutPluginSimpleContent() {
        DynamicMenu content = (DynamicMenu)Mockito.mock(DynamicMenu.class);
        String comment = "comment";
        org.uberfire.backend.vfs.Path actual = this.pluginServices.save((Plugin)content, "comment");
        Assert.assertNull((Object)actual);
    }

    @Test
    public void testSave() {
        org.uberfire.backend.vfs.Path expected = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        org.uberfire.backend.vfs.Path path = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        DefaultMetadata metadata = (DefaultMetadata)Mockito.mock(DefaultMetadata.class);
        PluginSimpleContent content = (PluginSimpleContent)Mockito.mock(PluginSimpleContent.class);
        String comment = "comment";
        ((PluginServicesImpl)Mockito.doReturn((Object)expected).when((Object)this.pluginServices)).save(content, "comment");
        org.uberfire.backend.vfs.Path actual = this.pluginServices.save(path, (Plugin)content, metadata, "comment");
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testSaveAndRename() {
        org.uberfire.backend.vfs.Path expected = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        org.uberfire.backend.vfs.Path path = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        String newFileName = "newFileName";
        DefaultMetadata metadata = (DefaultMetadata)Mockito.mock(DefaultMetadata.class);
        PluginSimpleContent content = (PluginSimpleContent)Mockito.mock(PluginSimpleContent.class);
        String comment = "comment";
        ((SaveAndRenameServiceImpl)Mockito.doReturn((Object)expected).when(this.saveAndRenameService)).saveAndRename(path, "newFileName", (Object)metadata, (Object)content, "comment");
        org.uberfire.backend.vfs.Path actual = this.pluginServices.saveAndRename(path, "newFileName", metadata, (Plugin)content, "comment");
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testGetRootAndGetFileSystem() {
        Assert.assertTrue((boolean)this.pluginServices.getRoot().getFileSystem().getName().equals(this.pluginsFS.getName()));
        Assert.assertTrue((boolean)this.pluginServices.getFileSystem().getName().equals(this.pluginsFS.getName()));
        for (PluginType type : PluginType.values()) {
            String expected = type == PluginType.PERSPECTIVE_LAYOUT ? this.perspectivesFS.getName() : this.pluginsFS.getName();
            Assert.assertTrue((boolean)this.pluginServices.getRoot(type).getFileSystem().getName().equals(expected));
            Assert.assertTrue((boolean)this.pluginServices.getFileSystem(type).getName().equals(expected));
        }
    }

    @Test
    public void testCreatePluginsDifferentTypes() {
        Collection listOfDefaultPlugins = this.pluginServices.listPlugins();
        Collection listOfPerspectivesPlugins = this.pluginServices.listPlugins(PluginType.PERSPECTIVE_LAYOUT);
        Assert.assertEquals((long)0L, (long)listOfDefaultPlugins.size());
        Assert.assertEquals((long)0L, (long)listOfPerspectivesPlugins.size());
        this.pluginServices.createNewPlugin("test", PluginType.DEFAULT);
        listOfDefaultPlugins = this.pluginServices.listPlugins();
        listOfPerspectivesPlugins = this.pluginServices.listPlugins(PluginType.PERSPECTIVE_LAYOUT);
        Assert.assertEquals((long)1L, (long)listOfDefaultPlugins.size());
        Assert.assertEquals((long)0L, (long)listOfPerspectivesPlugins.size());
        Assert.assertTrue((boolean)((Plugin)listOfDefaultPlugins.iterator().next()).getPath().toURI().startsWith(this.PLUGINS_REPO_PATH));
        this.pluginServices.createNewPlugin("test", PluginType.PERSPECTIVE_LAYOUT);
        listOfDefaultPlugins = this.pluginServices.listPlugins();
        listOfPerspectivesPlugins = this.pluginServices.listPlugins(PluginType.PERSPECTIVE_LAYOUT);
        Assert.assertEquals((long)1L, (long)listOfDefaultPlugins.size());
        Assert.assertEquals((long)1L, (long)listOfPerspectivesPlugins.size());
        Assert.assertTrue((boolean)((Plugin)listOfDefaultPlugins.iterator().next()).getPath().toURI().startsWith(this.PLUGINS_REPO_PATH));
        Assert.assertTrue((boolean)((Plugin)listOfPerspectivesPlugins.iterator().next()).getPath().toURI().startsWith(this.PERSPECTIVES_REPO_PATH));
    }

    @Test
    public void testDeletePluginsDifferentTypes() {
        Plugin defaultPlugin = this.pluginServices.createNewPlugin("test", PluginType.DEFAULT);
        Assert.assertEquals((long)1L, (long)this.pluginServices.listPlugins().size());
        Assert.assertEquals((long)0L, (long)this.pluginServices.listPlugins(PluginType.PERSPECTIVE_LAYOUT).size());
        Plugin perspectivePlugin = this.pluginServices.createNewPlugin("test", PluginType.PERSPECTIVE_LAYOUT);
        Assert.assertEquals((long)1L, (long)this.pluginServices.listPlugins().size());
        Assert.assertEquals((long)1L, (long)this.pluginServices.listPlugins(PluginType.PERSPECTIVE_LAYOUT).size());
        this.pluginServices.delete(defaultPlugin.getPath(), "delete plugin");
        Assert.assertEquals((long)0L, (long)this.pluginServices.listPlugins().size());
        Assert.assertEquals((long)1L, (long)this.pluginServices.listPlugins(PluginType.PERSPECTIVE_LAYOUT).size());
        this.pluginServices.delete(perspectivePlugin.getPath(), "delete plugin");
        Assert.assertEquals((long)0L, (long)this.pluginServices.listPlugins().size());
        Assert.assertEquals((long)0L, (long)this.pluginServices.listPlugins(PluginType.PERSPECTIVE_LAYOUT).size());
    }

    private org.uberfire.backend.vfs.Path createPlugin(String name, PluginType type, Framework framework) {
        this.pluginServices.createNewPlugin(name, type);
        ((Event)Mockito.verify(this.pluginAddedEvent, (VerificationMode)Mockito.times((int)1))).fire(Mockito.any(PluginAdded.class));
        Mockito.reset((Object[])new Event[]{this.pluginAddedEvent});
        PluginSimpleContent pluginSimpleContent = this.buildPlugin(name, type, framework);
        this.pluginServices.save(pluginSimpleContent, "");
        ((Event)Mockito.verify(this.pluginSavedEvent, (VerificationMode)Mockito.times((int)1))).fire(Mockito.any(PluginSaved.class));
        Mockito.reset((Object[])new Event[]{this.pluginSavedEvent});
        return pluginSimpleContent.getPath();
    }

    private PluginSimpleContent buildPlugin(String name, PluginType type, Framework framework) {
        HashSet<Framework> frameworks = new HashSet<Framework>();
        if (framework != null) {
            frameworks.add(framework);
        }
        String basePath = type == PluginType.PERSPECTIVE_LAYOUT ? this.PERSPECTIVES_PATH : this.PLUGINS_PATH;
        String fileName = type.name().toLowerCase() + ".plugin";
        String fullPath = basePath + "/" + name + "/" + fileName;
        return new PluginSimpleContent(name, type, PathFactory.newPath((String)fileName, (String)fullPath), null, null, new HashMap(), frameworks, null);
    }

    private boolean contains(Collection<RuntimePlugin> runtimePlugins, String pluginName) {
        for (RuntimePlugin runtimePlugin : runtimePlugins) {
            if (!runtimePlugin.getScript().contains("$registerPlugin({id:\"" + pluginName)) continue;
            return true;
        }
        return false;
    }
}

