/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.plugin.backend;

import java.io.IOException;
import java.net.URI;
import java.util.Iterator;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadException;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.ext.plugin.backend.MediaServletURI;
import org.uberfire.ext.plugin.backend.PluginMediaServlet;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.Path;

@RunWith(value=MockitoJUnitRunner.class)
public class PluginMediaServletTest {
    @Mock
    FileSystem fileSystem;
    @Mock
    Iterable<Path> iterable;
    @Mock
    Iterator<Path> iterator;
    @Mock
    ServletConfig config;
    @Mock
    IOService ioService;
    @Mock
    MediaServletURI mediaServletURI;
    @InjectMocks
    PluginMediaServlet servlet = this.fakeServlet();

    @Test
    public void testInit() throws Exception {
        Mockito.when(this.iterable.iterator()).thenReturn(this.iterator);
        Mockito.when((Object)this.fileSystem.getRootDirectories()).thenReturn(this.iterable);
        Mockito.when((Object)this.config.getInitParameter(Mockito.anyString())).thenReturn((Object)"/fake");
        Mockito.when((Object)this.ioService.newFileSystem((URI)Mockito.any(URI.class), Mockito.anyMapOf(String.class, Class.class))).thenReturn((Object)this.fileSystem);
        this.servlet.init(this.config);
        ((MediaServletURI)Mockito.verify((Object)this.mediaServletURI)).setURI((String)Mockito.eq((Object)"fake/"));
    }

    @Test
    public void testDoPost() throws Exception {
        FileItem fileItem = this.fileMock("C:\\Users\\user\\Desktop\\image.jpg");
        PluginMediaServlet servlet = (PluginMediaServlet)Mockito.spy((Object)this.fakeServlet(fileItem));
        HttpServletRequest request = this.requestMock("/plugins/screen");
        HttpServletResponse response = this.responseMock();
        servlet.doPost(request, response);
        ((PluginMediaServlet)Mockito.verify((Object)servlet)).resolve("/screen/media/image.jpg");
    }

    private HttpServletResponse responseMock() {
        return (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
    }

    private HttpServletRequest requestMock(String requestURI) {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.getRequestURI()).thenReturn((Object)requestURI);
        Mockito.when((Object)request.getContextPath()).thenReturn((Object)"");
        return request;
    }

    private FileItem fileMock(String fileName) {
        FileItem fileItem = (FileItem)Mockito.mock(FileItem.class);
        Mockito.when((Object)fileItem.getName()).thenReturn((Object)fileName);
        return fileItem;
    }

    private PluginMediaServlet fakeServlet() {
        return this.fakeServlet(null);
    }

    private PluginMediaServlet fakeServlet(final FileItem fileItem) {
        return new PluginMediaServlet(){

            protected FileItem getFileItem(HttpServletRequest request) throws FileUploadException {
                return fileItem;
            }

            protected void writeResponse(HttpServletResponse response, String ok) throws IOException {
            }
        };
    }
}

