/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.plugin.backend;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.commons.io.IOUtils;
import org.uberfire.backend.vfs.Path;
import org.uberfire.ext.plugin.model.CodeType;
import org.uberfire.ext.plugin.model.Framework;
import org.uberfire.ext.plugin.model.Language;
import org.uberfire.ext.plugin.model.PluginSimpleContent;
import org.uberfire.ext.plugin.model.PluginType;

public class PluginSamples {
    public static final String ANGULAR_TODO_REGISTRY = "angular_todo_registry.txt";
    public static final String EMPTY_SCREEN_REGISTRY = "empty_screen_registry.txt";
    public static final String SCREEN_WITH_TITLE_REGISTRY = "screen_with_title_registry.txt";
    public static final String SCREEN_WITH_TITLE_AND_NAME_REGISTRY = "screen_with_title_and_name_registry.txt";
    public static final String SPLASH_SCREEN_REGISTRY = "splash_screen_registry.txt";
    private static final String ANGULAR_MAIN = "angular_main.txt";
    private static final String ANGULAR_TEMPLATE = "angular_template.txt";
    private static final String ANGULAR_CSS = "angular_css.txt";
    private static final String SPLASH_TEMPLATE = "splash_template.txt";
    private static final String SPLASH_MAIN = "splash_main.txt";

    public static PluginSimpleContent getTodoAngularPluginSimpleContent() {
        HashMap<CodeType, String> codeMap = new HashMap<CodeType, String>();
        codeMap.put(CodeType.MAIN, PluginSamples.loadSample(ANGULAR_MAIN));
        Path path = null;
        HashSet<Framework> frameworks = new HashSet<Framework>();
        frameworks.add(Framework.ANGULAR);
        PluginSimpleContent plugin = new PluginSimpleContent("Yo", PluginType.SCREEN, path, PluginSamples.loadSample(ANGULAR_TEMPLATE), PluginSamples.loadSample(ANGULAR_CSS), codeMap, frameworks, Language.JAVASCRIPT);
        return plugin;
    }

    public static PluginSimpleContent getSplashScreen() {
        HashMap<CodeType, String> codeMap = new HashMap<CodeType, String>();
        codeMap.put(CodeType.MAIN, PluginSamples.loadSample(SPLASH_MAIN));
        codeMap.put(CodeType.ON_CLOSE, PluginSamples.loadSample(SPLASH_MAIN));
        codeMap.put(CodeType.ON_CONCURRENT_COPY, PluginSamples.loadSample(SPLASH_MAIN));
        codeMap.put(CodeType.TITLE, "Title");
        Path path = null;
        HashSet frameworks = new HashSet();
        PluginSimpleContent plugin = new PluginSimpleContent("Splash", PluginType.SPLASH, path, PluginSamples.loadSample(SPLASH_TEMPLATE), "", codeMap, frameworks, Language.JAVASCRIPT);
        return plugin;
    }

    public static PluginSimpleContent getEmptyScreen() {
        HashMap<CodeType, String> codeMap = new HashMap<CodeType, String>();
        codeMap.put(CodeType.MAIN, "");
        Path path = null;
        HashSet frameworks = new HashSet();
        PluginSimpleContent plugin = new PluginSimpleContent("Yo", PluginType.SCREEN, path, "", "", codeMap, frameworks, Language.JAVASCRIPT);
        return plugin;
    }

    public static PluginSimpleContent getScreenWithTitle() {
        HashMap<CodeType, String> codeMap = new HashMap<CodeType, String>();
        codeMap.put(CodeType.MAIN, "");
        codeMap.put(CodeType.TITLE, "My Title");
        Path path = null;
        HashSet frameworks = new HashSet();
        PluginSimpleContent plugin = new PluginSimpleContent("ScreenWithTitle", PluginType.SCREEN, path, "", "", codeMap, frameworks, Language.JAVASCRIPT);
        return plugin;
    }

    public static PluginSimpleContent getScreenWithMainAndTitle() {
        HashMap<CodeType, String> codeMap = new HashMap<CodeType, String>();
        codeMap.put(CodeType.MAIN, "alert('main');");
        codeMap.put(CodeType.TITLE, "My Title");
        Path path = null;
        HashSet frameworks = new HashSet();
        PluginSimpleContent plugin = new PluginSimpleContent("ScreenWithTitle", PluginType.SCREEN, path, "", "", codeMap, frameworks, Language.JAVASCRIPT);
        return plugin;
    }

    public static String loadSample(String file) {
        try {
            return IOUtils.toString((InputStream)new PluginSamples().getClass().getResourceAsStream(file), (String)"UTF-8");
        }
        catch (IOException e) {
            return "";
        }
    }
}

