/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.plugin.client.editor;

import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.workbench.events.ChangeTitleWidgetEvent;
import org.uberfire.client.workbench.type.ClientResourceType;
import org.uberfire.ext.editor.commons.client.BaseEditor;
import org.uberfire.ext.editor.commons.client.BaseEditorView;
import org.uberfire.ext.editor.commons.client.menu.MenuItems;
import org.uberfire.ext.editor.commons.service.support.SupportsCopy;
import org.uberfire.ext.editor.commons.service.support.SupportsDelete;
import org.uberfire.ext.editor.commons.service.support.SupportsRename;
import org.uberfire.ext.plugin.event.PluginRenamed;
import org.uberfire.ext.plugin.model.Plugin;
import org.uberfire.ext.plugin.model.PluginType;
import org.uberfire.ext.plugin.service.PluginServices;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.PlaceRequest;

public abstract class RuntimePluginBaseEditor
extends BaseEditor {
    protected Plugin plugin;
    @Inject
    private Caller<PluginServices> pluginServices;

    protected RuntimePluginBaseEditor(BaseEditorView baseView) {
        this.baseView = baseView;
    }

    protected abstract PluginType getPluginType();

    protected abstract ClientResourceType getResourceType();

    @OnStartup
    public void onStartup(ObservablePath path, PlaceRequest place) {
        this.init(path, place, this.getResourceType(), true, false, new MenuItems[]{MenuItems.SAVE, MenuItems.COPY, MenuItems.RENAME, MenuItems.DELETE});
        this.plugin = new Plugin(place.getParameter("name", ""), this.getPluginType(), (Path)path);
        this.place = place;
    }

    protected void onPlugInRenamed(@Observes PluginRenamed pluginRenamed) {
        if (pluginRenamed.getOldPluginName().equals(this.plugin.getName()) && pluginRenamed.getPlugin().getType().equals((Object)this.plugin.getType())) {
            this.plugin = new Plugin(pluginRenamed.getPlugin().getName(), this.getPluginType(), pluginRenamed.getPlugin().getPath());
            this.changeTitleNotification.fire((Object)new ChangeTitleWidgetEvent(this.place, this.getTitleText(), this.getTitle()));
        }
    }

    protected Caller<? extends SupportsDelete> getDeleteServiceCaller() {
        return this.pluginServices;
    }

    protected Caller<? extends SupportsRename> getRenameServiceCaller() {
        return this.pluginServices;
    }

    protected Caller<? extends SupportsCopy> getCopyServiceCaller() {
        return this.pluginServices;
    }
}

