/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.plugin.client.perspective.editor;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.annotations.WorkbenchEditor;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartTitleDecoration;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.mvp.UberView;
import org.uberfire.client.workbench.events.ChangeTitleWidgetEvent;
import org.uberfire.ext.editor.commons.client.BaseEditor;
import org.uberfire.ext.editor.commons.client.BaseEditorView;
import org.uberfire.ext.editor.commons.client.menu.MenuItems;
import org.uberfire.ext.editor.commons.service.support.SupportsCopy;
import org.uberfire.ext.editor.commons.service.support.SupportsDelete;
import org.uberfire.ext.editor.commons.service.support.SupportsRename;
import org.uberfire.ext.layout.editor.client.LayoutEditorPluginAPI;
import org.uberfire.ext.layout.editor.client.util.LayoutDragComponent;
import org.uberfire.ext.plugin.client.perspective.editor.components.popup.AddTag;
import org.uberfire.ext.plugin.client.perspective.editor.generator.PerspectiveEditorGenerator;
import org.uberfire.ext.plugin.client.perspective.editor.layout.editor.HTMLLayoutDragComponent;
import org.uberfire.ext.plugin.client.perspective.editor.layout.editor.ScreenLayoutDragComponent;
import org.uberfire.ext.plugin.client.perspective.editor.util.TagButton;
import org.uberfire.ext.plugin.client.type.PerspectiveLayoutPluginResourceType;
import org.uberfire.ext.plugin.event.PluginRenamed;
import org.uberfire.ext.plugin.model.LayoutEditorModel;
import org.uberfire.ext.plugin.model.Plugin;
import org.uberfire.ext.plugin.model.PluginType;
import org.uberfire.ext.plugin.service.PluginServices;
import org.uberfire.lifecycle.OnMayClose;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.events.NotificationEvent;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.Menus;

@Dependent
@WorkbenchEditor(identifier="Perspective Editor", supportedTypes={PerspectiveLayoutPluginResourceType.class}, priority=0x7FFFFFFF)
public class PerspectiveEditorPresenter
extends BaseEditor {
    private final View perspectiveEditorView;
    @Inject
    private PerspectiveEditorGenerator perspectiveEditorGenerator;
    @Inject
    private LayoutEditorPluginAPI layoutEditorPluginAPI;
    @Inject
    private Event<NotificationEvent> ufNotification;
    @Inject
    private PerspectiveLayoutPluginResourceType resourceType;
    private Plugin plugin;
    @Inject
    private Caller<PluginServices> pluginServices;
    @Inject
    private ScreenLayoutDragComponent screenLayoutDragComponent;
    @Inject
    private HTMLLayoutDragComponent htmlLayoutDragComponent;

    @Inject
    public PerspectiveEditorPresenter(View perspectiveEditorView) {
        super((BaseEditorView)perspectiveEditorView);
        this.perspectiveEditorView = perspectiveEditorView;
    }

    @OnStartup
    public void onStartup(ObservablePath path, PlaceRequest place) {
        this.init(path, place, this.resourceType, true, false, new MenuItems[]{MenuItems.SAVE, MenuItems.COPY, MenuItems.RENAME, MenuItems.DELETE});
        String name = place.getParameter("name", "");
        this.plugin = new Plugin(name, PluginType.PERSPECTIVE_LAYOUT, (Path)path);
        this.layoutEditorPluginAPI.init(PluginType.PERSPECTIVE_LAYOUT, name, new LayoutDragComponent[]{this.screenLayoutDragComponent, this.htmlLayoutDragComponent});
        this.perspectiveEditorView.setupLayoutEditor(this.layoutEditorPluginAPI.asWidget());
    }

    protected void makeMenuBar() {
        super.makeMenuBar();
        this.menuBuilder.addNewTopLevelMenu((MenuItem)new TagButton(new Command(){

            public void execute() {
                AddTag addTag = new AddTag(PerspectiveEditorPresenter.this);
                addTag.show();
            }
        }));
    }

    @OnMayClose
    public boolean onMayClose() {
        return super.mayClose(Integer.valueOf(this.layoutEditorPluginAPI.getCurrentModelHash()));
    }

    @WorkbenchPartTitleDecoration
    public IsWidget getTitle() {
        return super.getTitle();
    }

    @WorkbenchPartTitle
    public String getTitleText() {
        return "Perspective Editor [" + this.plugin.getName() + "]";
    }

    @WorkbenchMenu
    public Menus getMenus() {
        return this.menus;
    }

    protected void loadContent() {
        this.baseView.hideBusyIndicator();
        this.layoutEditorPluginAPI.load(PluginType.PERSPECTIVE_LAYOUT, (Path)this.versionRecordManager.getCurrentPath(), (ParameterizedCommand)new ParameterizedCommand<LayoutEditorModel>(){

            public void execute(LayoutEditorModel layoutEditorModel) {
                PerspectiveEditorPresenter.this.setOriginalHash(PerspectiveEditorPresenter.this.layoutEditorPluginAPI.getCurrentModelHash());
                PerspectiveEditorPresenter.this.plugin = (Plugin)layoutEditorModel;
            }
        });
    }

    protected void save() {
        this.layoutEditorPluginAPI.save((Path)this.versionRecordManager.getCurrentPath(), this.getSaveSuccessCallback(this.layoutEditorPluginAPI.getCurrentModelHash()));
        this.concurrentUpdateSessionInfo = null;
    }

    protected RemoteCallback<Path> getSaveSuccessCallback(int newHash) {
        return new RemoteCallback<Path>(){

            public void callback(Path path) {
                RemoteCallback saveSuccessCallback = PerspectiveEditorPresenter.super.getSaveSuccessCallback(PerspectiveEditorPresenter.this.layoutEditorPluginAPI.getCurrentModelHash());
                saveSuccessCallback.callback((Object)path);
                PerspectiveEditorPresenter.this.perspectiveEditorGenerator.generate(PerspectiveEditorPresenter.this.layoutEditorPluginAPI.getModel());
            }
        };
    }

    @WorkbenchPartView
    public UberView<PerspectiveEditorPresenter> getWidget() {
        return (UberView)this.baseView;
    }

    protected void onPlugInRenamed(@Observes PluginRenamed pluginRenamed) {
        if (pluginRenamed.getOldPluginName().equals(this.plugin.getName()) && pluginRenamed.getPlugin().getType().equals((Object)this.plugin.getType())) {
            this.plugin = new Plugin(pluginRenamed.getPlugin().getName(), PluginType.PERSPECTIVE_LAYOUT, pluginRenamed.getPlugin().getPath());
            this.changeTitleNotification.fire((Object)new ChangeTitleWidgetEvent(this.place, this.getTitleText(), this.getTitle()));
        }
    }

    protected Caller<? extends SupportsDelete> getDeleteServiceCaller() {
        return this.pluginServices;
    }

    protected Caller<? extends SupportsRename> getRenameServiceCaller() {
        return this.pluginServices;
    }

    protected Caller<? extends SupportsCopy> getCopyServiceCaller() {
        return this.pluginServices;
    }

    public void saveProperty(String key, String value) {
        this.layoutEditorPluginAPI.addLayoutProperty(key, value);
    }

    public String getLayoutProperty(String key) {
        return this.layoutEditorPluginAPI.getLayoutProperty(key);
    }

    public static interface View
    extends BaseEditorView {
        public void setupLayoutEditor(Widget var1);
    }
}

