/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.plugin.client.perspective.editor.generator;

import com.github.gwtbootstrap.client.ui.Column;
import com.github.gwtbootstrap.client.ui.FluidContainer;
import com.github.gwtbootstrap.client.ui.FluidRow;
import com.github.gwtbootstrap.client.ui.base.DivWidget;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.WorkbenchScreenActivity;
import org.uberfire.ext.layout.editor.api.editor.ColumnEditor;
import org.uberfire.ext.layout.editor.api.editor.LayoutComponent;
import org.uberfire.ext.layout.editor.api.editor.LayoutEditor;
import org.uberfire.ext.layout.editor.api.editor.RowEditor;
import org.uberfire.ext.plugin.client.perspective.editor.layout.editor.HTMLLayoutDragComponent;
import org.uberfire.ext.plugin.client.perspective.editor.layout.editor.ScreenLayoutDragComponent;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.workbench.model.NamedPosition;
import org.uberfire.workbench.model.Position;
import org.uberfire.workbench.model.menu.Menus;
import org.uberfire.workbench.model.toolbar.ToolBar;

public class DefaultPerspectiveEditorScreenActivity
implements WorkbenchScreenActivity {
    private LayoutEditor editor;
    private final PlaceManager placeManager;
    private PlaceRequest place;
    private static final Collection<String> ROLES = Collections.emptyList();
    private static final Collection<String> TRAITS = Collections.emptyList();
    private FluidContainer mainPanel;
    private List<Target> screensToLoad = new ArrayList<Target>();

    public DefaultPerspectiveEditorScreenActivity(LayoutEditor editor, PlaceManager placeManager) {
        this.placeManager = placeManager;
        this.build(editor);
    }

    public void build(LayoutEditor editor) {
        this.editor = editor;
        this.screensToLoad.clear();
        this.mainPanel = new FluidContainer();
        this.mainPanel.getElement().setId("mainContainer");
        List rows = this.editor.getRows();
        this.extractRows(rows, (DivWidget)this.mainPanel);
    }

    private void extractRows(List<RowEditor> rows, DivWidget parentWidget) {
        for (RowEditor rowEditor : rows) {
            FluidRow row = new FluidRow();
            for (ColumnEditor columnEditor : rowEditor.getColumnEditors()) {
                Column column = new Column(new Integer(columnEditor.getSpan()).intValue());
                if (this.columnHasNestedRows(columnEditor)) {
                    this.extractRows(columnEditor.getRows(), (DivWidget)column);
                } else {
                    this.generateComponents(columnEditor, column);
                }
                row.add((Widget)column);
            }
            parentWidget.add((Widget)row);
        }
    }

    private void generateComponents(ColumnEditor columnEditor, Column column) {
        for (LayoutComponent layoutComponent : columnEditor.getLayoutComponents()) {
            if (this.isAnHTMLComponent(layoutComponent)) {
                this.generateHtmlComponent(column, layoutComponent);
                continue;
            }
            if (!this.isAndScreenComponent(layoutComponent)) continue;
            this.generateScreenComponent(column, layoutComponent);
        }
    }

    private void generateScreenComponent(Column column, LayoutComponent layoutComponent) {
        Random r = new Random();
        Map properties = layoutComponent.getProperties();
        String placeName = (String)properties.get("Place Name");
        if (placeName != null) {
            FlowPanel panel = new FlowPanel();
            panel.getElement().setId(placeName + r.nextInt());
            column.add((Widget)panel);
            this.screensToLoad.add(new Target(placeName, column, panel, properties));
        }
    }

    private void generateHtmlComponent(Column column, LayoutComponent layoutComponent) {
        Map properties = layoutComponent.getProperties();
        String html = (String)properties.get("HTML_CODE");
        if (html != null) {
            HTMLPanel panel = new HTMLPanel(html);
            column.add((Widget)panel);
        }
    }

    private boolean isAndScreenComponent(LayoutComponent layoutComponent) {
        return layoutComponent.isFromMyDragTypeType(ScreenLayoutDragComponent.class);
    }

    private boolean isAnHTMLComponent(LayoutComponent layoutComponent) {
        return layoutComponent.isFromMyDragTypeType(HTMLLayoutDragComponent.class);
    }

    private boolean columnHasNestedRows(ColumnEditor columnEditor) {
        return columnEditor.getRows() != null && !columnEditor.getRows().isEmpty();
    }

    public void onStartup(PlaceRequest place) {
        this.place = place;
    }

    public PlaceRequest getPlace() {
        return this.place;
    }

    public boolean onMayClose() {
        return true;
    }

    public void onClose() {
    }

    public void onShutdown() {
    }

    public Position getDefaultPosition() {
        return new NamedPosition("mainContainer");
    }

    public PlaceRequest getOwningPlace() {
        return null;
    }

    public void onFocus() {
    }

    public void onLostFocus() {
    }

    public String getTitle() {
        return "";
    }

    public IsWidget getTitleDecoration() {
        return null;
    }

    public IsWidget getWidget() {
        return this.mainPanel;
    }

    public Menus getMenus() {
        return null;
    }

    public ToolBar getToolBar() {
        return null;
    }

    public void onOpen() {
        for (Target target : this.screensToLoad) {
            Column column = target.getColumn();
            FlowPanel panel = target.getPanel();
            int height = 400;
            panel.setPixelSize(column.getElement().getClientWidth(), 400);
            this.placeManager.goTo((PlaceRequest)new DefaultPlaceRequest(target.getPlaceName(), target.getParameters()), (HasWidgets)target.getPanel());
        }
    }

    public String getSignatureId() {
        return this.getName();
    }

    public String getName() {
        return this.editor.getName() + DefaultPerspectiveEditorScreenActivity.screenSufix();
    }

    public static String screenSufix() {
        return "Screen";
    }

    public Collection<String> getRoles() {
        return ROLES;
    }

    public Collection<String> getTraits() {
        return TRAITS;
    }

    public String contextId() {
        return this.getName();
    }

    public Integer preferredHeight() {
        return null;
    }

    public Integer preferredWidth() {
        return null;
    }

    private class Target {
        private final String placeName;
        private final Column column;
        private final FlowPanel panel;
        private final Map<String, String> parameters;

        public Target(String placeName, Column column, FlowPanel panel, Map<String, String> parameters) {
            this.placeName = placeName;
            this.column = column;
            this.panel = panel;
            this.parameters = parameters;
        }

        public Map<String, String> getParameters() {
            return this.parameters;
        }

        public FlowPanel getPanel() {
            return this.panel;
        }

        public Column getColumn() {
            return this.column;
        }

        public String getPlaceName() {
            return this.placeName;
        }
    }
}

