/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.plugin.client.perspective.editor.generator;

import java.lang.annotation.Annotation;
import java.util.Collection;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.ioc.client.QualifierUtil;
import org.jboss.errai.ioc.client.api.AfterInitialization;
import org.jboss.errai.ioc.client.container.IOC;
import org.jboss.errai.ioc.client.container.IOCBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanManagerImpl;
import org.uberfire.client.mvp.Activity;
import org.uberfire.client.mvp.ActivityBeansCache;
import org.uberfire.client.mvp.PerspectiveActivity;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.WorkbenchScreenActivity;
import org.uberfire.ext.layout.editor.api.LayoutServices;
import org.uberfire.ext.layout.editor.api.editor.LayoutEditor;
import org.uberfire.ext.plugin.client.perspective.editor.generator.DefaultPerspectiveEditorActivity;
import org.uberfire.ext.plugin.client.perspective.editor.generator.DefaultPerspectiveEditorScreenActivity;
import org.uberfire.ext.plugin.model.LayoutEditorModel;
import org.uberfire.ext.plugin.model.PluginType;
import org.uberfire.ext.plugin.service.PluginServices;

@ApplicationScoped
public class PerspectiveEditorGenerator {
    private SyncBeanManagerImpl beanManager;
    private ActivityBeansCache activityBeansCache;
    private PlaceManager placeManager;
    @Inject
    private Caller<PluginServices> pluginServices;
    @Inject
    private Caller<LayoutServices> layoutServices;

    @PostConstruct
    public void setup() {
        this.beanManager = (SyncBeanManagerImpl)IOC.getBeanManager();
        this.activityBeansCache = (ActivityBeansCache)this.beanManager.lookupBean(ActivityBeansCache.class, new Annotation[0]).getInstance();
        this.placeManager = (PlaceManager)this.beanManager.lookupBean(PlaceManager.class, new Annotation[0]).getInstance();
    }

    @AfterInitialization
    public void loadPerspectives() {
        ((PluginServices)this.pluginServices.call((RemoteCallback)new RemoteCallback<Collection<LayoutEditorModel>>(){

            public void callback(Collection<LayoutEditorModel> response) {
                for (LayoutEditorModel layoutEditorModel : response) {
                    PerspectiveEditorGenerator.this.generatePerspective(layoutEditorModel);
                }
            }
        })).listLayoutEditor(PluginType.PERSPECTIVE_LAYOUT);
    }

    private void generatePerspective(LayoutEditorModel model) {
        ((LayoutServices)this.layoutServices.call((RemoteCallback)new RemoteCallback<LayoutEditor>(){

            public void callback(LayoutEditor perspective) {
                if (perspective != null) {
                    PerspectiveEditorGenerator.this.generate(perspective);
                }
            }
        })).convertLayoutFromString(model.getLayoutEditorModel());
    }

    public void generate(LayoutEditor layoutEditor) {
        if (this.isANewPerspective(layoutEditor)) {
            DefaultPerspectiveEditorScreenActivity screen = this.createNewScreen(layoutEditor);
            this.createNewPerspective(layoutEditor, screen);
        } else {
            DefaultPerspectiveEditorScreenActivity screen = this.updateScreen(layoutEditor);
            this.updatePerspective(layoutEditor, screen);
        }
    }

    private void updatePerspective(LayoutEditor editor, DefaultPerspectiveEditorScreenActivity screen) {
        IOCBeanDef activity = this.activityBeansCache.getActivity(editor.getName());
        DefaultPerspectiveEditorActivity perspectiveEditorActivity = (DefaultPerspectiveEditorActivity)activity.getInstance();
        perspectiveEditorActivity.update(editor, screen);
    }

    private DefaultPerspectiveEditorScreenActivity updateScreen(LayoutEditor editor) {
        IOCBeanDef activity = this.activityBeansCache.getActivity(editor.getName() + DefaultPerspectiveEditorScreenActivity.screenSufix());
        DefaultPerspectiveEditorScreenActivity screenActivity = (DefaultPerspectiveEditorScreenActivity)activity.getInstance();
        screenActivity.build(editor);
        return screenActivity;
    }

    private void createNewPerspective(LayoutEditor perspective, DefaultPerspectiveEditorScreenActivity screen) {
        DefaultPerspectiveEditorActivity activity = new DefaultPerspectiveEditorActivity(perspective, screen);
        this.beanManager.addBean(PerspectiveActivity.class, DefaultPerspectiveEditorActivity.class, null, (Object)activity, QualifierUtil.DEFAULT_QUALIFIERS, perspective.getName(), true, null);
        this.activityBeansCache.addNewPerspectiveActivity((IOCBeanDef)this.beanManager.lookupBeans(perspective.getName()).iterator().next());
    }

    private DefaultPerspectiveEditorScreenActivity createNewScreen(LayoutEditor perspective) {
        DefaultPerspectiveEditorScreenActivity activity = new DefaultPerspectiveEditorScreenActivity(perspective, this.placeManager);
        this.beanManager.addBean(Activity.class, DefaultPerspectiveEditorScreenActivity.class, null, (Object)activity, QualifierUtil.DEFAULT_QUALIFIERS, activity.getName(), true, null);
        this.beanManager.addBean(WorkbenchScreenActivity.class, DefaultPerspectiveEditorScreenActivity.class, null, (Object)activity, QualifierUtil.DEFAULT_QUALIFIERS, activity.getName(), true, null);
        this.beanManager.addBean(DefaultPerspectiveEditorScreenActivity.class, DefaultPerspectiveEditorScreenActivity.class, null, (Object)activity, QualifierUtil.DEFAULT_QUALIFIERS, activity.getName(), true, null);
        this.activityBeansCache.addNewScreenActivity((IOCBeanDef)this.beanManager.lookupBeans(activity.getName()).iterator().next());
        return activity;
    }

    private boolean isANewPerspective(LayoutEditor editor) {
        IOCBeanDef activity = this.activityBeansCache.getActivity(editor.getName());
        return activity == null;
    }
}

